/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.DarculaColors;
import com.intellij.ui.Gray;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.UIManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBColor
extends Color {
    public static final Color PanelBackground = new JBColor("Panel.background", new Color(0xFFFFFF));
    private static final Color NAMED_COLOR_FALLBACK_MARKER = JBColor.marker("NAMED_COLOR_FALLBACK_MARKER");
    private final String name;
    private final Color darkColor;
    private final Color defaultColor;
    private final Supplier<? extends Color> func;
    public static final JBColor red;
    public static final JBColor RED;
    public static final JBColor blue;
    public static final JBColor BLUE;
    public static final JBColor white;
    public static final JBColor WHITE;
    public static final JBColor black;
    public static final JBColor BLACK;
    public static final JBColor gray;
    public static final JBColor GRAY;
    public static final JBColor lightGray;
    public static final JBColor LIGHT_GRAY;
    public static final JBColor darkGray;
    public static final JBColor DARK_GRAY;
    public static final JBColor pink;
    public static final JBColor PINK;
    public static final JBColor orange;
    public static final JBColor ORANGE;
    public static final JBColor yellow;
    public static final JBColor YELLOW;
    public static final JBColor green;
    public static final JBColor GREEN;
    public static final Color magenta;
    public static final Color MAGENTA;
    public static final Color cyan;
    public static final Color CYAN;
    private static final Map<String, Color> defaultThemeColors;

    public JBColor(int rgb, int darkRGB) {
        this(new Color(rgb, (rgb & 0xFF000000) != 0), new Color(darkRGB, (rgb & 0xFF000000) != 0));
    }

    public JBColor(@NotNull Color regular, @NotNull Color dark) {
        if (regular == null) {
            JBColor.$$$reportNull$$$0(0);
        }
        if (dark == null) {
            JBColor.$$$reportNull$$$0(1);
        }
        super(regular.getRGB(), regular.getAlpha() != 255);
        this.name = null;
        this.defaultColor = null;
        this.darkColor = dark;
        this.func = null;
    }

    protected JBColor(@NotNull Supplier<? extends Color> function) {
        if (function == null) {
            JBColor.$$$reportNull$$$0(2);
        }
        super(0);
        this.name = null;
        this.defaultColor = null;
        this.darkColor = null;
        this.func = function;
    }

    @Deprecated
    public JBColor(@NotNull NotNullProducer<? extends Color> function) {
        if (function == null) {
            JBColor.$$$reportNull$$$0(3);
        }
        super(0);
        this.name = null;
        this.defaultColor = null;
        this.darkColor = null;
        this.func = function::produce;
    }

    public JBColor(@NotNull String name2, @Nullable Color defaultColor) {
        if (name2 == null) {
            JBColor.$$$reportNull$$$0(4);
        }
        super(0);
        this.name = name2;
        this.defaultColor = defaultColor;
        this.darkColor = null;
        this.func = null;
    }

    public static JBColor lazy(@NotNull Supplier<? extends Color> supplier2) {
        if (supplier2 == null) {
            JBColor.$$$reportNull$$$0(5);
        }
        return new JBColor(supplier2);
    }

    @NotNull
    public static Color marker(final @NotNull String name2) {
        if (name2 == null) {
            JBColor.$$$reportNull$$$0(6);
        }
        return new JBColor(() -> {
            throw new AssertionError((Object)name2);
        }){

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }

            @Override
            public String toString() {
                return name2;
            }
        };
    }

    @NotNull
    public static JBColor namedColor(@NonNls @NotNull String propertyName, int defaultValueRGB) {
        if (propertyName == null) {
            JBColor.$$$reportNull$$$0(7);
        }
        return JBColor.namedColor(propertyName, new Color(defaultValueRGB));
    }

    @NotNull
    public static JBColor namedColor(@NonNls @NotNull String propertyName, int defaultValueRGB, int darkValueRGB) {
        if (propertyName == null) {
            JBColor.$$$reportNull$$$0(8);
        }
        return JBColor.namedColor(propertyName, new JBColor(defaultValueRGB, darkValueRGB));
    }

    @NotNull
    public static JBColor namedColor(@NonNls @NotNull String propertyName) {
        if (propertyName == null) {
            JBColor.$$$reportNull$$$0(9);
        }
        return JBColor.namedColor(propertyName, NAMED_COLOR_FALLBACK_MARKER);
    }

    @NotNull
    public static JBColor namedColor(@NonNls @NotNull String propertyName, @NotNull Color defaultColor) {
        if (propertyName == null) {
            JBColor.$$$reportNull$$$0(10);
        }
        if (defaultColor == null) {
            JBColor.$$$reportNull$$$0(11);
        }
        return new JBColor(propertyName, defaultColor);
    }

    @NotNull
    private static Color calculateColor(@NonNls @NotNull String name2, @Nullable Color defaultColor) {
        Color color;
        if (name2 == null) {
            JBColor.$$$reportNull$$$0(12);
        }
        if ((color = UIManager.getColor(name2)) != null) {
            Color color2 = color;
            if (color2 == null) {
                JBColor.$$$reportNull$$$0(13);
            }
            return color2;
        }
        if (!UIManager.getDefaults().containsKey("Theme.name")) {
            Color color3 = defaultColor == NAMED_COLOR_FALLBACK_MARKER || defaultColor == null ? JBColor.calculateFallback(name2) : defaultColor;
            if (color3 == null) {
                JBColor.$$$reportNull$$$0(14);
            }
            return color3;
        }
        Color patternMatch = JBColor.findPatternMatch(name2);
        if (patternMatch != null) {
            Color color4 = patternMatch;
            if (color4 == null) {
                JBColor.$$$reportNull$$$0(15);
            }
            return color4;
        }
        Color color5 = defaultColor == NAMED_COLOR_FALLBACK_MARKER || defaultColor == null ? JBColor.calculateFallback(name2) : defaultColor;
        if (color5 == null) {
            JBColor.$$$reportNull$$$0(16);
        }
        return color5;
    }

    @NotNull
    private static Color calculateFallback(@NonNls @NotNull String propertyName) {
        Color v;
        Color value;
        if (propertyName == null) {
            JBColor.$$$reportNull$$$0(17);
        }
        Color color = (value = UIManager.getColor(propertyName)) == null ? ((v = JBColor.findPatternMatch(propertyName)) == null ? Gray.TRANSPARENT : v) : value;
        if (UIManager.get(propertyName) == null && Registry.is("ide.save.missing.jb.colors", false)) {
            Color color2 = JBColor._saveAndReturnColor(propertyName, color);
            if (color2 == null) {
                JBColor.$$$reportNull$$$0(18);
            }
            return color2;
        }
        Color color3 = color;
        if (color3 == null) {
            JBColor.$$$reportNull$$$0(19);
        }
        return color3;
    }

    private static Color findPatternMatch(@NotNull String name2) {
        Object value;
        if (name2 == null) {
            JBColor.$$$reportNull$$$0(20);
        }
        if ((value = UIManager.get("*")) instanceof Map) {
            Map cache2;
            Map map2 = (Map)value;
            HashMap o = UIManager.get("*cache");
            if (!(o instanceof Map)) {
                o = new HashMap();
                UIManager.put("*cache", o);
            }
            if ((cache2 = (Map)o).containsKey(name2)) {
                return (Color)cache2.get(name2);
            }
            Color color = null;
            for (Map.Entry entry : map2.entrySet()) {
                Object result2;
                if (!(entry.getKey() instanceof String) || !name2.endsWith((String)entry.getKey()) || !((result2 = map2.get(entry.getKey())) instanceof Color)) continue;
                color = (Color)result2;
                break;
            }
            cache2.put(name2, color);
            return color;
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static Color link() {
        Color color = JBUI.CurrentTheme.Link.Foreground.ENABLED;
        if (color == null) {
            JBColor.$$$reportNull$$$0(21);
        }
        return color;
    }

    public static void setDark(boolean dark) {
        Lazy.DARK = dark;
    }

    public static boolean isBright() {
        return !Lazy.DARK;
    }

    @ApiStatus.Internal
    public Color getDarkVariant() {
        return this.darkColor;
    }

    @NotNull
    Color getColor() {
        if (this.func != null) {
            Color color = this.func.get();
            if (color == null) {
                JBColor.$$$reportNull$$$0(22);
            }
            return color;
        }
        if (this.name != null) {
            return JBColor.calculateColor(this.name, this.defaultColor);
        }
        Color color = Lazy.DARK ? this.getDarkVariant() : this;
        if (color == null) {
            JBColor.$$$reportNull$$$0(23);
        }
        return color;
    }

    @ApiStatus.Internal
    @Nullable
    public String getName() {
        return this.name;
    }

    @ApiStatus.Internal
    @Nullable
    public Color getDefaultColor() {
        return this.defaultColor == NAMED_COLOR_FALLBACK_MARKER ? null : this.defaultColor;
    }

    @Override
    public int getRed() {
        Color c = this.getColor();
        return c == this ? super.getRed() : c.getRed();
    }

    @Override
    public int getGreen() {
        Color c = this.getColor();
        return c == this ? super.getGreen() : c.getGreen();
    }

    @Override
    public int getBlue() {
        Color c = this.getColor();
        return c == this ? super.getBlue() : c.getBlue();
    }

    @Override
    public int getAlpha() {
        Color c = this.getColor();
        return c == this ? super.getAlpha() : c.getAlpha();
    }

    @Override
    public int getRGB() {
        Color c = this.getColor();
        return c == this ? super.getRGB() : c.getRGB();
    }

    @Override
    @NotNull
    public Color brighter() {
        if (this.func != null) {
            JBColor jBColor = JBColor.lazy(() -> this.func.get().brighter());
            if (jBColor == null) {
                JBColor.$$$reportNull$$$0(24);
            }
            return jBColor;
        }
        if (this.name != null) {
            Color color = JBColor.calculateColor(this.name, this.defaultColor).brighter();
            if (color == null) {
                JBColor.$$$reportNull$$$0(25);
            }
            return color;
        }
        return new JBColor(super.brighter(), this.getDarkVariant().brighter());
    }

    @Override
    @NotNull
    public Color darker() {
        if (this.func != null) {
            JBColor jBColor = JBColor.lazy(() -> this.func.get().darker());
            if (jBColor == null) {
                JBColor.$$$reportNull$$$0(26);
            }
            return jBColor;
        }
        if (this.name != null) {
            Color color = JBColor.calculateColor(this.name, this.defaultColor).darker();
            if (color == null) {
                JBColor.$$$reportNull$$$0(27);
            }
            return color;
        }
        return new JBColor(super.darker(), this.getDarkVariant().darker());
    }

    @Override
    public int hashCode() {
        Color c = this.getColor();
        return c == this ? super.hashCode() : c.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        Color c = this.getColor();
        return c == this ? super.equals(obj) : c.equals(obj);
    }

    @Override
    public String toString() {
        Color c = this.getColor();
        return c == this ? super.toString() : c.toString();
    }

    @Override
    public float @NotNull [] getRGBComponents(float[] compArray) {
        Color c = this.getColor();
        float[] fArray = c == this ? super.getRGBComponents(compArray) : c.getRGBComponents(compArray);
        if (fArray == null) {
            JBColor.$$$reportNull$$$0(28);
        }
        return fArray;
    }

    @Override
    public float @NotNull [] getRGBColorComponents(float[] compArray) {
        Color c = this.getColor();
        float[] fArray = c == this ? super.getRGBComponents(compArray) : c.getRGBColorComponents(compArray);
        if (fArray == null) {
            JBColor.$$$reportNull$$$0(29);
        }
        return fArray;
    }

    @Override
    public float @NotNull [] getComponents(float[] compArray) {
        Color c = this.getColor();
        float[] fArray = c == this ? super.getComponents(compArray) : c.getComponents(compArray);
        if (fArray == null) {
            JBColor.$$$reportNull$$$0(30);
        }
        return fArray;
    }

    @Override
    public float @NotNull [] getColorComponents(float[] compArray) {
        Color c = this.getColor();
        float[] fArray = c == this ? super.getColorComponents(compArray) : c.getColorComponents(compArray);
        if (fArray == null) {
            JBColor.$$$reportNull$$$0(31);
        }
        return fArray;
    }

    @Override
    public float @NotNull [] getComponents(@NotNull ColorSpace colorSpace, float[] compArray) {
        Color c;
        if (colorSpace == null) {
            JBColor.$$$reportNull$$$0(32);
        }
        float[] fArray = (c = this.getColor()) == this ? super.getComponents(colorSpace, compArray) : c.getComponents(colorSpace, compArray);
        if (fArray == null) {
            JBColor.$$$reportNull$$$0(33);
        }
        return fArray;
    }

    @Override
    public float @NotNull [] getColorComponents(@NotNull ColorSpace colorSpace, float[] compArray) {
        Color c;
        if (colorSpace == null) {
            JBColor.$$$reportNull$$$0(34);
        }
        float[] fArray = (c = this.getColor()) == this ? super.getColorComponents(colorSpace, compArray) : c.getColorComponents(colorSpace, compArray);
        if (fArray == null) {
            JBColor.$$$reportNull$$$0(35);
        }
        return fArray;
    }

    @Override
    @NotNull
    public ColorSpace getColorSpace() {
        Color c = this.getColor();
        ColorSpace colorSpace = c == this ? super.getColorSpace() : c.getColorSpace();
        if (colorSpace == null) {
            JBColor.$$$reportNull$$$0(36);
        }
        return colorSpace;
    }

    @Override
    @NotNull
    public synchronized PaintContext createContext(ColorModel cm, Rectangle r, Rectangle2D r2d, AffineTransform affineTransform, RenderingHints hints) {
        Color c = this.getColor();
        PaintContext paintContext = c == this ? super.createContext(cm, r, r2d, affineTransform, hints) : c.createContext(cm, r, r2d, affineTransform, hints);
        if (paintContext == null) {
            JBColor.$$$reportNull$$$0(37);
        }
        return paintContext;
    }

    @Override
    public int getTransparency() {
        Color c = this.getColor();
        return c == this ? super.getTransparency() : c.getTransparency();
    }

    @NotNull
    public static Color foreground() {
        return JBColor.namedColor("Label.foreground", new JBColor(Gray._0, (Color)Gray.xBB));
    }

    @NotNull
    public static Color background() {
        JBColor jBColor = JBColor.lazy(() -> JBUI.CurrentTheme.List.BACKGROUND);
        if (jBColor == null) {
            JBColor.$$$reportNull$$$0(38);
        }
        return jBColor;
    }

    @NotNull
    public static Color border() {
        return JBColor.namedColor("Borders.color", new JBColor(Gray._192, (Color)Gray._50));
    }

    @NotNull
    public static Color get(@NotNull String colorId, @NotNull Color defaultColor) {
        if (colorId == null) {
            JBColor.$$$reportNull$$$0(39);
        }
        if (defaultColor == null) {
            JBColor.$$$reportNull$$$0(40);
        }
        JBColor jBColor = JBColor.lazy(() -> {
            Color color = defaultThemeColors.get(colorId);
            if (color != null) {
                return color;
            }
            defaultThemeColors.put(colorId, defaultColor);
            return defaultColor;
        });
        if (jBColor == null) {
            JBColor.$$$reportNull$$$0(41);
        }
        return jBColor;
    }

    private static void saveMissingColorInUIDefaults(String propertyName, Color color) {
        String key;
        if (Registry.is("ide.save.missing.jb.colors", false) && UIManager.get(key = propertyName + "!!!") == null) {
            UIManager.put(key, color);
        }
    }

    @ApiStatus.Internal
    private static Color _saveAndReturnColor(@NonNls @NotNull String propertyName, Color color) {
        String key;
        Object saved;
        if (propertyName == null) {
            JBColor.$$$reportNull$$$0(42);
        }
        if ((saved = UIManager.get(key = propertyName + "!!!")) instanceof Color) {
            return (Color)saved;
        }
        UIManager.put(key, color);
        return color;
    }

    static {
        RED = red = new JBColor(Color.red, DarculaColors.RED);
        BLUE = blue = new JBColor(Color.blue, DarculaColors.BLUE);
        WHITE = white = new JBColor(Color.white, JBColor.background());
        BLACK = black = new JBColor(Color.black, JBColor.foreground());
        GRAY = gray = new JBColor(Gray._128, (Color)Gray._128);
        LIGHT_GRAY = lightGray = new JBColor(Gray._192, (Color)Gray._64);
        DARK_GRAY = darkGray = new JBColor(Gray._64, (Color)Gray._192);
        PINK = pink = new JBColor(Color.pink, Color.pink);
        ORANGE = orange = new JBColor(Color.orange, new Color(159, 107, 0));
        YELLOW = yellow = new JBColor(Color.yellow, new Color(138, 138, 0));
        GREEN = green = new JBColor(Color.green, new Color(98, 150, 85));
        MAGENTA = magenta = new JBColor(Color.magenta, new Color(151, 118, 169));
        CYAN = cyan = new JBColor(Color.cyan, new Color(0, 137, 137));
        defaultThemeColors = new HashMap<String, Color>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regular";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dark";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 17: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 11: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultColor";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/JBColor";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorSpace";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/JBColor";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateColor";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateFallback";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "link";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getColor";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "brighter";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "darker";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getRGBComponents";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getRGBColorComponents";
                break;
            }
            case 30: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 31: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorComponents";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorSpace";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createContext";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "background";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lazy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "marker";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "namedColor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calculateColor";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "calculateFallback";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findPatternMatch";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getComponents";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getColorComponents";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "_saveAndReturnColor";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 41: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Lazy {
        private static volatile boolean DARK = StartupUiUtil.isUnderDarcula();

        private Lazy() {
        }
    }
}

