/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.Area;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScreenUtil {
    public static final String DISPOSE_TEMPORARY = "dispose.temporary";
    @Nullable
    private static final Map<GraphicsConfiguration, Pair<Insets, Long>> ourInsetsCache = Boolean.getBoolean("ide.cache.screen.insets") ? new WeakHashMap() : null;
    private static final int ourInsetsTimeout = SystemProperties.getIntProperty("ide.insets.cache.timeout", 5000);

    private ScreenUtil() {
    }

    public static boolean isVisible(@NotNull Point location) {
        if (location == null) {
            ScreenUtil.$$$reportNull$$$0(0);
        }
        return ScreenUtil.getScreenRectangle(location).contains(location);
    }

    public static boolean isVisible(@NotNull Rectangle bounds) {
        Rectangle[] allScreenBounds;
        if (bounds == null) {
            ScreenUtil.$$$reportNull$$$0(1);
        }
        if (bounds.isEmpty()) {
            return false;
        }
        for (Rectangle screenBounds : allScreenBounds = ScreenUtil.getAllScreenBounds()) {
            int sq2;
            int sq1;
            double visibleFraction;
            Rectangle intersection = screenBounds.intersection(bounds);
            if (intersection.isEmpty() || !((visibleFraction = (double)(sq1 = intersection.width * intersection.height) / (double)(sq2 = bounds.width * bounds.height)) > 0.1)) continue;
            return true;
        }
        return false;
    }

    public static Rectangle getMainScreenBounds() {
        return ScreenUtil.getScreenRectangle(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice());
    }

    private static Rectangle[] getAllScreenBounds() {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        Rectangle[] result2 = new Rectangle[devices.length];
        for (int i = 0; i < devices.length; ++i) {
            result2[i] = ScreenUtil.getScreenRectangle(devices[i]);
        }
        return result2;
    }

    public static Shape getAllScreensShape() {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (devices.length == 0) {
            return new Rectangle();
        }
        if (devices.length == 1) {
            return ScreenUtil.getScreenRectangle(devices[0]);
        }
        Area area = new Area();
        for (GraphicsDevice device : devices) {
            area.add(new Area(ScreenUtil.getScreenRectangle(device)));
        }
        return area;
    }

    @NotNull
    public static Rectangle getAllScreensRectangle() {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (devices.length == 0) {
            return new Rectangle();
        }
        if (devices.length == 1) {
            Rectangle rectangle = ScreenUtil.getScreenRectangle(devices[0]);
            if (rectangle == null) {
                ScreenUtil.$$$reportNull$$$0(2);
            }
            return rectangle;
        }
        int minX = 0;
        int maxX = 0;
        int minY = 0;
        int maxY = 0;
        for (GraphicsDevice device : devices) {
            int y;
            Rectangle rectangle = ScreenUtil.getScreenRectangle(device);
            int x = rectangle.x;
            if (minX > x) {
                minX = x;
            }
            if (maxX < (x += rectangle.width)) {
                maxX = x;
            }
            if (minY > (y = rectangle.y)) {
                minY = y;
            }
            if (maxY >= (y += rectangle.height)) continue;
            maxY = y;
        }
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    public static Rectangle getScreenRectangle(@NotNull Point p) {
        if (p == null) {
            ScreenUtil.$$$reportNull$$$0(3);
        }
        return ScreenUtil.getScreenRectangle(p.x, p.y);
    }

    public static Rectangle getScreenRectangle(@NotNull Component component2) {
        GraphicsConfiguration configuration;
        if (component2 == null) {
            ScreenUtil.$$$reportNull$$$0(4);
        }
        if ((configuration = component2.getGraphicsConfiguration()) != null) {
            return ScreenUtil.getScreenRectangle(configuration);
        }
        Point p = new Point();
        SwingUtilities.convertPointToScreen(p, component2);
        return ScreenUtil.getScreenRectangle(p);
    }

    public static GraphicsDevice getScreenDevice(Rectangle bounds) {
        GraphicsDevice candidate = null;
        int maxIntersection = 0;
        for (GraphicsDevice device : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration config = device.getDefaultConfiguration();
            Rectangle rect2 = config.getBounds();
            Rectangle intersection = rect2.intersection(bounds);
            if (intersection.isEmpty() || intersection.width * intersection.height <= maxIntersection) continue;
            maxIntersection = intersection.width * intersection.height;
            candidate = device;
        }
        return candidate;
    }

    public static boolean isStandardAddRemoveNotify(Component component2) {
        JRootPane rootPane = ScreenUtil.findMainRootPane(component2);
        return rootPane == null || rootPane.getClientProperty(DISPOSE_TEMPORARY) == null;
    }

    private static JRootPane findMainRootPane(Component component2) {
        while (component2 != null) {
            Container parent = component2.getParent();
            if (parent == null) {
                return component2 instanceof RootPaneContainer ? ((RootPaneContainer)((Object)component2)).getRootPane() : null;
            }
            component2 = parent;
        }
        return null;
    }

    private static Rectangle applyInsets(Rectangle rect2, Insets i) {
        rect2 = new Rectangle(rect2);
        JBInsets.removeFrom(rect2, i);
        return rect2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Insets getScreenInsets(GraphicsConfiguration gc) {
        if (ourInsetsCache == null) {
            return ScreenUtil.calcInsets(gc);
        }
        Map<GraphicsConfiguration, Pair<Insets, Long>> map2 = ourInsetsCache;
        synchronized (map2) {
            Pair<Insets, Long> data2 = ourInsetsCache.get(gc);
            long now = System.currentTimeMillis();
            if (data2 == null || now > (Long)data2.second + (long)ourInsetsTimeout) {
                data2 = Pair.create(ScreenUtil.calcInsets(gc), now);
                ourInsetsCache.put(gc, data2);
            }
            return (Insets)data2.first;
        }
    }

    private static Insets calcInsets(GraphicsConfiguration gc) {
        return Toolkit.getDefaultToolkit().getScreenInsets(gc);
    }

    private static Rectangle getScreenRectangle(GraphicsDevice device) {
        return ScreenUtil.getScreenRectangle(device.getDefaultConfiguration());
    }

    public static Rectangle getScreenRectangle(GraphicsConfiguration configuration) {
        return ScreenUtil.applyInsets(configuration.getBounds(), ScreenUtil.getScreenInsets(configuration));
    }

    public static Rectangle getScreenRectangle(int x, int y) {
        if (GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance()) {
            return new Rectangle(x, y, 0, 0);
        }
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (devices.length == 0) {
            return new Rectangle(x, y, 0, 0);
        }
        if (devices.length == 1) {
            return ScreenUtil.getScreenRectangle(devices[0]);
        }
        Rectangle[] rectangles = new Rectangle[devices.length];
        for (int i = 0; i < devices.length; ++i) {
            GraphicsConfiguration configuration = devices[i].getDefaultConfiguration();
            Rectangle bounds = configuration.getBounds();
            rectangles[i] = ScreenUtil.applyInsets(bounds, ScreenUtil.getScreenInsets(configuration));
            if (!bounds.contains(x, y)) continue;
            return rectangles[i];
        }
        Rectangle bounds = rectangles[0];
        int minimum = ScreenUtil.distance(bounds, x, y);
        if (bounds.width == 0 || bounds.height == 0) {
            minimum = Integer.MAX_VALUE;
        }
        for (int i = 1; i < rectangles.length; ++i) {
            int distance;
            if (rectangles[i].width == 0 || rectangles[i].height == 0 || minimum <= (distance = ScreenUtil.distance(rectangles[i], x, y))) continue;
            minimum = distance;
            bounds = rectangles[i];
        }
        if (bounds.width == 0 || bounds.height == 0) {
            return new Rectangle(x, y, 0, 0);
        }
        return bounds;
    }

    private static int normalize(int value, int min, int max) {
        return value < min ? min : Math.min(value, max);
    }

    private static int distance(Rectangle bounds, int x, int y) {
        x -= ScreenUtil.normalize(x, bounds.x, bounds.x + bounds.width);
        y -= ScreenUtil.normalize(y, bounds.y, bounds.y + bounds.height);
        return x * x + y * y;
    }

    public static void moveRectangleToFitTheScreen(Rectangle aRectangle) {
        int screenX = aRectangle.x + aRectangle.width / 2;
        int screenY = aRectangle.y + aRectangle.height / 2;
        Rectangle screen = ScreenUtil.getScreenRectangle(screenX, screenY);
        ScreenUtil.moveToFit(aRectangle, screen, null);
    }

    public static void moveToFit(Rectangle rectangle, Rectangle container, @Nullable Insets padding) {
        ScreenUtil.moveToFit(rectangle, container, padding, false);
    }

    public static void moveToFit(Rectangle rectangle, Rectangle container, @Nullable Insets padding, boolean crop) {
        Rectangle move = new Rectangle(rectangle);
        JBInsets.addTo(move, padding);
        if (move.getMaxX() > container.getMaxX()) {
            move.x = (int)container.getMaxX() - move.width;
        }
        if (move.getMinX() < container.getMinX()) {
            move.x = (int)container.getMinX();
        }
        if (move.getMaxX() > container.getMaxX() && crop) {
            move.width = (int)container.getMaxX() - move.x;
        }
        if (move.getMaxY() > container.getMaxY()) {
            move.y = (int)container.getMaxY() - move.height;
        }
        if (move.getMinY() < container.getMinY()) {
            move.y = (int)container.getMinY();
        }
        if (move.getMaxY() > container.getMaxY() && crop) {
            move.height = (int)container.getMaxY() - move.y;
        }
        JBInsets.removeFrom(move, padding);
        rectangle.setBounds(move);
    }

    public static void fitToScreenVertical(Rectangle rectangle, int top, int bottom, boolean rightAligned) {
        Rectangle screen = ScreenUtil.getScreenRectangle(rectangle.x, rectangle.y);
        if (rectangle.width > screen.width) {
            rectangle.width = screen.width;
        }
        if (rightAligned) {
            rectangle.x -= rectangle.width;
        }
        if (rectangle.x < screen.x) {
            rectangle.x = screen.x;
        } else {
            int max = screen.x + screen.width;
            if (rectangle.x > max) {
                rectangle.x = max - rectangle.width;
            }
        }
        int above = rectangle.y - screen.y - top;
        int below = screen.height - above - top - bottom;
        if (below > rectangle.height) {
            rectangle.y += bottom;
        } else if (above > rectangle.height) {
            rectangle.y -= rectangle.height + top;
        } else if (below > above) {
            rectangle.y += bottom;
            rectangle.height = below;
        } else {
            rectangle.y -= rectangle.height + top;
            rectangle.height = above;
        }
    }

    public static void fitToScreen(Rectangle r) {
        int yOverdraft;
        Rectangle screen = ScreenUtil.getScreenRectangle(r.x, r.y);
        int xOverdraft = r.x + r.width - screen.x - screen.width;
        if (xOverdraft > 0) {
            int shift = Math.min(xOverdraft, r.x - screen.x);
            r.x -= shift;
            if ((xOverdraft -= shift) > 0) {
                r.width -= xOverdraft;
            }
        }
        if ((yOverdraft = r.y + r.height - screen.y - screen.height) > 0) {
            int shift = Math.min(yOverdraft, r.y - screen.y);
            r.y -= shift;
            if ((yOverdraft -= shift) > 0) {
                r.height -= yOverdraft;
            }
        }
    }

    public static Point findNearestPointOnBorder(Rectangle rect2, Point p) {
        Point[] variants;
        int x0 = rect2.x;
        int y0 = rect2.y;
        int x1 = x0 + rect2.width;
        int y1 = y0 + rect2.height;
        double distance = -1.0;
        Point best = null;
        for (Point variant : variants = new Point[]{new Point(p.x, y0), new Point(p.x, y1), new Point(x0, p.y), new Point(x1, p.y)}) {
            double d = variant.distance(p.x, p.y);
            if (best != null && !(distance > d)) continue;
            best = variant;
            distance = d;
        }
        return best;
    }

    public static void cropRectangleToFitTheScreen(Rectangle rect2) {
        int screenX = rect2.x;
        int screenY = rect2.y;
        Rectangle screen = ScreenUtil.getScreenRectangle(screenX, screenY);
        if (rect2.getMaxX() > screen.getMaxX()) {
            rect2.width = (int)screen.getMaxX() - rect2.x;
        }
        if (rect2.getMinX() < screen.getMinX()) {
            rect2.x = (int)screen.getMinX();
        }
        if (rect2.getMaxY() > screen.getMaxY()) {
            rect2.height = (int)screen.getMaxY() - rect2.y;
        }
        if (rect2.getMinY() < screen.getMinY()) {
            rect2.y = (int)screen.getMinY();
        }
    }

    public static boolean isMovementTowards(Point prevLocation, Point location, Rectangle bounds) {
        if (bounds == null) {
            return false;
        }
        if (prevLocation == null || prevLocation.equals(location)) {
            return true;
        }
        if (bounds.contains(location)) {
            return true;
        }
        int dx = prevLocation.x - location.x;
        int dy = prevLocation.y - location.y;
        if (dx > 0 && bounds.x >= prevLocation.x) {
            return false;
        }
        if (dx < 0 && bounds.x + bounds.width <= prevLocation.x) {
            return false;
        }
        if (dy < 0 && bounds.y + bounds.height <= prevLocation.y) {
            return false;
        }
        if (dy > 0 && bounds.y >= prevLocation.y) {
            return false;
        }
        if (dx == 0) {
            return location.x >= bounds.x && location.x < bounds.x + bounds.width && dy > 0 ^ bounds.y > location.y;
        }
        if (dy == 0) {
            return location.y >= bounds.y && location.y < bounds.y + bounds.height && dx > 0 ^ bounds.x > location.x;
        }
        float a = (float)dy / (float)dx;
        float b = (float)location.y - a * (float)location.x;
        float crossY = a * (float)bounds.x + b;
        if (crossY >= (float)bounds.y && crossY < (float)(bounds.y + bounds.height)) {
            return true;
        }
        crossY = a * (float)(bounds.x + bounds.width) + b;
        if (crossY >= (float)bounds.y && crossY < (float)(bounds.y + bounds.height)) {
            return true;
        }
        float crossX = ((float)bounds.y - b) / a;
        if (crossX >= (float)bounds.x && crossX < (float)(bounds.x + bounds.width)) {
            return true;
        }
        crossX = ((float)(bounds.y + bounds.height) - b) / a;
        return crossX >= (float)bounds.x && crossX < (float)(bounds.x + bounds.width);
    }

    public static boolean intersectsVisibleScreen(Window window) {
        return window.getGraphicsConfiguration().getBounds().intersects(window.getBounds());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ScreenUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ScreenUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllScreensRectangle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getScreenRectangle";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

