/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.diagnostic.StartUpMeasurer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class IconLoadMeasurer {
    public static final Counter svgDecoding = new Counter("svg-decode");
    private static final Counter svgLoading = new Counter("svg-load");
    public static final Counter svgPreBuiltLoad = new Counter("svg-prebuilt");
    public static final Counter svgCacheWrite = new Counter("svg-cache-write");
    public static final Counter svgCacheRead = new Counter("svg-cache-read");
    public static final Counter pngDecoding = new Counter("png-decode");
    private static final Counter pngLoading = new Counter("png-load");
    public static final Counter findIcon = new Counter("find-icon");
    public static final Counter findIconLoad = new Counter("find-icon-load");
    public static final Counter loadFromUrl = new Counter("load-from-url");
    public static final Counter loadFromResources = new Counter("load-from-resource");
    public static final Counter actionIcon = new Counter("action-icon");

    @NotNull
    public static List<Counter> getStats() {
        List<Counter> list2 = Arrays.asList(findIcon, findIconLoad, loadFromUrl, loadFromResources, svgLoading, svgDecoding, svgPreBuiltLoad, svgCacheRead, svgCacheWrite, pngLoading, pngDecoding, actionIcon);
        if (list2 == null) {
            IconLoadMeasurer.$$$reportNull$$$0(0);
        }
        return list2;
    }

    public static void addLoading(boolean isSvg, long start2) {
        (isSvg ? svgLoading : pngLoading).end(start2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/icons/IconLoadMeasurer", "getStats"));
    }

    public static final class Counter {
        public final String name;
        private final AtomicInteger counter;
        private final AtomicLong totalDuration;

        private Counter(@NotNull @NonNls String name2) {
            if (name2 == null) {
                Counter.$$$reportNull$$$0(0);
            }
            this.counter = new AtomicInteger();
            this.totalDuration = new AtomicLong();
            this.name = name2;
        }

        public int getCount() {
            return this.counter.get();
        }

        public long getTotalDuration() {
            return this.totalDuration.get();
        }

        public void end(long startTime) {
            if (startTime > 0L) {
                long duration = StartUpMeasurer.getCurrentTime() - startTime;
                this.counter.incrementAndGet();
                this.totalDuration.getAndAdd(duration);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ui/icons/IconLoadMeasurer$Counter", "<init>"));
        }
    }
}

