/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.DimensionService;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PopupPositionManager {
    private static final Position[] DEFAULT_POSITION_ORDER = new Position[]{Position.RIGHT, Position.LEFT, Position.TOP, Position.BOTTOM};

    private PopupPositionManager() {
    }

    public static void positionPopupInBestPosition(JBPopup hint, @Nullable Editor editor2, @Nullable DataContext dataContext) {
        PopupPositionManager.positionPopupInBestPosition(hint, editor2, dataContext, DEFAULT_POSITION_ORDER);
    }

    public static void positionPopupInBestPosition(final JBPopup hint, @Nullable Editor editor2, @Nullable DataContext dataContext, Position ... relationToExistingPopup) {
        LookupEx lookup2;
        if (relationToExistingPopup == null) {
            PopupPositionManager.$$$reportNull$$$0(0);
        }
        if ((lookup2 = LookupManager.getActiveLookup(editor2)) != null && lookup2.getCurrentItem() != null && lookup2.getComponent().isShowing()) {
            new PositionAdjuster(lookup2.getComponent()).adjust(hint, PositionAdjuster.getPopupSize(hint), relationToExistingPopup);
            lookup2.addLookupListener(new LookupListener(){

                @Override
                public void lookupCanceled(@NotNull LookupEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (hint.isVisible()) {
                        hint.cancel();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/popup/PopupPositionManager$1", "lookupCanceled"));
                }
            });
            return;
        }
        PositionAdjuster positionAdjuster = PopupPositionManager.createPositionAdjuster(hint);
        if (positionAdjuster != null) {
            positionAdjuster.adjust(hint, PositionAdjuster.getPopupSize(hint), relationToExistingPopup);
            return;
        }
        if (editor2 != null && editor2.getComponent().isShowing() && editor2 instanceof EditorEx) {
            dataContext = ((EditorEx)editor2).getDataContext();
        }
        if (dataContext != null) {
            if (hint.canShow()) {
                hint.showInBestPositionFor(dataContext);
            } else {
                hint.setLocation(hint.getBestPositionFor(dataContext));
            }
        }
    }

    private static Component discoverPopup(DataKey<JBPopup> datakey, Component focusOwner) {
        if (focusOwner == null) {
            focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        if (focusOwner == null) {
            return null;
        }
        DataContext dataContext = DataManager.getInstance().getDataContext(focusOwner);
        JBPopup popup2 = (JBPopup)datakey.getData(dataContext);
        if (popup2 != null && popup2.isVisible() && !popup2.isDisposed()) {
            return popup2.getContent();
        }
        return null;
    }

    @Nullable
    private static PositionAdjuster createPositionAdjuster(JBPopup hint) {
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            return null;
        }
        JBPopup popup2 = PopupUtil.getPopupContainerFor((Component)focusOwner);
        if (popup2 != null && popup2 != hint && !popup2.isDisposed()) {
            return new PositionAdjuster(popup2.getContent());
        }
        Component existing = PopupPositionManager.discoverPopup((DataKey<JBPopup>)LangDataKeys.POSITION_ADJUSTER_POPUP, focusOwner);
        if (existing != null) {
            return new PositionAdjuster2(existing, PopupPositionManager.discoverPopup((DataKey<JBPopup>)LangDataKeys.PARENT_POPUP, focusOwner));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relationToExistingPopup", "com/intellij/ui/popup/PopupPositionManager", "positionPopupInBestPosition"));
    }

    public static class PositionAdjuster {
        public static final int DEFAULT_GAP = 5;
        protected final int myGap;
        protected final Component myRelativeTo;
        protected final Point myRelativeOnScreen;
        protected final Rectangle myScreenRect;

        public PositionAdjuster(Component relativeTo, int gap) {
            this.myRelativeTo = relativeTo;
            this.myRelativeOnScreen = relativeTo.getLocationOnScreen();
            this.myScreenRect = ScreenUtil.getScreenRectangle(this.myRelativeOnScreen);
            this.myGap = gap;
        }

        public PositionAdjuster(Component relativeTo) {
            this(relativeTo, 5);
        }

        protected Rectangle positionRight(Dimension d) {
            return new Rectangle(this.myRelativeOnScreen.x + this.myRelativeTo.getWidth() + this.myGap, this.myRelativeOnScreen.y, d.width, d.height);
        }

        protected Rectangle positionLeft(Dimension d) {
            return new Rectangle(this.myRelativeOnScreen.x - this.myGap - d.width, this.myRelativeOnScreen.y, d.width, d.height);
        }

        protected Rectangle positionAbove(Dimension d) {
            return new Rectangle(this.myRelativeOnScreen.x, this.getYForTopPositioning() - this.myGap - d.height, d.width, d.height);
        }

        protected Rectangle positionUnder(Dimension d) {
            return new Rectangle(this.myRelativeOnScreen.x, this.myRelativeOnScreen.y + this.myGap + this.myRelativeTo.getHeight(), d.width, d.height);
        }

        protected int getYForTopPositioning() {
            return this.myRelativeOnScreen.y;
        }

        public void adjust(JBPopup popup2) {
            this.adjust(popup2, DEFAULT_POSITION_ORDER);
        }

        public void adjust(@NotNull JBPopup popup2, Position ... traversalPolicy) {
            if (popup2 == null) {
                PositionAdjuster.$$$reportNull$$$0(0);
            }
            if (traversalPolicy == null) {
                PositionAdjuster.$$$reportNull$$$0(1);
            }
            this.adjust(popup2, PositionAdjuster.getPopupSize(popup2), traversalPolicy);
        }

        public void adjust(@NotNull JBPopup popup2, @NotNull Dimension d, Position ... traversalPolicy) {
            Rectangle bounds;
            Dimension size;
            if (popup2 == null) {
                PositionAdjuster.$$$reportNull$$$0(2);
            }
            if (d == null) {
                PositionAdjuster.$$$reportNull$$$0(3);
            }
            if (traversalPolicy == null) {
                PositionAdjuster.$$$reportNull$$$0(4);
            }
            if (!(size = (bounds = this.adjustBounds(d, traversalPolicy)).getSize()).equals(d)) {
                popup2.setSize(size);
            }
            if (popup2.canShow()) {
                popup2.show(new RelativePoint(this.myRelativeTo, new Point(bounds.x - this.myRelativeOnScreen.x, bounds.y - this.myRelativeOnScreen.y)));
            } else {
                popup2.setLocation(bounds.getLocation());
            }
        }

        @NotNull
        public Rectangle adjustBounds(@NotNull Dimension d, @NotNull @NotNull Position @NotNull [] traversalPolicy) {
            if (d == null) {
                PositionAdjuster.$$$reportNull$$$0(5);
            }
            if (traversalPolicy == null) {
                PositionAdjuster.$$$reportNull$$$0(6);
            }
            if (traversalPolicy.length == 0) {
                traversalPolicy = DEFAULT_POSITION_ORDER;
            }
            Rectangle popupRect = null;
            Rectangle r = null;
            ArrayList<Rectangle> boxes = new ArrayList<Rectangle>();
            for (Position position : traversalPolicy) {
                switch (position) {
                    case TOP: {
                        r = this.positionAbove(d);
                        boxes.add(PositionAdjuster.crop(this.myScreenRect, new Rectangle(this.myRelativeOnScreen.x, this.myScreenRect.y, this.myScreenRect.width, this.getYForTopPositioning() - this.myScreenRect.y - this.myGap)));
                        break;
                    }
                    case BOTTOM: {
                        r = this.positionUnder(d);
                        boxes.add(PositionAdjuster.crop(this.myScreenRect, new Rectangle(this.myRelativeOnScreen.x, this.myRelativeOnScreen.y + this.myRelativeTo.getHeight() + this.myGap, this.myScreenRect.width, this.myScreenRect.height)));
                        break;
                    }
                    case LEFT: {
                        r = this.positionLeft(d);
                        boxes.add(PositionAdjuster.crop(this.myScreenRect, new Rectangle(this.myScreenRect.x, this.myRelativeOnScreen.y, this.myRelativeOnScreen.x - this.myScreenRect.x - this.myGap, this.myScreenRect.height)));
                        break;
                    }
                    case RIGHT: {
                        r = this.positionRight(d);
                        boxes.add(PositionAdjuster.crop(this.myScreenRect, new Rectangle(this.myRelativeOnScreen.x + this.myRelativeTo.getWidth() + this.myGap, this.myRelativeOnScreen.y, this.myScreenRect.width, this.myScreenRect.height)));
                    }
                }
                if (!this.myScreenRect.contains(r)) continue;
                popupRect = r;
                break;
            }
            if (popupRect != null) {
                Rectangle rectangle = r;
                if (rectangle == null) {
                    PositionAdjuster.$$$reportNull$$$0(7);
                }
                return rectangle;
            }
            boxes.sort(Comparator.comparingInt(o -> o.width).thenComparingInt(o -> o.height));
            Rectangle suitableBox = (Rectangle)boxes.get(boxes.size() - 1);
            Rectangle rectangle = PositionAdjuster.crop(suitableBox, new Rectangle(suitableBox.x < this.myRelativeOnScreen.x ? suitableBox.x + suitableBox.width - d.width : suitableBox.x, suitableBox.y < this.myRelativeOnScreen.y ? suitableBox.y + suitableBox.height - d.height : suitableBox.y, d.width, d.height));
            if (rectangle == null) {
                PositionAdjuster.$$$reportNull$$$0(8);
            }
            return rectangle;
        }

        protected static Rectangle crop(Rectangle source, Rectangle toCrop) {
            Rectangle result2 = new Rectangle(toCrop);
            if (toCrop.x < source.x) {
                result2.width -= source.x - toCrop.x;
                result2.x = source.x;
            }
            if (toCrop.y < source.y) {
                result2.height -= source.y - toCrop.y;
                result2.y = source.y;
            }
            if (result2.x + result2.width > source.x + source.width) {
                result2.width = source.x + source.width - result2.x;
            }
            if (result2.y + result2.height > source.y + source.height) {
                result2.height = source.y + source.height - result2.y;
            }
            return result2;
        }

        public static Dimension getPopupSize(JBPopup popup2) {
            String dimensionKey;
            Dimension size = null;
            if (popup2 instanceof AbstractPopup && (dimensionKey = ((AbstractPopup)popup2).getDimensionServiceKey()) != null) {
                size = DimensionService.getInstance().getSize(dimensionKey);
            }
            if (size == null) {
                size = popup2.getContent().getPreferredSize();
            }
            return size;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "popup";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "traversalPolicy";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "d";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/popup/PopupPositionManager$PositionAdjuster";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/popup/PopupPositionManager$PositionAdjuster";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "adjustBounds";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "adjust";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "adjustBounds";
                    break;
                }
                case 7: 
                case 8: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class PositionAdjuster2
    extends PositionAdjuster {
        private final Component myTopComponent;

        private PositionAdjuster2(Component relativeTo, Component topComponent) {
            super(relativeTo);
            this.myTopComponent = topComponent == null ? relativeTo : topComponent;
        }

        @Override
        protected int getYForTopPositioning() {
            return this.myTopComponent.getLocationOnScreen().y;
        }
    }

    public static enum Position {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

    }
}

