/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.util.gotoByName.QuickSearchComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.popup.PopupUpdateProcessorBase;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class PopupUpdateProcessor
extends PopupUpdateProcessorBase {
    private final Project myProject;

    protected PopupUpdateProcessor(Project project2) {
        this.myProject = project2;
    }

    public void beforeShown(final @NotNull LightweightWindowEvent windowEvent) {
        LookupEx activeLookup;
        if (windowEvent == null) {
            PopupUpdateProcessor.$$$reportNull$$$0(0);
        }
        if ((activeLookup = LookupManager.getInstance(this.myProject).getActiveLookup()) != null) {
            activeLookup.addLookupListener(new LookupListener(){

                @Override
                public void currentItemChanged(@NotNull LookupEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (windowEvent.asPopup().isVisible()) {
                        LookupElement item = event.getItem();
                        if (item != null) {
                            PsiElement targetElement = DocumentationManager.getInstance(PopupUpdateProcessor.this.myProject).getElementFromLookup(activeLookup.getEditor(), activeLookup.getPsiFile());
                            PopupUpdateProcessor.this.updatePopup(targetElement);
                        }
                    } else {
                        activeLookup.removeLookupListener(this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/popup/PopupUpdateProcessor$1", "currentItemChanged"));
                }
            });
        } else {
            HintUpdateSupply supply;
            Component focusedComponent = WindowManagerEx.getInstanceEx().getFocusedComponent(this.myProject);
            QuickSearchComponent quickSearch = PopupUpdateProcessor.findQuickSearchComponent(focusedComponent);
            if (quickSearch != null) {
                quickSearch.registerHint(windowEvent.asPopup());
            } else if (focusedComponent instanceof JComponent && (supply = HintUpdateSupply.getSupply((JComponent)((JComponent)focusedComponent))) != null) {
                supply.registerHint(windowEvent.asPopup());
            }
        }
    }

    private static QuickSearchComponent findQuickSearchComponent(Component c) {
        return ComponentUtil.getParentOfType(QuickSearchComponent.class, c);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "windowEvent", "com/intellij/ui/popup/PopupUpdateProcessor", "beforeShown"));
    }
}

