/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jetbrains.integratedBinaryPacking.IntBitPacker;
import org.jetbrains.mvstore.DataUtil;
import org.jetbrains.mvstore.type.DataType;

public final class ImageValue {
    final int[] data;
    final int w;
    final int h;

    ImageValue(int[] data2, int w, int h) {
        this.data = data2;
        this.w = w;
        this.h = h;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageValue value = (ImageValue)o;
        return this.w == value.w && this.h == value.h && Arrays.equals(this.data, value.data);
    }

    public int hashCode() {
        int result2 = Arrays.hashCode(this.data);
        result2 = 31 * result2 + this.w;
        result2 = 31 * result2 + this.h;
        return result2;
    }

    public static final class ImageValueSerializer
    implements DataType<ImageValue> {
        public ImageValue[] createStorage(int size) {
            return new ImageValue[size];
        }

        @Override
        public int getMemory(ImageValue obj) {
            return 10 + obj.data.length * 4 + 1;
        }

        @Override
        public int getFixedMemory() {
            return -1;
        }

        @Override
        public void write(ByteBuf buf, ImageValue obj) {
            if (obj.w == obj.h) {
                if (obj.w < 254) {
                    buf.writeByte(obj.w);
                } else {
                    buf.writeByte(255);
                    IntBitPacker.writeVar(buf, obj.w);
                }
            } else {
                buf.writeByte(254);
                IntBitPacker.writeVar(buf, obj.w);
                IntBitPacker.writeVar(buf, obj.h);
            }
            for (int i : obj.data) {
                buf.writeInt(i);
            }
        }

        @Override
        public ImageValue read(ByteBuf buf) {
            int actualHeight;
            int actualWidth;
            int format = buf.readUnsignedByte();
            if (format < 254) {
                actualWidth = format;
                actualHeight = format;
            } else if (format == 255) {
                actualHeight = actualWidth = IntBitPacker.readVar(buf);
            } else {
                actualWidth = IntBitPacker.readVar(buf);
                actualHeight = IntBitPacker.readVar(buf);
            }
            int length = actualWidth * actualHeight;
            int[] data2 = new int[length];
            int lengthInBytes = length << 2;
            ByteBuffer nioBuf = DataUtil.getNioBuffer(buf, buf.readerIndex(), lengthInBytes);
            nioBuf.asIntBuffer().get(data2, 0, length);
            buf.readerIndex(buf.readerIndex() + lengthInBytes);
            return new ImageValue(data2, actualWidth, actualHeight);
        }
    }
}

