/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.hover.TableHoverListener;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.tabs.ComboBoxColorRenderer;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.ui.tabs.FileColorsConfigurableKt;
import com.intellij.ui.tabs.ScopeListPopupStep;
import com.intellij.ui.tabs.TableColorRenderer;
import com.intellij.ui.tabs.TableHeaderRenderer;
import com.intellij.ui.tabs.TableScopeRenderer;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.StatusText;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u000e\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0002J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\u001fH\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J&\u0010#\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\u001bH\u0002J\u0011\u0010&\u001a\r\u0012\t\u0012\u00070\u0016\u00a2\u0006\u0002\b'0\u001fJ\u0014\u0010(\u001a\u0006\u0012\u0002\b\u00030)2\u0006\u0010*\u001a\u00020\u001bH\u0016J\b\u0010+\u001a\u00020\u001bH\u0016J\u0010\u0010,\u001a\u00020\u00162\u0006\u0010*\u001a\u00020\u001bH\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010\t2\u0006\u0010.\u001a\u00020\u001bH\u0002J\b\u0010/\u001a\u00020\u001bH\u0016J\u0017\u00100\u001a\u0004\u0018\u00010\u001b2\u0006\u0010.\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u00101J\u001a\u00102\u001a\u0004\u0018\u0001032\u0006\u0010.\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u001bH\u0016J\u0018\u00104\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u001bH\u0016J\b\u00105\u001a\u00020\u0019H\u0016J\u0010\u00106\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u001bH\u0002J\u0010\u00107\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u001bH\u0016J\b\u00108\u001a\u00020\u0012H\u0016J\u0014\u00109\u001a\u0004\u0018\u00010\u00162\b\u0010:\u001a\u0004\u0018\u000103H\u0002J \u0010;\u001a\u00020\u00192\u0006\u0010<\u001a\u00020\u00162\u0006\u0010=\u001a\u00020\u00162\u0006\u0010>\u001a\u00020\u0019H\u0002J\u0010\u0010?\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u001bH\u0002J\"\u0010@\u001a\u00020\u00122\b\u0010:\u001a\u0004\u0018\u0001032\u0006\u0010.\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\u001bH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/intellij/ui/tabs/FileColorsTableModel;", "Ljavax/swing/table/AbstractTableModel;", "Lcom/intellij/util/ui/EditableModel;", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "manager", "Lcom/intellij/ui/tabs/FileColorManagerImpl;", "(Lcom/intellij/ui/tabs/FileColorManagerImpl;)V", "local", "", "Lcom/intellij/ui/tabs/FileColorConfiguration;", "getManager", "()Lcom/intellij/ui/tabs/FileColorManagerImpl;", "shared", "table", "Ljavax/swing/JTable;", "addRow", "", "addScopeColor", "", "scope", "Lcom/intellij/psi/search/scope/packageSet/NamedScope;", "color", "", "apply", "canExchangeRows", "", "oldRow", "", "newRow", "copy", "configuration", "", "list", "createComponent", "Ljavax/swing/JComponent;", "exchangeRows", "oldIndex", "newIndex", "getColors", "Lorg/jetbrains/annotations/Nls;", "getColumnClass", "Ljava/lang/Class;", "column", "getColumnCount", "getColumnName", "getConfiguration", "row", "getRowCount", "getSharedIndex", "(I)Ljava/lang/Integer;", "getValueAt", "", "isCellEditable", "isModified", "onRowInserted", "removeRow", "reset", "resolveCustomColor", "value", "resolveDuplicate", "scopeName", "colorName", "toSharedList", "selectRow", "setValueAt", "intellij.platform.lang.impl"})
final class FileColorsTableModel
extends AbstractTableModel
implements EditableModel,
UnnamedConfigurable {
    private final List<FileColorConfiguration> local;
    private final List<FileColorConfiguration> shared;
    private JTable table;
    @NotNull
    private final FileColorManagerImpl manager;

    /*
     * WARNING - void declaration
     */
    private final List<FileColorConfiguration> copy(List<? extends FileColorConfiguration> list2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FileColorConfiguration fileColorConfiguration = (FileColorConfiguration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            FileColorConfiguration fileColorConfiguration2 = this.copy((FileColorConfiguration)it);
            collection.add(fileColorConfiguration2);
        }
        return (List)destination$iv$iv;
    }

    private final FileColorConfiguration copy(FileColorConfiguration configuration) {
        return new FileColorConfiguration(configuration.getScopeName(), configuration.getColorID());
    }

    private final void selectRow(int row) {
        JTable jTable = this.table;
        if (jTable == null) {
            return;
        }
        JTable table = jTable;
        table.setRowSelectionInterval(row, row);
        table.scrollRectToVisible(table.getCellRect(row, 0, true));
    }

    private final FileColorConfiguration getConfiguration(int row) {
        Integer n = this.getSharedIndex(row);
        if (n == null) {
            return null;
        }
        int index = n;
        return index < 0 ? this.local.get(row) : this.shared.get(index);
    }

    private final Integer getSharedIndex(int row) {
        if (row < 0) {
            return null;
        }
        int index = row - this.local.size();
        return index < this.shared.size() ? Integer.valueOf(index) : null;
    }

    private final String resolveCustomColor(Object value) {
        String string2;
        Object object = value;
        if (!(object instanceof String)) {
            object = null;
        }
        String string3 = (String)object;
        if (string3 == null) {
            return null;
        }
        String name2 = string3;
        if (this.manager.getColor(name2) != null) {
            return name2;
        }
        JTable jTable = this.table;
        if (jTable == null) {
            return null;
        }
        JTable parent = jTable;
        Color color = ColorChooser.chooseColor((Component)parent, (String)IdeBundle.message((String)"settings.file.colors.dialog.choose.color", (Object[])new Object[0]), null);
        if (color != null) {
            Color color2;
            Color it = color2 = color;
            boolean bl = false;
            string2 = ColorUtil.toHex(it);
        } else {
            string2 = null;
        }
        return string2;
    }

    private final boolean resolveDuplicate(String scopeName, String colorName, boolean toSharedList) {
        boolean update2;
        FileColorConfiguration configuration;
        int index;
        block15: {
            Object object;
            Object oldColor;
            boolean bl;
            String title;
            JTable parent;
            block19: {
                block18: {
                    Color color;
                    Object object2;
                    block17: {
                        block16: {
                            Color color2;
                            block14: {
                                List<FileColorConfiguration> list2;
                                block13: {
                                    int n;
                                    List<FileColorConfiguration> $this$indexOfFirst$iv = list2 = toSharedList ? this.shared : this.local;
                                    boolean $i$f$indexOfFirst = false;
                                    int index$iv = 0;
                                    Iterator<FileColorConfiguration> iterator = $this$indexOfFirst$iv.iterator();
                                    while (iterator.hasNext()) {
                                        FileColorConfiguration item$iv;
                                        FileColorConfiguration it = item$iv = iterator.next();
                                        boolean bl2 = false;
                                        if (Intrinsics.areEqual((Object)it.getScopeName(), (Object)scopeName)) {
                                            n = index$iv;
                                            break block13;
                                        }
                                        ++index$iv;
                                    }
                                    n = index = -1;
                                }
                                if (index < 0) {
                                    return false;
                                }
                                JTable jTable = this.table;
                                if (jTable == null) {
                                    return false;
                                }
                                parent = jTable;
                                Project project2 = this.manager.getProject();
                                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"manager.project");
                                NamedScope namedScope = FileColorsConfigurableKt.access$findScope(scopeName, project2);
                                Intrinsics.checkNotNull((Object)namedScope);
                                String presentableName = namedScope.getPresentableName();
                                boolean bl3 = toSharedList;
                                String string2 = bl3 ? IdeBundle.message((String)"settings.file.colors.dialog.warning.shared", (Object[])new Object[]{presentableName}) : IdeBundle.message((String)"settings.file.colors.dialog.warning.local", (Object[])new Object[]{presentableName});
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"when (toSharedList) {\n  \u2026\", presentableName)\n    }");
                                title = string2;
                                configuration = list2.get(index);
                                boolean it = Intrinsics.areEqual((Object)configuration.getColorID(), (Object)colorName);
                                if (!it) break block14;
                                bl = Messages.showYesNoDialog((Component)parent, (String)IdeBundle.message((String)"settings.file.colors.dialog.warning.append", (Object[])new Object[0]), (String)title, (Icon)Messages.getWarningIcon()) != 0;
                                break block15;
                            }
                            object2 = this.manager.getColor(configuration.getColorID());
                            if (object2 == null) break block16;
                            Color it = color2 = object2;
                            boolean bl4 = false;
                            object2 = ColorUtil.toHex(it);
                            if (object2 != null) break block17;
                        }
                        object2 = "";
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"manager.getColor(configu\u2026?.let { toHex(it) } ?: \"\"");
                    oldColor = object2;
                    object = this.manager.getColor(colorName);
                    if (object == null) break block18;
                    Color it = color = object;
                    boolean bl5 = false;
                    object = ColorUtil.toHex(it);
                    if (object != null) break block19;
                }
                object = "";
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"manager.getColor(colorNa\u2026?.let { toHex(it) } ?: \"\"");
            Object newColor = object;
            bl = update2 = Messages.showOkCancelDialog((Component)parent, (String)IdeBundle.message((String)"settings.file.colors.dialog.warning.replace", (Object[])new Object[]{oldColor, newColor}), (String)title, (String)IdeBundle.message((String)"settings.file.colors.dialog.warning.update", (Object[])new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getWarningIcon()) == 0;
        }
        if (!update2) {
            return false;
        }
        configuration.setColorID(colorName);
        int row = toSharedList ? this.local.size() + index : index;
        this.fireTableRowsUpdated(row, row);
        this.selectRow(row);
        return true;
    }

    private final void onRowInserted(int row) {
        this.fireTableRowsInserted(row, row);
        this.selectRow(row);
    }

    public final void addScopeColor(@NotNull NamedScope scope, @Nullable String color) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        String string2 = this.resolveCustomColor(color);
        if (string2 == null) {
            return;
        }
        String colorName = string2;
        String string3 = scope.getScopeId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"scope.scopeId");
        if (this.resolveDuplicate(string3, colorName, false)) {
            return;
        }
        this.local.add(0, new FileColorConfiguration(scope.getScopeId(), colorName));
        this.onRowInserted(0);
    }

    @NotNull
    public final List<String> getColors() {
        List list2 = new ArrayList();
        Collection collection = list2;
        Collection<String> collection2 = this.manager.getColorNames();
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"manager.colorNames");
        Object object = collection2;
        CollectionsKt.addAll((Collection)collection, (Iterable)object);
        collection = list2;
        object = IdeBundle.message((String)"settings.file.color.custom.name", (Object[])new Object[0]);
        collection.add(object);
        return list2;
    }

    @Override
    public int getColumnCount() {
        return FileColorsConfigurableKt.access$getColumns$p().length;
    }

    @Override
    @NotNull
    public String getColumnName(int column) {
        return FileColorsConfigurableKt.access$getColumns$p()[column].getName();
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int column) {
        return FileColorsConfigurableKt.access$getColumns$p()[column].getType();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return FileColorsConfigurableKt.access$getColumns$p()[column].getEditable();
    }

    @Override
    public int getRowCount() {
        return this.local.size() + this.shared.size();
    }

    @Override
    @Nullable
    public Object getValueAt(int row, int column) {
        Object object;
        switch (column) {
            case 0: {
                FileColorConfiguration fileColorConfiguration = this.getConfiguration(row);
                if (fileColorConfiguration != null) {
                    object = fileColorConfiguration.getScopeName();
                    break;
                }
                object = null;
                break;
            }
            case 1: {
                object = this.getConfiguration(row);
                break;
            }
            case 2: {
                object = row >= this.local.size();
                break;
            }
            default: {
                object = null;
            }
        }
        return object;
    }

    @Override
    public void setValueAt(@Nullable Object value, int row, int column) {
        switch (column) {
            case 1: {
                FileColorConfiguration fileColorConfiguration = this.getConfiguration(row);
                if (fileColorConfiguration == null) {
                    return;
                }
                FileColorConfiguration configuration = fileColorConfiguration;
                String string2 = this.resolveCustomColor(value);
                if (string2 == null) {
                    return;
                }
                configuration.setColorID(string2);
                this.fireTableCellUpdated(row, column);
                break;
            }
            case 2: {
                Integer n = this.getSharedIndex(row);
                if (n == null) {
                    return;
                }
                int index = n;
                if (index < 0) {
                    FileColorConfiguration configuration = this.local.remove(row);
                    this.fireTableRowsDeleted(row, row);
                    String string3 = configuration.getScopeName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"configuration.scopeName");
                    String string4 = configuration.getColorID();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"configuration.colorID");
                    if (this.resolveDuplicate(string3, string4, true)) {
                        return;
                    }
                    this.shared.add(0, configuration);
                    this.onRowInserted(this.local.size());
                    break;
                }
                if (index >= this.shared.size()) break;
                FileColorConfiguration configuration = this.shared.remove(index);
                this.fireTableRowsDeleted(row, row);
                String string5 = configuration.getScopeName();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"configuration.scopeName");
                String string6 = configuration.getColorID();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"configuration.colorID");
                if (this.resolveDuplicate(string5, string6, false)) {
                    return;
                }
                this.local.add(configuration);
                this.onRowInserted(this.local.size() - 1);
            }
        }
    }

    @NotNull
    public Void addRow() {
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    public void removeRow(int row) {
        Integer n = this.getSharedIndex(row);
        if (n == null) {
            return;
        }
        int index = n;
        if (index < 0) {
            this.local.remove(row);
        } else {
            this.shared.remove(index);
        }
        this.fireTableRowsDeleted(row, row);
    }

    @Override
    public void exchangeRows(int oldRow, int newRow) {
        if (oldRow == newRow) {
            return;
        }
        Integer n = this.getSharedIndex(oldRow);
        if (n == null) {
            return;
        }
        int oldIndex = n;
        Integer n2 = this.getSharedIndex(newRow);
        if (n2 == null) {
            return;
        }
        int newIndex = n2;
        if (oldIndex < 0 && newIndex < 0) {
            this.exchangeRows(this.local, oldRow, newRow);
        } else {
            if (oldIndex < 0 || newIndex < 0) {
                return;
            }
            this.exchangeRows(this.shared, oldIndex, newIndex);
        }
        this.fireTableRowsUpdated(oldRow, oldRow);
        this.fireTableRowsUpdated(newRow, newRow);
    }

    private final void exchangeRows(List<FileColorConfiguration> list2, int oldIndex, int newIndex) {
        int maxIndex = RangesKt.coerceAtLeast((int)oldIndex, (int)newIndex);
        int minIndex = RangesKt.coerceAtMost((int)oldIndex, (int)newIndex);
        FileColorConfiguration maxConfiguration = list2.remove(maxIndex);
        FileColorConfiguration minConfiguration = list2.remove(minIndex);
        list2.add(minIndex, maxConfiguration);
        list2.add(maxIndex, minConfiguration);
    }

    @Override
    public boolean canExchangeRows(int oldRow, int newRow) {
        if (oldRow == newRow) {
            return true;
        }
        Integer n = this.getSharedIndex(oldRow);
        if (n == null) {
            return false;
        }
        int oldIndex = n;
        Integer n2 = this.getSharedIndex(newRow);
        if (n2 == null) {
            return false;
        }
        int newIndex = n2;
        return oldIndex < 0 == newIndex < 0;
    }

    @NotNull
    public JComponent createComponent() {
        JCheckBox editorCheckBox;
        DefaultCellEditor editorWrapper;
        TableCellEditor booleanEditor;
        TableCellEditor tableCellEditor;
        JCheckBox rendererCheckBox;
        JBTable table = new JBTable((TableModel)this);
        table.setShowGrid(false);
        TableHoverListener.DEFAULT.removeFrom((JComponent)table);
        StatusText statusText = table.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"table.emptyText");
        statusText.setText(IdeBundle.message((String)"settings.file.colors.no.colors.specified", (Object[])new Object[0]));
        table.getEmptyText().appendSecondaryText(IdeBundle.message((String)"settings.file.colors.add.colors.link", (Object[])new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, new ActionListener(this, table){
            final /* synthetic */ FileColorsTableModel this$0;
            final /* synthetic */ JBTable $table;

            public final void actionPerformed(ActionEvent it) {
                ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new ScopeListPopupStep(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"JBPopupFactory.getInstan\u2026ScopeListPopupStep(this))");
                ListPopup popup2 = listPopup;
                popup2.showInCenterOf((Component)this.$table);
            }
            {
                this.this$0 = fileColorsTableModel;
                this.$table = jBTable;
            }
        });
        ShortcutSet shortcutSet = CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD);
        Intrinsics.checkNotNullExpressionValue((Object)shortcutSet, (String)"CommonActionsPanel.getCo\u2026ActionsPanel.Buttons.ADD)");
        String string2 = KeymapUtil.getShortcutsText((Shortcut[])shortcutSet.getShortcuts());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getShortcutsText(CommonA\u2026l.Buttons.ADD).shortcuts)");
        String shortcut = string2;
        CharSequence charSequence = shortcut;
        if (charSequence.length() > 0) {
            table.getEmptyText().appendText(" (" + shortcut + ")");
        }
        this.table = (JTable)table;
        JTableHeader jTableHeader = table.getTableHeader();
        Intrinsics.checkNotNullExpressionValue((Object)jTableHeader, (String)"table.tableHeader");
        jTableHeader.setDefaultRenderer(new TableHeaderRenderer());
        table.setDefaultRenderer(String.class, (TableCellRenderer)new TableScopeRenderer(this.manager));
        Collection $this$toTypedArray$iv = this.getColors();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new String[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        ComboBox editor2 = new ComboBox(objectArray);
        editor2.setRenderer((ListCellRenderer)new ComboBoxColorRenderer(this.manager));
        table.setDefaultEditor(FileColorConfiguration.class, (TableCellEditor)new DefaultCellEditor((JComboBox)editor2));
        table.setDefaultRenderer(FileColorConfiguration.class, (TableCellRenderer)new TableColorRenderer(this.manager));
        TableCellRenderer booleanRenderer = table.getDefaultRenderer(Boolean.class);
        TableCellRenderer tableCellRenderer = booleanRenderer;
        if (!(tableCellRenderer instanceof JCheckBox)) {
            tableCellRenderer = null;
        }
        JCheckBox jCheckBox = rendererCheckBox = (JCheckBox)((Object)tableCellRenderer);
        if (jCheckBox != null) {
            jCheckBox.setHorizontalAlignment(2);
        }
        if (!((tableCellEditor = (booleanEditor = table.getDefaultEditor(Boolean.class))) instanceof DefaultCellEditor)) {
            tableCellEditor = null;
        }
        DefaultCellEditor defaultCellEditor = editorWrapper = (DefaultCellEditor)tableCellEditor;
        Component component2 = defaultCellEditor != null ? defaultCellEditor.getComponent() : null;
        if (!(component2 instanceof JCheckBox)) {
            component2 = null;
        }
        JCheckBox jCheckBox2 = editorCheckBox = (JCheckBox)component2;
        if (jCheckBox2 != null) {
            jCheckBox2.setHorizontalAlignment(2);
        }
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)((JTable)table)).setAddAction(new AnActionButtonRunnable(this){
            final /* synthetic */ FileColorsTableModel this$0;

            public final void run(AnActionButton it) {
                block0: {
                    RelativePoint relativePoint;
                    ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)new ScopeListPopupStep(this.this$0));
                    Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"JBPopupFactory.getInstan\u2026ScopeListPopupStep(this))");
                    ListPopup popup2 = listPopup;
                    AnActionButton anActionButton = it;
                    Intrinsics.checkNotNullExpressionValue((Object)anActionButton, (String)"it");
                    RelativePoint relativePoint2 = anActionButton.getPreferredPopupPoint();
                    if (relativePoint2 == null) break block0;
                    RelativePoint point = relativePoint = relativePoint2;
                    boolean bl = false;
                    popup2.show(point);
                }
            }
            {
                this.this$0 = fileColorsTableModel;
            }
        }).setAddIcon(LayeredIcon.ADD_WITH_DROPDOWN).setMoveUpActionUpdater(new AnActionButtonUpdater(this, table){
            final /* synthetic */ FileColorsTableModel this$0;
            final /* synthetic */ JBTable $table;

            public final boolean isEnabled(@NotNull AnActionEvent it) {
                boolean bl;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    int[] nArray = this.$table.getSelectedRows();
                    Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"table.selectedRows");
                    int[] $this$all$iv = nArray;
                    boolean $i$f$all = false;
                    int n = $this$all$iv.length;
                    for (int i = 0; i < n; ++i) {
                        int element$iv;
                        int it2 = element$iv = $this$all$iv[i];
                        boolean bl2 = false;
                        if (this.this$0.canExchangeRows(it2, it2 - 1)) continue;
                        bl = false;
                        break block1;
                    }
                    bl = true;
                }
                return bl;
            }
            {
                this.this$0 = fileColorsTableModel;
                this.$table = jBTable;
            }
        }).setMoveDownActionUpdater(new AnActionButtonUpdater(this, table){
            final /* synthetic */ FileColorsTableModel this$0;
            final /* synthetic */ JBTable $table;

            public final boolean isEnabled(@NotNull AnActionEvent it) {
                boolean bl;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    int[] nArray = this.$table.getSelectedRows();
                    Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"table.selectedRows");
                    int[] $this$all$iv = nArray;
                    boolean $i$f$all = false;
                    int n = $this$all$iv.length;
                    for (int i = 0; i < n; ++i) {
                        int element$iv;
                        int it2 = element$iv = $this$all$iv[i];
                        boolean bl2 = false;
                        if (this.this$0.canExchangeRows(it2, it2 + 1)) continue;
                        bl = false;
                        break block1;
                    }
                    bl = true;
                }
                return bl;
            }
            {
                this.this$0 = fileColorsTableModel;
                this.$table = jBTable;
            }
        }).createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"createDecorator(table)\n \u2026 } }\n      .createPanel()");
        return jPanel;
    }

    public boolean isModified() {
        return Intrinsics.areEqual(this.local, this.manager.getApplicationLevelConfigurations()) ^ true || Intrinsics.areEqual(this.shared, this.manager.getProjectLevelConfigurations()) ^ true;
    }

    public void apply() {
        this.manager.getModel().setConfigurations(this.copy(this.local), false);
        this.manager.getModel().setConfigurations(this.copy(this.shared), true);
    }

    public void reset() {
        this.local.clear();
        List<FileColorConfiguration> list2 = this.manager.getApplicationLevelConfigurations();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"manager.applicationLevelConfigurations");
        this.local.addAll((Collection<FileColorConfiguration>)this.copy(list2));
        this.shared.clear();
        List<FileColorConfiguration> list3 = this.manager.getProjectLevelConfigurations();
        Intrinsics.checkNotNullExpressionValue(list3, (String)"manager.projectLevelConfigurations");
        this.shared.addAll((Collection<FileColorConfiguration>)this.copy(list3));
        this.fireTableDataChanged();
    }

    @NotNull
    public final FileColorManagerImpl getManager() {
        return this.manager;
    }

    public FileColorsTableModel(@NotNull FileColorManagerImpl manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.manager = manager;
        this.local = new ArrayList();
        this.shared = new ArrayList();
    }
}

