/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class MethodInvocator {
    private static final Logger LOG = Logger.getInstance(MethodInvocator.class);
    private Method myMethod;

    public MethodInvocator(Class<?> aClass, String method2, Class<?> ... parameterTypes) {
        this(true, aClass, method2, parameterTypes);
    }

    public MethodInvocator(boolean warnIfAbsent, Class<?> aClass, String method2, Class<?> ... parameterTypes) {
        block3: {
            try {
                this.myMethod = aClass.getDeclaredMethod(method2, parameterTypes);
                if (!this.myMethod.isAccessible()) {
                    this.myMethod.setAccessible(true);
                }
            }
            catch (NoSuchMethodException e) {
                if (!warnIfAbsent) break block3;
                LOG.warn("Method not found: " + aClass.getName() + "." + method2);
            }
        }
    }

    public boolean isAvailable() {
        return this.myMethod != null;
    }

    public Object invoke(Object object, Object ... arguments) {
        if (!this.isAvailable()) {
            throw new IllegalStateException("Method is not available");
        }
        try {
            return this.myMethod.invoke(object, arguments);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

