/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtilRt;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathUtilRt {
    private static final String WINDOWS_INVALID_CHARS = "<>:\"|?*";
    private static final Set<String> WINDOWS_RESERVED_NAMES = new HashSet<String>(Arrays.asList("CON", "PRN", "AUX", "NUL", "COM1", "COM2", "COM3", "COM4", "COM5", "COM6", "COM7", "COM8", "COM9", "LPT1", "LPT2", "LPT3", "LPT4", "LPT5", "LPT6", "LPT7", "LPT8", "LPT9"));
    private static final Charset FS_CHARSET = PathUtilRt.fsCharset();

    @NotNull
    public static String getFileName(@Nullable String path2) {
        if (StringUtilRt.isEmpty(path2)) {
            return "";
        }
        int end = PathUtilRt.getEnd(path2);
        int start2 = PathUtilRt.getLastIndexOfPathSeparator(path2, end);
        if (PathUtilRt.isWindowsUNCRoot(path2, start2)) {
            start2 = -1;
        }
        String string2 = path2.substring(start2 + 1, end);
        if (string2 == null) {
            PathUtilRt.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Nullable
    public static String getFileExtension(@Nullable String path2) {
        if (StringUtilRt.isEmpty(path2)) {
            return null;
        }
        int end = PathUtilRt.getEnd(path2);
        int start2 = PathUtilRt.getLastIndexOfPathSeparator(path2, end) + 1;
        int index = StringUtilRt.lastIndexOf(path2, '.', Math.max(start2, 0), end);
        return index < 0 ? null : path2.substring(index + 1, end);
    }

    private static int getEnd(@NotNull String path2) {
        if (path2 == null) {
            PathUtilRt.$$$reportNull$$$0(1);
        }
        for (int index = path2.length() - 1; index >= 0; --index) {
            char c = path2.charAt(index);
            if (c == '/' || c == '\\') continue;
            return index + 1;
        }
        return path2.length() - 1;
    }

    @NotNull
    public static String getParentPath(@NotNull String path2) {
        if (path2 == null) {
            PathUtilRt.$$$reportNull$$$0(2);
        }
        if (path2.isEmpty()) {
            return "";
        }
        int end = Math.max(path2.lastIndexOf(47), path2.lastIndexOf(92));
        if (end == path2.length() - 1) {
            end = PathUtilRt.getLastIndexOfPathSeparator(path2, end);
        }
        if (end == -1 || end == 0) {
            return "";
        }
        if (PathUtilRt.isWindowsUNCRoot(path2, end)) {
            return "";
        }
        char prev = path2.charAt(end - 1);
        if (prev == '/' || prev == '\\') {
            --end;
        }
        String string2 = path2.substring(0, end);
        if (string2 == null) {
            PathUtilRt.$$$reportNull$$$0(3);
        }
        return string2;
    }

    private static int getLastIndexOfPathSeparator(@NotNull CharSequence path2, int end) {
        if (path2 == null) {
            PathUtilRt.$$$reportNull$$$0(4);
        }
        return Math.max(StringUtilRt.lastIndexOf(path2, '/', 0, end - 1), StringUtilRt.lastIndexOf(path2, '\\', 0, end - 1));
    }

    public static boolean isWindowsUNCRoot(@NotNull CharSequence path2, int lastPathSeparatorPosition) {
        if (path2 == null) {
            PathUtilRt.$$$reportNull$$$0(5);
        }
        return Platform.CURRENT == Platform.WINDOWS && (StringUtilRt.startsWith(path2, "//") || StringUtilRt.startsWith(path2, "\\\\")) && PathUtilRt.getLastIndexOfPathSeparator(path2, lastPathSeparatorPosition) == 1;
    }

    @NotNull
    public static String suggestFileName(@NotNull String text2) {
        if (text2 == null) {
            PathUtilRt.$$$reportNull$$$0(6);
        }
        return PathUtilRt.suggestFileName(text2, false, false);
    }

    @NotNull
    public static String suggestFileName(@NotNull String text2, boolean allowDots, boolean allowSpaces) {
        if (text2 == null) {
            PathUtilRt.$$$reportNull$$$0(7);
        }
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (!PathUtilRt.isValidFileNameChar(c, Platform.CURRENT, true) || !allowDots && c == '.' || !allowSpaces && Character.isWhitespace(c)) {
                result2.append('_');
                continue;
            }
            result2.append(c);
        }
        String string2 = result2.toString();
        if (string2 == null) {
            PathUtilRt.$$$reportNull$$$0(8);
        }
        return string2;
    }

    public static boolean isValidFileName(@NotNull String fileName, boolean strict) {
        if (fileName == null) {
            PathUtilRt.$$$reportNull$$$0(9);
        }
        return PathUtilRt.isValidFileName(fileName, Platform.CURRENT, strict, FS_CHARSET);
    }

    public static boolean isValidFileName(@NotNull String name2, @NotNull Platform os, boolean strict, @Nullable Charset cs) {
        if (name2 == null) {
            PathUtilRt.$$$reportNull$$$0(10);
        }
        if (os == null) {
            PathUtilRt.$$$reportNull$$$0(11);
        }
        if (name2.isEmpty() || name2.equals(".") || name2.equals("..")) {
            return false;
        }
        for (int i = 0; i < name2.length(); ++i) {
            if (PathUtilRt.isValidFileNameChar(name2.charAt(i), os, strict)) continue;
            return false;
        }
        if (os == Platform.WINDOWS && name2.length() >= 3 && name2.length() <= 4 && WINDOWS_RESERVED_NAMES.contains(name2.toUpperCase(Locale.ENGLISH))) {
            return false;
        }
        return cs == null || cs.canEncode() && cs.newEncoder().canEncode(name2);
    }

    private static boolean isValidFileNameChar(char c, Platform os, boolean strict) {
        if (c == '/' || c == '\\') {
            return false;
        }
        if (!(!strict && os != Platform.WINDOWS || c >= ' ' && WINDOWS_INVALID_CHARS.indexOf(c) < 0)) {
            return false;
        }
        return !strict || c != ';';
    }

    private static Charset fsCharset() {
        String property;
        if (!SystemInfoRt.isWindows && !SystemInfoRt.isMac && (property = System.getProperty("sun.jnu.encoding")) != null) {
            try {
                return Charset.forName(property);
            }
            catch (Exception e) {
                LoggerRt.getInstance(PathUtilRt.class).warn("unknown JNU charset: " + property, e);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/PathUtilRt";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/PathUtilRt";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestFileName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getEnd";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParentPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLastIndexOfPathSeparator";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isWindowsUNCRoot";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "suggestFileName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isValidFileName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Platform {
        UNIX,
        WINDOWS;

        public static final Platform CURRENT;

        static {
            CURRENT = SystemInfoRt.isWindows ? WINDOWS : UNIX;
        }
    }
}

