/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.InitialPatternConditionPlus;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public final class PatternValuesIndex {
    public static Set<String> buildStringIndex(Collection<? extends ElementPattern<?>> patterns) {
        HashSet<String> result2 = new HashSet<String>();
        PatternValuesIndex.processStringValues(patterns, (elementPattern, value) -> {
            for (Object o : value) {
                if (!(o instanceof String)) continue;
                result2.add((String)o);
            }
            return true;
        });
        return result2;
    }

    public static boolean processStringValues(Collection<? extends ElementPattern<?>> patterns, PairProcessor<? super ElementPattern<?>, ? super Collection<Object>> valueProcessor) {
        LinkedList<ElementPattern> stack = new LinkedList<ElementPattern>();
        for (ElementPattern<?> next : patterns) {
            stack.add(next);
            while (!stack.isEmpty()) {
                ElementPattern pattern = (ElementPattern)stack.removeFirst();
                ElementPatternCondition patternCondition = pattern.getCondition();
                InitialPatternCondition initialCondition = patternCondition.getInitialCondition();
                if (initialCondition instanceof InitialPatternConditionPlus) {
                    ContainerUtil.addAllNotNull(stack, ((InitialPatternConditionPlus)initialCondition).getPatterns());
                }
                for (PatternCondition condition : patternCondition.getConditions()) {
                    Collection values2;
                    if (condition instanceof PatternConditionPlus) {
                        stack.add(((PatternConditionPlus)condition).getValuePattern());
                        continue;
                    }
                    if (!(condition instanceof ValuePatternCondition) || valueProcessor.process(next, values2 = ((ValuePatternCondition)condition).getValues())) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

