/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.text.Strings;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.UrlClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static byte @Nullable [] getResourceAsBytes(@NotNull String path2, @NotNull ClassLoader classLoader) throws IOException {
        if (path2 == null) {
            ResourceUtil.$$$reportNull$$$0(0);
        }
        if (classLoader == null) {
            ResourceUtil.$$$reportNull$$$0(1);
        }
        return ResourceUtil.getResourceAsBytes(path2, classLoader, false);
    }

    public static byte @Nullable [] getResourceAsBytes(@NotNull String path2, @NotNull ClassLoader classLoader, boolean checkParents) throws IOException {
        if (path2 == null) {
            ResourceUtil.$$$reportNull$$$0(2);
        }
        if (classLoader == null) {
            ResourceUtil.$$$reportNull$$$0(3);
        }
        if (classLoader instanceof UrlClassLoader) {
            return ((UrlClassLoader)classLoader).getResourceAsBytes(path2, checkParents);
        }
        InputStream stream = classLoader.getResourceAsStream(path2);
        if (stream == null) {
            return null;
        }
        try (InputStream inputStream = stream;){
            byte[] byArray = stream.readAllBytes();
            return byArray;
        }
    }

    @Deprecated(forRemoval=true)
    public static URL getResource(@NotNull Class<?> loaderClass, @NonNls @NotNull String basePath, @NonNls @NotNull String fileName) {
        if (loaderClass == null) {
            ResourceUtil.$$$reportNull$$$0(4);
        }
        if (basePath == null) {
            ResourceUtil.$$$reportNull$$$0(5);
        }
        if (fileName == null) {
            ResourceUtil.$$$reportNull$$$0(6);
        }
        return ResourceUtil.getResource(loaderClass.getClassLoader(), basePath, fileName);
    }

    public static InputStream getResourceAsStream(@NotNull ClassLoader loader, @NonNls @NotNull String basePath, @NonNls @NotNull String fileName) {
        String fixedPath;
        if (loader == null) {
            ResourceUtil.$$$reportNull$$$0(7);
        }
        if (basePath == null) {
            ResourceUtil.$$$reportNull$$$0(8);
        }
        if (fileName == null) {
            ResourceUtil.$$$reportNull$$$0(9);
        }
        if ((fixedPath = Strings.trimStart(Strings.trimEnd(basePath, "/"), "/")).isEmpty()) {
            return loader.getResourceAsStream(fileName);
        }
        List<String> bundles = ResourceUtil.calculateBundleNames(fixedPath, Locale.getDefault());
        for (String bundle : bundles) {
            InputStream stream = loader.getResourceAsStream(bundle + "/" + fileName);
            if (stream == null) continue;
            return stream;
        }
        return loader.getResourceAsStream(fixedPath + "/" + fileName);
    }

    public static URL getResource(@NotNull ClassLoader loader, @NonNls @NotNull String basePath, @NonNls @NotNull String fileName) {
        if (loader == null) {
            ResourceUtil.$$$reportNull$$$0(10);
        }
        if (basePath == null) {
            ResourceUtil.$$$reportNull$$$0(11);
        }
        if (fileName == null) {
            ResourceUtil.$$$reportNull$$$0(12);
        }
        String fixedPath = Strings.trimStart(Strings.trimEnd(basePath, "/"), "/");
        List<String> bundles = ResourceUtil.calculateBundleNames(fixedPath, Locale.getDefault());
        for (String bundle : bundles) {
            URL url = loader.getResource(bundle + "/" + fileName);
            if (url == null) continue;
            try {
                url.openConnection();
            }
            catch (IOException e) {
                continue;
            }
            return url;
        }
        return loader.getResource(fixedPath + "/" + fileName);
    }

    @NotNull
    private static List<String> calculateBundleNames(@NotNull String baseName, @NotNull Locale locale) {
        if (baseName == null) {
            ResourceUtil.$$$reportNull$$$0(13);
        }
        if (locale == null) {
            ResourceUtil.$$$reportNull$$$0(14);
        }
        ArrayList<String> result2 = new ArrayList<String>(3);
        result2.add(0, baseName);
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        if (languageLength + countryLength + variantLength == 0) {
            ArrayList<String> arrayList = result2;
            if (arrayList == null) {
                ResourceUtil.$$$reportNull$$$0(15);
            }
            return arrayList;
        }
        StringBuilder temp = new StringBuilder(baseName);
        temp.append('_');
        temp.append(language);
        if (languageLength > 0) {
            result2.add(0, temp.toString());
        }
        if (countryLength + variantLength == 0) {
            ArrayList<String> arrayList = result2;
            if (arrayList == null) {
                ResourceUtil.$$$reportNull$$$0(16);
            }
            return arrayList;
        }
        temp.append('_');
        temp.append(country);
        if (countryLength > 0) {
            result2.add(0, temp.toString());
        }
        if (variantLength == 0) {
            ArrayList<String> arrayList = result2;
            if (arrayList == null) {
                ResourceUtil.$$$reportNull$$$0(17);
            }
            return arrayList;
        }
        temp.append('_');
        temp.append(variant);
        result2.add(0, temp.toString());
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            ResourceUtil.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static String loadText(@NotNull URL url) throws IOException {
        if (url == null) {
            ResourceUtil.$$$reportNull$$$0(19);
        }
        return ResourceUtil.loadText(URLUtil.openStream(url));
    }

    @NotNull
    public static String loadText(@NotNull InputStream in) throws IOException {
        if (in == null) {
            ResourceUtil.$$$reportNull$$$0(20);
        }
        InputStream inputStream = in;
        String string2 = new String(in.readAllBytes(), StandardCharsets.UTF_8);
        String string3 = string2;
        if (string3 == null) {
            ResourceUtil.$$$reportNull$$$0(21);
        }
        return string3;
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaderClass";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ResourceUtil";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ResourceUtil";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateBundleNames";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsBytes";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getResource";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsStream";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "calculateBundleNames";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

