/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.svg.SvgCacheManager;
import com.intellij.ui.svg.SvgDocumentFactoryKt;
import com.intellij.ui.svg.SvgPrebuiltCacheManager;
import com.intellij.ui.svg.SvgTranscoder;
import com.intellij.util.ImageLoader;
import com.intellij.util.SVGLoaderKt;
import com.intellij.util.SvgCache;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.ImageUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.batik.transcoder.TranscoderException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002TUB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001c\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0007J\"\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\u001a2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0007J\u0018\u0010)\u001a\u00020*2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u0010)\u001a\u00020*2\u0006\u0010\u0019\u001a\u00020+2\u0006\u0010\"\u001a\u00020#H\u0007J2\u0010)\u001a\u00020*2\b\u0010\u0019\u001a\u0004\u0018\u00010+2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(2\u0006\u0010,\u001a\u00020%2\u0006\u0010-\u001a\u00020%H\u0007J\"\u0010)\u001a\u00020*2\b\u0010\u0019\u001a\u0004\u0018\u00010+2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0007J4\u0010)\u001a\u00020*2\b\u0010&\u001a\u0004\u0018\u00010\u001a2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#2\u0006\u0010.\u001a\u00020\u000e2\b\u0010/\u001a\u0004\u0018\u00010 H\u0007J8\u00100\u001a\u0002012\b\u0010&\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\"\u001a\u00020#2\b\u0010/\u001a\u0004\u0018\u00010 2\b\u00102\u001a\u0004\u0018\u00010\u001eH\u0002JN\u00103\u001a\u0004\u0018\u00010*2\f\u00104\u001a\b\u0012\u0002\b\u0003\u0018\u0001052\b\u00106\u001a\u0004\u0018\u0001072\u0006\u0010&\u001a\u00020\u001a2\u0006\u00108\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020#2\u0006\u0010.\u001a\u00020\u000e2\n\b\u0002\u0010/\u001a\u0004\u0018\u00010 H\u0007J\"\u00109\u001a\u00020*2\b\u0010\u0019\u001a\u0004\u0018\u00010+2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020(H\u0007J\u0018\u0010;\u001a\u0002012\u0006\u0010<\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0007J<\u0010=\u001a\u0004\u0018\u00010>2\b\u0010?\u001a\u0004\u0018\u00010\u001e2\u0012\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0A2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00040AH\u0007J4\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\b\u0010G\u001a\u0004\u0018\u00010H2\b\u0010I\u001a\u0004\u0018\u00010J2\u0006\u0010K\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\u0004H\u0007J\u001a\u0010M\u001a\u00020D2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010N\u001a\u00020\u0018H\u0002J\u0012\u0010O\u001a\u00020D2\b\u0010P\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010Q\u001a\u00020D2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0010\u0010R\u001a\u00020\u001a2\u0006\u0010S\u001a\u00020\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R.\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00068F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u00020\u000e8F@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\r\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006V"}, d2={"Lcom/intellij/util/SVGLoader;", "", "()V", "ICON_DEFAULT_SIZE", "", "colorPatcher", "Lcom/intellij/util/SVGLoader$SvgElementColorPatcherProvider;", "colorPatcherProvider", "getColorPatcherProvider$annotations", "getColorPatcherProvider", "()Lcom/intellij/util/SVGLoader$SvgElementColorPatcherProvider;", "setColorPatcherProvider", "(Lcom/intellij/util/SVGLoader$SvgElementColorPatcherProvider;)V", "isColorRedefinitionContext", "", "isColorRedefinitionContext$annotations", "()Z", "setColorRedefinitionContext", "(Z)V", "persistentCache", "Lcom/intellij/ui/svg/SvgCacheManager;", "getPersistentCache", "()Lcom/intellij/ui/svg/SvgCacheManager;", "createDocument", "Lorg/w3c/dom/Document;", "url", "", "inputStream", "Ljava/io/InputStream;", "data", "", "getDocumentSize", "Lcom/intellij/util/ImageLoader$Dimension2DDouble;", "stream", "scale", "", "getMaxZoomFactor", "", "path", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "load", "Ljava/awt/Image;", "Ljava/net/URL;", "width", "height", "isDark", "docSize", "loadAndCache", "Ljava/awt/image/BufferedImage;", "themeDigest", "loadFromClassResource", "resourceClass", "Ljava/lang/Class;", "classLoader", "Ljava/lang/ClassLoader;", "rasterizedCacheKey", "loadHiDPI", "context", "loadWithoutCache", "content", "newPatcher", "Lcom/intellij/util/SVGLoader$SvgElementColorPatcher;", "digest", "newPalette", "", "alphas", "paintIconWithSelection", "", "icon", "Ljavax/swing/Icon;", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "patchColors", "document", "setContextColorPatcher", "provider", "setSelectionColorPatcherProvider", "toCanonicalColor", "color", "SvgElementColorPatcher", "SvgElementColorPatcherProvider", "intellij.platform.util.ui"})
@ApiStatus.Internal
public final class SVGLoader {
    private static volatile boolean isColorRedefinitionContext;
    public static final int ICON_DEFAULT_SIZE = 16;
    @NotNull
    public static final SVGLoader INSTANCE;

    @JvmStatic
    public static /* synthetic */ void isColorRedefinitionContext$annotations() {
    }

    public static final boolean isColorRedefinitionContext() {
        return SVGLoaderKt.access$getContextColorPatcher$p() != null && isColorRedefinitionContext && EDT.isCurrentThreadEdt() && Registry.is("ide.patch.icons.on.selection", false);
    }

    public static final void setColorRedefinitionContext(boolean bl) {
        isColorRedefinitionContext = bl;
    }

    @JvmStatic
    @NotNull
    public static final Image load(@NotNull URL url, float scale) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string2 = url.getPath();
        InputStream inputStream = url.openStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"url.openStream()");
        return SVGLoader.load(string2, inputStream, scale, false, null);
    }

    @JvmStatic
    @NotNull
    public static final Image load(@NotNull InputStream stream, float scale) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        return SVGLoader.load(null, stream, scale, false, null);
    }

    @JvmStatic
    @NotNull
    public static final Image load(@Nullable URL url, @NotNull InputStream stream, float scale) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        URL uRL = url;
        return SVGLoader.load(uRL != null ? uRL.getPath() : null, stream, scale, false, null);
    }

    @JvmStatic
    @ApiStatus.Internal
    @Nullable
    public static final Image loadFromClassResource(@Nullable Class<?> resourceClass, @Nullable ClassLoader classLoader, @NotNull String path2, int rasterizedCacheKey, float scale, boolean isDark, @Nullable ImageLoader.Dimension2DDouble docSize) throws IOException {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        byte[] themeDigest = null;
        byte[] data2 = null;
        SvgPrebuiltCacheManager cache2 = SvgCache.INSTANCE.getPrebuiltPersistentCache();
        if (cache2 != null && !SVGLoader.isColorRedefinitionContext()) {
            SvgElementColorPatcher subPatcher;
            long start2 = StartUpMeasurer.getCurrentTimeIfEnabled();
            themeDigest = SVGLoaderKt.access$getDEFAULT_THEME$p();
            SvgElementColorPatcherProvider colorPatcher = SVGLoaderKt.access$getOurColorPatcher$p();
            if (colorPatcher != null && (subPatcher = colorPatcher.forPath(path2)) != null) {
                themeDigest = subPatcher.digest();
            }
            if (themeDigest != null) {
                Image image;
                if (Intrinsics.areEqual((Object)themeDigest, (Object)SVGLoaderKt.access$getDEFAULT_THEME$p()) && rasterizedCacheKey != 0) {
                    try {
                        Image image2 = cache2.loadFromCache(rasterizedCacheKey, scale, isDark, docSize);
                        if (image2 != null) {
                            Image it = image = image2;
                            boolean bl = false;
                            return it;
                        }
                        image = null;
                    }
                    catch (Throwable e) {
                        boolean $i$f$logger = false;
                        Logger logger = Logger.getInstance(SVGLoader.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                        logger.error("cannot load from prebuilt icon cache", e);
                        image = Unit.INSTANCE;
                    }
                }
                byte[] byArray = ImageLoader.getResourceData(path2, resourceClass, classLoader);
                if (byArray == null) {
                    return null;
                }
                data2 = byArray;
                SvgCacheManager svgCacheManager = SvgCache.INSTANCE.getPersistentCache();
                Intrinsics.checkNotNull((Object)svgCacheManager);
                Image image3 = svgCacheManager.loadFromCache(themeDigest, data2, scale, isDark, docSize);
                if (image3 != null) {
                    Image it = image = image3;
                    boolean bl = false;
                    return it;
                }
            }
            if (start2 != -1L) {
                IconLoadMeasurer.svgCacheRead.end(start2);
            }
        } else {
            themeDigest = null;
        }
        if (data2 == null) {
            byte[] byArray = ImageLoader.getResourceData(path2, resourceClass, classLoader);
            if (byArray == null) {
                return null;
            }
            data2 = byArray;
        }
        return INSTANCE.loadAndCache(path2, data2, scale, docSize, themeDigest);
    }

    public static /* synthetic */ Image loadFromClassResource$default(Class clazz, ClassLoader classLoader, String string2, int n, float f, boolean bl, ImageLoader.Dimension2DDouble dimension2DDouble, int n2, Object object) throws IOException {
        if ((n2 & 0x40) != 0) {
            dimension2DDouble = null;
        }
        return SVGLoader.loadFromClassResource(clazz, classLoader, string2, n, f, bl, dimension2DDouble);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final Image load(@Nullable String path2, @NotNull InputStream stream, float scale, boolean isDark, @Nullable ImageLoader.Dimension2DDouble docSize) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        SvgCacheManager persistentCache = SvgCache.INSTANCE.getPersistentCache();
        if (persistentCache == null || SVGLoader.isColorRedefinitionContext()) {
            return INSTANCE.loadAndCache(path2, stream.readAllBytes(), scale, docSize, null);
        }
        long start2 = StartUpMeasurer.getCurrentTimeIfEnabled();
        SvgElementColorPatcherProvider svgElementColorPatcherProvider = SVGLoaderKt.access$getOurColorPatcher$p();
        SvgElementColorPatcher colorPatcher = svgElementColorPatcherProvider != null ? svgElementColorPatcherProvider.forPath(path2) : null;
        byte[] themeDigest = colorPatcher == null ? SVGLoaderKt.access$getDEFAULT_THEME$p() : colorPatcher.digest();
        byte[] data2 = null;
        if (themeDigest == null) {
            data2 = null;
        } else {
            data2 = stream.readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)data2, (String)"data");
            Image image = persistentCache.loadFromCache(themeDigest, data2, scale, isDark, docSize);
            if (image != null) {
                Image image2;
                Image it = image2 = image;
                boolean bl = false;
                return it;
            }
        }
        if (start2 != -1L) {
            IconLoadMeasurer.svgCacheRead.end(start2);
        }
        return INSTANCE.loadAndCache(path2, data2, scale, docSize, themeDigest);
    }

    private final BufferedImage loadAndCache(String path2, byte[] data2, float scale, ImageLoader.Dimension2DDouble docSize, byte[] themeDigest) throws IOException {
        BufferedImage bufferedImage;
        long decodingStart = StartUpMeasurer.getCurrentTimeIfEnabled();
        try {
            bufferedImage = SvgTranscoder.Companion.createImage$default(SvgTranscoder.Companion, scale, this.createDocument(path2, data2), docSize, 0.0f, 0.0f, 24, null);
        }
        catch (TranscoderException e) {
            ImageLoader.Dimension2DDouble dimension2DDouble = docSize;
            if (dimension2DDouble != null) {
                dimension2DDouble.setSize(0.0, 0.0);
            }
            throw (Throwable)new IOException(e);
        }
        BufferedImage bufferedImage2 = bufferedImage;
        if (decodingStart != -1L) {
            IconLoadMeasurer.svgDecoding.end(decodingStart);
        }
        if (themeDigest != null) {
            try {
                long cacheWriteStart = StartUpMeasurer.getCurrentTimeIfEnabled();
                SvgCacheManager svgCacheManager = SvgCache.INSTANCE.getPersistentCache();
                if (svgCacheManager != null) {
                    Intrinsics.checkNotNull((Object)data2);
                    svgCacheManager.storeLoadedImage(themeDigest, data2, scale, bufferedImage2);
                }
                IconLoadMeasurer.svgCacheWrite.end(cacheWriteStart);
            }
            catch (Exception e) {
                Logger.getInstance(SVGLoader.class).error("Failed to write SVG cache for: " + path2, e);
            }
        }
        return bufferedImage2;
    }

    @JvmStatic
    @NotNull
    public static final BufferedImage loadWithoutCache(@NotNull byte[] content2, float scale) throws IOException {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        try {
            bufferedImage = SvgTranscoder.Companion.createImage$default(SvgTranscoder.Companion, scale, INSTANCE.createDocument(null, new ByteArrayInputStream(content2)), null, 0.0f, 0.0f, 24, null);
        }
        catch (TranscoderException e) {
            throw (Throwable)new IOException(e);
        }
        return bufferedImage;
    }

    @JvmStatic
    @NotNull
    public static final Image load(@Nullable URL url, @NotNull InputStream stream, @NotNull ScaleContext scaleContext, double width, double height) throws IOException {
        Image image;
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        try {
            double scale = scaleContext.getScale(DerivedScaleType.PIX_SCALE);
            URL uRL = url;
            image = SvgTranscoder.Companion.createImage(1.0f, INSTANCE.createDocument(uRL != null ? uRL.getPath() : null, stream), null, (float)(width * scale), (float)(height * scale));
        }
        catch (TranscoderException e) {
            throw (Throwable)new IOException(e);
        }
        return image;
    }

    @JvmStatic
    @NotNull
    public static final Image loadHiDPI(@Nullable URL url, @NotNull InputStream stream, @NotNull ScaleContext context2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        URL uRL = url;
        Image image = SVGLoader.load(uRL != null ? uRL.getPath() : null, stream, (float)context2.getScale(DerivedScaleType.PIX_SCALE), false, null);
        Image image2 = ImageUtil.ensureHiDPI(image, context2);
        Intrinsics.checkNotNullExpressionValue((Object)image2, (String)"ImageUtil.ensureHiDPI(image, context)");
        return image2;
    }

    @JvmStatic
    @NotNull
    public static final ImageLoader.Dimension2DDouble getDocumentSize(@NotNull InputStream stream, float scale) throws IOException {
        block3: {
            int n;
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            BufferExposingByteArrayOutputStream buffer = new BufferExposingByteArrayOutputStream(100);
            byte[] bytes = new byte[3];
            boolean checkClosingBracket = false;
            int ch = 0;
            while (true) {
                int n2;
                int it = n2 = stream.read();
                boolean bl = false;
                ch = it;
                if (n2 == -1) break block3;
                buffer.write(ch);
                n2 = 60;
                if (ch == n2) {
                    n = stream.read(bytes, 0, 3);
                    if (n != -1) {
                        int n3;
                        buffer.write(bytes, 0, n);
                        checkClosingBracket = n == 3 && bytes[0] == (byte)(n3 = 115) && bytes[1] == (byte)(n3 = 118) && bytes[2] == (byte)(n3 = 103);
                        continue;
                    }
                    break block3;
                }
                if (checkClosingBracket && ch == (n = 62)) break;
            }
            byte[] byArray = new byte[6];
            n = 60;
            byArray[0] = (byte)n;
            n = 47;
            byArray[1] = (byte)n;
            n = 115;
            byArray[2] = (byte)n;
            n = 118;
            byArray[3] = (byte)n;
            n = 103;
            byArray[4] = (byte)n;
            n = 62;
            byArray[5] = (byte)n;
            buffer.write(byArray);
            ByteArrayInputStream input = new ByteArrayInputStream(buffer.getInternalBuffer(), 0, buffer.size());
            return SvgTranscoder.Companion.getDocumentSize(scale, SvgDocumentFactoryKt.createSvgDocument(null, input));
        }
        return new ImageLoader.Dimension2DDouble((float)16 * scale, (float)16 * scale);
    }

    @JvmStatic
    public static final double getMaxZoomFactor(@Nullable String path2, @NotNull InputStream stream, @NotNull ScaleContext scaleContext) throws IOException {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        ImageLoader.Dimension2DDouble size = SvgTranscoder.Companion.getDocumentSize((float)scaleContext.getScale(DerivedScaleType.PIX_SCALE), INSTANCE.createDocument(path2, stream));
        float iconMaxSize2 = SvgTranscoder.Companion.getIconMaxSize();
        return RangesKt.coerceAtMost((double)((double)iconMaxSize2 / size.getWidth()), (double)((double)iconMaxSize2 / size.getHeight()));
    }

    private final Document createDocument(String url, InputStream inputStream) {
        Document document = SvgDocumentFactoryKt.createSvgDocument(url, inputStream);
        this.patchColors(url, document);
        return document;
    }

    private final Document createDocument(String url, byte[] data2) {
        Intrinsics.checkNotNull((Object)data2);
        Document document = SvgDocumentFactoryKt.createSvgDocument(url, data2);
        this.patchColors(url, document);
        return document;
    }

    private final void patchColors(String url, Document document) {
        block3: {
            SvgElementColorPatcher selectionPatcher;
            SvgElementColorPatcherProvider selectionPatcherProvider;
            SvgElementColorPatcherProvider colorPatcher = SVGLoaderKt.access$getOurColorPatcher$p();
            if (colorPatcher != null) {
                SvgElementColorPatcher patcher;
                SvgElementColorPatcher svgElementColorPatcher = patcher = colorPatcher.forPath(url);
                if (svgElementColorPatcher != null) {
                    Element element2 = document.getDocumentElement();
                    Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"document.documentElement");
                    svgElementColorPatcher.patchColors(element2);
                }
            }
            if (!SVGLoader.isColorRedefinitionContext() || (selectionPatcherProvider = SVGLoader.getColorPatcherProvider()) == null) break block3;
            SvgElementColorPatcher svgElementColorPatcher = selectionPatcher = selectionPatcherProvider.forPath(url);
            if (svgElementColorPatcher != null) {
                Element element3 = document.getDocumentElement();
                Intrinsics.checkNotNullExpressionValue((Object)element3, (String)"document.documentElement");
                svgElementColorPatcher.patchColors(element3);
            }
        }
    }

    @JvmStatic
    public static final void setContextColorPatcher(@Nullable SvgElementColorPatcherProvider provider2) {
        SVGLoaderKt.access$setContextColorPatcher$p(provider2);
    }

    @JvmStatic
    public static /* synthetic */ void getColorPatcherProvider$annotations() {
    }

    @Nullable
    public static final SvgElementColorPatcherProvider getColorPatcherProvider() {
        return SVGLoaderKt.access$getContextColorPatcher$p();
    }

    public static final void setColorPatcherProvider(@Nullable SvgElementColorPatcherProvider colorPatcher) {
        SVGLoaderKt.access$setOurColorPatcher$p(colorPatcher);
        IconLoader.clearCache();
    }

    @JvmStatic
    @Nullable
    public static final SvgElementColorPatcher newPatcher(@Nullable byte[] digest, @NotNull Map<String, String> newPalette, @NotNull Map<String, Integer> alphas) {
        Intrinsics.checkNotNullParameter(newPalette, (String)"newPalette");
        Intrinsics.checkNotNullParameter(alphas, (String)"alphas");
        return newPalette.isEmpty() ? null : (SvgElementColorPatcher)new SvgElementColorPatcher(digest, newPalette, alphas){
            final /* synthetic */ byte[] $digest;
            final /* synthetic */ Map $newPalette;
            final /* synthetic */ Map $alphas;

            @Nullable
            public byte[] digest() {
                return this.$digest;
            }

            /*
             * WARNING - void declaration
             */
            public void patchColors(@NotNull Element svg) {
                NodeList nodes;
                Intrinsics.checkNotNullParameter((Object)svg, (String)"svg");
                this.patchColorAttribute(svg, "fill");
                this.patchColorAttribute(svg, "stroke");
                NodeList nodeList = nodes = svg.getChildNodes();
                Intrinsics.checkNotNullExpressionValue((Object)nodeList, (String)"nodes");
                int length = nodeList.getLength();
                int n = 0;
                int n2 = length;
                while (n < n2) {
                    void i;
                    Node item = nodes.item((int)i);
                    if (item instanceof Element) {
                        this.patchColors((Element)item);
                    }
                    ++i;
                }
            }

            private final void patchColorAttribute(Element svg, String attrName) {
                String color = svg.getAttribute(attrName);
                String opacity = svg.getAttribute(attrName + "-opacity");
                if (!Strings.isEmpty(color)) {
                    int alpha = 255;
                    if (!Strings.isEmpty(opacity)) {
                        try {
                            String string2 = opacity;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"opacity");
                            String string3 = string2;
                            double d = 255.0f * Float.parseFloat(string3);
                            alpha = (int)Math.ceil(d);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    String newColor = null;
                    String string4 = color;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"color");
                    String key = SVGLoader.access$toCanonicalColor(SVGLoader.INSTANCE, string4);
                    if (alpha != 255) {
                        newColor = (String)this.$newPalette.get(key + Integer.toHexString(alpha));
                    }
                    if (newColor == null) {
                        newColor = (String)this.$newPalette.get(key);
                    }
                    if (newColor != null) {
                        svg.setAttribute(attrName, newColor);
                        if (this.$alphas.get(newColor) != null) {
                            String string5 = attrName + "-opacity";
                            V v = this.$alphas.get(newColor);
                            Intrinsics.checkNotNull(v);
                            svg.setAttribute(string5, String.valueOf((float)((Number)v).intValue() / 255.0f));
                        }
                    }
                }
            }
            {
                this.$digest = $captured_local_variable$0;
                this.$newPalette = $captured_local_variable$1;
                this.$alphas = $captured_local_variable$2;
            }
        };
    }

    private final String toCanonicalColor(String color) {
        String string2 = color;
        String string3 = string2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        Object s = string3;
        if (StringsKt.startsWith$default((String)s, (String)"#", (boolean)false, (int)2, null) && ((String)s).length() < 7) {
            s = "#" + ColorUtil.toHex(ColorUtil.fromHex((String)s));
        }
        return s;
    }

    @JvmStatic
    public static final void setSelectionColorPatcherProvider(@Nullable SvgElementColorPatcherProvider colorPatcher) {
        SVGLoaderKt.access$setSelectionColorPatcher$p(colorPatcher);
        IconLoader.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void paintIconWithSelection(@NotNull Icon icon2, @Nullable Component c, @Nullable Graphics g, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        if (SVGLoaderKt.access$getSelectionColorPatcher$p() == null) {
            icon2.paintIcon(c, g, x, y);
        } else {
            try {
                SVGLoader.setContextColorPatcher(SVGLoaderKt.access$getSelectionColorPatcher$p());
                isColorRedefinitionContext = true;
                icon2.paintIcon(c, g, x, y);
            }
            finally {
                SVGLoader.setContextColorPatcher(null);
                isColorRedefinitionContext = false;
            }
        }
    }

    @Nullable
    public final SvgCacheManager getPersistentCache() {
        return SvgCache.INSTANCE.getPersistentCache();
    }

    private SVGLoader() {
    }

    static {
        SVGLoader sVGLoader;
        INSTANCE = sVGLoader = new SVGLoader();
    }

    public static final /* synthetic */ String access$toCanonicalColor(SVGLoader $this, String color) {
        return $this.toCanonicalColor(color);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/intellij/util/SVGLoader$SvgElementColorPatcher;", "", "digest", "", "patchColors", "", "svg", "Lorg/w3c/dom/Element;", "intellij.platform.util.ui"})
    public static interface SvgElementColorPatcher {
        public void patchColors(@NotNull Element var1);

        @Nullable
        public byte[] digest();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/SVGLoader$SvgElementColorPatcherProvider;", "", "forPath", "Lcom/intellij/util/SVGLoader$SvgElementColorPatcher;", "path", "", "intellij.platform.util.ui"})
    public static interface SvgElementColorPatcherProvider {
        @Nullable
        public SvgElementColorPatcher forPath(@Nullable String var1);
    }
}

