/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ObjectCacheBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.Iterator;

public class ObjectCache<K, V>
extends ObjectCacheBase
implements Iterable<V> {
    public static final int DEFAULT_SIZE = 8192;
    public static final int MIN_SIZE = 4;
    private int myTop;
    private int myBack;
    private final CacheEntry<K, V>[] myCache;
    private final int[] myHashTable;
    private final int myHashTableSize;
    private int myCount;
    private int myFirstFree;
    private DeletedPairsListener[] myListeners;
    private int myAttempts;
    private int myHits;

    public ObjectCache() {
        this(8192);
    }

    public ObjectCache(int cacheSize) {
        if (cacheSize < 4) {
            cacheSize = 4;
        }
        this.myBack = 0;
        this.myTop = 0;
        this.myCache = new CacheEntry[cacheSize + 1];
        for (int i = 0; i < this.myCache.length; ++i) {
            this.myCache[i] = new CacheEntry();
        }
        this.myHashTableSize = ObjectCache.getAdjustedTableSize(cacheSize);
        this.myHashTable = new int[this.myHashTableSize];
        this.myAttempts = 0;
        this.myHits = 0;
        this.myFirstFree = 0;
        this.myCount = 0;
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public boolean containsKey(K key) {
        return this.isCached(key);
    }

    public V get(K key) {
        return this.tryKey(key);
    }

    public V put(K key, V value) {
        V oldValue = this.tryKey(key);
        if (oldValue != null) {
            this.remove(key);
        }
        this.cacheObject(key, value);
        return oldValue;
    }

    public void remove(K key) {
        int index = this.searchForCacheEntry(key);
        if (index != 0) {
            this.removeEntry(index);
            this.removeEntryFromHashTable(index);
            this.myCache[index].hash_next = this.myFirstFree;
            this.myFirstFree = index;
            Object deletedVal = this.myCache[index].value;
            this.myCache[index].key = null;
            this.myCache[index].value = null;
            this.fireListenersAboutDeletion(key, deletedVal);
        }
    }

    public void removeAll() {
        ArrayList keys2 = new ArrayList(this.count());
        int current = this.myTop;
        while (current > 0) {
            if (this.myCache[current].value != null) {
                keys2.add(this.myCache[current].key);
            }
            current = this.myCache[current].next;
        }
        for (Object key : keys2) {
            this.remove(key);
        }
    }

    public final void cacheObject(K key, V x) {
        K deletedKey = null;
        V deletedValue = null;
        int index = this.myFirstFree;
        if (this.myCount < this.myCache.length - 1) {
            if (index == 0) {
                index = this.myCount;
                ++index;
            } else {
                this.myFirstFree = this.myCache[index].hash_next;
            }
            if (this.myCount == 0) {
                this.myBack = index;
            }
        } else {
            index = this.myBack;
            this.removeEntryFromHashTable(index);
            CacheEntry<K, V> cacheEntry = this.myCache[index];
            deletedKey = cacheEntry.key;
            deletedValue = cacheEntry.value;
            this.myBack = this.myCache[index].prev;
            this.myCache[this.myCache[index].prev].next = 0;
        }
        this.myCache[index].key = key;
        this.myCache[index].value = x;
        this.addEntry2HashTable(index);
        this.add2Top(index);
        if (deletedKey != null) {
            this.fireListenersAboutDeletion(deletedKey, deletedValue);
        }
    }

    public final V tryKey(K key) {
        ++this.myAttempts;
        int index = this.searchForCacheEntry(key);
        if (index == 0) {
            return null;
        }
        ++this.myHits;
        CacheEntry<K, V> cacheEntry = this.myCache[index];
        int top = this.myTop;
        if (index != top) {
            int prev = cacheEntry.prev;
            int next = cacheEntry.next;
            if (index == this.myBack) {
                this.myBack = prev;
            } else {
                this.myCache[next].prev = prev;
            }
            this.myCache[prev].next = next;
            cacheEntry.next = top;
            cacheEntry.prev = 0;
            this.myCache[top].prev = index;
            this.myTop = index;
        }
        return this.myCache[index].value;
    }

    public final boolean isCached(K key) {
        return this.searchForCacheEntry(key) != 0;
    }

    public int count() {
        return this.myCount;
    }

    public int size() {
        return this.myCache.length - 1;
    }

    public double hitRate() {
        return this.myAttempts > 0 ? (double)this.myHits / (double)this.myAttempts : 0.0;
    }

    private void add2Top(int index) {
        this.myCache[index].next = this.myTop;
        this.myCache[index].prev = 0;
        this.myCache[this.myTop].prev = index;
        this.myTop = index;
    }

    private void removeEntry(int index) {
        if (index == this.myBack) {
            this.myBack = this.myCache[index].prev;
        } else {
            this.myCache[this.myCache[index].next].prev = this.myCache[index].prev;
        }
        if (index == this.myTop) {
            this.myTop = this.myCache[index].next;
        } else {
            this.myCache[this.myCache[index].prev].next = this.myCache[index].next;
        }
    }

    private void addEntry2HashTable(int index) {
        int hash_index = (this.myCache[index].key.hashCode() & Integer.MAX_VALUE) % this.myHashTableSize;
        this.myCache[index].hash_next = this.myHashTable[hash_index];
        this.myHashTable[hash_index] = index;
        ++this.myCount;
    }

    private void removeEntryFromHashTable(int index) {
        int hash_index = (this.myCache[index].key.hashCode() & Integer.MAX_VALUE) % this.myHashTableSize;
        int current = this.myHashTable[hash_index];
        int previous = 0;
        while (current != 0) {
            int next = this.myCache[current].hash_next;
            if (current == index) {
                if (previous != 0) {
                    this.myCache[previous].hash_next = next;
                } else {
                    this.myHashTable[hash_index] = next;
                }
                --this.myCount;
                break;
            }
            previous = current;
            current = next;
        }
    }

    private int searchForCacheEntry(K key) {
        int index = (key.hashCode() & Integer.MAX_VALUE) % this.myHashTableSize;
        int current = this.myHashTable[index];
        this.myCache[0].key = key;
        while (!key.equals(this.myCache[current].key)) {
            current = this.myCache[current].hash_next;
        }
        return current;
    }

    @Override
    public Iterator<V> iterator() {
        return new ObjectCacheIterator(this);
    }

    public void addDeletedPairsListener(DeletedPairsListener listener2) {
        this.myListeners = this.myListeners == null ? new DeletedPairsListener[1] : Arrays.copyOf(this.myListeners, this.myListeners.length + 1);
        this.myListeners[this.myListeners.length - 1] = listener2;
    }

    public void removeDeletedPairsListener(DeletedPairsListener listener2) {
        if (this.myListeners != null) {
            if (this.myListeners.length == 1) {
                this.myListeners = null;
            } else {
                DeletedPairsListener[] newListeners = new DeletedPairsListener[this.myListeners.length - 1];
                int i = 0;
                for (DeletedPairsListener myListener : this.myListeners) {
                    if (myListener == listener2) continue;
                    newListeners[i++] = myListener;
                }
                this.myListeners = newListeners;
            }
        }
    }

    private void fireListenersAboutDeletion(K key, V value) {
        if (this.myListeners != null) {
            for (DeletedPairsListener myListener : this.myListeners) {
                myListener.objectRemoved(key, value);
            }
        }
    }

    public static interface DeletedPairsListener
    extends EventListener {
        public void objectRemoved(Object var1, Object var2);
    }

    protected static class ObjectCacheIterator<K, V>
    implements Iterator<V> {
        private final ObjectCache<? super K, ? extends V> myCache;
        private int myCurrentEntry;

        public ObjectCacheIterator(ObjectCache<? super K, ? extends V> cache2) {
            this.myCache = cache2;
            this.myCurrentEntry = 0;
            ((ObjectCache)cache2).myCache[0].next = ((ObjectCache)cache2).myTop;
        }

        @Override
        public boolean hasNext() {
            this.myCurrentEntry = ((ObjectCache)this.myCache).myCache[this.myCurrentEntry].next;
            return this.myCurrentEntry != 0;
        }

        @Override
        public V next() {
            return ((ObjectCache)this.myCache).myCache[this.myCurrentEntry].value;
        }

        @Override
        public void remove() {
            this.myCache.remove(((ObjectCache)this.myCache).myCache[this.myCurrentEntry].key);
        }
    }

    protected static class CacheEntry<K, V> {
        public K key;
        public V value;
        public int prev;
        public int next;
        public int hash_next;

        protected CacheEntry() {
        }
    }
}

