/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.BuildableRootsChangeRescanningInfo;
import com.intellij.util.indexing.BuildableRootsChangeRescanningInfoImpl;
import com.intellij.util.indexing.EntityIndexingService;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.RootChangesLogger;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.builders.IndexableIteratorBuilders;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.legacyBridge.project.ProjectRootsChangeListener;
import com.intellij.workspaceModel.storage.EntityChange;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.api.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.ModuleId;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Pair;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

class EntityIndexingServiceImpl
implements EntityIndexingService {
    private static final Logger LOG = Logger.getInstance(EntityIndexingServiceImpl.class);
    private static final RootChangesLogger ROOT_CHANGES_LOGGER = new RootChangesLogger();

    EntityIndexingServiceImpl() {
    }

    public void indexChanges(@NotNull Project project2, @NotNull List<? extends RootsChangeRescanningInfo> changes) {
        if (project2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(0);
        }
        if (changes == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(1);
        }
        if (!(FileBasedIndex.getInstance() instanceof FileBasedIndexImpl)) {
            return;
        }
        if (LightEdit.owns((Project)project2)) {
            return;
        }
        if (changes.isEmpty()) {
            EntityIndexingServiceImpl.runFullRescan(project2, "Project roots have changed");
        }
        boolean fullReindexOnBuildableChanges = Registry.is("indexing.full.rescan.on.buildable.changes");
        for (RootsChangeRescanningInfo rootsChangeRescanningInfo : changes) {
            if (rootsChangeRescanningInfo == RootsChangeRescanningInfo.TOTAL_RESCAN) {
                EntityIndexingServiceImpl.runFullRescan(project2, "Reindex requested by project root model changes");
                return;
            }
            if (!fullReindexOnBuildableChanges || !(rootsChangeRescanningInfo instanceof BuildableRootsChangeRescanningInfo)) continue;
            EntityIndexingServiceImpl.runFullRescan(project2, "Reindex requested by buildable changes");
            return;
        }
        SmartList<? extends IndexableEntityProvider.IndexableIteratorBuilder> builders = new SmartList<IndexableEntityProvider.IndexableIteratorBuilder>();
        EntityStorage entityStorage = WorkspaceModel.getInstance(project2).getEntityStorage().getCurrent();
        for (RootsChangeRescanningInfo rootsChangeRescanningInfo : changes) {
            if (rootsChangeRescanningInfo == RootsChangeRescanningInfo.NO_RESCAN_NEEDED) continue;
            if (rootsChangeRescanningInfo instanceof ProjectRootsChangeListener.WorkspaceEventRescanningInfo) {
                builders.addAll(EntityIndexingServiceImpl.getBuildersOnWorkspaceChange(project2, ((ProjectRootsChangeListener.WorkspaceEventRescanningInfo)rootsChangeRescanningInfo).getEvents()));
                continue;
            }
            if (rootsChangeRescanningInfo instanceof BuildableRootsChangeRescanningInfo) {
                builders.addAll(EntityIndexingServiceImpl.getBuildersOnBuildableChangeInfo((BuildableRootsChangeRescanningInfo)rootsChangeRescanningInfo));
                continue;
            }
            LOG.warn("Unexpected change " + rootsChangeRescanningInfo.getClass() + " " + rootsChangeRescanningInfo + ", full reindex requested");
            EntityIndexingServiceImpl.runFullRescan(project2, "Reindex on unexpected change in EntityIndexingServiceImpl");
            return;
        }
        if (!builders.isEmpty()) {
            List<IndexableFilesIterator> mergedIterators = IndexableIteratorBuilders.INSTANCE.instantiateBuilders(builders, project2, entityStorage);
            List<String> list2 = ContainerUtil.map(mergedIterators, it -> it.getDebugName());
            LOG.debug("Accumulated iterators: " + list2);
            int maxNamesToLog = 10;
            String reasonMessage = "changes in: " + list2.stream().limit(maxNamesToLog).map(n -> StringUtil.wrapWithDoubleQuote(n)).collect(Collectors.joining(", "));
            if (list2.size() > maxNamesToLog) {
                reasonMessage = reasonMessage + " and " + (list2.size() - maxNamesToLog) + " iterators more";
            }
            EntityIndexingServiceImpl.logRootChanges(project2, false);
            new UnindexedFilesUpdater(project2, mergedIterators, reasonMessage).queue(project2);
        }
    }

    private static void runFullRescan(@NotNull Project project2, @NotNull @NonNls String reason) {
        if (project2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(2);
        }
        if (reason == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(3);
        }
        EntityIndexingServiceImpl.logRootChanges(project2, true);
        new UnindexedFilesUpdater(project2, reason).queue(project2);
    }

    private static void logRootChanges(@NotNull Project project2, boolean isFullReindex) {
        if (project2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (LOG.isDebugEnabled()) {
                String message2 = isFullReindex ? "Project roots of " + project2.getName() + " have changed" : "Project roots of " + project2.getName() + " will be partially reindexed";
                LOG.debug(message2, new Throwable());
            }
        } else {
            ROOT_CHANGES_LOGGER.info(project2, isFullReindex);
        }
    }

    @TestOnly
    @NotNull
    static List<IndexableFilesIterator> getIterators(@NotNull Project project2, @NotNull Collection<EntityChange<?>> events) {
        if (project2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(5);
        }
        if (events == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(6);
        }
        EntityStorage entityStorage = WorkspaceModel.getInstance(project2).getEntityStorage().getCurrent();
        List<IndexableEntityProvider.IndexableIteratorBuilder> result2 = EntityIndexingServiceImpl.getBuildersOnWorkspaceChange(project2, events);
        List<IndexableFilesIterator> list2 = IndexableIteratorBuilders.INSTANCE.instantiateBuilders(result2, project2, entityStorage);
        if (list2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    private static List<IndexableEntityProvider.IndexableIteratorBuilder> getBuildersOnWorkspaceChange(@NotNull Project project2, @NotNull Collection<EntityChange<?>> event) {
        if (project2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(8);
        }
        if (event == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(9);
        }
        SmartList<IndexableEntityProvider.IndexableIteratorBuilder> builders = new SmartList<IndexableEntityProvider.IndexableIteratorBuilder>();
        for (EntityChange<?> change : event) {
            WorkspaceEntity entity;
            if (change instanceof EntityChange.Added) {
                entity = ((EntityChange.Added)change).getEntity();
                EntityIndexingServiceImpl.collectIteratorBuildersOnAdd(entity, project2, builders);
                continue;
            }
            if (change instanceof EntityChange.Replaced) {
                WorkspaceEntity newEntity2 = ((EntityChange.Replaced)change).getNewEntity();
                WorkspaceEntity oldEntity = ((EntityChange.Replaced)change).getOldEntity();
                EntityIndexingServiceImpl.collectIteratorBuildersOnReplace(oldEntity, newEntity2, project2, builders);
                continue;
            }
            if (change instanceof EntityChange.Removed) {
                entity = ((EntityChange.Removed)change).getEntity();
                EntityIndexingServiceImpl.collectIteratorBuildersOnRemove(entity, project2, builders);
                continue;
            }
            LOG.error("Unexpected change " + change.getClass() + " " + change);
        }
        SmartList<IndexableEntityProvider.IndexableIteratorBuilder> smartList = builders;
        if (smartList == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(10);
        }
        return smartList;
    }

    private static <E extends WorkspaceEntity> void collectIteratorBuildersOnAdd(@NotNull E entity, @NotNull Project project2, @NotNull Collection<IndexableEntityProvider.IndexableIteratorBuilder> builders) {
        if (entity == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(11);
        }
        if (project2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(12);
        }
        if (builders == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(13);
        }
        Class entityClass = entity.getEntityInterface();
        for (IndexableEntityProvider<? extends WorkspaceEntity> provider2 : IndexableEntityProvider.EP_NAME.getExtensionList()) {
            if (entityClass != provider2.getEntityClass()) continue;
            builders.addAll(provider2.getAddedEntityIteratorBuilders(entity, project2));
        }
    }

    private static <E extends WorkspaceEntity> void collectIteratorBuildersOnReplace(@NotNull E oldEntity, @NotNull E newEntity2, @NotNull Project project2, @NotNull Collection<IndexableEntityProvider.IndexableIteratorBuilder> builders) {
        if (oldEntity == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(14);
        }
        if (newEntity2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(15);
        }
        if (project2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(16);
        }
        if (builders == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(17);
        }
        Class entityClass = oldEntity.getEntityInterface();
        for (IndexableEntityProvider<? extends WorkspaceEntity> provider2 : IndexableEntityProvider.EP_NAME.getExtensionList()) {
            if (entityClass != provider2.getEntityClass()) continue;
            builders.addAll(provider2.getReplacedEntityIteratorBuilders(oldEntity, newEntity2));
        }
        if (oldEntity instanceof ModuleEntity) {
            ModuleEntity oldModule = (ModuleEntity)oldEntity;
            ModuleEntity newModule = (ModuleEntity)newEntity2;
            for (IndexableEntityProvider<? extends WorkspaceEntity> provider3 : IndexableEntityProvider.EP_NAME.getExtensionList()) {
                if (!(provider3 instanceof IndexableEntityProvider.ModuleEntityDependent)) continue;
                builders.addAll(((IndexableEntityProvider.ModuleEntityDependent)provider3).getReplacedModuleEntityIteratorBuilder(oldModule, newModule, project2));
            }
        }
    }

    private static <E extends WorkspaceEntity> void collectIteratorBuildersOnRemove(@NotNull E entity, @NotNull Project project2, @NotNull Collection<IndexableEntityProvider.IndexableIteratorBuilder> builders) {
        if (entity == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(18);
        }
        if (project2 == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(19);
        }
        if (builders == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(20);
        }
        Class entityClass = entity.getEntityInterface();
        for (IndexableEntityProvider<? extends WorkspaceEntity> provider2 : IndexableEntityProvider.EP_NAME.getExtensionList()) {
            if (entityClass != provider2.getEntityClass()) continue;
            builders.addAll(provider2.getRemovedEntityIteratorBuilders(entity, project2));
        }
    }

    @NotNull
    private static Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> getBuildersOnBuildableChangeInfo(@NotNull BuildableRootsChangeRescanningInfo buildableInfo) {
        if (buildableInfo == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(21);
        }
        BuildableRootsChangeRescanningInfoImpl info = (BuildableRootsChangeRescanningInfoImpl)buildableInfo;
        SmartList<IndexableEntityProvider.IndexableIteratorBuilder> builders = new SmartList<IndexableEntityProvider.IndexableIteratorBuilder>();
        IndexableIteratorBuilders instance2 = IndexableIteratorBuilders.INSTANCE;
        for (ModuleId moduleId : info.getModules()) {
            builders.addAll(instance2.forModuleContent(moduleId));
        }
        if (info.hasInheritedSdk()) {
            builders.addAll(instance2.forInheritedSdk());
        }
        for (Pair pair : info.getSdks()) {
            builders.addAll(instance2.forSdk((String)pair.getFirst(), (String)pair.getSecond()));
        }
        for (LibraryId libraryId : info.getLibraries()) {
            builders.addAll(instance2.forLibraryEntity(libraryId, true));
        }
        SmartList<IndexableEntityProvider.IndexableIteratorBuilder> smartList = builders;
        if (smartList == null) {
            EntityIndexingServiceImpl.$$$reportNull$$$0(22);
        }
        return smartList;
    }

    @NotNull
    public BuildableRootsChangeRescanningInfo createBuildableInfo() {
        return new BuildableRootsChangeRescanningInfoImpl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 22: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 7: 
            case 10: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/EntityIndexingServiceImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builders";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldEntity";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEntity";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildableInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/EntityIndexingServiceImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIterators";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildersOnWorkspaceChange";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildersOnBuildableChangeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "indexChanges";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runFullRescan";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logRootChanges";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIterators";
                break;
            }
            case 7: 
            case 10: 
            case 22: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getBuildersOnWorkspaceChange";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectIteratorBuildersOnAdd";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "collectIteratorBuildersOnReplace";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectIteratorBuildersOnRemove";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getBuildersOnBuildableChangeInfo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 10: 
            case 22: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

