/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.serviceContainer.ComponentManagerImplKt;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.CorruptionMarker;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexConfiguration;
import com.intellij.util.indexing.IndexDataInitializer;
import com.intellij.util.indexing.IndexId;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexVersionRegistrationSink;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.PersistentIndicesConfiguration;
import com.intellij.util.indexing.RebuildStatus;
import com.intellij.util.indexing.RegisteredIndexes;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.storage.DefaultIndexStorageLayout;
import com.intellij.util.indexing.impl.storage.FileBasedIndexLayoutSettings;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.IOUtil;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

final class FileBasedIndexDataInitialization
extends IndexDataInitializer<IndexConfiguration> {
    private static final Logger LOG = Logger.getInstance(FileBasedIndexDataInitialization.class);
    private boolean myCurrentVersionCorrupted;
    @NotNull
    private final FileBasedIndexImpl myFileBasedIndex;
    @NotNull
    private final RegisteredIndexes myRegisteredIndexes;
    @NotNull
    private final IntSet myStaleIds;
    @NotNull
    private final IndexVersionRegistrationSink myRegistrationResultSink;
    @NotNull
    private final IndexConfiguration myState;

    FileBasedIndexDataInitialization(@NotNull FileBasedIndexImpl index, @NotNull RegisteredIndexes registeredIndexes) {
        if (index == null) {
            FileBasedIndexDataInitialization.$$$reportNull$$$0(0);
        }
        if (registeredIndexes == null) {
            FileBasedIndexDataInitialization.$$$reportNull$$$0(1);
        }
        this.myStaleIds = IntSets.synchronize(new IntOpenHashSet());
        this.myRegistrationResultSink = new IndexVersionRegistrationSink();
        this.myState = new IndexConfiguration();
        this.myFileBasedIndex = index;
        this.myRegisteredIndexes = registeredIndexes;
    }

    @NotNull
    private Collection<ThrowableRunnable<?>> initAssociatedDataForExtensions() {
        FileBasedIndexExtension extension2;
        Activity activity = StartUpMeasurer.startActivity("file index extensions iteration");
        ExtensionPointImpl extPoint = (ExtensionPointImpl)FileBasedIndexExtension.EXTENSION_POINT_NAME.getPoint();
        Iterator extensions2 = extPoint.iterator();
        ArrayList tasks = new ArrayList(extPoint.size());
        while (extensions2.hasNext() && (extension2 = (FileBasedIndexExtension)extensions2.next()) != null) {
            RebuildStatus.registerIndex(extension2.getName());
            this.myRegisteredIndexes.registerIndexExtension(extension2);
            tasks.add(() -> {
                if (IOUtil.isSharedCachesEnabled()) {
                    IOUtil.OVERRIDE_BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER_PROP.set(false);
                }
                try {
                    FileBasedIndexImpl.registerIndexer(extension2, this.myState, this.myRegistrationResultSink, this.myStaleIds);
                }
                catch (IOException io) {
                    throw io;
                }
                catch (Throwable t) {
                    ComponentManagerImplKt.handleComponentError((Throwable)t, (String)extension2.getClass().getName(), null);
                }
                finally {
                    IOUtil.OVERRIDE_BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER_PROP.remove();
                }
            });
        }
        this.myRegisteredIndexes.extensionsDataWasLoaded();
        activity.end();
        ArrayList arrayList = tasks;
        if (arrayList == null) {
            FileBasedIndexDataInitialization.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected Collection<ThrowableRunnable<?>> prepareTasks() {
        PersistentFSImpl fs = (PersistentFSImpl)ManagingFS.getInstance();
        FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
        Disposable disposable = () -> new FileBasedIndexImpl.MyShutDownTask().run();
        ApplicationManager.getApplication().addApplicationListener(new MyApplicationListener(fileBasedIndex), disposable);
        Disposer.register((Disposable)fs, disposable);
        this.myFileBasedIndex.setUpShutDownTask();
        Collection<ThrowableRunnable<?>> tasks = this.initAssociatedDataForExtensions();
        PersistentIndicesConfiguration.loadConfiguration();
        this.myCurrentVersionCorrupted = CorruptionMarker.requireInvalidation();
        boolean storageLayoutChanged = FileBasedIndexLayoutSettings.INSTANCE.loadUsedLayout();
        for (FileBasedIndexInfrastructureExtension ex : (FileBasedIndexInfrastructureExtension[])FileBasedIndexInfrastructureExtension.EP_NAME.getExtensions()) {
            FileBasedIndexInfrastructureExtension.InitializationResult result2 = ex.initialize(DefaultIndexStorageLayout.getUsedLayoutId());
            this.myCurrentVersionCorrupted = this.myCurrentVersionCorrupted || result2 == FileBasedIndexInfrastructureExtension.InitializationResult.INDEX_REBUILD_REQUIRED;
        }
        boolean bl = this.myCurrentVersionCorrupted = this.myCurrentVersionCorrupted || storageLayoutChanged;
        if (this.myCurrentVersionCorrupted) {
            CorruptionMarker.dropIndexes();
        }
        Collection<ThrowableRunnable<?>> collection = tasks;
        if (collection == null) {
            FileBasedIndexDataInitialization.$$$reportNull$$$0(3);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    protected IndexConfiguration finish() {
        this.myState.finalizeFileTypeMappingForIndices();
        this.showChangedIndexesNotification();
        this.myRegistrationResultSink.logChangedAndFullyBuiltIndices(FileBasedIndexImpl.LOG, "Indexes to be rebuilt after version change:", this.myCurrentVersionCorrupted ? "Indexes to be rebuilt after corruption:" : "Indices to be built:");
        this.myState.freeze();
        this.myRegisteredIndexes.setState(this.myState);
        for (ID indexId : this.myState.getIndexIDs()) {
            try {
                RebuildStatus.clearIndexIfNecessary(indexId, () -> this.myFileBasedIndex.clearIndex(indexId));
            }
            catch (StorageException e) {
                this.myFileBasedIndex.requestRebuild(indexId);
                FileBasedIndexImpl.LOG.error(e);
            }
        }
        IndexConfiguration indexConfiguration = this.myState;
        IndexConfiguration indexConfiguration2 = indexConfiguration;
        if (indexConfiguration2 == null) {
            FileBasedIndexDataInitialization.$$$reportNull$$$0(4);
        }
        return indexConfiguration2;
        finally {
            FileBasedIndexImpl.setupWritingIndexValuesSeparatedFromCounting();
            FileBasedIndexImpl.setupWritingIndexValuesSeparatedFromCountingForContentIndependentIndexes();
            this.myFileBasedIndex.addStaleIds(this.myStaleIds);
            this.myFileBasedIndex.setUpFlusher();
            this.myFileBasedIndex.setUpHealthCheck();
            this.myRegisteredIndexes.ensureLoadedIndexesUpToDate();
            this.myRegisteredIndexes.markInitialized();
            FileBasedIndexDataInitialization.saveRegisteredIndicesAndDropUnregisteredOnes(this.myState.getIndexIDs());
        }
    }

    private void showChangedIndexesNotification() {
        String rebuildNotification;
        if (ApplicationManager.getApplication().isHeadlessEnvironment() || !Registry.is("ide.showIndexRebuildMessage", false)) {
            return;
        }
        if (this.myCurrentVersionCorrupted) {
            rebuildNotification = IndexingBundle.message((String)"index.corrupted.notification.text", (Object[])new Object[0]);
        } else if (this.myRegistrationResultSink.hasChangedIndexes()) {
            rebuildNotification = IndexingBundle.message((String)"index.format.changed.notification.text", (Object[])new Object[]{this.myRegistrationResultSink.changedIndices()});
        } else {
            return;
        }
        NotificationGroupManager.getInstance().getNotificationGroup("IDE Caches").createNotification(IndexingBundle.message((String)"index.rebuild.notification.title", (Object[])new Object[0]), rebuildNotification, NotificationType.INFORMATION).notify(null);
    }

    @Override
    @NotNull
    protected String getInitializationFinishedMessage(@NotNull IndexConfiguration initializationResult) {
        if (initializationResult == null) {
            FileBasedIndexDataInitialization.$$$reportNull$$$0(5);
        }
        String string2 = "Initialized indexes: " + initializationResult.getIndexIDs() + ".";
        if (string2 == null) {
            FileBasedIndexDataInitialization.$$$reportNull$$$0(6);
        }
        return string2;
    }

    private static void saveRegisteredIndicesAndDropUnregisteredOnes(@NotNull Collection<? extends ID<?, ?>> ids) {
        boolean dropFilenameIndex;
        if (ids == null) {
            FileBasedIndexDataInitialization.$$$reportNull$$$0(7);
        }
        if (ApplicationManager.getApplication().isDisposed() || !IndexInfrastructure.hasIndices()) {
            return;
        }
        Path registeredIndicesFile = PathManager.getIndexRoot().resolve("registered");
        HashSet<String> indicesToDrop = new HashSet<String>();
        boolean exceptionThrown = false;
        if (Files.exists(registeredIndicesFile, new LinkOption[0])) {
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(Files.newInputStream(registeredIndicesFile, new OpenOption[0])));){
                int size = in.readInt();
                for (int idx = 0; idx < size; ++idx) {
                    indicesToDrop.add(IOUtil.readString(in));
                }
            }
            catch (Throwable e) {
                LOG.info(e);
                exceptionThrown = true;
                ids.stream().map(IndexId::getName).forEach(indicesToDrop::add);
            }
        }
        boolean bl = dropFilenameIndex = Registry.is("indexing.filename.over.vfs") && indicesToDrop.contains(FilenameIndex.NAME.getName());
        if (!exceptionThrown) {
            for (ID<?, ?> key : ids) {
                if (dropFilenameIndex && key == FilenameIndex.NAME) continue;
                indicesToDrop.remove(key.getName());
            }
        }
        if (!indicesToDrop.isEmpty()) {
            HashSet<String> filtered;
            Collection<String> collection = filtered = !dropFilenameIndex ? indicesToDrop : ContainerUtil.filter(indicesToDrop, o -> !FilenameIndex.NAME.getName().equals(o));
            if (!filtered.isEmpty()) {
                LOG.info("Dropping indices:" + String.join((CharSequence)",", filtered));
            }
            for (String s : indicesToDrop) {
                try {
                    FileUtil.deleteWithRenaming(IndexInfrastructure.getFileBasedIndexRootDir((String)s).toFile());
                }
                catch (IOException e) {
                    LOG.warn(e);
                }
            }
        }
        try {
            Files.createDirectories(registeredIndicesFile.getParent(), new FileAttribute[0]);
            try (DataOutputStream os = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(registeredIndicesFile, new OpenOption[0])));){
                os.writeInt(ids.size());
                for (ID<?, ?> id2 : ids) {
                    IOUtil.writeString(id2.getName(), os);
                }
            }
        }
        catch (IOException e) {
            LOG.warn(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registeredIndexes";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/FileBasedIndexDataInitialization";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializationResult";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexDataInitialization";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "initAssociatedDataForExtensions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTasks";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "finish";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializationFinishedMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInitializationFinishedMessage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "saveRegisteredIndicesAndDropUnregisteredOnes";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyApplicationListener
    implements ApplicationListener {
        private final FileBasedIndexImpl myFileBasedIndex;

        MyApplicationListener(FileBasedIndexImpl fileBasedIndex) {
            this.myFileBasedIndex = fileBasedIndex;
        }

        @Override
        public void writeActionStarted(@NotNull Object action2) {
            if (action2 == null) {
                MyApplicationListener.$$$reportNull$$$0(0);
            }
            this.myFileBasedIndex.clearUpToDateIndexesForUnsavedOrTransactedDocs();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/util/indexing/FileBasedIndexDataInitialization$MyApplicationListener", "writeActionStarted"));
        }
    }
}

