/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.google.common.collect.Iterators;
import com.intellij.AppTopics;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.startup.ServiceNotReadyException;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.EditorHighlighterCache;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.AsyncEventSupport;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.cache.impl.id.PlatformIdTableBuilding;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.impl.VirtualFileEnumeration;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.reference.SoftReference;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.FlushingDaemon;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.SmartFMap;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.gist.GistManager;
import com.intellij.util.indexing.AuthenticContent;
import com.intellij.util.indexing.CorruptionMarker;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.DocumentContent;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.EmptyIndex;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexFileTypeListener;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtensionUpdatableIndex;
import com.intellij.util.indexing.FileBasedIndexScanUtil;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.FileIndexesValuesApplier;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.GlobalIndexFilter;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexConfiguration;
import com.intellij.util.indexing.IndexDataInitializer;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexUpToDateCheckIn;
import com.intellij.util.indexing.IndexVersion;
import com.intellij.util.indexing.IndexVersionRegistrationSink;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableFilesFilter;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedFileImpl;
import com.intellij.util.indexing.IndexedFileWrapper;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.IndexingFlag;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.PerIndexDocumentVersionMap;
import com.intellij.util.indexing.PersistentIndicesConfiguration;
import com.intellij.util.indexing.ProjectFilesCondition;
import com.intellij.util.indexing.PsiContent;
import com.intellij.util.indexing.RebuildStatus;
import com.intellij.util.indexing.RegisteredIndexes;
import com.intellij.util.indexing.SingleIndexValueApplier;
import com.intellij.util.indexing.SingleIndexValueRemover;
import com.intellij.util.indexing.StaleIndexesChecker;
import com.intellij.util.indexing.StorageBufferingHandler;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.UnindexedFilesUpdaterListener;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.UpdateTask;
import com.intellij.util.indexing.contentQueue.CachedFileContent;
import com.intellij.util.indexing.diagnostic.StorageDiagnosticData;
import com.intellij.util.indexing.events.ChangedFilesCollector;
import com.intellij.util.indexing.events.DeletedVirtualFileStub;
import com.intellij.util.indexing.events.VfsEventsMerger;
import com.intellij.util.indexing.impl.storage.DefaultIndexStorageLayout;
import com.intellij.util.indexing.impl.storage.TransientFileContentIndex;
import com.intellij.util.indexing.impl.storage.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.projectFilter.FileAddStatus;
import com.intellij.util.indexing.projectFilter.IncrementalProjectIndexableFilesFilterHolder;
import com.intellij.util.indexing.projectFilter.ProjectIndexableFilesFilterHolder;
import com.intellij.util.indexing.roots.IndexableFilesContributor;
import com.intellij.util.indexing.snapshot.SnapshotHashEnumeratorService;
import com.intellij.util.indexing.snapshot.SnapshotInputMappings;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingsStatistics;
import com.intellij.util.indexing.storage.VfsAwareIndexStorageLayout;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.SimpleMessageBusConnection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class FileBasedIndexImpl
extends FileBasedIndexEx {
    private static final ThreadLocal<VirtualFile> ourIndexedFile = new ThreadLocal();
    private static final ThreadLocal<FileBasedIndex.IndexWritingFile> ourWritingIndexFile = new ThreadLocal();
    private static final ThreadLocal<VirtualFile> ourFileToBeIndexed = new ThreadLocal();
    @ApiStatus.Internal
    public static final Logger LOG = Logger.getInstance(FileBasedIndexImpl.class);
    private volatile RegisteredIndexes myRegisteredIndexes;
    @Nullable
    private volatile String myShutdownReason;
    private final PerIndexDocumentVersionMap myLastIndexedDocStamps = new PerIndexDocumentVersionMap();
    private final ProjectIndexableFilesFilterHolder myIndexableFilesFilterHolder;
    private final NotNullLazyValue<ChangedFilesCollector> myChangedFilesCollector = NotNullLazyValue.createValue(() -> AsyncEventSupport.EP_NAME.findExtensionOrFail(ChangedFilesCollector.class));
    private final List<Pair<IndexableFileSet, Project>> myIndexableSets = ContainerUtil.createLockFreeCopyOnWriteList();
    private final SimpleMessageBusConnection myConnection;
    private final FileDocumentManager myFileDocumentManager;
    private final Set<ID<?, ?>> myUpToDateIndicesForUnsavedOrTransactedDocuments = ContainerUtil.newConcurrentSet();
    private volatile SmartFMap<Document, PsiFile> myTransactionMap = SmartFMap.emptyMap();
    final boolean myIsUnitTestMode;
    @Nullable
    private Runnable myShutDownTask;
    @Nullable
    private ScheduledFuture<?> myFlushingFuture;
    @Nullable
    private ScheduledFuture<?> myHealthCheckFuture;
    private final AtomicInteger myLocalModCount = new AtomicInteger();
    private final IntSet myStaleIds = new IntOpenHashSet();
    final Lock myReadLock;
    public final Lock myWriteLock;
    private final UnindexedFilesUpdaterListener myUnindexedFilesUpdaterListener;
    private final ThreadLocal<Boolean> myReentrancyGuard = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final Key<WeakReference<Pair<FileContentImpl, Long>>> ourFileContentKey = Key.create("unsaved.document.index.content");
    private final StorageBufferingHandler myStorageBufferingHandler = new StorageBufferingHandler(){

        @Override
        @NotNull
        protected Stream<UpdatableIndex<?, ?, ?, ?>> getIndexes() {
            IndexConfiguration state = FileBasedIndexImpl.this.getState();
            Stream<UpdatableIndex<?, ?, ?, ?>> stream = state.getIndexIDs().stream().map(id2 -> FileBasedIndexImpl.this.getIndex(id2));
            if (stream == null) {
                6.$$$reportNull$$$0(0);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/FileBasedIndexImpl$6", "getIndexes"));
        }
    };
    private final VirtualFileUpdateTask myForceUpdateTask = new VirtualFileUpdateTask();
    private static volatile boolean ourWritingIndexValuesSeparatedFromCounting;
    private static volatile boolean ourWritingIndexValuesSeparatedFromCountingForContentIndependentIndexes;

    private IndexConfiguration getState() {
        return this.myRegisteredIndexes.getConfigurationState();
    }

    void dropRegisteredIndexes() {
        ScheduledFuture<?> flushingFuture = this.myFlushingFuture;
        LOG.assertTrue(flushingFuture == null || flushingFuture.isCancelled() || flushingFuture.isDone());
        LOG.assertTrue(this.myUpToDateIndicesForUnsavedOrTransactedDocuments.isEmpty());
        LOG.assertTrue(this.myTransactionMap.isEmpty());
        this.myRegisteredIndexes = null;
    }

    public FileBasedIndexImpl() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.myReadLock = lock.readLock();
        this.myWriteLock = lock.writeLock();
        this.myFileDocumentManager = FileDocumentManager.getInstance();
        this.myIsUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        SimpleMessageBusConnection connection = messageBus.simpleConnect();
        this.myUnindexedFilesUpdaterListener = messageBus.syncPublisher(UnindexedFilesUpdaterListener.TOPIC);
        connection.subscribe(PsiDocumentTransactionListener.TOPIC, new PsiDocumentTransactionListener(){

            @Override
            public void transactionStarted(@NotNull Document doc, @NotNull PsiFile file2) {
                if (doc == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                FileBasedIndexImpl.this.myTransactionMap = FileBasedIndexImpl.this.myTransactionMap.plus(doc, file2);
                FileBasedIndexImpl.this.clearUpToDateIndexesForUnsavedOrTransactedDocs();
            }

            @Override
            public void transactionCompleted(@NotNull Document doc, @NotNull PsiFile file2) {
                if (doc == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                FileBasedIndexImpl.this.myTransactionMap = FileBasedIndexImpl.this.myTransactionMap.minus(doc);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "doc";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "transactionStarted";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "transactionCompleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(FileTypeManager.TOPIC, new FileBasedIndexFileTypeListener());
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, new FileDocumentManagerListener(){

            public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    2.$$$reportNull$$$0(1);
                }
                FileBasedIndexImpl.this.cleanupMemoryStorage(true);
            }

            public void unsavedDocumentsDropped() {
                FileBasedIndexImpl.this.cleanupMemoryStorage(false);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/util/indexing/FileBasedIndexImpl$2";
                objectArray[2] = "fileContentReloaded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(AppLifecycleListener.TOPIC, new AppLifecycleListener(){

            public void appWillBeClosed(boolean isRestart) {
                if (FileBasedIndexImpl.this.myRegisteredIndexes != null && !FileBasedIndexImpl.this.myRegisteredIndexes.areIndexesReady()) {
                    new Task.Modal(null, IndexingBundle.message((String)"indexes.preparing.to.shutdown.message", (Object[])new Object[0]), false){

                        @Override
                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            FileBasedIndexImpl.this.myRegisteredIndexes.waitUntilAllIndicesAreInitialized();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/indexing/FileBasedIndexImpl$3$1", "run"));
                        }
                    }.queue();
                }
            }
        });
        this.myConnection = connection;
        FileBasedIndexExtension.EXTENSION_POINT_NAME.addExtensionPointListener(new ExtensionPointListener<FileBasedIndexExtension<?, ?>>(){

            @Override
            public void extensionRemoved(@NotNull FileBasedIndexExtension<?, ?> extension2, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(1);
                }
                ID.unloadId(extension2.getName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "extension";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/util/indexing/FileBasedIndexImpl$4";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
        this.myIndexableFilesFilterHolder = new IncrementalProjectIndexableFilesFilterHolder();
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            StorageDiagnosticData.dumpPeriodically();
        }
    }

    void scheduleFullIndexesRescan(@NotNull String reason) {
        if (reason == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(0);
        }
        IndexingFlag.cleanupProcessedFlag();
        FileBasedIndexImpl.scheduleIndexRescanningForAllProjects(reason);
    }

    @VisibleForTesting
    void doClearIndices(@NotNull Predicate<? super ID<?, ?>> filter2) {
        if (filter2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(1);
        }
        try {
            this.waitUntilIndicesAreInitialized();
        }
        catch (ProcessCanceledException e) {
            return;
        }
        IndexingStamp.flushCaches();
        ArrayList<ID> clearedIndexes = new ArrayList<ID>();
        ArrayList<ID> survivedIndexes = new ArrayList<ID>();
        for (ID indexId : this.getState().getIndexIDs()) {
            if (filter2.test(indexId)) {
                try {
                    this.clearIndex(indexId);
                }
                catch (StorageException e) {
                    LOG.info(e);
                }
                catch (Exception e) {
                    LOG.error(e);
                }
                clearedIndexes.add(indexId);
                continue;
            }
            survivedIndexes.add(indexId);
        }
        LOG.info("indexes cleared: " + clearedIndexes.stream().map(id2 -> id2.getName()).collect(Collectors.joining(", ")) + "\nsurvived indexes: " + survivedIndexes.stream().map(id2 -> id2.getName()).collect(Collectors.joining(", ")));
    }

    public void registerProjectFileSets(@NotNull Project project2) {
        if (project2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(2);
        }
        for (final IndexableFilesContributor extension2 : (IndexableFilesContributor[])IndexableFilesContributor.EP_NAME.getExtensions()) {
            final Predicate contributorsPredicate = extension2.getOwnFilePredicate(project2);
            this.registerIndexableSet(new IndexableFileSet(){

                public boolean isInSet(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return contributorsPredicate.test(file2);
                }

                public String toString() {
                    return "IndexableFileSet[" + extension2 + "]";
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexImpl$5", "isInSet"));
                }
            }, project2);
        }
    }

    public void removeProjectFileSets(@NotNull Project project2) {
        if (project2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(3);
        }
        this.myIndexableSets.removeIf(p -> ((Project)p.second).equals(project2));
    }

    boolean processChangedFiles(@NotNull Project project2, @NotNull Processor<? super VirtualFile> processor) {
        if (project2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(5);
        }
        Iterator iterator = Iterators.concat(this.getChangedFilesCollector().getEventMerger().getChangedFiles().iterator(), this.getChangedFilesCollector().getFilesToUpdate().iterator());
        HashSet<VirtualFile> checkedFiles = new HashSet<VirtualFile>();
        Predicate<VirtualFile> filterPredicate = this.filesToBeIndexedForProjectCondition(project2);
        while (iterator.hasNext()) {
            VirtualFile virtualFile2 = (VirtualFile)iterator.next();
            if (!filterPredicate.test(virtualFile2) || checkedFiles.contains(virtualFile2)) continue;
            checkedFiles.add(virtualFile2);
            if (processor.process(virtualFile2)) continue;
            return false;
        }
        return true;
    }

    public RegisteredIndexes getRegisteredIndexes() {
        return this.myRegisteredIndexes;
    }

    void setUpShutDownTask() {
        this.myShutDownTask = new MyShutDownTask();
        ShutDownTracker.getInstance().registerShutdownTask(this.myShutDownTask);
    }

    @ApiStatus.Internal
    public void resetSnapshotInputMappingStatistics() {
        for (ID id2 : this.getRegisteredIndexes().getState().getIndexIDs()) {
            UpdatableIndex index = this.getIndex(id2);
            if (!(index instanceof VfsAwareMapReduceIndex)) continue;
            ((VfsAwareMapReduceIndex)index).resetSnapshotInputMappingsStatistics();
        }
    }

    @ApiStatus.Internal
    @NotNull
    public List<SnapshotInputMappingsStatistics> dumpSnapshotInputMappingStatistics() {
        List<SnapshotInputMappingsStatistics> list2 = this.getRegisteredIndexes().getState().getIndexIDs().stream().map(id2 -> {
            UpdatableIndex index = this.getIndex((ID)id2);
            if (index instanceof VfsAwareMapReduceIndex) {
                return ((VfsAwareMapReduceIndex)index).dumpSnapshotInputMappingsStatistics();
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        if (list2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addStaleIds(@NotNull IntSet staleIds) {
        if (staleIds == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(7);
        }
        IntSet intSet = this.myStaleIds;
        synchronized (intSet) {
            this.myStaleIds.addAll(staleIds);
        }
    }

    void setUpHealthCheck() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.myHealthCheckFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(ConcurrencyUtil.underThreadNameRunnable("Index Healthcheck", () -> this.myIndexableFilesFilterHolder.runHealthCheck()), 5L, 5L, TimeUnit.MINUTES);
        }
    }

    public static boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file2, @Nullable FileType fileType) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(8);
        }
        return ProjectCoreUtil.isProjectOrWorkspaceFile(file2, fileType);
    }

    public void requestReindex(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(9);
        }
        this.requestReindex(file2, true);
    }

    @ApiStatus.Internal
    public void requestReindex(@NotNull VirtualFile file2, boolean forceRebuild) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(10);
        }
        GistManager.getInstance().invalidateData(file2);
        VfsEventsMerger.tryLog((String)"explicit_request_reindex", (VirtualFile)file2);
        ChangedFilesCollector changedFilesCollector = this.getChangedFilesCollector();
        if (forceRebuild) {
            file2.putUserData(IndexingDataKeys.REBUILD_REQUESTED, Boolean.TRUE);
        }
        changedFilesCollector.scheduleForIndexingRecursively(file2, true);
        if (this.myRegisteredIndexes.isInitialized()) {
            changedFilesCollector.ensureUpToDateAsync();
        }
    }

    public synchronized void loadIndexes() {
        if (this.myRegisteredIndexes == null) {
            super.loadIndexes();
            LOG.assertTrue(this.myRegisteredIndexes == null);
            this.myStorageBufferingHandler.resetState();
            this.myRegisteredIndexes = new RegisteredIndexes(this.myFileDocumentManager, this);
            this.myShutdownReason = null;
        }
    }

    public void waitUntilIndicesAreInitialized() {
        if (this.myRegisteredIndexes == null) {
            throw new ServiceNotReadyException();
        }
        this.myRegisteredIndexes.waitUntilIndicesAreInitialized();
    }

    static <K, V> void registerIndexer(@NotNull FileBasedIndexExtension<K, V> extension2, @NotNull IndexConfiguration state, @NotNull IndexVersionRegistrationSink versionRegistrationStatusSink, @NotNull IntSet staleInputIdSink) throws Exception {
        if (extension2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(11);
        }
        if (state == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(12);
        }
        if (versionRegistrationStatusSink == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(13);
        }
        if (staleInputIdSink == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(14);
        }
        ID name2 = extension2.getName();
        int version = FileBasedIndexImpl.getIndexExtensionVersion(extension2);
        IndexVersion.IndexVersionDiff diff = IndexVersion.versionDiffers(name2, version);
        versionRegistrationStatusSink.setIndexVersionDiff(name2, diff);
        if (diff != IndexVersion.IndexVersionDiff.UP_TO_DATE) {
            FileUtil.deleteWithRenamingIfExists(IndexInfrastructure.getPersistentIndexRootDir((ID)name2));
            FileUtil.deleteWithRenamingIfExists(IndexInfrastructure.getIndexRootDir((ID)name2));
            IndexVersion.rewriteVersion(name2, version);
            try {
                for (FileBasedIndexInfrastructureExtension ex : FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()) {
                    ex.onFileBasedIndexVersionChanged(name2);
                }
            }
            catch (Exception e) {
                LOG.error(e);
            }
        }
        FileBasedIndexImpl.initIndexStorage(extension2, version, state, versionRegistrationStatusSink, staleInputIdSink);
    }

    private static <K, V> void initIndexStorage(@NotNull FileBasedIndexExtension<K, V> extension2, int version, @NotNull IndexConfiguration state, @NotNull IndexVersionRegistrationSink registrationStatusSink, @NotNull IntSet staleInputIdSink) throws Exception {
        HashSet addedTypes;
        FileBasedIndex.InputFilter inputFilter;
        if (extension2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(15);
        }
        if (state == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(16);
        }
        if (registrationStatusSink == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(17);
        }
        if (staleInputIdSink == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(18);
        }
        ID name2 = extension2.getName();
        boolean contentHashesEnumeratorOk = true;
        try {
            inputFilter = extension2.getInputFilter();
            if (inputFilter instanceof FileBasedIndex.FileTypeSpecificInputFilter) {
                addedTypes = new HashSet();
                ((FileBasedIndex.FileTypeSpecificInputFilter)inputFilter).registerFileTypesUsedForIndexing(type -> {
                    if (type != null) {
                        addedTypes.add(type);
                    }
                });
            } else {
                addedTypes = null;
            }
            if (VfsAwareMapReduceIndex.hasSnapshotMapping(extension2)) {
                contentHashesEnumeratorOk = SnapshotHashEnumeratorService.getInstance().initialize();
            }
        }
        catch (Exception e) {
            state.registerIndexInitializationProblem(name2, (Throwable)e);
            throw e;
        }
        UpdatableIndex index = null;
        int attemptCount = 2;
        for (int attempt = 0; attempt < attemptCount; ++attempt) {
            try {
                VfsAwareIndexStorageLayout<K, V> layout = DefaultIndexStorageLayout.getLayout(extension2, contentHashesEnumeratorOk);
                index = FileBasedIndexImpl.createIndex(extension2, layout);
                for (FileBasedIndexInfrastructureExtension infrastructureExtension : FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()) {
                    UpdatableIndex intermediateIndex = infrastructureExtension.combineIndex(extension2, index);
                    if (intermediateIndex == null) continue;
                    index = intermediateIndex;
                }
                state.registerIndex(name2, index, FileBasedIndexImpl.composeInputFilter((FileBasedIndex.InputFilter)inputFilter, (file2, project2) -> !GlobalIndexFilter.isExcludedFromIndexViaFilters(file2, name2, project2)), version + GlobalIndexFilter.getFiltersVersion(name2), addedTypes);
                break;
            }
            catch (Exception e) {
                boolean lastAttempt = attempt == attemptCount - 1;
                try {
                    VfsAwareIndexStorageLayout<K, V> layout = DefaultIndexStorageLayout.getLayout(extension2, contentHashesEnumeratorOk);
                    layout.clearIndexData();
                }
                catch (Exception layoutEx) {
                    LOG.error(layoutEx);
                }
                for (FileBasedIndexInfrastructureExtension ext : FileBasedIndexInfrastructureExtension.EP_NAME.getExtensionList()) {
                    try {
                        ext.resetPersistentState(name2);
                    }
                    catch (Exception extEx) {
                        LOG.error(extEx);
                    }
                }
                registrationStatusSink.setIndexVersionDiff(name2, new IndexVersion.IndexVersionDiff.CorruptedRebuild(version));
                IndexVersion.rewriteVersion(name2, version);
                if (lastAttempt) {
                    state.registerIndexInitializationProblem(name2, (Throwable)e);
                    if (extension2 instanceof CustomImplementationFileBasedIndexExtension) {
                        ((CustomImplementationFileBasedIndexExtension)extension2).handleInitializationError((Throwable)e);
                    }
                    throw e;
                }
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    LOG.error(e);
                    continue;
                }
                String message2 = "Attempt #" + attemptCount + " to initialize index has failed for " + extension2.getName();
                if (e instanceof CorruptedException) {
                    LOG.warn(message2 + " because storage corrupted");
                    continue;
                }
                LOG.warn(message2, e);
                continue;
            }
        }
        try {
            if (StubUpdatingIndex.INDEX_ID.equals(extension2.getName()) && index != null) {
                staleInputIdSink.addAll(StaleIndexesChecker.checkIndexForStaleRecords(index, true));
            }
        }
        catch (Exception e) {
            LOG.error("Exception while checking for stale records", e);
        }
    }

    @NotNull
    private static <K, V> UpdatableIndex<K, V, FileContent, ?> createIndex(@NotNull FileBasedIndexExtension<K, V> extension2, @NotNull VfsAwareIndexStorageLayout<K, V> layout) throws StorageException, IOException {
        if (extension2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(19);
        }
        if (layout == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(20);
        }
        if (extension2.getName() == FilenameIndex.NAME && Registry.is("indexing.filename.over.vfs")) {
            return new EmptyIndex(extension2);
        }
        if (extension2 instanceof CustomImplementationFileBasedIndexExtension) {
            UpdatableIndex index;
            UpdatableIndex updatableIndex = index = ((CustomImplementationFileBasedIndexExtension)extension2).createIndexImplementation(extension2, layout);
            if (updatableIndex == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(21);
            }
            return updatableIndex;
        }
        TransientFileContentIndex<K, V, VfsAwareMapReduceIndex.IndexerIdHolder> transientFileContentIndex = TransientFileContentIndex.createIndex(extension2, layout, null);
        if (transientFileContentIndex == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(22);
        }
        return transientFileContentIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void performShutdown(boolean keepConnection, @NotNull String reason) {
        if (reason == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(23);
        }
        this.myShutdownReason = keepConnection ? reason : null;
        RegisteredIndexes registeredIndexes = this.myRegisteredIndexes;
        if (registeredIndexes == null) return;
        if (!registeredIndexes.performShutdown()) {
            return;
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> registeredIndexes.waitUntilAllIndicesAreInitialized());
        try {
            if (this.myShutDownTask != null) {
                ShutDownTracker.getInstance().unregisterShutdownTask(this.myShutDownTask);
            }
            if (this.myFlushingFuture != null) {
                this.myFlushingFuture.cancel(false);
                this.myFlushingFuture = null;
            }
            if (this.myHealthCheckFuture == null) return;
            this.myHealthCheckFuture.cancel(false);
            this.myHealthCheckFuture = null;
            return;
        }
        finally {
            LOG.info("START INDEX SHUTDOWN");
            try {
                UpdatableIndex index;
                PersistentIndicesConfiguration.saveConfiguration();
                for (VirtualFile file2 : this.getChangedFilesCollector().getAllPossibleFilesToUpdate()) {
                    PingProgress.interactWithEdtProgress();
                    int fileId = FileBasedIndexImpl.getFileId((VirtualFile)file2);
                    try {
                        this.removeDataFromIndicesForFile(fileId, file2, "shutdown");
                    }
                    catch (Throwable throwable) {
                        LOG.error(throwable);
                    }
                }
                this.getChangedFilesCollector().clearFilesToUpdate();
                IndexingStamp.flushCaches();
                IndexingFlag.unlockAllFiles();
                if (this.myIsUnitTestMode && (index = this.getState().getIndex(StubUpdatingIndex.INDEX_ID)) != null) {
                    StaleIndexesChecker.checkIndexForStaleRecords(index, false);
                }
                IndexConfiguration state = this.getState();
                for (ID indexId : state.getIndexIDs()) {
                    PingProgress.interactWithEdtProgress();
                    try {
                        UpdatableIndex index2 = this.getIndex(indexId);
                        if (!RebuildStatus.isOk(indexId)) {
                            this.clearIndex(indexId);
                        }
                        index2.dispose();
                    }
                    catch (Throwable throwable) {
                        LOG.info("Problem disposing " + indexId, throwable);
                    }
                }
                FileBasedIndexInfrastructureExtension.EP_NAME.extensions().forEach(ex -> ex.shutdown());
                SnapshotHashEnumeratorService.getInstance().close();
                if (!keepConnection) {
                    this.myConnection.disconnect();
                }
            }
            catch (Throwable e) {
                LOG.error("Problems during index shutdown", e);
            }
            finally {
                IndexVersion.clearCachedIndexVersions();
            }
            LOG.info("END INDEX SHUTDOWN");
        }
    }

    public void removeDataFromIndicesForFile(int fileId, @NotNull VirtualFile file2, @NotNull String cause) {
        boolean isValid;
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(24);
        }
        if (cause == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(25);
        }
        VfsEventsMerger.tryLog((String)"REMOVE", (VirtualFile)file2, () -> "cause=" + cause);
        VirtualFile originalFile = file2 instanceof DeletedVirtualFileStub ? ((DeletedVirtualFileStub)file2).getOriginalFile() : file2;
        List<ID<?, ?>> states = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        if (!states.isEmpty()) {
            ProgressManager.getInstance().executeNonCancelableSection(() -> this.removeFileDataFromIndices(states, fileId, originalFile));
        }
        if (file2 instanceof VirtualFileSystemEntry && file2.isValid()) {
            IndexingFlag.cleanProcessingFlag(file2);
        }
        boolean bl = isValid = file2 instanceof DeletedVirtualFileStub ? ((DeletedVirtualFileStub)file2).getOriginalFile().isValid() : file2.isValid();
        if (!isValid) {
            this.getIndexableFilesFilterHolder().removeFile(fileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFileDataFromIndices(@NotNull Collection<? extends ID<?, ?>> affectedIndices, int inputId, @Nullable VirtualFile file2) {
        if (affectedIndices == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(26);
        }
        assert (ProgressManager.getInstance().isInNonCancelableSection());
        try {
            this.removeTransientFileDataFromIndices(affectedIndices, inputId, file2);
            Throwable unexpectedError = null;
            for (ID<?, ?> indexId : affectedIndices) {
                try {
                    this.removeSingleIndexValue(indexId, inputId);
                }
                catch (Throwable e) {
                    LOG.info(e);
                    if (unexpectedError != null) continue;
                    unexpectedError = e;
                }
            }
            if (unexpectedError != null) {
                LOG.error(unexpectedError);
            }
        }
        finally {
            IndexingStamp.flushCache(inputId);
        }
    }

    private void removeTransientFileDataFromIndices(@NotNull Collection<? extends ID<?, ?>> indices, int inputId, @Nullable VirtualFile file2) {
        Document document;
        if (indices == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(27);
        }
        for (ID<?, ?> indexId : indices) {
            this.getIndex(indexId).removeTransientDataForFile(inputId);
        }
        Document document2 = document = file2 == null ? null : this.myFileDocumentManager.getCachedDocument(file2);
        if (document != null) {
            this.myLastIndexedDocStamps.clearForDocument(document);
            document.putUserData(ourFileContentKey, null);
        }
        this.clearUpToDateIndexesForUnsavedOrTransactedDocs();
    }

    private void flushAllIndices(long modCount) {
        if (HeavyProcessLatch.INSTANCE.isRunning()) {
            return;
        }
        IndexingStamp.flushCaches();
        IndexConfiguration state = this.getState();
        for (ID indexId : state.getIndexIDs()) {
            if (HeavyProcessLatch.INSTANCE.isRunning() || modCount != (long)this.myLocalModCount.get()) {
                return;
            }
            try {
                UpdatableIndex index = state.getIndex(indexId);
                if (index == null) continue;
                index.flush();
            }
            catch (Throwable e) {
                this.requestRebuild(indexId, e);
            }
        }
        SnapshotHashEnumeratorService.getInstance().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> boolean ensureUpToDate(@NotNull ID<K, ?> indexId, @Nullable Project project2, @Nullable GlobalSearchScope filter2, @Nullable VirtualFile restrictedFile) {
        block19: {
            String shutdownReason;
            if (indexId == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(28);
            }
            if ((shutdownReason = this.myShutdownReason) != null) {
                LOG.info("FileBasedIndex is currently shutdown because: " + shutdownReason);
                return false;
            }
            ProgressManager.checkCanceled();
            SlowOperations.assertSlowOperationsAreAllowed();
            this.getChangedFilesCollector().ensureUpToDate();
            ApplicationManager.getApplication().assertReadAccessAllowed();
            NoAccessDuringPsiEvents.checkCallContext(indexId);
            if (!this.needsFileContentLoading(indexId)) {
                return true;
            }
            if (filter2 == GlobalSearchScope.EMPTY_SCOPE || filter2 instanceof DelegatingGlobalSearchScope && ((DelegatingGlobalSearchScope)filter2).unwrap() == GlobalSearchScope.EMPTY_SCOPE) {
                return false;
            }
            if (project2 == null) {
                LOG.warn("Please provide a GlobalSearchScope with specified project. Otherwise it might lead to performance problems!", new Exception());
            }
            if (project2 != null && project2.isDefault()) {
                LOG.error("FileBasedIndex should not receive default project");
            }
            if (FileBasedIndexScanUtil.isManuallyManaged(indexId)) {
                return true;
            }
            if (ActionUtil.isDumbMode((Project)project2) && this.getCurrentDumbModeAccessType_NoDumbChecks() == null) {
                FileBasedIndexImpl.handleDumbMode(project2);
            }
            if (this.myReentrancyGuard.get().booleanValue()) {
                return true;
            }
            this.myReentrancyGuard.set(Boolean.TRUE);
            try {
                block20: {
                    if (!IndexUpToDateCheckIn.isUpToDateCheckEnabled()) break block19;
                    try {
                        if (RebuildStatus.isOk(indexId)) break block20;
                        if (this.getCurrentDumbModeAccessType_NoDumbChecks() == null) {
                            throw new ServiceNotReadyException();
                        }
                        boolean bl = false;
                        return bl;
                    }
                    catch (RuntimeException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof StorageException || cause instanceof IOException) {
                            this.scheduleRebuild(indexId, e);
                            break block19;
                        }
                        throw e;
                    }
                }
                if (!ActionUtil.isDumbMode((Project)project2) || this.getCurrentDumbModeAccessType_NoDumbChecks() == null) {
                    this.forceUpdate(project2, filter2, restrictedFile);
                }
                this.indexUnsavedDocuments(indexId, project2, filter2, restrictedFile);
            }
            finally {
                this.myReentrancyGuard.set(Boolean.FALSE);
            }
        }
        return true;
    }

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        Boolean scanResult;
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(29);
        }
        if (processor == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(30);
        }
        if (scope == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(31);
        }
        if ((scanResult = FileBasedIndexScanUtil.processAllKeys(indexId, processor, scope, idFilter)) != null) {
            return scanResult;
        }
        return super.processAllKeys(indexId, processor, scope, idFilter);
    }

    private static void handleDumbMode(@Nullable Project project2) throws IndexNotReadyException {
        ProgressManager.checkCanceled();
        throw IndexNotReadyException.create(project2 == null ? null : DumbServiceImpl.getInstance((Project)project2).getDumbModeStartTrace());
    }

    @TestOnly
    public void cleanupForNextTest() {
        this.getChangedFilesCollector().ensureUpToDate();
        this.myTransactionMap = SmartFMap.emptyMap();
        for (ID indexId : this.getState().getIndexIDs()) {
            UpdatableIndex index = this.getIndex(indexId);
            index.cleanupForNextTest();
        }
    }

    @ApiStatus.Internal
    public ChangedFilesCollector getChangedFilesCollector() {
        return this.myChangedFilesCollector.getValue();
    }

    void filesUpdateStarted(Project project2, boolean isFullUpdate) {
        if (isFullUpdate) {
            this.myIndexableFilesFilterHolder.entireProjectUpdateStarted(project2);
        }
        this.ensureStaleIdsDeleted();
        this.getChangedFilesCollector().ensureUpToDate();
        this.fireUpdateStarted(project2);
    }

    void fireUpdateStarted(Project project2) {
        this.myUnindexedFilesUpdaterListener.updateStarted(project2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureStaleIdsDeleted() {
        this.loadIndexes();
        this.waitUntilIndicesAreInitialized();
        IntSet intSet = this.myStaleIds;
        synchronized (intSet) {
            if (this.myStaleIds.isEmpty()) {
                return;
            }
            try {
                StaleIndexesChecker.clearStaleIndexes(this.myStaleIds);
            }
            catch (Exception e) {
                LOG.error(e);
            }
            finally {
                this.myStaleIds.clear();
            }
        }
    }

    void filesUpdateFinished(@NotNull Project project2) {
        if (project2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(32);
        }
        this.myIndexableFilesFilterHolder.entireProjectUpdateFinished(project2);
        this.fireUpdateFinished(project2);
    }

    void fireUpdateFinished(@NotNull Project project2) {
        if (project2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(33);
        }
        this.myUnindexedFilesUpdaterListener.updateFinished(project2);
    }

    @Nullable
    public IdFilter projectIndexableFiles(@Nullable Project project2) {
        if (project2 == null || project2.isDefault()) {
            return null;
        }
        return this.myIndexableFilesFilterHolder.getProjectIndexableFiles(project2);
    }

    @NotNull
    public ProjectIndexableFilesFilterHolder getIndexableFilesFilterHolder() {
        ProjectIndexableFilesFilterHolder projectIndexableFilesFilterHolder = this.myIndexableFilesFilterHolder;
        if (projectIndexableFilesFilterHolder == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(34);
        }
        return projectIndexableFilesFilterHolder;
    }

    private static void scheduleIndexRescanningForAllProjects(@NotNull String reason) {
        if (reason == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(35);
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            new UnindexedFilesUpdater(project2, reason).queue(project2);
        }
    }

    void clearIndicesIfNecessary() {
        this.waitUntilIndicesAreInitialized();
        for (ID indexId : this.getState().getIndexIDs()) {
            try {
                RebuildStatus.clearIndexIfNecessary(indexId, () -> this.clearIndex(indexId));
            }
            catch (StorageException e) {
                LOG.error(e);
                this.requestRebuild(indexId);
            }
        }
    }

    void clearIndex(@NotNull ID<?, ?> indexId) throws StorageException {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(36);
        }
        if (IOUtil.isSharedCachesEnabled()) {
            IOUtil.OVERRIDE_BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER_PROP.set(false);
        }
        try {
            this.advanceIndexVersion(indexId);
            this.getIndex(indexId).clear();
        }
        finally {
            IOUtil.OVERRIDE_BYTE_BUFFERS_USE_NATIVE_BYTE_ORDER_PROP.remove();
        }
    }

    private void advanceIndexVersion(ID<?, ?> indexId) {
        try {
            IndexVersion.rewriteVersion(indexId, this.myRegisteredIndexes.getState().getIndexVersion(indexId));
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @NotNull
    private Set<Document> getTransactedDocuments() {
        Set<Document> set2 = this.myTransactionMap.keySet();
        if (set2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(37);
        }
        return set2;
    }

    private void indexUnsavedDocuments(@NotNull ID<?, ?> indexId, @Nullable Project project2, @Nullable GlobalSearchScope filter2, @Nullable VirtualFile restrictedFile) {
        List<Document> documentsToProcessForProject;
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(38);
        }
        if (this.myUpToDateIndicesForUnsavedOrTransactedDocuments.contains(indexId)) {
            return;
        }
        HashSet<Document> documents = new HashSet<Document>();
        this.myFileDocumentManager.processUnsavedDocuments(document -> {
            documents.add((Document)document);
            return true;
        });
        documents.addAll(this.getTransactedDocuments());
        if (project2 != null) {
            Collections.addAll(documents, PsiDocumentManager.getInstance(project2).getUncommittedDocuments());
        }
        if (!documents.isEmpty() && !(documentsToProcessForProject = ContainerUtil.filter(documents, document -> FileBasedIndexImpl.belongsToScope((VirtualFile)this.myFileDocumentManager.getFile((Document)document), (VirtualFile)restrictedFile, (GlobalSearchScope)filter2))).isEmpty()) {
            UpdateTask<Document> task2 = this.myRegisteredIndexes.getUnsavedDataUpdateTask(indexId);
            assert (task2 != null) : "Task for unsaved data indexing was not initialized for index " + indexId;
            if (this.myStorageBufferingHandler.runUpdate(true, () -> task2.processAll(documentsToProcessForProject, project2)) && documentsToProcessForProject.size() == documents.size() && !this.hasActiveTransactions()) {
                this.myUpToDateIndicesForUnsavedOrTransactedDocuments.add(indexId);
            }
        }
    }

    private boolean hasActiveTransactions() {
        return !this.myTransactionMap.isEmpty();
    }

    void indexUnsavedDocument(@NotNull Document document, @NotNull ID<?, ?> requestedIndexId, @NotNull Project project2, @NotNull VirtualFile vFile) {
        if (document == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(39);
        }
        if (requestedIndexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(40);
        }
        if (project2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(41);
        }
        if (vFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(42);
        }
        PsiFile dominantContentFile = FileBasedIndexImpl.findLatestKnownPsiForUncomittedDocument(document, project2);
        DocumentContent content2 = FileBasedIndexImpl.findLatestContent(document, dominantContentFile);
        long currentDocStamp = PsiDocumentManager.getInstance(project2).getLastCommittedStamp(document);
        long previousDocStamp = this.myLastIndexedDocStamps.get(document, requestedIndexId);
        if (previousDocStamp == currentDocStamp) {
            return;
        }
        CharSequence contentText = content2.getText();
        FileTypeManagerEx.getInstanceEx().freezeFileTypeTemporarilyIn(vFile, () -> {
            IndexedFileImpl indexedFile = new IndexedFileImpl(vFile, project2);
            if (this.getAffectedIndexCandidates(indexedFile).contains(requestedIndexId) && this.acceptsInput(requestedIndexId, indexedFile)) {
                int inputId = FileBasedIndexImpl.getFileId((VirtualFile)vFile);
                if (!this.isTooLarge(vFile, Long.valueOf(contentText.length()))) {
                    FileContentImpl newFc = FileBasedIndexImpl.getUnsavedDocContent(document, project2, vFile, currentDocStamp, contentText);
                    FileBasedIndexImpl.tuneFileContent(document, dominantContentFile, content2, newFc);
                    FileBasedIndexImpl.markFileIndexed(vFile, newFc);
                    try {
                        this.updateIndexInNonCancellableSection(requestedIndexId, inputId, newFc);
                    }
                    finally {
                        FileBasedIndexImpl.unmarkBeingIndexed();
                        FileBasedIndexImpl.cleanFileContent(newFc, dominantContentFile);
                    }
                } else {
                    this.updateIndexInNonCancellableSection(requestedIndexId, inputId, null);
                }
            }
            long previousState = this.myLastIndexedDocStamps.set(document, requestedIndexId, currentDocStamp);
            assert (previousState == previousDocStamp);
        });
    }

    @NotNull
    private static DocumentContent findLatestContent(@NotNull Document document, @Nullable PsiFile dominantContentFile) {
        if (document == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(43);
        }
        return dominantContentFile != null && dominantContentFile.getViewProvider().getModificationStamp() != document.getModificationStamp() ? new PsiContent(document, dominantContentFile) : new AuthenticContent(document);
    }

    private void updateIndexInNonCancellableSection(@NotNull ID<?, ?> requestedIndexId, int inputId, FileContentImpl newFc) {
        if (requestedIndexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(44);
        }
        Computable update2 = this.getIndex(requestedIndexId).mapInputAndPrepareUpdate(inputId, (Object)newFc);
        ProgressManager.getInstance().executeNonCancelableSection(update2::compute);
    }

    private static void tuneFileContent(@NotNull Document document, PsiFile dominantContentFile, DocumentContent content2, FileContentImpl newFc) {
        if (document == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(45);
        }
        FileBasedIndexImpl.initFileContent(newFc, dominantContentFile);
        newFc.ensureThreadSafeLighterAST();
        if (content2 instanceof AuthenticContent) {
            newFc.putUserData(PlatformIdTableBuilding.EDITOR_HIGHLIGHTER, EditorHighlighterCache.getEditorHighlighterForCachesBuilding((Document)document));
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static FileContentImpl getUnsavedDocContent(@NotNull Document document, @NotNull Project project2, @NotNull VirtualFile vFile, long currentDocStamp, @NotNull CharSequence charSequence) {
        void contentText;
        WeakReference<Pair<FileContentImpl, Long>> previousContentAndStampRef;
        Pair<FileContentImpl, Long> previousContentAndStamp;
        if (document == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(46);
        }
        if (project2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(47);
        }
        if (vFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(48);
        }
        if (charSequence == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(49);
        }
        if ((previousContentAndStamp = SoftReference.dereference(previousContentAndStampRef = document.getUserData(ourFileContentKey))) != null && currentDocStamp == previousContentAndStamp.getSecond()) {
            FileContentImpl fileContentImpl = previousContentAndStamp.getFirst();
            if (fileContentImpl == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(50);
            }
            return fileContentImpl;
        }
        FileContentImpl newFc = (FileContentImpl)FileContentImpl.createByText(vFile, (CharSequence)contentText, project2);
        document.putUserData(ourFileContentKey, new WeakReference<Pair<FileContentImpl, Long>>(Pair.create(newFc, currentDocStamp)));
        FileContentImpl fileContentImpl = newFc;
        if (fileContentImpl == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(51);
        }
        return fileContentImpl;
    }

    @NotNull
    public <K, V> Map<K, V> getFileData(@NotNull ID<K, V> id2, @NotNull VirtualFile virtualFile2, @NotNull Project project2) {
        if (id2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(52);
        }
        if (virtualFile2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(53);
        }
        if (project2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(54);
        }
        if (ModelBranch.getFileBranch(virtualFile2) != null) {
            return this.getInMemoryData(id2, virtualFile2, project2);
        }
        Map map2 = super.getFileData(id2, virtualFile2, project2);
        if (map2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(55);
        }
        return map2;
    }

    @NotNull
    public <K, V> Collection<VirtualFile> getContainingFiles(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter2) {
        Collection<VirtualFile> scanResult;
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(56);
        }
        if (dataKey == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(57);
        }
        if (filter2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(58);
        }
        if ((scanResult = FileBasedIndexScanUtil.getContainingFiles(indexId, dataKey, filter2)) != null) {
            Collection<VirtualFile> collection = scanResult;
            if (collection == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(59);
            }
            return collection;
        }
        Collection collection = super.getContainingFiles(indexId, dataKey, filter2);
        if (collection == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(60);
        }
        return collection;
    }

    protected <K, V> boolean processValuesInOneFile(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull VirtualFile restrictToFile, @NotNull GlobalSearchScope scope, @NotNull FileBasedIndex.ValueProcessor<? super V> processor) {
        Boolean scanResult;
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(61);
        }
        if (dataKey == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(62);
        }
        if (restrictToFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(63);
        }
        if (scope == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(64);
        }
        if (processor == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(65);
        }
        if ((scanResult = FileBasedIndexScanUtil.processValuesInOneFile(indexId, dataKey, restrictToFile, scope, processor)) != null) {
            return scanResult;
        }
        return super.processValuesInOneFile(indexId, dataKey, restrictToFile, scope, processor);
    }

    protected <K, V> boolean processValuesInScope(@NotNull ID<K, V> indexId, @NotNull K dataKey, boolean ensureValueProcessedOnce, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull FileBasedIndex.ValueProcessor<? super V> processor) {
        Boolean scanResult;
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(66);
        }
        if (dataKey == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(67);
        }
        if (scope == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(68);
        }
        if (processor == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(69);
        }
        if ((scanResult = FileBasedIndexScanUtil.processValuesInScope(indexId, dataKey, ensureValueProcessedOnce, scope, idFilter, processor)) != null) {
            return scanResult;
        }
        return super.processValuesInScope(indexId, dataKey, ensureValueProcessedOnce, scope, idFilter, processor);
    }

    public <K, V> boolean processFilesContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> dataKeys, @NotNull GlobalSearchScope filter2, @Nullable Condition<? super V> valueChecker, @NotNull Processor<? super VirtualFile> processor) {
        Boolean scanResult;
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(70);
        }
        if (dataKeys == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(71);
        }
        if (filter2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(72);
        }
        if (processor == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(73);
        }
        if ((scanResult = FileBasedIndexScanUtil.processFilesContainingAllKeys(indexId, dataKeys, filter2, valueChecker, processor)) != null) {
            return scanResult;
        }
        return super.processFilesContainingAllKeys(indexId, dataKeys, filter2, valueChecker, processor);
    }

    public <K, V> boolean processFilesContainingAnyKey(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> dataKeys, @NotNull GlobalSearchScope filter2, @Nullable IdFilter idFilter, @Nullable Condition<? super V> valueChecker, @NotNull Processor<? super VirtualFile> processor) {
        IdFilter idFilterAdjusted;
        Boolean scanResult;
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(74);
        }
        if (dataKeys == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(75);
        }
        if (filter2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(76);
        }
        if (processor == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(77);
        }
        if ((scanResult = FileBasedIndexScanUtil.processFilesContainingAnyKey(indexId, dataKeys, filter2, idFilterAdjusted = idFilter != null ? idFilter : this.extractIdFilter(filter2, filter2.getProject()), valueChecker, processor)) != null) {
            return scanResult;
        }
        return super.processFilesContainingAnyKey(indexId, dataKeys, filter2, idFilterAdjusted, valueChecker, processor);
    }

    public boolean processFilesContainingAllKeys(@NotNull Collection<? extends FileBasedIndex.AllKeysQuery<?, ?>> queries, @NotNull GlobalSearchScope filter2, @NotNull Processor<? super VirtualFile> processor) {
        Boolean scanResult;
        if (queries == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(78);
        }
        if (filter2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(79);
        }
        if (processor == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(80);
        }
        if ((scanResult = FileBasedIndexScanUtil.processFilesContainingAllKeys(queries, filter2, processor)) != null) {
            return scanResult;
        }
        return super.processFilesContainingAllKeys(queries, filter2, processor);
    }

    @Nullable
    public VirtualFile findFileById(int id2) {
        return PersistentFS.getInstance().findFileByIdIfCached(id2);
    }

    @NotNull
    public Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(81);
        }
        return logger;
    }

    @NotNull
    private <K, V> Map<K, V> getInMemoryData(@NotNull ID<K, V> id2, @NotNull VirtualFile virtualFile2, @NotNull Project project2) {
        PsiFile psiFile;
        if (id2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(82);
        }
        if (virtualFile2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(83);
        }
        if (project2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(84);
        }
        if ((psiFile = PsiManager.getInstance(project2).findFile(virtualFile2)) != null) {
            Map indexValues = (Map)CachedValuesManager.getCachedValue(psiFile, () -> {
                try {
                    FileContentImpl fc = psiFile instanceof PsiBinaryFile ? (FileContentImpl)FileContentImpl.createByFile(virtualFile2, project2) : (FileContentImpl)FileContentImpl.createByText(virtualFile2, psiFile.getViewProvider().getContents(), project2);
                    FileBasedIndexImpl.initFileContent(fc, psiFile);
                    Map<ID, Map> result2 = FactoryMap.create(key -> this.getIndex((ID)key).getExtension().getIndexer().map(fc));
                    return CachedValueProvider.Result.createSingleDependency(result2, psiFile);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            Map map2 = (Map)indexValues.get(id2);
            if (map2 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(85);
            }
            return map2;
        }
        Map map3 = Collections.emptyMap();
        if (map3 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(86);
        }
        return map3;
    }

    @ApiStatus.Internal
    public void runCleanupAction(@NotNull Runnable cleanupAction) {
        if (cleanupAction == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(87);
        }
        Computable<Boolean> updateComputable = () -> {
            ProgressManager.getInstance().executeNonCancelableSection(cleanupAction);
            return true;
        };
        this.runUpdateForPersistentData(updateComputable);
        this.myStorageBufferingHandler.runUpdate(true, updateComputable);
    }

    public void cleanupMemoryStorage(boolean skipContentDependentIndexes) {
        this.myLastIndexedDocStamps.clear();
        if (this.myRegisteredIndexes == null) {
            return;
        }
        IndexConfiguration state = this.myRegisteredIndexes.getState();
        if (state == null) {
            return;
        }
        for (ID indexId : state.getIndexIDs()) {
            if (skipContentDependentIndexes && this.myRegisteredIndexes.isContentDependentIndex(indexId)) continue;
            UpdatableIndex index = this.getIndex(indexId);
            index.cleanupMemoryStorage();
        }
    }

    public void requestRebuild(@NotNull ID<?, ?> indexId, @NotNull Throwable throwable) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(88);
        }
        if (throwable == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(89);
        }
        if (FileBasedIndexScanUtil.isManuallyManaged(indexId)) {
            this.advanceIndexVersion(indexId);
        } else if (!this.myRegisteredIndexes.isExtensionsDataLoaded()) {
            IndexDataInitializer.submitGenesisTask(() -> {
                this.waitUntilIndicesAreInitialized();
                this.doRequestRebuild(indexId, throwable);
                return null;
            });
        } else {
            this.doRequestRebuild(indexId, throwable);
        }
    }

    private void doRequestRebuild(@NotNull ID<?, ?> indexId, Throwable throwable) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(90);
        }
        IndexingFlag.cleanupProcessedFlag();
        if (!this.myRegisteredIndexes.isExtensionsDataLoaded()) {
            FileBasedIndexImpl.reportUnexpectedAsyncInitState();
        }
        if (RebuildStatus.requestRebuild(indexId)) {
            String message2 = "Rebuild requested for index " + indexId;
            Application app = ApplicationManager.getApplication();
            if (this.myIsUnitTestMode && app.isReadAccessAllowed() && !app.isDispatchThread()) {
                LOG.error(message2, throwable);
            } else {
                LOG.info(message2, throwable);
            }
            IndexingFlag.cleanupProcessedFlag();
            if (!this.myRegisteredIndexes.isInitialized()) {
                return;
            }
            this.advanceIndexVersion(indexId);
            Runnable rebuildRunnable = () -> FileBasedIndexImpl.scheduleIndexRescanningForAllProjects(message2);
            ((AppUIExecutor)AppUIExecutor.onWriteThread().later().expireWith(app)).submit(rebuildRunnable);
        }
    }

    private static void reportUnexpectedAsyncInitState() {
        LOG.error("Unexpected async indices initialization problem");
    }

    @NotNull
    public <K, V> UpdatableIndex<K, V, FileContent, ?> getIndex(ID<K, V> indexId) {
        UpdatableIndex index = this.getState().getIndex(indexId);
        if (index == null) {
            Throwable initializationProblem = this.getState().getInitializationProblem(indexId);
            String message2 = "Index is not created for `" + indexId.getName() + "`";
            throw initializationProblem != null ? new IllegalStateException(message2, initializationProblem) : new IllegalStateException(message2);
        }
        UpdatableIndex updatableIndex = index;
        if (updatableIndex == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(91);
        }
        return updatableIndex;
    }

    private FileBasedIndex.InputFilter getInputFilter(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(92);
        }
        if (!this.myRegisteredIndexes.isInitialized()) {
            this.waitUntilIndicesAreInitialized();
        }
        return this.getState().getInputFilter(indexId);
    }

    @NotNull
    Collection<VirtualFile> getFilesToUpdate(Project project2) {
        List<VirtualFile> list2 = ContainerUtil.filter(this.getChangedFilesCollector().getAllFilesToUpdate(), this.filesToBeIndexedForProjectCondition(project2)::test);
        if (list2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(93);
        }
        return list2;
    }

    @NotNull
    private Predicate<VirtualFile> filesToBeIndexedForProjectCondition(Project project2) {
        Predicate<VirtualFile> predicate = virtualFile2 -> {
            if (!virtualFile2.isValid()) {
                return true;
            }
            for (Pair<IndexableFileSet, Project> set2 : this.myIndexableSets) {
                Project proj = (Project)set2.second;
                if (proj != null && !proj.equals(project2) || !ReadAction.compute(() -> ((IndexableFileSet)set2.first).isInSet(virtualFile2)).booleanValue()) continue;
                return true;
            }
            return false;
        };
        if (predicate == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(94);
        }
        return predicate;
    }

    public boolean isFileUpToDate(VirtualFile file2) {
        return file2 instanceof VirtualFileWithId && !this.getChangedFilesCollector().isScheduledForUpdate(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRefreshedFile(@Nullable Project project2, @NotNull CachedFileContent fileContent) {
        if (fileContent == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(95);
        }
        VirtualFile file2 = fileContent.getVirtualFile();
        if (this.getChangedFilesCollector().isScheduledForUpdate(file2)) {
            try {
                this.indexFileContent(project2, fileContent, null).apply(file2);
            }
            finally {
                IndexingStamp.flushCache(FileBasedIndexImpl.getFileId((VirtualFile)file2));
                IndexingFlag.unlockFile(file2);
            }
        }
    }

    private boolean isPendingDeletionFileAppearedInIndexableFilter(int fileId, @NotNull VirtualFile file2) {
        VirtualFile originalFile;
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(96);
        }
        return file2 instanceof DeletedVirtualFileStub && (originalFile = ((DeletedVirtualFileStub)file2).getOriginalFile()).isValid() && this.ensureFileBelongsToIndexableFilter(fileId, originalFile) != FileAddStatus.SKIPPED;
    }

    @ApiStatus.Internal
    @NotNull
    public FileIndexesValuesApplier indexFileContent(@Nullable Project project2, @NotNull CachedFileContent content2, @Nullable FileType cachedFileType) {
        FileIndexesValuesApplier applier;
        if (content2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(97);
        }
        ProgressManager.checkCanceled();
        VirtualFile file2 = content2.getVirtualFile();
        int fileId = FileBasedIndexImpl.getFileId((VirtualFile)file2);
        boolean writeIndexValuesSeparately = FileBasedIndexImpl.isWritingIndexValuesSeparatedFromCounting();
        boolean isValid = file2.isValid();
        if (file2.isValid() && content2.getTimeStamp() != file2.getTimeStamp()) {
            content2 = new CachedFileContent(file2);
        }
        if (this.isPendingDeletionFileAppearedInIndexableFilter(fileId, file2)) {
            file2 = ((DeletedVirtualFileStub)file2).getOriginalFile();
            content2 = new CachedFileContent(file2);
            isValid = file2.isValid();
            this.dropNontrivialIndexedStates(fileId);
            cachedFileType = file2.getFileType();
        }
        if (!isValid || this.isTooLarge(file2)) {
            ProgressManager.checkCanceled();
            applier = new FileIndexesValuesApplier(this, fileId, file2, Collections.emptyList(), Collections.emptyList(), true, true, writeIndexValuesSeparately, cachedFileType == null ? file2.getFileType() : cachedFileType, false);
        } else {
            applier = this.doIndexFileContent(project2, content2, cachedFileType, writeIndexValuesSeparately);
        }
        applier.applyImmediately(file2, isValid);
        FileIndexesValuesApplier fileIndexesValuesApplier = applier;
        if (fileIndexesValuesApplier == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(98);
        }
        return fileIndexesValuesApplier;
    }

    @NotNull
    private FileIndexesValuesApplier doIndexFileContent(@Nullable Project project2, @NotNull CachedFileContent content2, @Nullable FileType cachedFileType, boolean writeIndexSeparately) {
        if (content2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(99);
        }
        ProgressManager.checkCanceled();
        VirtualFile file2 = content2.getVirtualFile();
        Ref<Boolean> setIndexedStatus = Ref.create(Boolean.TRUE);
        Ref fileTypeRef = Ref.create();
        int inputId = FileBasedIndexImpl.getFileId((VirtualFile)file2);
        Project guessedProject = project2 != null ? project2 : this.myIndexableFilesFilterHolder.findProjectForFile(inputId);
        IndexedFileImpl indexedFile = new IndexedFileImpl(file2, guessedProject);
        ArrayList appliers = new ArrayList();
        ArrayList<SingleIndexValueRemover> removers = new ArrayList<SingleIndexValueRemover>();
        FileTypeManagerEx fileTypeManagerEx = FileTypeManagerEx.getInstanceEx();
        if (fileTypeManagerEx instanceof FileTypeManagerImpl) {
            ((FileTypeManagerImpl)fileTypeManagerEx).freezeFileTypeTemporarilyWithProvidedValueIn(file2, cachedFileType, () -> {
                ProgressManager.checkCanceled();
                IndexedFileImpl fc = null;
                HashSet currentIndexedStates = new HashSet(IndexingStamp.getNontrivialFileIndexedStates(inputId));
                List<ID<?, ?>> affectedIndexCandidates = this.getAffectedIndexCandidates(indexedFile);
                int size = affectedIndexCandidates.size();
                for (int i = 0; i < size; ++i) {
                    boolean update2;
                    boolean acceptedAndRequired;
                    ID<?, ?> iD = affectedIndexCandidates.get(i);
                    if (FileBasedIndexScanUtil.isManuallyManaged(iD)) continue;
                    ProgressManager.checkCanceled();
                    if (fc == null) {
                        fc = (FileContentImpl)FileContentImpl.createByContent(file2, () -> content2.getBytesOrEmpty(), guessedProject);
                        fc.setSubstituteFileType(indexedFile.getFileType());
                        ProgressManager.checkCanceled();
                        fileTypeRef.set(fc.getFileType());
                        ProgressManager.checkCanceled();
                    }
                    boolean bl = acceptedAndRequired = this.acceptsInput(iD, fc) && this.getIndexingState(fc, iD).updateRequired();
                    if (acceptedAndRequired) {
                        boolean update3 = RebuildStatus.isOk(iD);
                        if (!update3) {
                            setIndexedStatus.set(Boolean.FALSE);
                            currentIndexedStates.remove(iD);
                        }
                    } else {
                        update2 = false;
                    }
                    if (!update2 && this.doTraceStubUpdates(iD)) {
                        String reason = acceptedAndRequired ? "index is required to rebuild, and indexing does not update such" : (this.acceptsInput(iD, fc) ? "update is not required" : "file is not accepted by index");
                        LOG.info("index " + iD + " should not be updated for " + fc.getFileName() + " because " + reason);
                    }
                    if (!update2) continue;
                    ProgressManager.checkCanceled();
                    SingleIndexValueApplier singleIndexValueApplier = this.createSingleIndexValueApplier(iD, file2, inputId, (FileContent)((Object)fc), writeIndexSeparately);
                    if (singleIndexValueApplier == null) {
                        setIndexedStatus.set(Boolean.FALSE);
                    } else {
                        appliers.add(singleIndexValueApplier);
                    }
                    currentIndexedStates.remove(iD);
                }
                boolean shouldClearAllIndexedStates = fc == null;
                for (ID iD : currentIndexedStates) {
                    ProgressManager.checkCanceled();
                    if (!shouldClearAllIndexedStates && !this.getIndex(iD).getIndexingStateForFile(inputId, (IndexedFile)fc).updateRequired()) continue;
                    ProgressManager.checkCanceled();
                    SingleIndexValueRemover remover = this.createSingleIndexRemover(iD, file2, (FileContent)((Object)fc), inputId, writeIndexSeparately);
                    if (remover == null) {
                        setIndexedStatus.set(Boolean.FALSE);
                        continue;
                    }
                    removers.add(remover);
                }
                fileTypeRef.set(fc != null ? fc.getFileType() : file2.getFileType());
            });
        }
        file2.putUserData(IndexingDataKeys.REBUILD_REQUESTED, null);
        return new FileIndexesValuesApplier(this, inputId, file2, appliers, removers, false, setIndexedStatus.get(), writeIndexSeparately, (FileType)fileTypeRef.get(), this.doTraceSharedIndexUpdates());
    }

    @NotNull
    List<ID<?, ?>> getAffectedIndexCandidates(@NotNull IndexedFile indexedFile) {
        if (indexedFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(100);
        }
        if (indexedFile.getFile().isDirectory()) {
            List<ID<?, ?>> list2 = FileBasedIndexImpl.isProjectOrWorkspaceFile(indexedFile.getFile(), null) ? Collections.emptyList() : this.myRegisteredIndexes.getIndicesForDirectories();
            if (list2 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(101);
            }
            return list2;
        }
        FileType fileType = indexedFile.getFileType();
        if (fileType instanceof SubstitutedFileType) {
            fileType = ((SubstitutedFileType)fileType).getFileType();
        }
        if (FileBasedIndexImpl.isProjectOrWorkspaceFile(indexedFile.getFile(), fileType)) {
            List<ID<?, ?>> list3 = Collections.emptyList();
            if (list3 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(102);
            }
            return list3;
        }
        List list4 = this.getState().getFileTypesForIndex(fileType);
        if (list4 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(103);
        }
        return list4;
    }

    private static void cleanFileContent(FileContentImpl fc, PsiFile psiFile) {
        if (fc == null) {
            return;
        }
        if (psiFile != null) {
            psiFile.putUserData(PsiFileImpl.BUILDING_STUB, null);
        }
        fc.putUserData(IndexingDataKeys.PSI_FILE, null);
    }

    private static void initFileContent(@NotNull FileContentImpl fc, PsiFile psiFile) {
        if (fc == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(104);
        }
        if (psiFile != null) {
            psiFile.putUserData(PsiFileImpl.BUILDING_STUB, true);
            fc.putUserData(IndexingDataKeys.PSI_FILE, psiFile);
        }
    }

    @NonNls
    static String getFileInfoLogString(int inputId, @Nullable VirtualFile file2, @Nullable FileContent currentFC) {
        if (file2 == null && currentFC == null) {
            return String.valueOf(inputId);
        }
        String fileName = currentFC != null ? currentFC.getFileName() : file2.getName();
        return fileName + "(id=" + inputId + ")";
    }

    void requestIndexRebuildOnException(RuntimeException exception, ID<?, ?> indexId) {
        Throwable causeToRebuildIndex = FileBasedIndexImpl.getCauseToRebuildIndex((RuntimeException)exception);
        if (causeToRebuildIndex == null) {
            throw exception;
        }
        this.requestRebuild(indexId, exception);
    }

    void updateSingleIndex(@NotNull ID<?, ?> indexId, @NotNull VirtualFile file2, int inputId, @NotNull FileContent currentFC) {
        SingleIndexValueApplier applier;
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(105);
        }
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(106);
        }
        if (currentFC == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(107);
        }
        if ((applier = this.createSingleIndexValueApplier(indexId, file2, inputId, currentFC, FileBasedIndexImpl.isWritingIndexValuesSeparatedFromCounting())) != null) {
            applier.apply();
        }
    }

    /*
     * Exception decompiling
     */
    @ApiStatus.Internal
    @Nullable(value="null in case index update is not necessary or the update has failed")
    <FileIndexMetaData> @Nullable(value="null in case index update is not necessary or the update has failed") SingleIndexValueApplier<FileIndexMetaData> createSingleIndexValueApplier(@NotNull ID<?, ?> indexId, @NotNull VirtualFile file, int inputId, @NotNull FileContent currentFC, boolean writeValuesSeparately) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void increaseLocalModCount() {
        this.myLocalModCount.incrementAndGet();
    }

    private void removeSingleIndexValue(@NotNull ID<?, ?> indexId, int inputId) {
        boolean isWritingValuesSeparately;
        SingleIndexValueRemover remover;
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(111);
        }
        if ((remover = this.createSingleIndexRemover(indexId, null, null, inputId, isWritingValuesSeparately = FileBasedIndexImpl.isWritingIndexValuesSeparatedFromCounting())) != null && isWritingValuesSeparately) {
            remover.remove();
        }
    }

    @Nullable(value="null in case index value removal is not necessary or immediate removal failed")
    private @Nullable(value="null in case index value removal is not necessary or immediate removal failed") SingleIndexValueRemover createSingleIndexRemover(@NotNull ID<?, ?> indexId, @Nullable VirtualFile file2, @Nullable FileContent fileContent, int inputId, boolean isWritingValuesSeparately) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(112);
        }
        if (this.doTraceStubUpdates(indexId)) {
            LOG.info("index " + indexId + " deletion requested for " + FileBasedIndexImpl.getFileInfoLogString(inputId, file2, fileContent));
        }
        if (!this.myRegisteredIndexes.isExtensionsDataLoaded()) {
            FileBasedIndexImpl.reportUnexpectedAsyncInitState();
        }
        if (!RebuildStatus.isOk(indexId) && !this.myIsUnitTestMode) {
            return null;
        }
        SingleIndexValueRemover remover = new SingleIndexValueRemover(this, indexId, file2, fileContent, inputId, isWritingValuesSeparately);
        if (!isWritingValuesSeparately && !remover.remove()) {
            return null;
        }
        return remover;
    }

    boolean runUpdateForPersistentData(Supplier<Boolean> storageUpdate) {
        return this.myStorageBufferingHandler.runUpdate(false, () -> ProgressManager.getInstance().computeInNonCancelableSection(() -> FileBasedIndexImpl.lambda$runUpdateForPersistentData$27((Supplier)storageUpdate)));
    }

    static void setIndexedState(UpdatableIndex<?, ?, FileContent, ?> index, @NotNull IndexedFile currentFC, int inputId, boolean indexWasProvided) {
        if (currentFC == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(113);
        }
        if (index instanceof FileBasedIndexInfrastructureExtensionUpdatableIndex) {
            ((FileBasedIndexInfrastructureExtensionUpdatableIndex)index).setIndexedStateForFile(inputId, currentFC, indexWasProvided);
        } else {
            index.setIndexedStateForFile(inputId, currentFC);
        }
    }

    public static void markFileIndexed(@Nullable VirtualFile file2, @Nullable FileContent fc) {
        if (fc != null && (ourIndexedFile.get() != null || ourFileToBeIndexed.get() != null)) {
            throw new AssertionError((Object)"Reentrant indexing");
        }
        ourIndexedFile.set(file2);
    }

    public static void unmarkBeingIndexed() {
        ourIndexedFile.remove();
    }

    public VirtualFile getFileBeingCurrentlyIndexed() {
        return ourIndexedFile.get();
    }

    static void markFileWritingIndexes(int fileId, @Nullable String filePath) {
        if (ourWritingIndexFile.get() != null) {
            throw new AssertionError((Object)"Reentrant writing indices");
        }
        ourWritingIndexFile.set(new FileBasedIndex.IndexWritingFile(fileId, filePath));
    }

    static void unmarkWritingIndexes() {
        ourWritingIndexFile.remove();
    }

    @Nullable
    public FileBasedIndex.IndexWritingFile getFileWritingCurrentlyIndexes() {
        return ourWritingIndexFile.get();
    }

    private void forceUpdate(@Nullable Project project2, @Nullable GlobalSearchScope filter2, @Nullable VirtualFile restrictedTo) {
        Collection<VirtualFile> allFilesToUpdate = this.getChangedFilesCollector().getAllFilesToUpdate();
        if (!allFilesToUpdate.isEmpty()) {
            boolean includeFilesFromOtherProjects = restrictedTo == null && project2 == null;
            List<VirtualFile> virtualFilesToBeUpdatedForProject = ContainerUtil.filter(allFilesToUpdate, new ProjectFilesCondition(this.projectIndexableFiles(project2), filter2, restrictedTo, includeFilesFromOtherProjects));
            if (!virtualFilesToBeUpdatedForProject.isEmpty()) {
                this.myForceUpdateTask.processAll(virtualFilesToBeUpdatedForProject, project2);
            }
        }
    }

    public boolean needsFileContentLoading(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(114);
        }
        return this.myRegisteredIndexes.isContentDependentIndex(indexId);
    }

    @NotNull
    public Set<Project> getContainingProjects(@NotNull VirtualFile file2) {
        Project project2;
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(115);
        }
        if ((project2 = ProjectCoreUtil.theOnlyOpenProject()) != null) {
            Set<Project> set2 = this.belongsToIndexableFiles(file2) ? Collections.singleton(project2) : Collections.emptySet();
            if (set2 == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(116);
            }
            return set2;
        }
        SmartHashSet projects = null;
        for (Pair<IndexableFileSet, Project> set3 : this.myIndexableSets) {
            if (projects != null && projects.contains(set3.second) || !((IndexableFileSet)set3.first).isInSet(file2)) continue;
            if (projects == null) {
                projects = new SmartHashSet();
            }
            projects.add((Project)set3.second);
        }
        Set<Project> set4 = ContainerUtil.notNullize(projects);
        if (set4 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(117);
        }
        return set4;
    }

    public boolean belongsToProjectIndexableFiles(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(118);
        }
        if (project2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(119);
        }
        return ContainerUtil.find(this.myIndexableSets, pair -> ((Project)pair.second).equals(project2) && ((IndexableFileSet)pair.first).isInSet(file2)) != null;
    }

    public boolean belongsToIndexableFiles(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(120);
        }
        return ContainerUtil.find(this.myIndexableSets, pair -> ((IndexableFileSet)pair.first).isInSet(file2)) != null;
    }

    @ApiStatus.Internal
    public void dropNontrivialIndexedStates(int inputId) {
        for (ID<?, ?> id2 : IndexingStamp.getNontrivialFileIndexedStates(inputId)) {
            this.dropNontrivialIndexedStates(inputId, id2);
        }
    }

    @ApiStatus.Internal
    public void dropNontrivialIndexedStates(int inputId, ID<?, ?> indexId) {
        UpdatableIndex<?, ?, FileContent, ?> index = this.getIndex(indexId);
        index.invalidateIndexedStateForFile(inputId);
    }

    public void doTransientStateChangeForFile(int fileId, @NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(121);
        }
        this.clearUpToDateIndexesForUnsavedOrTransactedDocs();
        Document document = this.myFileDocumentManager.getCachedDocument(file2);
        if (document != null && this.myFileDocumentManager.isDocumentUnsaved(document)) {
            this.myLastIndexedDocStamps.clearForDocument(document);
            document.putUserData(ourFileContentKey, null);
            return;
        }
        Collection<ID<?, ?>> contentDependentIndexes = ContainerUtil.intersection(IndexingStamp.getNontrivialFileIndexedStates(fileId), this.myRegisteredIndexes.getRequiringContentIndices());
        this.removeTransientFileDataFromIndices(contentDependentIndexes, fileId, file2);
        for (ID<?, ?> candidate : contentDependentIndexes) {
            this.getIndex(candidate).invalidateIndexedStateForFile(fileId);
        }
        IndexingStamp.flushCache(fileId);
        this.getChangedFilesCollector().scheduleForUpdate(file2);
    }

    public void doInvalidateIndicesForFile(int fileId, @NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(122);
        }
        IndexingFlag.cleanProcessedFlagRecursively(file2);
        List<ID<?, ?>> nontrivialFileIndexedStates = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        this.removeTransientFileDataFromIndices(nontrivialFileIndexedStates, fileId, file2);
        for (ID<?, ?> indexId : nontrivialFileIndexedStates) {
            if (this.myRegisteredIndexes.isContentDependentIndex(indexId)) continue;
            this.removeSingleIndexValue(indexId, fileId);
        }
        if (!file2.isDirectory()) {
            this.getChangedFilesCollector().scheduleForUpdate((VirtualFile)new DeletedVirtualFileStub((VirtualFileWithId)((Object)file2)));
        } else {
            this.getChangedFilesCollector().removeScheduledFileFromUpdate(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleFileForIndexing(int fileId, @NotNull VirtualFile file2, boolean contentChange) {
        List<IndexableFilesFilter> filters;
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(123);
        }
        if (!(filters = IndexableFilesFilter.EP_NAME.getExtensionList()).isEmpty() && !ContainerUtil.exists(filters, e -> e.shouldIndex(file2))) {
            return;
        }
        if (this.ensureFileBelongsToIndexableFilter(fileId, file2) == FileAddStatus.SKIPPED) {
            this.doInvalidateIndicesForFile(fileId, file2);
            return;
        }
        List<ID<?, ?>> nontrivialFileIndexedStates = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        this.removeTransientFileDataFromIndices(nontrivialFileIndexedStates, fileId, file2);
        boolean fileIsDirectory = file2.isDirectory();
        IndexedFileImpl indexedFile = new IndexedFileImpl(file2, this.myIndexableFilesFilterHolder.findProjectForFile(fileId));
        IndexedFileWrapper fileContent = null;
        for (ID<Object, Object> indexId : contentChange ? Collections.singleton(FileTypeIndex.NAME) : this.getContentLessIndexes(fileIsDirectory)) {
            if (!this.acceptsInput(indexId, indexedFile)) continue;
            if (fileContent == null) {
                fileContent = new IndexedFileWrapper((IndexedFile)indexedFile);
            }
            this.updateSingleIndex(indexId, file2, fileId, (FileContent)fileContent);
        }
        if (!fileIsDirectory) {
            if (!file2.isValid() || this.isTooLarge(file2)) {
                this.getChangedFilesCollector().scheduleForUpdate((VirtualFile)new DeletedVirtualFileStub((VirtualFileWithId)((Object)file2)));
            } else {
                ourFileToBeIndexed.set(file2);
                try {
                    FileTypeManagerEx.getInstanceEx().freezeFileTypeTemporarilyIn(file2, () -> {
                        List<ID<?, ?>> candidates = this.getAffectedIndexCandidates(indexedFile);
                        boolean scheduleForUpdate = false;
                        int size = candidates.size();
                        for (int i = 0; i < size; ++i) {
                            ID<?, ?> indexId = candidates.get(i);
                            if (!this.needsFileContentLoading(indexId) || !this.acceptsInput(indexId, indexedFile)) continue;
                            this.getIndex(indexId).invalidateIndexedStateForFile(fileId);
                            scheduleForUpdate = true;
                        }
                        if (scheduleForUpdate) {
                            IndexingStamp.flushCache(fileId);
                            this.getChangedFilesCollector().scheduleForUpdate(file2);
                        } else {
                            IndexingFlag.setFileIndexed(file2);
                        }
                    });
                }
                finally {
                    ourFileToBeIndexed.remove();
                }
            }
        } else {
            IndexingFlag.setFileIndexed(file2);
        }
    }

    @NotNull
    private FileAddStatus ensureFileBelongsToIndexableFilter(int fileId, @NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(124);
        }
        FileAddStatus fileAddStatus = this.myIndexableFilesFilterHolder.addFileId(fileId, (Function0<? extends Set<? extends Project>>)((Function0)() -> this.getContainingProjects(file2)));
        if (fileAddStatus == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(125);
        }
        return fileAddStatus;
    }

    @NotNull
    Collection<ID<?, ?>> getContentLessIndexes(boolean isDirectory) {
        Collection<ID<?, ?>> collection = isDirectory ? this.myRegisteredIndexes.getIndicesForDirectories() : this.myRegisteredIndexes.getNotRequiringContentIndices();
        if (collection == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(126);
        }
        return collection;
    }

    @NotNull
    public Collection<ID<?, ?>> getContentDependentIndexes() {
        Set<ID<?, ?>> set2 = this.myRegisteredIndexes.getRequiringContentIndices();
        if (set2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(127);
        }
        return set2;
    }

    void clearUpToDateIndexesForUnsavedOrTransactedDocs() {
        if (!this.myUpToDateIndicesForUnsavedOrTransactedDocuments.isEmpty()) {
            this.myUpToDateIndicesForUnsavedOrTransactedDocuments.clear();
        }
    }

    FileIndexingState shouldIndexFile(@NotNull IndexedFile file2, @NotNull ID<?, ?> indexId) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(128);
        }
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(129);
        }
        if (!this.acceptsInput(indexId, file2)) {
            return this.getIndexingState(file2, indexId) == FileIndexingState.NOT_INDEXED ? FileIndexingState.UP_TO_DATE : FileIndexingState.OUT_DATED;
        }
        return this.getIndexingState(file2, indexId);
    }

    @NotNull
    FileIndexingState getIndexingState(@NotNull IndexedFile file2, @NotNull ID<?, ?> indexId) {
        VirtualFile virtualFile2;
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(130);
        }
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(131);
        }
        if (FileBasedIndexImpl.isMock(virtualFile2 = file2.getFile())) {
            FileIndexingState fileIndexingState = FileIndexingState.NOT_INDEXED;
            if (fileIndexingState == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(132);
            }
            return fileIndexingState;
        }
        FileIndexingState fileIndexingState = this.getIndex(indexId).getIndexingStateForFile(((NewVirtualFile)virtualFile2).getId(), file2);
        if (fileIndexingState == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(133);
        }
        return fileIndexingState;
    }

    public static boolean isMock(VirtualFile file2) {
        return !(file2 instanceof NewVirtualFile);
    }

    public boolean isTooLarge(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(134);
        }
        return this.isTooLarge(file2, null);
    }

    public boolean isTooLarge(@NotNull VirtualFile file2, @Nullable(value="if content size should be retrieved from a file") @Nullable(value="if content size should be retrieved from a file") Long contentSize) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(135);
        }
        return FileBasedIndexImpl.isTooLarge((VirtualFile)file2, (Long)contentSize, this.myRegisteredIndexes.getNoLimitCheckFileTypes());
    }

    public void registerIndexableSet(@NotNull IndexableFileSet set2, @NotNull Project project2) {
        if (set2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(136);
        }
        if (project2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(137);
        }
        this.myIndexableSets.add(Pair.create(set2, project2));
    }

    boolean acceptsInput(@NotNull ID<?, ?> indexId, @NotNull IndexedFile indexedFile) {
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(138);
        }
        if (indexedFile == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(139);
        }
        FileBasedIndex.InputFilter filter2 = this.getInputFilter(indexId);
        return FileBasedIndexImpl.acceptsInput((FileBasedIndex.InputFilter)filter2, (IndexedFile)indexedFile);
    }

    public void removeIndexableSet(@NotNull IndexableFileSet set2) {
        if (set2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(140);
        }
        if (!this.myIndexableSets.removeIf(p -> p.first == set2)) {
            return;
        }
        ChangedFilesCollector changedFilesCollector = this.getChangedFilesCollector();
        for (VirtualFile file2 : changedFilesCollector.getAllFilesToUpdate()) {
            int fileId = FileBasedIndexImpl.getFileId((VirtualFile)file2);
            if (!file2.isValid()) {
                this.removeDataFromIndicesForFile(fileId, file2, "invalid_file");
                changedFilesCollector.removeFileIdFromFilesScheduledForUpdate(fileId);
                continue;
            }
            if (this.belongsToIndexableFiles(file2)) continue;
            if (ChangedFilesCollector.CLEAR_NON_INDEXABLE_FILE_DATA) {
                this.removeDataFromIndicesForFile(fileId, file2, "non_indexable_file");
            }
            changedFilesCollector.removeFileIdFromFilesScheduledForUpdate(fileId);
        }
        IndexingStamp.flushCaches();
    }

    public VirtualFile findFileById(Project project2, int id2) {
        return ManagingFS.getInstance().findFileById(id2);
    }

    @Nullable
    private static PsiFile findLatestKnownPsiForUncomittedDocument(@NotNull Document doc, @NotNull Project project2) {
        if (doc == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(141);
        }
        if (project2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(142);
        }
        return PsiDocumentManager.getInstance(project2).getCachedPsiFile(doc);
    }

    void setUpFlusher() {
        this.myFlushingFuture = FlushingDaemon.everyFiveSeconds((Runnable)new Runnable(){
            private int lastModCount;

            @Override
            public void run() {
                int currentModCount = FileBasedIndexImpl.this.myLocalModCount.get();
                if (this.lastModCount == currentModCount) {
                    FileBasedIndexImpl.this.flushAllIndices(this.lastModCount);
                }
                this.lastModCount = currentModCount;
            }
        });
    }

    public void invalidateCaches() {
        CorruptionMarker.requestInvalidation();
    }

    public boolean isFileIndexedInCurrentSession(@NotNull VirtualFile file2, @NotNull ID<?, ?> indexId) {
        if (file2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(143);
        }
        if (indexId == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(144);
        }
        if (!(file2.isValid() && file2 instanceof VirtualFileSystemEntry && ((VirtualFileSystemEntry)file2).isFileIndexed())) {
            return false;
        }
        int fileId = FileBasedIndexImpl.getFileId((VirtualFile)file2);
        return IndexingStamp.getNontrivialFileIndexedStates(fileId).contains(indexId);
    }

    @ApiStatus.Internal
    @NotNull
    public IntPredicate getAccessibleFileIdFilter(@Nullable Project project2) {
        boolean dumb = ActionUtil.isDumbMode((Project)project2);
        if (!dumb) {
            IntPredicate intPredicate = f -> true;
            if (intPredicate == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(145);
            }
            return intPredicate;
        }
        if (DumbServiceImpl.ALWAYS_SMART && project2 != null && UnindexedFilesUpdater.isIndexUpdateInProgress(project2)) {
            IntPredicate intPredicate = f -> true;
            if (intPredicate == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(146);
            }
            return intPredicate;
        }
        DumbModeAccessType dumbModeAccessType = this.getCurrentDumbModeAccessType();
        if (dumbModeAccessType == null) {
            IntPredicate intPredicate = __ -> true;
            if (intPredicate == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(147);
            }
            return intPredicate;
        }
        if (dumbModeAccessType == DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE) {
            IntPredicate intPredicate = f -> true;
            if (intPredicate == null) {
                FileBasedIndexImpl.$$$reportNull$$$0(148);
            }
            return intPredicate;
        }
        assert (dumbModeAccessType == DumbModeAccessType.RELIABLE_DATA_ONLY);
        IntPredicate intPredicate = fileId -> !this.getChangedFilesCollector().containsFileId(fileId);
        if (intPredicate == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(149);
        }
        return intPredicate;
    }

    @Nullable
    public IdFilter extractIdFilter(@Nullable GlobalSearchScope scope, @Nullable Project project2) {
        if (scope == null) {
            return this.projectIndexableFiles(project2);
        }
        IdFilter filter2 = this.extractFileEnumeration(scope);
        if (filter2 != null) {
            return filter2;
        }
        return this.projectIndexableFiles(ObjectUtils.chooseNotNull(project2, scope.getProject()));
    }

    @ApiStatus.Internal
    public void flushIndexes() {
        for (ID id2 : this.getRegisteredIndexes().getState().getIndexIDs()) {
            try {
                this.getIndex(id2).flush();
            }
            catch (StorageException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @ApiStatus.Internal
    static <K, V> int getIndexExtensionVersion(@NotNull FileBasedIndexExtension<K, V> extension2) {
        if (extension2 == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(150);
        }
        int version = extension2.getVersion();
        if (VfsAwareMapReduceIndex.hasSnapshotMapping(extension2)) {
            version += SnapshotInputMappings.getVersion();
        }
        return version;
    }

    @Nullable
    private IdFilter extractFileEnumeration(final @NotNull GlobalSearchScope scope) {
        VirtualFileEnumeration hint;
        if (scope == null) {
            FileBasedIndexImpl.$$$reportNull$$$0(151);
        }
        if ((hint = VirtualFileEnumeration.extract(scope)) != null) {
            return new IdFilter(){

                public boolean containsFileId(int id2) {
                    return hint.contains(id2);
                }

                public String toString() {
                    return "IdFilter of " + scope;
                }
            };
        }
        Project project2 = scope.getProject();
        if (project2 == null) {
            return null;
        }
        return this.projectIndexableFiles(project2);
    }

    private static boolean isWritingIndexValuesSeparatedFromCounting() {
        return ourWritingIndexValuesSeparatedFromCounting;
    }

    static boolean isWritingIndexValuesSeparatedFromCountingForContentIndependentIndexes() {
        return ourWritingIndexValuesSeparatedFromCounting && ourWritingIndexValuesSeparatedFromCountingForContentIndependentIndexes;
    }

    static void setupWritingIndexValuesSeparatedFromCounting() {
        ourWritingIndexValuesSeparatedFromCounting = Registry.is("indexing.separate.applying.values.from.counting");
    }

    static void setupWritingIndexValuesSeparatedFromCountingForContentIndependentIndexes() {
        ourWritingIndexValuesSeparatedFromCountingForContentIndependentIndexes = Registry.is("indexing.separate.applying.values.from.counting.for.content.independent.indexes");
    }

    private static /* synthetic */ Boolean lambda$runUpdateForPersistentData$27(Supplier storageUpdate) throws RuntimeException {
        return (Boolean)storageUpdate.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 21: 
            case 22: 
            case 34: 
            case 37: 
            case 50: 
            case 51: 
            case 55: 
            case 59: 
            case 60: 
            case 81: 
            case 85: 
            case 86: 
            case 91: 
            case 93: 
            case 94: 
            case 98: 
            case 101: 
            case 102: 
            case 103: 
            case 116: 
            case 117: 
            case 125: 
            case 126: 
            case 127: 
            case 132: 
            case 133: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 21: 
            case 22: 
            case 34: 
            case 37: 
            case 50: 
            case 51: 
            case 55: 
            case 59: 
            case 60: 
            case 81: 
            case 85: 
            case 86: 
            case 91: 
            case 93: 
            case 94: 
            case 98: 
            case 101: 
            case 102: 
            case 103: 
            case 116: 
            case 117: 
            case 125: 
            case 126: 
            case 127: 
            case 132: 
            case 133: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 1: 
            case 58: 
            case 72: 
            case 76: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 32: 
            case 33: 
            case 41: 
            case 47: 
            case 54: 
            case 84: 
            case 119: 
            case 137: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 30: 
            case 65: 
            case 69: 
            case 73: 
            case 77: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: 
            case 21: 
            case 22: 
            case 34: 
            case 37: 
            case 50: 
            case 51: 
            case 55: 
            case 59: 
            case 60: 
            case 81: 
            case 85: 
            case 86: 
            case 91: 
            case 93: 
            case 94: 
            case 98: 
            case 101: 
            case 102: 
            case 103: 
            case 116: 
            case 117: 
            case 125: 
            case 126: 
            case 127: 
            case 132: 
            case 133: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/FileBasedIndexImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staleIds";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 24: 
            case 96: 
            case 106: 
            case 109: 
            case 115: 
            case 118: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 128: 
            case 130: 
            case 134: 
            case 135: 
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: 
            case 15: 
            case 19: 
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionRegistrationStatusSink";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staleInputIdSink";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrationStatusSink";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedIndices";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 28: 
            case 29: 
            case 36: 
            case 38: 
            case 56: 
            case 61: 
            case 66: 
            case 70: 
            case 74: 
            case 88: 
            case 90: 
            case 92: 
            case 105: 
            case 108: 
            case 111: 
            case 112: 
            case 114: 
            case 129: 
            case 131: 
            case 138: 
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 31: 
            case 64: 
            case 68: 
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 39: 
            case 43: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestedIndexId";
                break;
            }
            case 42: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentText";
                break;
            }
            case 52: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 53: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 57: 
            case 62: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restrictToFile";
                break;
            }
            case 71: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKeys";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queries";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cleanupAction";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
            case 97: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 100: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexedFile";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fc";
                break;
            }
            case 107: 
            case 110: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFC";
                break;
            }
            case 136: 
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpSnapshotInputMappingStatistics";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndex";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexableFilesFilterHolder";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransactedDocuments";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnsavedDocContent";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileData";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFiles";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getInMemoryData";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndex";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToUpdate";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "filesToBeIndexedForProjectCondition";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "indexFileContent";
                break;
            }
            case 101: 
            case 102: 
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedIndexCandidates";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingProjects";
                break;
            }
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureFileBelongsToIndexableFilter";
                break;
            }
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentLessIndexes";
                break;
            }
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentDependentIndexes";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexingState";
                break;
            }
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleFileIdFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scheduleFullIndexesRescan";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doClearIndices";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerProjectFileSets";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeProjectFileSets";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processChangedFiles";
                break;
            }
            case 6: 
            case 21: 
            case 22: 
            case 34: 
            case 37: 
            case 50: 
            case 51: 
            case 55: 
            case 59: 
            case 60: 
            case 81: 
            case 85: 
            case 86: 
            case 91: 
            case 93: 
            case 94: 
            case 98: 
            case 101: 
            case 102: 
            case 103: 
            case 116: 
            case 117: 
            case 125: 
            case 126: 
            case 127: 
            case 132: 
            case 133: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addStaleIds";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isProjectOrWorkspaceFile";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "requestReindex";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexer";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "initIndexStorage";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createIndex";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "performShutdown";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeDataFromIndicesForFile";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeFileDataFromIndices";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "removeTransientFileDataFromIndices";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "ensureUpToDate";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "filesUpdateFinished";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "fireUpdateFinished";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "scheduleIndexRescanningForAllProjects";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "clearIndex";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "indexUnsavedDocuments";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "indexUnsavedDocument";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findLatestContent";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "updateIndexInNonCancellableSection";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "tuneFileContent";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getUnsavedDocContent";
                break;
            }
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getFileData";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFiles";
                break;
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "processValuesInOneFile";
                break;
            }
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "processValuesInScope";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 78: 
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAllKeys";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAnyKey";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getInMemoryData";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "runCleanupAction";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "requestRebuild";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "doRequestRebuild";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getInputFilter";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "processRefreshedFile";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "isPendingDeletionFileAppearedInIndexableFilter";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "indexFileContent";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "doIndexFileContent";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedIndexCandidates";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "initFileContent";
                break;
            }
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "updateSingleIndex";
                break;
            }
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "createSingleIndexValueApplier";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "removeSingleIndexValue";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "createSingleIndexRemover";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "setIndexedState";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "needsFileContentLoading";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "getContainingProjects";
                break;
            }
            case 118: 
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "belongsToProjectIndexableFiles";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "belongsToIndexableFiles";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "doTransientStateChangeForFile";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "doInvalidateIndicesForFile";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "scheduleFileForIndexing";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "ensureFileBelongsToIndexableFilter";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "shouldIndexFile";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "getIndexingState";
                break;
            }
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "isTooLarge";
                break;
            }
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "registerIndexableSet";
                break;
            }
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "acceptsInput";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "removeIndexableSet";
                break;
            }
            case 141: 
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "findLatestKnownPsiForUncomittedDocument";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "isFileIndexedInCurrentSession";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "getIndexExtensionVersion";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "extractFileEnumeration";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 21: 
            case 22: 
            case 34: 
            case 37: 
            case 50: 
            case 51: 
            case 55: 
            case 59: 
            case 60: 
            case 81: 
            case 85: 
            case 86: 
            case 91: 
            case 93: 
            case 94: 
            case 98: 
            case 101: 
            case 102: 
            case 103: 
            case 116: 
            case 117: 
            case 125: 
            case 126: 
            case 127: 
            case 132: 
            case 133: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class VirtualFileUpdateTask
    extends UpdateTask<VirtualFile> {
        private VirtualFileUpdateTask() {
        }

        void doProcess(VirtualFile item, Project project2) {
            FileBasedIndexImpl.this.processRefreshedFile(project2, new CachedFileContent(item));
        }
    }

    static class MyShutDownTask
    implements Runnable {
        MyShutDownTask() {
        }

        @Override
        public void run() {
            try {
                FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
                if (fileBasedIndex instanceof FileBasedIndexImpl) {
                    ((FileBasedIndexImpl)fileBasedIndex).performShutdown(false, "IDE shutdown");
                }
            }
            finally {
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    StorageDiagnosticData.dumpOnShutdown();
                }
            }
        }
    }
}

