/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilesScanExecutor;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.todo.TodoIndex;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexedFileImpl;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.impl.InputData;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FileBasedIndexScanUtil {
    private static void ensureUpToDate(@NotNull ID<?, ?> indexId) {
        if (indexId == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(0);
        }
        SlowOperations.assertSlowOperationsAreAllowed();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        NoAccessDuringPsiEvents.checkCallContext(indexId);
        ProgressManager.checkCanceled();
        ((FileBasedIndexImpl)FileBasedIndex.getInstance()).getChangedFilesCollector().processFilesToUpdateInReadAction();
    }

    @Nullable
    public static <K, V> Map<K, V> getIndexData(@NotNull ID<K, V> indexId, @Nullable Project project2, @NotNull VirtualFile file2) {
        if (indexId == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(2);
        }
        FileBasedIndexScanUtil.ensureUpToDate(indexId);
        return FileBasedIndexScanUtil.getIndexer(indexId, project2, true).apply(file2);
    }

    @Nullable
    public static <V, K> Collection<VirtualFile> getContainingFiles(@NotNull ID<K, V> indexId, @NotNull K key, @NotNull GlobalSearchScope scope) {
        if (indexId == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(3);
        }
        if (key == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(5);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor(new HashSet());
        Boolean result2 = FileBasedIndexScanUtil.processFilesContainingAnyKey(indexId, Set.of(key), scope, null, null, processor);
        return result2 == null ? null : processor.getResults();
    }

    @Nullable
    static <K> Boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(8);
        }
        if (indexId == FilenameIndex.NAME && Registry.is("indexing.filename.over.vfs")) {
            FileBasedIndexScanUtil.ensureUpToDate(indexId);
            return FSRecords.processAllNames(processor);
        }
        if (indexId == FileTypeIndex.NAME && Registry.is("indexing.filetype.over.vfs")) {
            InThisThreadProcessor threadProcessor = new InThisThreadProcessor();
            return FileBasedIndexScanUtil.processFilesInScope(indexId, scope, true, idFilter, file2 -> {
                FileType fileType = file2.getFileType();
                return threadProcessor.process(() -> processor.process((Object)fileType));
            }) && threadProcessor.processQueue();
        }
        if (indexId == IdIndex.NAME && Registry.is("indexing.id.over.vfs")) {
            return FileBasedIndexScanUtil.doProcessAllKeys(indexId, processor, scope, idFilter);
        }
        return null;
    }

    public static <K> boolean doProcessAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (indexId == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(11);
        }
        Project project2 = scope.getProject();
        InThisThreadProcessor threadProcessor = new InThisThreadProcessor();
        Function indexer = FileBasedIndexScanUtil.getIndexer(indexId, project2, false);
        return FileBasedIndexScanUtil.processFilesInScope(indexId, scope, false, idFilter, file2 -> {
            Map map2 = (Map)indexer.apply((VirtualFile)file2);
            if (map2 == null) {
                return true;
            }
            return threadProcessor.process(() -> ContainerUtil.process(map2.keySet(), processor));
        }) && threadProcessor.processQueue();
    }

    @Nullable
    static <K, V> Boolean processValuesInScope(@NotNull ID<K, V> indexId, @NotNull K dataKey, boolean ensureValueProcessedOnce, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull FileBasedIndex.ValueProcessor<? super V> processor) {
        if (indexId == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(12);
        }
        if (dataKey == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(15);
        }
        if (indexId == FilenameIndex.NAME && Registry.is("indexing.filename.over.vfs")) {
            FileBasedIndexScanUtil.ensureUpToDate(indexId);
            IntOpenHashSet ids = new IntOpenHashSet();
            FSRecords.processFilesWithNames(Set.of((String)dataKey), id2 -> {
                if (idFilter != null && !idFilter.containsFileId(id2)) {
                    return true;
                }
                ids.add(id2);
                return true;
            });
            PersistentFS fs = PersistentFS.getInstance();
            IntIterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                VirtualFile file3 = fs.findFileById(iterator.nextInt());
                if (file3 == null || !scope.contains(file3)) continue;
                if (!processor.process(file3, null)) {
                    return false;
                }
                if (!ensureValueProcessedOnce) continue;
                break;
            }
            return true;
        }
        if (indexId == FileTypeIndex.NAME && Registry.is("indexing.filetype.over.vfs")) {
            Ref<Boolean> stoppedByVal;
            InThisThreadProcessor threadProcessor = new InThisThreadProcessor();
            Ref<Boolean> ref = stoppedByVal = ensureValueProcessedOnce ? Ref.create(false) : null;
            if (!(FileBasedIndexScanUtil.processFilesInScope(indexId, scope, true, idFilter, file2 -> {
                if (!Objects.equals(dataKey, file2.getFileType())) {
                    return true;
                }
                if (!threadProcessor.process(() -> processor.process(file2, null))) {
                    return false;
                }
                if (ensureValueProcessedOnce) {
                    stoppedByVal.set(true);
                    return false;
                }
                return true;
            }) || ensureValueProcessedOnce && stoppedByVal.get().booleanValue())) {
                return false;
            }
            return threadProcessor.processQueue();
        }
        if (indexId == IdIndex.NAME && Registry.is("indexing.id.over.vfs")) {
            return FileBasedIndexScanUtil.doProcessValuesInScope(indexId, dataKey, ensureValueProcessedOnce, scope, idFilter, processor);
        }
        return null;
    }

    public static <K, V> boolean doProcessValuesInScope(@NotNull ID<K, V> indexId, @NotNull K dataKey, boolean ensureValueProcessedOnce, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull FileBasedIndex.ValueProcessor<? super V> processor) {
        if (indexId == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(16);
        }
        if (dataKey == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(17);
        }
        if (scope == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(18);
        }
        if (processor == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(19);
        }
        Project project2 = scope.getProject();
        InThisThreadProcessor threadProcessor = new InThisThreadProcessor();
        ConcurrentHashMap visitedValues = ensureValueProcessedOnce ? new ConcurrentHashMap() : null;
        Function indexer = FileBasedIndexScanUtil.getIndexer(indexId, project2, false);
        return FileBasedIndexScanUtil.processFilesInScope(indexId, scope, false, idFilter, file2 -> {
            Object value;
            Map map2 = (Map)indexer.apply((VirtualFile)file2);
            Object k = value = map2 == null ? null : (Object)map2.get(dataKey);
            if (value == null) {
                return true;
            }
            if (ensureValueProcessedOnce && visitedValues.put(value, true) != null) {
                return true;
            }
            return threadProcessor.process(() -> processor.process(file2, value));
        }) && threadProcessor.processQueue();
    }

    @Nullable
    private static <K, V> FileBasedIndexExtension<K, V> findIndexExtension(@NotNull ID<K, V> id2) {
        if (id2 == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(20);
        }
        for (FileBasedIndexExtension extension2 : FileBasedIndexExtension.EXTENSION_POINT_NAME.getExtensionList()) {
            if (extension2.getName() != id2) continue;
            return extension2;
        }
        return null;
    }

    @Nullable
    public static <K, V> Boolean processValuesInOneFile(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull VirtualFile file2, @NotNull GlobalSearchScope scope, @NotNull FileBasedIndex.ValueProcessor<? super V> processor) {
        if (indexId == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(21);
        }
        if (dataKey == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(22);
        }
        if (file2 == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(23);
        }
        if (scope == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(24);
        }
        if (processor == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(25);
        }
        if (indexId == IdIndex.NAME && Registry.is("indexing.id.over.vfs")) {
            Object value;
            Map<K, V> map2 = FileBasedIndexScanUtil.getIndexer(indexId, scope.getProject(), false).apply(file2);
            Object v0 = value = map2 == null ? null : map2.get(dataKey);
            if (value == null) {
                return true;
            }
            return processor.process(file2, value);
        }
        return null;
    }

    @Nullable
    public static <K, V> Boolean processFilesContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> dataKeys, @NotNull GlobalSearchScope scope, @Nullable Condition<? super V> valueChecker, @NotNull Processor<? super VirtualFile> processor) {
        if (indexId == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(26);
        }
        if (dataKeys == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(27);
        }
        if (scope == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(28);
        }
        if (processor == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(29);
        }
        if (indexId == IdIndex.NAME && Registry.is("indexing.id.over.vfs")) {
            Project project2 = scope.getProject();
            InThisThreadProcessor threadProcessor = new InThisThreadProcessor();
            Function indexer = FileBasedIndexScanUtil.getIndexer(indexId, project2, false);
            return FileBasedIndexScanUtil.processFilesInScope(indexId, scope, false, null, file2 -> {
                Map map2 = (Map)indexer.apply((VirtualFile)file2);
                if (map2 == null) {
                    return true;
                }
                for (Object key : dataKeys) {
                    Object value = map2.get(key);
                    if (value == null) {
                        return true;
                    }
                    if (valueChecker == null || valueChecker.value((Object)value)) continue;
                    return true;
                }
                return threadProcessor.process(() -> processor.process((VirtualFile)file2));
            }) && threadProcessor.processQueue();
        }
        return null;
    }

    @Nullable
    public static Boolean processFilesContainingAllKeys(@NotNull Collection<? extends FileBasedIndex.AllKeysQuery<?, ?>> queries, @NotNull GlobalSearchScope scope, @NotNull Processor<? super VirtualFile> processor) {
        FileBasedIndex.AllKeysQuery<?, ?> query2;
        if (queries == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(30);
        }
        if (scope == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(31);
        }
        if (processor == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(32);
        }
        if ((query2 = ContainerUtil.getFirstItem(queries)) != null && query2.getIndexId() == IdIndex.NAME && Registry.is("indexing.id.over.vfs")) {
            FileBasedIndex.AllKeysQuery<?, ?> q = query2;
            return FileBasedIndexScanUtil.processFilesContainingAllKeys(IdIndex.NAME, q.getDataKeys(), scope, q.getValueChecker(), processor);
        }
        return null;
    }

    public static <K, V> Boolean processFilesContainingAnyKey(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> keys2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter, @Nullable Condition<? super V> valueChecker, @NotNull Processor<? super VirtualFile> processor) {
        if (indexId == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(33);
        }
        if (keys2 == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(34);
        }
        if (scope == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(35);
        }
        if (processor == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(36);
        }
        if (indexId == FilenameIndex.NAME && Registry.is("indexing.filename.over.vfs")) {
            FileBasedIndexScanUtil.ensureUpToDate(indexId);
            IntOpenHashSet ids = new IntOpenHashSet();
            FSRecords.processFilesWithNames((Set)((Set)keys2), id2 -> {
                if (idFilter != null && !idFilter.containsFileId(id2)) {
                    return true;
                }
                ids.add(id2);
                return true;
            });
            PersistentFS fs = PersistentFS.getInstance();
            IntIterator iterator = ids.iterator();
            while (iterator.hasNext()) {
                VirtualFile file2 = fs.findFileById(iterator.nextInt());
                if (file2 == null || !scope.contains(file2) || valueChecker != null && !valueChecker.value(file2.getName()) || processor.process(file2)) continue;
                return false;
            }
            return true;
        }
        return null;
    }

    private static boolean processFilesInScope(@NotNull ID<?, ?> indexId, @NotNull GlobalSearchScope scope, boolean includingBinary, @Nullable IdFilter idFilter, @NotNull Processor<? super VirtualFile> processor) {
        if (indexId == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(37);
        }
        if (scope == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(38);
        }
        if (processor == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(39);
        }
        FileBasedIndexScanUtil.ensureUpToDate(indexId);
        return FilesScanExecutor.processFilesInScope(includingBinary, scope, idFilter, processor);
    }

    @NotNull
    private static <K, V> Function<VirtualFile, ? extends Map<K, V>> getIndexer(@NotNull ID<K, V> indexId, @Nullable Project project2, boolean binary) {
        if (indexId == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(40);
        }
        UpdatableIndex index = ((FileBasedIndexEx)FileBasedIndex.getInstance()).getIndex(indexId);
        FileBasedIndexExtension<K, V> indexExtension = Objects.requireNonNull(FileBasedIndexScanUtil.findIndexExtension(indexId));
        FileBasedIndex.InputFilter inputFilter = indexExtension.getInputFilter();
        DataIndexer indexer = indexExtension.getIndexer();
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Function<VirtualFile, Map> function = file2 -> {
            IndexedFileImpl indexedFile = new IndexedFileImpl((VirtualFile)file2, project2);
            if (!FileBasedIndexEx.acceptsInput((FileBasedIndex.InputFilter)inputFilter, (IndexedFile)indexedFile)) {
                return null;
            }
            int fileId = FileBasedIndex.getFileId((VirtualFile)file2);
            Document document = fileDocumentManager.getCachedDocument((VirtualFile)file2);
            boolean unsavedDocument = document != null && fileDocumentManager.isDocumentUnsaved(document);
            try {
                Map map2;
                if (!unsavedDocument && index.getIndexingStateForFile(fileId, (IndexedFile)indexedFile) == FileIndexingState.UP_TO_DATE) {
                    try {
                        Map map3 = index.getIndexedFileData(fileId);
                        return map3;
                    }
                    catch (StorageException e) {
                        throw new RuntimeException(e);
                    }
                }
                FileContent content2 = FileBasedIndexScanUtil.getFileContent(file2, project2, binary);
                Map map4 = map2 = content2 == null ? null : indexer.map(content2);
                if (unsavedDocument) {
                    Map map5 = map2;
                    return map5;
                }
                InputData inputData = map2 == null || map2.isEmpty() ? InputData.empty() : new InputData<K, V>(map2){};
                Computable computable = index.prepareUpdate(fileId, inputData);
                ProgressManager.getInstance().computeInNonCancelableSection(computable::compute);
                IndexingStamp.setFileIndexedStateCurrent(fileId, indexId);
                Map map6 = map2;
                return map6;
            }
            finally {
                IndexingStamp.flushCache(fileId);
            }
        };
        if (function == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(41);
        }
        return function;
    }

    @Nullable
    private static FileContent getFileContent(@NotNull VirtualFile file2, @Nullable Project project2, boolean withBinary) {
        if (file2 == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(42);
        }
        if (withBinary && file2.getFileType().isBinary()) {
            try {
                return FileContentImpl.createByFile(file2, project2);
            }
            catch (IOException e) {
                return null;
            }
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
        CharSequence s = document != null ? document.getCharsSequence() : LoadTextUtil.loadText(file2, -1);
        return FileContentImpl.createByText(file2, s, project2);
    }

    public static boolean isManuallyManaged(@NotNull ID<?, ?> id2) {
        if (id2 == null) {
            FileBasedIndexScanUtil.$$$reportNull$$$0(43);
        }
        return id2 == TodoIndex.NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 41: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 2: 
            case 23: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 18: 
            case 24: 
            case 28: 
            case 31: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: 
            case 10: 
            case 15: 
            case 19: 
            case 25: 
            case 29: 
            case 32: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKey";
                break;
            }
            case 20: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataKeys";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queries";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/FileBasedIndexScanUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/FileBasedIndexScanUtil";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ensureUpToDate";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIndexData";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFiles";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processAllKeys";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doProcessAllKeys";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processValuesInScope";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doProcessValuesInScope";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findIndexExtension";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processValuesInOneFile";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAllKeys";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAnyKey";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processFilesInScope";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getIndexer";
                break;
            }
            case 41: {
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getFileContent";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isManuallyManaged";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 41: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InThisThreadProcessor {
        final Thread thread = Thread.currentThread();
        final ConcurrentLinkedQueue<BooleanSupplier> queue = new ConcurrentLinkedQueue();

        private InThisThreadProcessor() {
        }

        boolean process(@NotNull BooleanSupplier r) {
            if (r == null) {
                InThisThreadProcessor.$$$reportNull$$$0(0);
            }
            if (Thread.currentThread() != this.thread) {
                this.queue.add(r);
                return true;
            }
            if (!this.processQueue()) {
                return false;
            }
            return r.getAsBoolean();
        }

        boolean processQueue() {
            BooleanSupplier polled;
            while ((polled = this.queue.poll()) != null) {
                if (polled.getAsBoolean()) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/util/indexing/FileBasedIndexScanUtil$InThisThreadProcessor", "process"));
        }
    }
}

