/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexingFlag;
import com.intellij.util.indexing.SingleIndexValueApplier;
import com.intellij.util.indexing.SingleIndexValueRemover;
import com.intellij.util.indexing.diagnostic.FileIndexingStatistics;
import com.intellij.util.indexing.events.VfsEventsMerger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class FileIndexesValuesApplier {
    private final FileBasedIndexImpl myIndex;
    private final int fileId;
    @NotNull
    private final List<SingleIndexValueApplier<?>> appliers;
    @NotNull
    private final List<SingleIndexValueRemover> removers;
    private final boolean removeDataFromIndicesForFile;
    private boolean shouldMarkFileAsIndexed;
    private final long fileStatusLockObject;
    @NotNull
    public final FileIndexingStatistics stats;
    public final boolean isWriteValuesSeparately;
    private long separateApplicationTimeNanos;

    FileIndexesValuesApplier(FileBasedIndexImpl index, int fileId, @NotNull VirtualFile file2, @NotNull List<SingleIndexValueApplier<?>> appliers, @NotNull List<SingleIndexValueRemover> removers, boolean removeDataFromIndicesForFile, boolean shouldMarkFileAsIndexed, boolean writeValuesSeparately, @NotNull FileType fileType, boolean logEmptyProvidedIndexes) {
        if (file2 == null) {
            FileIndexesValuesApplier.$$$reportNull$$$0(0);
        }
        if (appliers == null) {
            FileIndexesValuesApplier.$$$reportNull$$$0(1);
        }
        if (removers == null) {
            FileIndexesValuesApplier.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            FileIndexesValuesApplier.$$$reportNull$$$0(3);
        }
        this.separateApplicationTimeNanos = -1L;
        this.myIndex = index;
        this.fileId = fileId;
        this.appliers = appliers;
        this.removers = removers;
        this.removeDataFromIndicesForFile = removeDataFromIndicesForFile;
        this.shouldMarkFileAsIndexed = shouldMarkFileAsIndexed;
        this.fileStatusLockObject = writeValuesSeparately && shouldMarkFileAsIndexed ? IndexingFlag.getOrCreateHash(file2) : IndexingFlag.getNonExistentHash();
        this.isWriteValuesSeparately = writeValuesSeparately;
        this.stats = this.createStats(file2, appliers, removers, fileType, logEmptyProvidedIndexes);
    }

    private FileIndexingStatistics createStats(@NotNull VirtualFile file2, @NotNull List<SingleIndexValueApplier<?>> appliers, @NotNull List<SingleIndexValueRemover> removers, @NotNull FileType fileType, boolean logEmptyProvidedIndexes) {
        if (file2 == null) {
            FileIndexesValuesApplier.$$$reportNull$$$0(4);
        }
        if (appliers == null) {
            FileIndexesValuesApplier.$$$reportNull$$$0(5);
        }
        if (removers == null) {
            FileIndexesValuesApplier.$$$reportNull$$$0(6);
        }
        if (fileType == null) {
            FileIndexesValuesApplier.$$$reportNull$$$0(7);
        }
        HashSet indexesProvidedByExtensions = new HashSet();
        boolean wasFullyIndexedByInfrastructureExtension = true;
        HashMap perIndexerUpdateTimes = new HashMap();
        for (SingleIndexValueApplier<?> applier : appliers) {
            perIndexerUpdateTimes.put(applier.indexId, applier.mapInputTime);
            if (applier.wasIndexProvidedByExtension()) {
                indexesProvidedByExtensions.add(applier.indexId);
                continue;
            }
            if (this.myIndex.doTraceSharedIndexUpdates()) {
                FileBasedIndexImpl.LOG.info("shared index " + applier.indexId + " is not provided for file " + file2.getName());
            }
            wasFullyIndexedByInfrastructureExtension = false;
        }
        HashMap perIndexerDeletionTimes = new HashMap();
        for (SingleIndexValueRemover remover : removers) {
            perIndexerDeletionTimes.put(remover.indexId, remover.mapInputTime);
        }
        if (logEmptyProvidedIndexes && indexesProvidedByExtensions.isEmpty()) {
            FileBasedIndexImpl.LOG.info("no shared indexes were provided for file " + file2.getName());
        }
        return new FileIndexingStatistics(fileType, indexesProvidedByExtensions, !indexesProvidedByExtensions.isEmpty() && wasFullyIndexedByInfrastructureExtension, perIndexerUpdateTimes, perIndexerDeletionTimes);
    }

    void applyImmediately(@NotNull VirtualFile file2, boolean isValid) {
        if (file2 == null) {
            FileIndexesValuesApplier.$$$reportNull$$$0(8);
        }
        if (this.isWriteValuesSeparately) {
            return;
        }
        if (this.removeDataFromIndicesForFile) {
            this.myIndex.removeDataFromIndicesForFile(this.fileId, file2, "invalid_or_large_file");
        }
        if (this.shouldMarkFileAsIndexed) {
            IndexingFlag.setFileIndexed(file2);
        }
        VfsEventsMerger.tryLog((String)"INDEX_UPDATED", (VirtualFile)file2, () -> " updated_indexes=" + this.stats.getPerIndexerUpdateTimes().keySet() + " deleted_indexes=" + this.stats.getPerIndexerDeleteTimes().keySet() + " valid=" + isValid);
        this.myIndex.getChangedFilesCollector().removeFileIdFromFilesScheduledForUpdate(this.fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileIndexesValuesApplier.$$$reportNull$$$0(9);
        }
        if (!this.isWriteValuesSeparately) {
            return;
        }
        long applicationStart = System.nanoTime();
        try {
            if (this.removeDataFromIndicesForFile) {
                this.myIndex.removeDataFromIndicesForFile(this.fileId, file2, "invalid_or_large_file");
            }
            if (!this.appliers.isEmpty() || !this.removers.isEmpty()) {
                for (SingleIndexValueApplier<?> applier : this.appliers) {
                    boolean applied = applier.apply();
                    if (applied) continue;
                    this.shouldMarkFileAsIndexed = false;
                }
                for (SingleIndexValueRemover remover : this.removers) {
                    boolean removed = remover.remove();
                    if (removed) continue;
                    this.shouldMarkFileAsIndexed = false;
                }
            }
            if (this.shouldMarkFileAsIndexed) {
                IndexingFlag.setIndexedIfFileWithSameLock(file2, this.fileStatusLockObject);
            } else if (this.fileStatusLockObject != IndexingFlag.getNonExistentHash()) {
                IndexingFlag.unlockFile(file2);
            }
            VfsEventsMerger.tryLog((String)"INDEX_UPDATED", (VirtualFile)file2, () -> " updated_indexes=" + this.stats.getPerIndexerUpdateTimes().keySet() + " deleted_indexes=" + this.stats.getPerIndexerDeleteTimes().keySet());
            this.myIndex.getChangedFilesCollector().removeFileIdFromFilesScheduledForUpdate(this.fileId);
        }
        finally {
            this.separateApplicationTimeNanos = System.nanoTime() - applicationStart;
        }
    }

    public long getSeparateApplicationTimeNanos() {
        if (!this.isWriteValuesSeparately) {
            return 0L;
        }
        if (this.separateApplicationTimeNanos == -1L) {
            throw new IllegalStateException("Index values were not applied");
        }
        return this.separateApplicationTimeNanos;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliers";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removers";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/FileIndexesValuesApplier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createStats";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "applyImmediately";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

