/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IdFilter;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindSymbolParameters {
    private final String myCompletePattern;
    private final String myLocalPatternName;
    private final GlobalSearchScope mySearchScope;
    private final IdFilter myIdFilter;

    @Deprecated
    public FindSymbolParameters(@NotNull String pattern, @NotNull String name2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (pattern == null) {
            FindSymbolParameters.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            FindSymbolParameters.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            FindSymbolParameters.$$$reportNull$$$0(2);
        }
        this.myCompletePattern = pattern;
        this.myLocalPatternName = name2;
        this.mySearchScope = scope;
        this.myIdFilter = idFilter;
    }

    public FindSymbolParameters(@NotNull String pattern, @NotNull String name2, @NotNull GlobalSearchScope scope) {
        if (pattern == null) {
            FindSymbolParameters.$$$reportNull$$$0(3);
        }
        if (name2 == null) {
            FindSymbolParameters.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            FindSymbolParameters.$$$reportNull$$$0(5);
        }
        this(pattern, name2, scope, null);
    }

    public FindSymbolParameters withCompletePattern(@NotNull String pattern) {
        if (pattern == null) {
            FindSymbolParameters.$$$reportNull$$$0(6);
        }
        return new FindSymbolParameters(pattern, this.myLocalPatternName, this.mySearchScope, this.myIdFilter);
    }

    public FindSymbolParameters withLocalPattern(@NotNull String pattern) {
        if (pattern == null) {
            FindSymbolParameters.$$$reportNull$$$0(7);
        }
        return new FindSymbolParameters(this.myCompletePattern, pattern, this.mySearchScope, this.myIdFilter);
    }

    public FindSymbolParameters withScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            FindSymbolParameters.$$$reportNull$$$0(8);
        }
        return new FindSymbolParameters(this.myCompletePattern, this.myLocalPatternName, scope, this.myIdFilter);
    }

    @NotNull
    public String getCompletePattern() {
        String string2 = this.myCompletePattern;
        if (string2 == null) {
            FindSymbolParameters.$$$reportNull$$$0(9);
        }
        return string2;
    }

    @NotNull
    public String getLocalPatternName() {
        String string2 = this.myLocalPatternName;
        if (string2 == null) {
            FindSymbolParameters.$$$reportNull$$$0(10);
        }
        return string2;
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope globalSearchScope = this.mySearchScope;
        if (globalSearchScope == null) {
            FindSymbolParameters.$$$reportNull$$$0(11);
        }
        return globalSearchScope;
    }

    @Nullable
    public IdFilter getIdFilter() {
        return this.myIdFilter;
    }

    @NotNull
    public Project getProject() {
        Project project2 = Objects.requireNonNull(this.mySearchScope.getProject());
        if (project2 == null) {
            FindSymbolParameters.$$$reportNull$$$0(12);
        }
        return project2;
    }

    public boolean isSearchInLibraries() {
        return this.mySearchScope.isSearchInLibraries();
    }

    public static FindSymbolParameters wrap(@NotNull String pattern, @NotNull Project project2, boolean searchInLibraries) {
        if (pattern == null) {
            FindSymbolParameters.$$$reportNull$$$0(13);
        }
        if (project2 == null) {
            FindSymbolParameters.$$$reportNull$$$0(14);
        }
        return new FindSymbolParameters(pattern, pattern, FindSymbolParameters.searchScopeFor(project2, searchInLibraries), ((FileBasedIndexImpl)FileBasedIndex.getInstance()).projectIndexableFiles(project2));
    }

    public static FindSymbolParameters wrap(@NotNull String pattern, @NotNull GlobalSearchScope scope) {
        if (pattern == null) {
            FindSymbolParameters.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            FindSymbolParameters.$$$reportNull$$$0(16);
        }
        return new FindSymbolParameters(pattern, pattern, scope, null);
    }

    public static FindSymbolParameters simple(@NotNull Project project2, boolean searchInLibraries) {
        if (project2 == null) {
            FindSymbolParameters.$$$reportNull$$$0(17);
        }
        return new FindSymbolParameters("", "", FindSymbolParameters.searchScopeFor(project2, searchInLibraries), ((FileBasedIndexImpl)FileBasedIndex.getInstance()).projectIndexableFiles(project2));
    }

    @NotNull
    public static GlobalSearchScope searchScopeFor(@NotNull Project project2, boolean searchInLibraries) {
        if (project2 == null) {
            FindSymbolParameters.$$$reportNull$$$0(18);
        }
        GlobalSearchScope globalSearchScope = searchInLibraries ? ProjectScope.getAllScope(project2) : ProjectScope.getProjectScope(project2);
        if (globalSearchScope == null) {
            FindSymbolParameters.$$$reportNull$$$0(19);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/FindSymbolParameters";
                break;
            }
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/FindSymbolParameters";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletePattern";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalPatternName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchScope";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "searchScopeFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withCompletePattern";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "withLocalPattern";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "withScope";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 19: {
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "simple";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "searchScopeFor";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

