/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.util.indexing.StripedIndexingStampLock;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000f\u001a\u00020\u000bH\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0007J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0006H\u0007J\b\u0010\u0016\u001a\u00020\u000bH\u0007J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/indexing/IndexingFlag;", "", "()V", "hashes", "Lcom/intellij/util/indexing/StripedIndexingStampLock;", "nonExistentHash", "", "getNonExistentHash$annotations", "getNonExistentHash", "()J", "cleanProcessedFlagRecursively", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "cleanProcessingFlag", "cleanupProcessedFlag", "dumpLockedFiles", "", "getOrCreateHash", "setFileIndexed", "setIndexedIfFileWithSameLock", "lockObject", "unlockAllFiles", "unlockFile", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class IndexingFlag {
    private static final StripedIndexingStampLock hashes;
    private static final long nonExistentHash;
    @NotNull
    public static final IndexingFlag INSTANCE;

    @JvmStatic
    public static /* synthetic */ void getNonExistentHash$annotations() {
    }

    public static final long getNonExistentHash() {
        return nonExistentHash;
    }

    @JvmStatic
    public static final void cleanupProcessedFlag() {
        VirtualFileSystemEntry.markAllFilesAsUnindexed();
    }

    @JvmStatic
    public static final void cleanProcessedFlagRecursively(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!(file2 instanceof VirtualFileSystemEntry)) {
            return;
        }
        IndexingFlag.cleanProcessingFlag(file2);
        if (file2.isDirectory()) {
            Iterator iterator = ((VirtualFileSystemEntry)file2).getCachedChildren().iterator();
            while (iterator.hasNext()) {
                VirtualFile child;
                VirtualFile virtualFile2 = child = (VirtualFile)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"child");
                IndexingFlag.cleanProcessedFlagRecursively(virtualFile2);
            }
        }
    }

    @JvmStatic
    public static final void cleanProcessingFlag(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (file2 instanceof VirtualFileSystemEntry) {
            hashes.releaseHash(((VirtualFileSystemEntry)file2).getId());
            ((VirtualFileSystemEntry)file2).setFileIndexed(false);
        }
    }

    @JvmStatic
    public static final void setFileIndexed(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (file2 instanceof VirtualFileSystemEntry) {
            ((VirtualFileSystemEntry)file2).setFileIndexed(true);
        }
    }

    @JvmStatic
    public static final long getOrCreateHash(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (file2 instanceof VirtualFileSystemEntry) {
            return hashes.getHash(((VirtualFileSystemEntry)file2).getId());
        }
        return nonExistentHash;
    }

    @JvmStatic
    public static final void unlockFile(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (file2 instanceof VirtualFileWithId) {
            hashes.releaseHash(((VirtualFileWithId)((Object)file2)).getId());
        }
    }

    @JvmStatic
    public static final void setIndexedIfFileWithSameLock(@NotNull VirtualFile file2, long lockObject) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (file2 instanceof VirtualFileSystemEntry) {
            long hash = hashes.releaseHash(((VirtualFileSystemEntry)file2).getId());
            if (!((VirtualFileSystemEntry)file2).isFileIndexed()) {
                ((VirtualFileSystemEntry)file2).setFileIndexed(hash == lockObject);
            }
        }
    }

    @JvmStatic
    public static final void unlockAllFiles() {
        hashes.clear();
    }

    @JvmStatic
    @TestOnly
    @NotNull
    public static final int[] dumpLockedFiles() {
        int[] nArray = hashes.dumpIds();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"hashes.dumpIds()");
        return nArray;
    }

    private IndexingFlag() {
    }

    static {
        IndexingFlag indexingFlag;
        INSTANCE = indexingFlag = new IndexingFlag();
        hashes = new StripedIndexingStampLock();
    }
}

