/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.actions.SynchronizeCurrentFileAction;
import com.intellij.ide.actions.cache.AsyncRecoveryResult;
import com.intellij.ide.actions.cache.CacheInconsistencyProblem;
import com.intellij.ide.actions.cache.FilesRecoveryScope;
import com.intellij.ide.actions.cache.RecoveryAction;
import com.intellij.ide.actions.cache.RecoveryScope;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR%\u0010\u000b\u001a\u00130\u0004\u00a2\u0006\u000e\b\f\u0012\n\b\r\u0012\u0006\b\n0\u000e8\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/indexing/RefreshIndexableFilesAction;", "Lcom/intellij/ide/actions/cache/RecoveryAction;", "()V", "actionKey", "", "getActionKey", "()Ljava/lang/String;", "performanceRate", "", "getPerformanceRate", "()I", "presentableName", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "getPresentableName", "performSync", "", "Lcom/intellij/ide/actions/cache/CacheInconsistencyProblem;", "recoveryScope", "Lcom/intellij/ide/actions/cache/RecoveryScope;", "Event", "EventLog", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class RefreshIndexableFilesAction
implements RecoveryAction {
    public int getPerformanceRate() {
        return 9999;
    }

    @NotNull
    public String getPresentableName() {
        String string2 = LangBundle.message("refresh.indexable.files.recovery.action.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"LangBundle.message(\"refr\u2026es.recovery.action.name\")");
        return string2;
    }

    @NotNull
    public String getActionKey() {
        return "refresh";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public List<CacheInconsistencyProblem> performSync(@NotNull RecoveryScope recoveryScope) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Disposable actionDisposable;
        VirtualFile[] virtualFileArray;
        Intrinsics.checkNotNullParameter((Object)recoveryScope, (String)"recoveryScope");
        Project project2 = recoveryScope.getProject();
        if (recoveryScope instanceof FilesRecoveryScope) {
            Collection $this$toTypedArray$iv = ((FilesRecoveryScope)recoveryScope).getFiles();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            VirtualFile[] virtualFileArray2 = thisCollection$iv.toArray(new VirtualFile[0]);
            if (virtualFileArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            virtualFileArray = virtualFileArray2;
        } else {
            ManagingFS managingFS = ManagingFS.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)managingFS, (String)"ManagingFS.getInstance()");
            virtualFileArray = managingFS.getLocalRoots();
        }
        VirtualFile[] rootsToRefresh = virtualFileArray;
        RefreshQueue.getInstance().refresh(false, true, null, Arrays.copyOf(rootsToRefresh, rootsToRefresh.length));
        EventLog eventLog = new EventLog();
        Object $this$use$iv = Disposer.newDisposable();
        boolean $i$f$use = false;
        try {
            actionDisposable = $this$use$iv;
            boolean bl = false;
            MessageBusConnection messageBusConnection = project2.getMessageBus().connect(actionDisposable);
            Topic<BulkFileListener> topic = VirtualFileManager.VFS_CHANGES;
            Intrinsics.checkNotNullExpressionValue(topic, (String)"VirtualFileManager.VFS_CHANGES");
            messageBusConnection.subscribe(topic, eventLog);
            Collection files2 = null;
            if (recoveryScope instanceof FilesRecoveryScope) {
                files2 = ((FilesRecoveryScope)recoveryScope).getFiles();
            } else {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$flatMapTo$iv$iv;
                FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
                if (fileBasedIndex == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
                }
                FileBasedIndexImpl fileBasedIndex2 = (FileBasedIndexImpl)fileBasedIndex;
                List list2 = fileBasedIndex2.getIndexableFilesProviders(project2);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"fileBasedIndex.getIndexableFilesProviders(project)");
                Iterable $this$flatMap$iv = list2;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    IndexableFilesIterator it = (IndexableFilesIterator)element$iv$iv;
                    boolean bl2 = false;
                    Iterable list$iv$iv = it.getRootUrls(project2);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List rootUrls = (List)destination$iv$iv;
                Iterable $this$mapNotNull$iv = rootUrls;
                boolean $i$f$mapNotNull = false;
                $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    VirtualFile virtualFile2;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl3 = false;
                    String it = (String)element$iv$iv;
                    boolean bl4 = false;
                    if (VirtualFileManager.getInstance().refreshAndFindFileByUrl(it) == null) continue;
                    VirtualFile it$iv$iv = virtualFile2;
                    boolean bl5 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                files2 = (List)destination$iv$iv;
            }
            SynchronizeCurrentFileAction.synchronizeFiles(files2, project2, false);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if ($this$use$iv != null) {
                Disposer.dispose((Disposable)$this$use$iv);
            }
        }
        $this$use$iv = eventLog.getLoggedEvents();
        boolean $i$f$filter = false;
        actionDisposable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Event event = (Event)element$iv$iv;
            boolean bl = false;
            boolean $i$f$runReadAction = false;
            if (!((Boolean)ApplicationManager.getApplication().runReadAction(new Computable(event, rootsToRefresh){
                final /* synthetic */ Event $event$inlined;
                final /* synthetic */ VirtualFile[] $rootsToRefresh$inlined;
                {
                    this.$event$inlined = event;
                    this.$rootsToRefresh$inlined = virtualFileArray;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public final T compute() {
                    boolean bl;
                    boolean bl2 = false;
                    if (this.$event$inlined.getFile().isValid()) {
                        boolean bl3;
                        block3: {
                            Intrinsics.checkNotNullExpressionValue((Object)this.$rootsToRefresh$inlined, (String)"rootsToRefresh");
                            VirtualFile[] $this$any$iv = this.$rootsToRefresh$inlined;
                            boolean $i$f$any = false;
                            int n = $this$any$iv.length;
                            for (int i = 0; i < n; ++i) {
                                VirtualFile element$iv;
                                VirtualFile it = element$iv = $this$any$iv[i];
                                boolean bl4 = false;
                                VirtualFile virtualFile2 = it;
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"it");
                                if (!(virtualFile2.isValid() && VfsUtilCore.isAncestor(it, this.$event$inlined.getFile(), false))) continue;
                                bl3 = true;
                                break block3;
                            }
                            bl3 = false;
                        }
                        if (bl3) {
                            bl = true;
                            return (T)Boolean.valueOf(bl);
                        }
                    }
                    bl = false;
                    return (T)Boolean.valueOf(bl);
                }
            })).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Event event = (Event)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CacheInconsistencyProblem cacheInconsistencyProblem = it.toCacheInconsistencyProblem();
            collection.add(cacheInconsistencyProblem);
        }
        return (List)destination$iv$iv;
    }

    public boolean canBeApplied(@NotNull RecoveryScope recoveryScope) {
        Intrinsics.checkNotNullParameter((Object)recoveryScope, (String)"recoveryScope");
        return RecoveryAction.DefaultImpls.canBeApplied((RecoveryAction)this, (RecoveryScope)recoveryScope);
    }

    @NotNull
    public CompletableFuture<AsyncRecoveryResult> perform(@NotNull RecoveryScope recoveryScope) {
        Intrinsics.checkNotNullParameter((Object)recoveryScope, (String)"recoveryScope");
        return RecoveryAction.DefaultImpls.perform((RecoveryAction)this, (RecoveryScope)recoveryScope);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0016\u0010\r\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\fH\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/util/indexing/RefreshIndexableFilesAction$EventLog;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "()V", "loggedEvents", "", "Lcom/intellij/util/indexing/RefreshIndexableFilesAction$Event;", "getLoggedEvents", "()Ljava/util/List;", "after", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "before", "logEvent", "event", "intellij.platform.lang.impl"})
    private static final class EventLog
    implements BulkFileListener {
        @NotNull
        private final List<Event> loggedEvents = new ArrayList();

        @NotNull
        public final List<Event> getLoggedEvents() {
            return this.loggedEvents;
        }

        @Override
        public void before(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            for (VFileEvent vFileEvent : events) {
                if (vFileEvent instanceof VFileCreateEvent) continue;
                this.logEvent(vFileEvent);
            }
        }

        @Override
        public void after(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            for (VFileEvent vFileEvent : events) {
                if (!(vFileEvent instanceof VFileCreateEvent)) continue;
                this.logEvent(vFileEvent);
            }
        }

        private final void logEvent(VFileEvent event) {
            block0: {
                VirtualFile virtualFile2;
                VirtualFile virtualFile3 = event.getFile();
                if (virtualFile3 == null) break block0;
                VirtualFile it = virtualFile2 = virtualFile3;
                boolean bl = false;
                VirtualFile virtualFile4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"it");
                this.loggedEvents.add(new Event(virtualFile4));
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/intellij/util/indexing/RefreshIndexableFilesAction$Event;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component1", "copy", "equals", "", "other", "hashCode", "", "toCacheInconsistencyProblem", "Lcom/intellij/ide/actions/cache/CacheInconsistencyProblem;", "toString", "", "intellij.platform.lang.impl"})
    private static final class Event {
        @NotNull
        private final VirtualFile file;

        @NotNull
        public final CacheInconsistencyProblem toCacheInconsistencyProblem() {
            return new CacheInconsistencyProblem(this){
                final /* synthetic */ Event this$0;

                @NotNull
                public String getMessage() {
                    return "vfs event on " + this.this$0.getFile().getUrl();
                }
                {
                    this.this$0 = this$0;
                }
            };
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        public Event(@NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            this.file = file2;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.file;
        }

        @NotNull
        public final Event copy(@NotNull VirtualFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            return new Event(file2);
        }

        public static /* synthetic */ Event copy$default(Event event, VirtualFile virtualFile2, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile2 = event.file;
            }
            return event.copy(virtualFile2);
        }

        @NotNull
        public String toString() {
            return "Event(file=" + this.file + ")";
        }

        public int hashCode() {
            VirtualFile virtualFile2 = this.file;
            return virtualFile2 != null ? virtualFile2.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Event)) break block3;
                    Event event = (Event)object;
                    if (!Intrinsics.areEqual((Object)this.file, (Object)event.file)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

