/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.actions.cache.AsyncRecoveryResult;
import com.intellij.ide.actions.cache.CacheInconsistencyProblem;
import com.intellij.ide.actions.cache.ExceptionalCompletionProblem;
import com.intellij.ide.actions.cache.FilesRecoveryScope;
import com.intellij.ide.actions.cache.RecoveryAction;
import com.intellij.ide.actions.cache.RecoveryScope;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.BooleanFunction;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexingFlag;
import com.intellij.util.indexing.RescanIndexesAction;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryImpl;
import com.intellij.util.indexing.diagnostic.ScanningType;
import com.intellij.util.indexing.diagnostic.dto.JsonScanningStatistics;
import com.intellij.util.indexing.roots.ProjectIndexableFilesIteratorImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u0017H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR%\u0010\u000b\u001a\u00130\u0004\u00a2\u0006\u000e\b\f\u0012\n\b\r\u0012\u0006\b\n0\u000e8\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lcom/intellij/util/indexing/RescanIndexesAction;", "Lcom/intellij/ide/actions/cache/RecoveryAction;", "()V", "actionKey", "", "getActionKey", "()Ljava/lang/String;", "performanceRate", "", "getPerformanceRate", "()I", "presentableName", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "getPresentableName", "performSync", "", "Lcom/intellij/ide/actions/cache/CacheInconsistencyProblem;", "recoveryScope", "Lcom/intellij/ide/actions/cache/RecoveryScope;", "extractConsistencyProblems", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl;", "UnindexedFilesInconsistencyProblem", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class RescanIndexesAction
implements RecoveryAction {
    public int getPerformanceRate() {
        return 9990;
    }

    @NotNull
    public String getPresentableName() {
        String string2 = LangBundle.message("rescan.indexes.recovery.action.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"LangBundle.message(\"resc\u2026es.recovery.action.name\")");
        return string2;
    }

    @NotNull
    public String getActionKey() {
        return "rescan";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<CacheInconsistencyProblem> performSync(@NotNull RecoveryScope recoveryScope) {
        void predefinedIndexableFilesIterators;
        Intrinsics.checkNotNullParameter((Object)recoveryScope, (String)"recoveryScope");
        Project project2 = recoveryScope.getProject();
        CompletableFuture historyFuture = new CompletableFuture();
        List stubAndIndexingStampInconsistencies = Collections.synchronizedList(new ArrayList());
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        if (recoveryScope instanceof FilesRecoveryScope) {
            Collection<ProjectIndexableFilesIteratorImpl> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ((FilesRecoveryScope)recoveryScope).getFiles();
            void var15_8 = predefinedIndexableFilesIterators;
            boolean $i$f$map = false;
            void var8_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                ProjectIndexableFilesIteratorImpl projectIndexableFilesIteratorImpl = new ProjectIndexableFilesIteratorImpl((VirtualFile)it);
                collection.add(projectIndexableFilesIteratorImpl);
            }
            collection = (List)destination$iv$iv;
            var15_8.element = collection;
        }
        new UnindexedFilesUpdater(stubAndIndexingStampInconsistencies, historyFuture, project2, (Ref.ObjectRef)predefinedIndexableFilesIterators, project2, false, false, (List)predefinedIndexableFilesIterators.element, "Rescanning indexes recovery action", (List)predefinedIndexableFilesIterators.element == null ? ScanningType.FULL_FORCED : ScanningType.PARTIAL_FORCED){
            private final UpdatableIndex<Integer, SerializedStubTree, FileContent, ?> stubIndex;
            final /* synthetic */ List $stubAndIndexingStampInconsistencies;
            final /* synthetic */ CompletableFuture $historyFuture;
            final /* synthetic */ Project $project;
            final /* synthetic */ Ref.ObjectRef $predefinedIndexableFilesIterators;

            @Nullable
            protected BooleanFunction<IndexedFile> getForceReindexingTrigger() {
                if (this.stubIndex != null) {
                    return new BooleanFunction(this){
                        final /* synthetic */ performSync.2 this$0;

                        public final boolean fun(IndexedFile it) {
                            IndexedFile indexedFile = it;
                            Intrinsics.checkNotNullExpressionValue((Object)indexedFile, (String)"it");
                            VirtualFile virtualFile2 = indexedFile.getFile();
                            if (virtualFile2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.vfs.VirtualFileWithId");
                            }
                            int fileId = ((VirtualFileWithId)((Object)virtualFile2)).getId();
                            if (performSync.2.access$getStubIndex$p(this.this$0).getIndexingStateForFile(fileId, it) == FileIndexingState.UP_TO_DATE && performSync.2.access$getStubIndex$p(this.this$0).getIndexedFileData(fileId).isEmpty()) {
                                VirtualFile virtualFile3 = it.getFile();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"it.file");
                                if (performSync.2.access$isAbleToBuildStub(this.this$0, virtualFile3)) {
                                    List list2 = this.this$0.$stubAndIndexingStampInconsistencies;
                                    VirtualFile virtualFile4 = it.getFile();
                                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"it.file");
                                    String string2 = virtualFile4.getPath();
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.file.path");
                                    list2.add(new performSync.StubAndIndexStampInconsistency(this.this$0, string2));
                                    return true;
                                }
                            }
                            return false;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    };
                }
                return null;
            }

            private final boolean isAbleToBuildStub(VirtualFile file2) {
                Object object;
                Object object2 = this;
                try {
                    performSync.2 $this$runCatching = object2;
                    boolean bl = false;
                    object = Result.constructor-impl((Object)StubTreeBuilder.buildStubTree(FileContentImpl.createByFile(file2)));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                object2 = object;
                return (Result.isFailure-impl((Object)object2) ? null : object2) != null;
            }

            @NotNull
            protected ProjectIndexingHistoryImpl performScanningAndIndexing(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    IndexingFlag.cleanupProcessedFlag();
                    ProjectIndexingHistoryImpl projectIndexingHistoryImpl = super.performScanningAndIndexing(indicator);
                    Intrinsics.checkNotNullExpressionValue((Object)projectIndexingHistoryImpl, (String)"super.performScanningAndIndexing(indicator)");
                    ProjectIndexingHistoryImpl history = projectIndexingHistoryImpl;
                    this.$historyFuture.complete(history);
                    return history;
                }
                catch (Exception e) {
                    this.$historyFuture.completeExceptionally(e);
                    throw (Throwable)e;
                }
            }

            @Nullable
            public DumbModeTask tryMergeWith(@NotNull DumbModeTask taskFromQueue) {
                Intrinsics.checkNotNullParameter((Object)taskFromQueue, (String)"taskFromQueue");
                return taskFromQueue instanceof UnindexedFilesUpdater && Intrinsics.areEqual((Object)this.$project, (Object)((UnindexedFilesUpdater)taskFromQueue).myProject) && Intrinsics.areEqual(((UnindexedFilesUpdater)taskFromQueue).getClass(), this.getClass()) ? (DumbModeTask)this : null;
            }
            {
                Object object;
                this.$stubAndIndexingStampInconsistencies = $captured_local_variable$0;
                this.$historyFuture = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                this.$predefinedIndexableFilesIterators = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6, $super_call_param$7, $super_call_param$8, $super_call_param$9);
                Object object2 = this;
                performSync.2 var17_12 = this;
                try {
                    performSync.2 $this$runCatching = object2;
                    boolean bl = false;
                    FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
                    if (fileBasedIndex == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
                    }
                    object = Result.constructor-impl(((FileBasedIndexImpl)fileBasedIndex).getIndex(StubUpdatingIndex.INDEX_ID));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Object object3 = object;
                performSync.2 v1 = var17_12;
                object2 = object3;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable != null) {
                    void it;
                    Object object4;
                    Object object5 = object4 = (object = throwable);
                    var17_12 = v1;
                    boolean bl = false;
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(RescanIndexesAction.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.error((Throwable)it);
                    object3 = Unit.INSTANCE;
                    v1 = var17_12;
                }
                v1.stubIndex = (UpdatableIndex)(Result.isFailure-impl((Object)object2) ? null : object2);
            }

            public static final /* synthetic */ boolean access$isAbleToBuildStub(performSync.2 $this, VirtualFile file2) {
                return $this.isAbleToBuildStub(file2);
            }

            public static final /* synthetic */ UpdatableIndex access$getStubIndex$p(performSync.2 $this) {
                return $this.stubIndex;
            }
        }.queue(project2);
        try {
            Object object = ProgressIndicatorUtils.awaitWithCheckCanceled((Future)historyFuture);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ProgressIndicatorUtils.a\u2026ckCanceled(historyFuture)");
            Collection collection = this.extractConsistencyProblems((ProjectIndexingHistoryImpl)object);
            List list2 = stubAndIndexingStampInconsistencies;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"stubAndIndexingStampInconsistencies");
            return CollectionsKt.plus((Collection)collection, (Iterable)list2);
        }
        catch (Exception e) {
            return CollectionsKt.listOf((Object)new ExceptionalCompletionProblem((Throwable)e));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<CacheInconsistencyProblem> extractConsistencyProblems(ProjectIndexingHistoryImpl $this$extractConsistencyProblems) {
        void $this$mapTo$iv$iv;
        JsonScanningStatistics it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$extractConsistencyProblems.getScanningStatistics();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (JsonScanningStatistics)element$iv$iv;
            boolean bl = false;
            if (!(it.getNumberOfFilesForIndexing() != 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (JsonScanningStatistics)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            UnindexedFilesInconsistencyProblem unindexedFilesInconsistencyProblem = new UnindexedFilesInconsistencyProblem(it.getNumberOfFilesForIndexing(), it.getProviderName());
            collection.add(unindexedFilesInconsistencyProblem);
        }
        return (List)destination$iv$iv;
    }

    public boolean canBeApplied(@NotNull RecoveryScope recoveryScope) {
        Intrinsics.checkNotNullParameter((Object)recoveryScope, (String)"recoveryScope");
        return RecoveryAction.DefaultImpls.canBeApplied((RecoveryAction)this, (RecoveryScope)recoveryScope);
    }

    @NotNull
    public CompletableFuture<AsyncRecoveryResult> perform(@NotNull RecoveryScope recoveryScope) {
        Intrinsics.checkNotNullParameter((Object)recoveryScope, (String)"recoveryScope");
        return RecoveryAction.DefaultImpls.perform((RecoveryAction)this, (RecoveryScope)recoveryScope);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/util/indexing/RescanIndexesAction$UnindexedFilesInconsistencyProblem;", "Lcom/intellij/ide/actions/cache/CacheInconsistencyProblem;", "numberOfFilesForIndexing", "", "providerName", "", "(ILjava/lang/String;)V", "message", "getMessage", "()Ljava/lang/String;", "intellij.platform.lang.impl"})
    private static final class UnindexedFilesInconsistencyProblem
    implements CacheInconsistencyProblem {
        private final int numberOfFilesForIndexing;
        private final String providerName;

        @NotNull
        public String getMessage() {
            return "Provider `" + this.providerName + "` had " + this.numberOfFilesForIndexing + " unindexed files";
        }

        public UnindexedFilesInconsistencyProblem(int numberOfFilesForIndexing, @NotNull String providerName) {
            Intrinsics.checkNotNullParameter((Object)providerName, (String)"providerName");
            this.numberOfFilesForIndexing = numberOfFilesForIndexing;
            this.providerName = providerName;
        }
    }
}

