/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtensionUpdatableIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructureExtensionUpdateComputation;
import com.intellij.util.indexing.UpdatableIndex;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
class SingleIndexValueApplier<FileIndexMetaData> {
    private final FileBasedIndexImpl myIndex;
    @NotNull
    final ID<?, ?> indexId;
    final int inputId;
    @Nullable
    private final FileIndexMetaData myFileIndexMetaData;
    final long mapInputTime;
    @NotNull
    final Supplier<Boolean> storageUpdate;
    @NotNull
    private final String fileInfo;
    @NotNull
    private final String filePath;
    private final boolean isMock;

    SingleIndexValueApplier(@NotNull FileBasedIndexImpl index, @NotNull ID<?, ?> indexId, int inputId, @Nullable FileIndexMetaData fileIndexMetaData, @NotNull Supplier<Boolean> update2, @NotNull VirtualFile file2, @NotNull FileContent currentFC, long mapInputTime) {
        if (index == null) {
            SingleIndexValueApplier.$$$reportNull$$$0(0);
        }
        if (indexId == null) {
            SingleIndexValueApplier.$$$reportNull$$$0(1);
        }
        if (update2 == null) {
            SingleIndexValueApplier.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            SingleIndexValueApplier.$$$reportNull$$$0(3);
        }
        if (currentFC == null) {
            SingleIndexValueApplier.$$$reportNull$$$0(4);
        }
        this.myIndex = index;
        this.indexId = indexId;
        this.inputId = inputId;
        this.myFileIndexMetaData = fileIndexMetaData;
        this.mapInputTime = mapInputTime;
        this.storageUpdate = update2;
        this.fileInfo = FileBasedIndexImpl.getFileInfoLogString(inputId, file2, currentFC);
        this.filePath = file2.getPath();
        this.isMock = FileBasedIndexImpl.isMock(currentFC.getFile());
    }

    boolean wasIndexProvidedByExtension() {
        return this.storageUpdate instanceof IndexInfrastructureExtensionUpdateComputation && ((IndexInfrastructureExtensionUpdateComputation)this.storageUpdate).isIndexProvided();
    }

    boolean applyImmediately() {
        return this.doApply();
    }

    boolean apply() {
        FileBasedIndexImpl.markFileWritingIndexes(this.inputId, this.filePath);
        try {
            boolean bl = this.doApply();
            return bl;
        }
        catch (RuntimeException exception) {
            this.myIndex.requestIndexRebuildOnException(exception, this.indexId);
            boolean bl = false;
            return bl;
        }
        finally {
            FileBasedIndexImpl.unmarkWritingIndexes();
        }
    }

    private boolean doApply() {
        if (this.myIndex.runUpdateForPersistentData(this.storageUpdate)) {
            if (this.myIndex.doTraceStubUpdates(this.indexId) || this.myIndex.doTraceIndexUpdates()) {
                FileBasedIndexImpl.LOG.info("index " + this.indexId + " update finished for " + this.fileInfo);
            }
            if (!this.isMock) {
                ConcurrencyUtil.withLock(this.myIndex.myReadLock, () -> {
                    UpdatableIndex<?, ?, FileContent, ?> index = this.myIndex.getIndex(this.indexId);
                    SingleIndexValueApplier.setIndexedState(index, this.myFileIndexMetaData, this.inputId, this.wasIndexProvidedByExtension());
                });
            }
        }
        return true;
    }

    private static <FileIndexMetaData> void setIndexedState(@NotNull UpdatableIndex<?, ?, FileContent, FileIndexMetaData> index, @Nullable FileIndexMetaData fileData, int inputId, boolean indexWasProvided) {
        if (index == null) {
            SingleIndexValueApplier.$$$reportNull$$$0(5);
        }
        if (index instanceof FileBasedIndexInfrastructureExtensionUpdatableIndex) {
            ((FileBasedIndexInfrastructureExtensionUpdatableIndex)index).setIndexedStateForFileOnFileIndexMetaData(inputId, fileData, indexWasProvided);
        } else {
            index.setIndexedStateForFileOnFileIndexMetaData(inputId, fileData);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "update";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFC";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/SingleIndexValueApplier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setIndexedState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

