/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.util.SmartList;
import it.unimi.dsi.fastutil.ints.Int2LongMap;
import it.unimi.dsi.fastutil.ints.Int2LongOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;

class StripedIndexingStampLock {
    static final long NON_EXISTENT_HASH = 0L;
    private static final int LOCK_SIZE = 16;
    private final ReadWriteLock[] myLocks = new ReadWriteLock[16];
    private final Int2LongMap[] myHashes = new Int2LongMap[16];
    private final AtomicLong myCurrentHash = new AtomicLong(1L);

    StripedIndexingStampLock() {
        for (int i = 0; i < this.myLocks.length; ++i) {
            this.myLocks[i] = new ReentrantReadWriteLock();
            this.myHashes[i] = new Int2LongOpenHashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long releaseHash(int id2) {
        Lock lock = this.getLock(id2).writeLock();
        lock.lock();
        try {
            long l = this.getHashes(id2).remove(id2);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getHash(int id2) {
        Lock lock = this.getLock(id2).writeLock();
        lock.lock();
        try {
            Int2LongMap hashes = this.getHashes(id2);
            long hash = hashes.get(id2);
            if (hash == 0L) {
                hash = this.myCurrentHash.getAndIncrement();
                hashes.put(id2, hash);
            }
            long l = hash;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    private ReadWriteLock getLock(int fileId) {
        return this.myLocks[this.getIndex(fileId)];
    }

    private int getIndex(int fileId) {
        if (fileId < 0) {
            fileId = -fileId;
        }
        return (fileId & 0xFF) % this.myLocks.length;
    }

    private Int2LongMap getHashes(int fileId) {
        return this.myHashes[this.getIndex(fileId)];
    }

    void clear() {
        this.forEachStripe(false, Int2LongMap::clear);
    }

    int[] dumpIds() {
        IntArrayList result2 = new IntArrayList();
        this.forEachStripe(true, map2 -> result2.addAll(map2.keySet()));
        return result2.toIntArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forEachStripe(boolean readLock, Consumer<? super Int2LongMap> consumer) {
        SmartList<Exception> exceptions = new SmartList<Exception>();
        for (int i = 0; i < this.myLocks.length; ++i) {
            Lock lock = null;
            try {
                ReadWriteLock readWriteLock = this.getLock(i);
                lock = readLock ? readWriteLock.readLock() : readWriteLock.writeLock();
                lock.lock();
                consumer.accept(this.getHashes(i));
                continue;
            }
            catch (Exception e) {
                exceptions.add(e);
                continue;
            }
            finally {
                if (lock != null) {
                    try {
                        lock.unlock();
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                    }
                }
            }
        }
        if (!exceptions.isEmpty()) {
            IllegalStateException exception = new IllegalStateException("Exceptions while clearing");
            for (Exception suppressed : exceptions) {
                exception.addSuppressed(suppressed);
            }
            throw exception;
        }
    }
}

