/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.contentQueue;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.contentQueue.CachedFileContent;
import com.intellij.util.indexing.contentQueue.CachedFileContentLoader;
import com.intellij.util.indexing.contentQueue.FailedToLoadContentException;
import com.intellij.util.indexing.contentQueue.TooLargeContentException;
import org.jetbrains.annotations.NotNull;

public class CurrentProjectHintedCachedFileContentLoader
implements CachedFileContentLoader {
    private final Project myProject;

    public CurrentProjectHintedCachedFileContentLoader(Project project2) {
        this.myProject = project2;
    }

    @Override
    @NotNull
    public CachedFileContent loadContent(@NotNull VirtualFile file2) throws FailedToLoadContentException, TooLargeContentException {
        if (file2 == null) {
            CurrentProjectHintedCachedFileContentLoader.$$$reportNull$$$0(0);
        }
        CachedFileContent content2 = new CachedFileContent(file2);
        if (file2.isDirectory() || !file2.isValid() || file2.is(VFileProperty.SPECIAL) || VfsUtilCore.isBrokenLink(file2)) {
            content2.setEmptyContent();
            CachedFileContent cachedFileContent = content2;
            if (cachedFileContent == null) {
                CurrentProjectHintedCachedFileContentLoader.$$$reportNull$$$0(1);
            }
            return cachedFileContent;
        }
        try {
            ProjectLocator.computeWithPreferredProject(file2, this.myProject, () -> content2.getBytes());
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (FileTooBigException e) {
            throw new TooLargeContentException(file2);
        }
        catch (Throwable e) {
            throw new FailedToLoadContentException(file2, e);
        }
        CachedFileContent cachedFileContent = content2;
        if (cachedFileContent == null) {
            CurrentProjectHintedCachedFileContentLoader.$$$reportNull$$$0(2);
        }
        return cachedFileContent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/contentQueue/CurrentProjectHintedCachedFileContentLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/contentQueue/CurrentProjectHintedCachedFileContentLoader";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadContent";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

