/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.fasterxml.jackson.core.JsonParser;
import com.intellij.codeWithMe.ClientId;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.indexing.diagnostic.ChangedFilesPushedDiagnostic;
import com.intellij.util.indexing.diagnostic.ChangedFilesPushedEvent;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumperUtils;
import com.intellij.util.indexing.diagnostic.JsonSharedIndexDiagnosticEvent;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryImpl;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistoryListener;
import com.intellij.util.indexing.diagnostic.SharedIndexDiagnostic;
import com.intellij.util.indexing.diagnostic.dto.JsonIndexDiagnostic;
import com.intellij.util.indexing.diagnostic.dto.JsonIndexDiagnosticAppInfo;
import com.intellij.util.indexing.diagnostic.dto.JsonProjectIndexingFileCount;
import com.intellij.util.indexing.diagnostic.dto.JsonProjectIndexingHistoryTimes;
import com.intellij.util.indexing.diagnostic.dto.JsonRuntimeInfo;
import com.intellij.util.indexing.diagnostic.presentation.JsonToHtmlConverterKt;
import com.intellij.util.io.PathKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 /2\u00020\u0001:\u0002/0B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J3\u0010\u001b\u001a\u0004\u0018\u0001H\u001c\"\u0004\b\u0000\u0010\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001c0 H\u0002\u00a2\u0006\u0002\u0010!J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160%2\u0006\u0010&\u001a\u00020\u0016H\u0002J\u000e\u0010'\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010(\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0007J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010&\u001a\u00020\u0016H\u0002J!\u0010*\u001a\u00020\u00102\u0017\u0010+\u001a\u0013\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020\u00100,\u00a2\u0006\u0002\b.H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000RN\u0010\u0005\u001aB\u0012\u0016\u0012\u0014 \t*\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b0\u0007\u00a2\u0006\u0002\b\b \t*\u001f\u0012\u0016\u0012\u0014 \t*\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b0\u0007\u00a2\u0006\u0002\b\b0\n\u00a2\u0006\u0002\b\b0\u0006\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper;", "Lcom/intellij/openapi/Disposable;", "()V", "isDisposed", "", "unsavedIndexingHistories", "", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryImpl;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm.PlatformType", "", "deleteOutdatedDiagnostics", "", "Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$ExistingDiagnostic;", "existingDiagnostics", "dispose", "", "dumpProjectIndexingHistoryToLogSubdirectory", "projectIndexingHistory", "fastReadAppInfo", "Lcom/intellij/util/indexing/diagnostic/dto/JsonIndexDiagnosticAppInfo;", "jsonFile", "Ljava/nio/file/Path;", "fastReadFileCount", "Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingFileCount;", "fastReadIndexingHistoryTimes", "Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingHistoryTimes;", "fastReadJsonField", "T", "propertyName", "", "type", "Ljava/lang/Class;", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "fastReadRuntimeInfo", "Lcom/intellij/util/indexing/diagnostic/dto/JsonRuntimeInfo;", "getFilesForNewJsonAndHtmlDiagnostics", "Lkotlin/Pair;", "indexDiagnosticDirectory", "onIndexingFinished", "onIndexingStarted", "parseExistingDiagnostics", "runAllListenersSafely", "block", "Lkotlin/Function1;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryListener;", "Lkotlin/ExtensionFunctionType;", "Companion", "ExistingDiagnostic", "intellij.platform.lang.impl"})
public final class IndexDiagnosticDumper
implements Disposable {
    private boolean isDisposed;
    private final Set<ProjectIndexingHistoryImpl> unsavedIndexingHistories;
    private static final String fileNamePrefix = "diagnostic-";
    @NotNull
    private static final ExtensionPointName<ProjectIndexingHistoryListener> projectIndexingHistoryListenerEpName;
    @TestOnly
    private static boolean shouldDumpInUnitTestMode;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public final void onIndexingStarted(@NotNull ProjectIndexingHistoryImpl projectIndexingHistory) {
        Intrinsics.checkNotNullParameter((Object)projectIndexingHistory, (String)"projectIndexingHistory");
        this.runAllListenersSafely((Function1<? super ProjectIndexingHistoryListener, Unit>)((Function1)new Function1<ProjectIndexingHistoryListener, Unit>(projectIndexingHistory){
            final /* synthetic */ ProjectIndexingHistoryImpl $projectIndexingHistory;

            public final void invoke(@NotNull ProjectIndexingHistoryListener $this$runAllListenersSafely) {
                Intrinsics.checkNotNullParameter((Object)$this$runAllListenersSafely, (String)"$receiver");
                $this$runAllListenersSafely.onStartedIndexing(this.$projectIndexingHistory);
            }
            {
                this.$projectIndexingHistory = projectIndexingHistoryImpl;
                super(1);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onIndexingFinished(@NotNull ProjectIndexingHistoryImpl projectIndexingHistory) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)projectIndexingHistory, (String)"projectIndexingHistory");
                try {
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                    if (!application.isUnitTestMode() || shouldDumpInUnitTestMode) break block4;
                    this.runAllListenersSafely((Function1<? super ProjectIndexingHistoryListener, Unit>)((Function1)new Function1<ProjectIndexingHistoryListener, Unit>(projectIndexingHistory){
                        final /* synthetic */ ProjectIndexingHistoryImpl $projectIndexingHistory;

                        public final void invoke(@NotNull ProjectIndexingHistoryListener $this$runAllListenersSafely) {
                            Intrinsics.checkNotNullParameter((Object)$this$runAllListenersSafely, (String)"$this$runAllListenersSafely");
                            $this$runAllListenersSafely.onFinishedIndexing(this.$projectIndexingHistory);
                        }
                        {
                            this.$projectIndexingHistory = projectIndexingHistoryImpl;
                            super(1);
                        }
                    }));
                    return;
                }
                catch (Throwable throwable) {
                    this.runAllListenersSafely((Function1<? super ProjectIndexingHistoryListener, Unit>)((Function1)new /* invalid duplicate definition of identical inner class */));
                    throw throwable;
                }
            }
            if (!projectIndexingHistory.getTimes().getWasInterrupted() || IndexDiagnosticDumper.Companion.getShouldDumpDiagnosticsForInterruptedUpdaters()) break block5;
            this.runAllListenersSafely((Function1<? super ProjectIndexingHistoryListener, Unit>)((Function1)new /* invalid duplicate definition of identical inner class */));
            return;
        }
        projectIndexingHistory.indexingFinished();
        this.unsavedIndexingHistories.add(projectIndexingHistory);
        NonUrgentExecutor.getInstance().execute(new Runnable(this, projectIndexingHistory){
            final /* synthetic */ IndexDiagnosticDumper this$0;
            final /* synthetic */ ProjectIndexingHistoryImpl $projectIndexingHistory;

            public final void run() {
                IndexDiagnosticDumper.access$dumpProjectIndexingHistoryToLogSubdirectory(this.this$0, this.$projectIndexingHistory);
            }
            {
                this.this$0 = indexDiagnosticDumper;
                this.$projectIndexingHistory = projectIndexingHistoryImpl;
            }
        });
        this.runAllListenersSafely((Function1<? super ProjectIndexingHistoryListener, Unit>)((Function1)new /* invalid duplicate definition of identical inner class */));
    }

    private final void runAllListenersSafely(Function1<? super ProjectIndexingHistoryListener, Unit> block) {
        List listeners2 = (List)ProgressManager.getInstance().computeInNonCancelableSection(runAllListenersSafely.listeners.1.INSTANCE);
        for (ProjectIndexingHistoryListener listener2 : listeners2) {
            try {
                block.invoke((Object)listener2);
            }
            catch (Exception e) {
                if (e instanceof ControlFlowException) continue;
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized void dumpProjectIndexingHistoryToLogSubdirectory(ProjectIndexingHistoryImpl projectIndexingHistory) {
        if (!this.unsavedIndexingHistories.remove(projectIndexingHistory)) {
            return;
        }
        try {
            void diagnosticJson;
            boolean bl;
            boolean bl2 = bl = !this.isDisposed;
            if (!bl) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            Path indexDiagnosticDirectory = Companion.getProjectDiagnosticDirectory(projectIndexingHistory.getProject());
            Pair<Path, Path> pair = this.getFilesForNewJsonAndHtmlDiagnostics(indexDiagnosticDirectory);
            Path path2 = (Path)pair.component1();
            Path diagnosticHtml = (Path)pair.component2();
            JsonIndexDiagnostic jsonIndexDiagnostic = JsonIndexDiagnostic.Companion.generateForHistory(projectIndexingHistory);
            IndexDiagnosticDumperUtils.INSTANCE.writeValue((Path)diagnosticJson, jsonIndexDiagnostic);
            PathKt.write$default(diagnosticHtml, JsonToHtmlConverterKt.generateHtml(jsonIndexDiagnostic), null, false, 6, null);
            List<ExistingDiagnostic> existingDiagnostics = this.parseExistingDiagnostics(indexDiagnosticDirectory);
            List<ExistingDiagnostic> survivedDiagnostics = this.deleteOutdatedDiagnostics(existingDiagnostics);
            List<JsonSharedIndexDiagnosticEvent> sharedIndexEvents = SharedIndexDiagnostic.INSTANCE.readEvents(projectIndexingHistory.getProject());
            List<ChangedFilesPushedEvent> changedFilesPushedEvents = ChangedFilesPushedDiagnostic.INSTANCE.readEvents(projectIndexingHistory.getProject());
            Path path3 = indexDiagnosticDirectory.resolve("report.html");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"indexDiagnosticDirectory.resolve(\"report.html\")");
            String string3 = projectIndexingHistory.getProject().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"projectIndexingHistory.project.name");
            PathKt.write$default(path3, JsonToHtmlConverterKt.createAggregateHtml(string3, survivedDiagnostics, sharedIndexEvents, changedFilesPushedEvents), null, false, 6, null);
        }
        catch (Exception e) {
            LOG.warn("Failed to dump index diagnostic", e);
        }
    }

    private final Pair<Path, Path> getFilesForNewJsonAndHtmlDiagnostics(Path indexDiagnosticDirectory) {
        Path diagnosticJson = null;
        Path diagnosticHtml = null;
        LocalDateTime nowTime = LocalDateTime.now();
        while (true) {
            LocalDateTime localDateTime = nowTime;
            Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"nowTime");
            diagnosticJson = IndexDiagnosticDumperUtils.getDumpFilePath$default(IndexDiagnosticDumperUtils.INSTANCE, fileNamePrefix, localDateTime, "json", indexDiagnosticDirectory, null, 16, null);
            diagnosticHtml = IndexDiagnosticDumperUtils.getDumpFilePath$default(IndexDiagnosticDumperUtils.INSTANCE, fileNamePrefix, nowTime, "html", indexDiagnosticDirectory, null, 16, null);
            if (!PathKt.exists(diagnosticJson) && !PathKt.exists(diagnosticHtml)) break;
            nowTime = nowTime.plusNanos(TimeUnit.MILLISECONDS.toNanos(1L));
        }
        return TuplesKt.to((Object)diagnosticJson, (Object)diagnosticHtml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final <T> T fastReadJsonField(Path jsonFile, String propertyName, Class<T> type) {
        try {
            Object object = jsonFile;
            OpenOption[] openOptionArray = new OpenOption[]{};
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            object = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
            object2 = null;
            try {
                BufferedReader reader = (BufferedReader)object;
                boolean bl = false;
                Closeable closeable = (Closeable)IndexDiagnosticDumperUtils.INSTANCE.getJacksonMapper().getFactory().createParser((Reader)reader);
                Throwable throwable = null;
                try {
                    JsonParser parser = (JsonParser)closeable;
                    boolean bl2 = false;
                    while (parser.nextToken() != null) {
                        JsonParser jsonParser = parser;
                        Intrinsics.checkNotNullExpressionValue((Object)jsonParser, (String)"parser");
                        String property = jsonParser.getCurrentName();
                        if (!Intrinsics.areEqual((Object)property, (Object)propertyName)) continue;
                        parser.nextToken();
                        Object object3 = IndexDiagnosticDumperUtils.INSTANCE.getJacksonMapper().readValue(parser, type);
                        Object object4 = object3;
                        return (T)object4;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Unit unit = Unit.INSTANCE;
                return null;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        catch (Exception e) {
            LOG.debug("Failed to parse project indexing time", e);
        }
        return null;
    }

    private final JsonProjectIndexingHistoryTimes fastReadIndexingHistoryTimes(Path jsonFile) {
        return this.fastReadJsonField(jsonFile, "times", JsonProjectIndexingHistoryTimes.class);
    }

    private final JsonProjectIndexingFileCount fastReadFileCount(Path jsonFile) {
        return this.fastReadJsonField(jsonFile, "fileCount", JsonProjectIndexingFileCount.class);
    }

    private final JsonIndexDiagnosticAppInfo fastReadAppInfo(Path jsonFile) {
        return this.fastReadJsonField(jsonFile, "appInfo", JsonIndexDiagnosticAppInfo.class);
    }

    private final JsonRuntimeInfo fastReadRuntimeInfo(Path jsonFile) {
        return this.fastReadJsonField(jsonFile, "runtimeInfo", JsonRuntimeInfo.class);
    }

    private final List<ExistingDiagnostic> deleteOutdatedDiagnostics(List<ExistingDiagnostic> existingDiagnostics) {
        Iterable $this$sortedByDescending$iv = existingDiagnostics;
        boolean $i$f$sortedByDescending = false;
        List sortedDiagnostics = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ExistingDiagnostic it = (ExistingDiagnostic)b;
                boolean bl = false;
                Comparable comparable = it.getIndexingTimes().getUpdatingStart().getInstant();
                it = (ExistingDiagnostic)a;
                Comparable comparable2 = comparable;
                bl = false;
                ZonedDateTime zonedDateTime = it.getIndexingTimes().getUpdatingStart().getInstant();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)zonedDateTime);
            }
        });
        long sizeLimit = (long)IndexDiagnosticDumper.Companion.getIndexingDiagnosticsSizeLimitOfFilesInMBPerProject() * (long)1000000;
        int numberLimit = 0;
        if (IndexDiagnosticDumper.Companion.isIntegrationTest()) {
            numberLimit = existingDiagnostics.size();
        } else if (sizeLimit > 0L) {
            int number = 0;
            for (ExistingDiagnostic diagnostic : existingDiagnostics) {
                sizeLimit -= diagnostic.getJsonFile().toFile().length();
                if ((sizeLimit -= diagnostic.getHtmlFile().toFile().length()) <= 0L) break;
                ++number;
            }
            int diagnostic = IndexDiagnosticDumper.Companion.getIndexingDiagnosticsLimitOfFiles();
            numberLimit = Math.min(diagnostic, number);
        } else {
            numberLimit = IndexDiagnosticDumper.Companion.getIndexingDiagnosticsLimitOfFiles();
        }
        List survivedDiagnostics = CollectionsKt.take((Iterable)sortedDiagnostics, (int)numberLimit);
        List outdatedDiagnostics = CollectionsKt.drop((Iterable)sortedDiagnostics, (int)numberLimit);
        for (ExistingDiagnostic diagnostic : outdatedDiagnostics) {
            PathKt.delete$default(diagnostic.getJsonFile(), false, 1, null);
            PathKt.delete$default(diagnostic.getHtmlFile(), false, 1, null);
        }
        return survivedDiagnostics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<ExistingDiagnostic> parseExistingDiagnostics(Path indexDiagnosticDirectory) {
        List list2;
        AutoCloseable autoCloseable = Files.list(indexDiagnosticDirectory);
        Throwable throwable = null;
        try {
            Stream files2 = (Stream)autoCloseable;
            boolean bl = false;
            Stream stream = files2;
            Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"files");
            list2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)stream), (Function1)parseExistingDiagnostics.1.1.INSTANCE), (Function1)((Function1)new Function1<Path, ExistingDiagnostic>(this){
                final /* synthetic */ IndexDiagnosticDumper this$0;
                {
                    this.this$0 = indexDiagnosticDumper;
                    super(1);
                }

                @Nullable
                public final ExistingDiagnostic invoke(Path jsonFile) {
                    Path htmlFile;
                    Path path2 = jsonFile;
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"jsonFile");
                    JsonProjectIndexingHistoryTimes jsonProjectIndexingHistoryTimes = IndexDiagnosticDumper.access$fastReadIndexingHistoryTimes(this.this$0, path2);
                    if (jsonProjectIndexingHistoryTimes == null) {
                        return null;
                    }
                    JsonProjectIndexingHistoryTimes times2 = jsonProjectIndexingHistoryTimes;
                    JsonIndexDiagnosticAppInfo jsonIndexDiagnosticAppInfo = IndexDiagnosticDumper.access$fastReadAppInfo(this.this$0, jsonFile);
                    if (jsonIndexDiagnosticAppInfo == null) {
                        return null;
                    }
                    JsonIndexDiagnosticAppInfo appInfo = jsonIndexDiagnosticAppInfo;
                    JsonRuntimeInfo jsonRuntimeInfo = IndexDiagnosticDumper.access$fastReadRuntimeInfo(this.this$0, jsonFile);
                    if (jsonRuntimeInfo == null) {
                        return null;
                    }
                    JsonRuntimeInfo runtimeInfo = jsonRuntimeInfo;
                    JsonProjectIndexingFileCount fileCount = IndexDiagnosticDumper.access$fastReadFileCount(this.this$0, jsonFile);
                    Path path3 = htmlFile = jsonFile.resolveSibling(PathsKt.getNameWithoutExtension((Path)jsonFile) + ".html");
                    Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"htmlFile");
                    if (!PathKt.exists(path3)) {
                        return null;
                    }
                    return new ExistingDiagnostic(jsonFile, htmlFile, times2, appInfo, runtimeInfo, fileCount);
                }
            })));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return list2;
    }

    @Override
    public synchronized void dispose() {
        Iterator<ProjectIndexingHistoryImpl> iterator = this.unsavedIndexingHistories.iterator();
        while (iterator.hasNext()) {
            ProjectIndexingHistoryImpl unsavedIndexingHistory;
            ProjectIndexingHistoryImpl projectIndexingHistoryImpl = unsavedIndexingHistory = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)projectIndexingHistoryImpl, (String)"unsavedIndexingHistory");
            this.dumpProjectIndexingHistoryToLogSubdirectory(projectIndexingHistoryImpl);
        }
        this.isDisposed = true;
    }

    public IndexDiagnosticDumper() {
        Set set2 = ConcurrentCollectionFactory.createConcurrentIdentitySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"ConcurrentCollectionFact\u2026ectIndexingHistoryImpl>()");
        this.unsavedIndexingHistories = set2;
    }

    static {
        Companion = new Companion(null);
        ExtensionPointName extensionPointName = ExtensionPointName.create("com.intellij.projectIndexingHistoryListener");
        Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"ExtensionPointName.creat\u2026IndexingHistoryListener\")");
        projectIndexingHistoryListenerEpName = extensionPointName;
        Logger logger = Logger.getInstance(IndexDiagnosticDumper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Index\u2026nosticDumper::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$dumpProjectIndexingHistoryToLogSubdirectory(IndexDiagnosticDumper $this, ProjectIndexingHistoryImpl projectIndexingHistory) {
        $this.dumpProjectIndexingHistoryToLogSubdirectory(projectIndexingHistory);
    }

    public static final /* synthetic */ JsonProjectIndexingHistoryTimes access$fastReadIndexingHistoryTimes(IndexDiagnosticDumper $this, Path jsonFile) {
        return $this.fastReadIndexingHistoryTimes(jsonFile);
    }

    public static final /* synthetic */ JsonIndexDiagnosticAppInfo access$fastReadAppInfo(IndexDiagnosticDumper $this, Path jsonFile) {
        return $this.fastReadAppInfo(jsonFile);
    }

    public static final /* synthetic */ JsonRuntimeInfo access$fastReadRuntimeInfo(IndexDiagnosticDumper $this, Path jsonFile) {
        return $this.fastReadRuntimeInfo(jsonFile);
    }

    public static final /* synthetic */ JsonProjectIndexingFileCount access$fastReadFileCount(IndexDiagnosticDumper $this, Path jsonFile) {
        return $this.fastReadFileCount(jsonFile);
    }

    @JvmStatic
    @NotNull
    public static final IndexDiagnosticDumper getInstance() {
        return Companion.getInstance();
    }

    @NotNull
    public static final ExtensionPointName<ProjectIndexingHistoryListener> getProjectIndexingHistoryListenerEpName() {
        Companion companion = Companion;
        return projectIndexingHistoryListenerEpName;
    }

    private static final boolean getShouldDumpDiagnosticsForInterruptedUpdaters() {
        return IndexDiagnosticDumper.Companion.getShouldDumpDiagnosticsForInterruptedUpdaters();
    }

    private static final int getIndexingDiagnosticsLimitOfFiles() {
        return IndexDiagnosticDumper.Companion.getIndexingDiagnosticsLimitOfFiles();
    }

    private static final int getIndexingDiagnosticsSizeLimitOfFilesInMiBPerProject() {
        return IndexDiagnosticDumper.Companion.getIndexingDiagnosticsSizeLimitOfFilesInMiBPerProject();
    }

    private static final int getIndexingDiagnosticsSizeLimitOfFilesInMBPerProject() {
        return IndexDiagnosticDumper.Companion.getIndexingDiagnosticsSizeLimitOfFilesInMBPerProject();
    }

    public static final boolean getShouldDumpPathsOfIndexedFiles() {
        return Companion.getShouldDumpPathsOfIndexedFiles();
    }

    public static final boolean getShouldDumpProviderRootPaths() {
        return Companion.getShouldDumpProviderRootPaths();
    }

    public static final boolean getShouldProvideVisibleAndAllThreadsTimeInfo() {
        return Companion.getShouldProvideVisibleAndAllThreadsTimeInfo();
    }

    public static final boolean getShouldDumpInUnitTestMode() {
        Companion companion = Companion;
        return shouldDumpInUnitTestMode;
    }

    public static final void setShouldDumpInUnitTestMode(boolean bl) {
        Companion companion = Companion;
        shouldDumpInUnitTestMode = bl;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\nH\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\fH\u00c6\u0003JG\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006'"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$ExistingDiagnostic;", "", "jsonFile", "Ljava/nio/file/Path;", "htmlFile", "indexingTimes", "Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingHistoryTimes;", "appInfo", "Lcom/intellij/util/indexing/diagnostic/dto/JsonIndexDiagnosticAppInfo;", "runtimeInfo", "Lcom/intellij/util/indexing/diagnostic/dto/JsonRuntimeInfo;", "fileCount", "Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingFileCount;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingHistoryTimes;Lcom/intellij/util/indexing/diagnostic/dto/JsonIndexDiagnosticAppInfo;Lcom/intellij/util/indexing/diagnostic/dto/JsonRuntimeInfo;Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingFileCount;)V", "getAppInfo", "()Lcom/intellij/util/indexing/diagnostic/dto/JsonIndexDiagnosticAppInfo;", "getFileCount", "()Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingFileCount;", "getHtmlFile", "()Ljava/nio/file/Path;", "getIndexingTimes", "()Lcom/intellij/util/indexing/diagnostic/dto/JsonProjectIndexingHistoryTimes;", "getJsonFile", "getRuntimeInfo", "()Lcom/intellij/util/indexing/diagnostic/dto/JsonRuntimeInfo;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.lang.impl"})
    public static final class ExistingDiagnostic {
        @NotNull
        private final Path jsonFile;
        @NotNull
        private final Path htmlFile;
        @NotNull
        private final JsonProjectIndexingHistoryTimes indexingTimes;
        @NotNull
        private final JsonIndexDiagnosticAppInfo appInfo;
        @NotNull
        private final JsonRuntimeInfo runtimeInfo;
        @Nullable
        private final JsonProjectIndexingFileCount fileCount;

        @NotNull
        public final Path getJsonFile() {
            return this.jsonFile;
        }

        @NotNull
        public final Path getHtmlFile() {
            return this.htmlFile;
        }

        @NotNull
        public final JsonProjectIndexingHistoryTimes getIndexingTimes() {
            return this.indexingTimes;
        }

        @NotNull
        public final JsonIndexDiagnosticAppInfo getAppInfo() {
            return this.appInfo;
        }

        @NotNull
        public final JsonRuntimeInfo getRuntimeInfo() {
            return this.runtimeInfo;
        }

        @Nullable
        public final JsonProjectIndexingFileCount getFileCount() {
            return this.fileCount;
        }

        public ExistingDiagnostic(@NotNull Path jsonFile, @NotNull Path htmlFile, @NotNull JsonProjectIndexingHistoryTimes indexingTimes, @NotNull JsonIndexDiagnosticAppInfo appInfo, @NotNull JsonRuntimeInfo runtimeInfo, @Nullable JsonProjectIndexingFileCount fileCount) {
            Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
            Intrinsics.checkNotNullParameter((Object)htmlFile, (String)"htmlFile");
            Intrinsics.checkNotNullParameter((Object)indexingTimes, (String)"indexingTimes");
            Intrinsics.checkNotNullParameter((Object)appInfo, (String)"appInfo");
            Intrinsics.checkNotNullParameter((Object)runtimeInfo, (String)"runtimeInfo");
            this.jsonFile = jsonFile;
            this.htmlFile = htmlFile;
            this.indexingTimes = indexingTimes;
            this.appInfo = appInfo;
            this.runtimeInfo = runtimeInfo;
            this.fileCount = fileCount;
        }

        @NotNull
        public final Path component1() {
            return this.jsonFile;
        }

        @NotNull
        public final Path component2() {
            return this.htmlFile;
        }

        @NotNull
        public final JsonProjectIndexingHistoryTimes component3() {
            return this.indexingTimes;
        }

        @NotNull
        public final JsonIndexDiagnosticAppInfo component4() {
            return this.appInfo;
        }

        @NotNull
        public final JsonRuntimeInfo component5() {
            return this.runtimeInfo;
        }

        @Nullable
        public final JsonProjectIndexingFileCount component6() {
            return this.fileCount;
        }

        @NotNull
        public final ExistingDiagnostic copy(@NotNull Path jsonFile, @NotNull Path htmlFile, @NotNull JsonProjectIndexingHistoryTimes indexingTimes, @NotNull JsonIndexDiagnosticAppInfo appInfo, @NotNull JsonRuntimeInfo runtimeInfo, @Nullable JsonProjectIndexingFileCount fileCount) {
            Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
            Intrinsics.checkNotNullParameter((Object)htmlFile, (String)"htmlFile");
            Intrinsics.checkNotNullParameter((Object)indexingTimes, (String)"indexingTimes");
            Intrinsics.checkNotNullParameter((Object)appInfo, (String)"appInfo");
            Intrinsics.checkNotNullParameter((Object)runtimeInfo, (String)"runtimeInfo");
            return new ExistingDiagnostic(jsonFile, htmlFile, indexingTimes, appInfo, runtimeInfo, fileCount);
        }

        public static /* synthetic */ ExistingDiagnostic copy$default(ExistingDiagnostic existingDiagnostic, Path path2, Path path3, JsonProjectIndexingHistoryTimes jsonProjectIndexingHistoryTimes, JsonIndexDiagnosticAppInfo jsonIndexDiagnosticAppInfo, JsonRuntimeInfo jsonRuntimeInfo, JsonProjectIndexingFileCount jsonProjectIndexingFileCount, int n, Object object) {
            if ((n & 1) != 0) {
                path2 = existingDiagnostic.jsonFile;
            }
            if ((n & 2) != 0) {
                path3 = existingDiagnostic.htmlFile;
            }
            if ((n & 4) != 0) {
                jsonProjectIndexingHistoryTimes = existingDiagnostic.indexingTimes;
            }
            if ((n & 8) != 0) {
                jsonIndexDiagnosticAppInfo = existingDiagnostic.appInfo;
            }
            if ((n & 0x10) != 0) {
                jsonRuntimeInfo = existingDiagnostic.runtimeInfo;
            }
            if ((n & 0x20) != 0) {
                jsonProjectIndexingFileCount = existingDiagnostic.fileCount;
            }
            return existingDiagnostic.copy(path2, path3, jsonProjectIndexingHistoryTimes, jsonIndexDiagnosticAppInfo, jsonRuntimeInfo, jsonProjectIndexingFileCount);
        }

        @NotNull
        public String toString() {
            return "ExistingDiagnostic(jsonFile=" + this.jsonFile + ", htmlFile=" + this.htmlFile + ", indexingTimes=" + this.indexingTimes + ", appInfo=" + this.appInfo + ", runtimeInfo=" + this.runtimeInfo + ", fileCount=" + this.fileCount + ")";
        }

        public int hashCode() {
            Path path2 = this.jsonFile;
            Path path3 = this.htmlFile;
            JsonProjectIndexingHistoryTimes jsonProjectIndexingHistoryTimes = this.indexingTimes;
            JsonIndexDiagnosticAppInfo jsonIndexDiagnosticAppInfo = this.appInfo;
            JsonRuntimeInfo jsonRuntimeInfo = this.runtimeInfo;
            JsonProjectIndexingFileCount jsonProjectIndexingFileCount = this.fileCount;
            return (((((path2 != null ? ((Object)path2).hashCode() : 0) * 31 + (path3 != null ? ((Object)path3).hashCode() : 0)) * 31 + (jsonProjectIndexingHistoryTimes != null ? ((Object)jsonProjectIndexingHistoryTimes).hashCode() : 0)) * 31 + (jsonIndexDiagnosticAppInfo != null ? ((Object)jsonIndexDiagnosticAppInfo).hashCode() : 0)) * 31 + (jsonRuntimeInfo != null ? ((Object)jsonRuntimeInfo).hashCode() : 0)) * 31 + (jsonProjectIndexingFileCount != null ? ((Object)jsonProjectIndexingFileCount).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ExistingDiagnostic)) break block3;
                    ExistingDiagnostic existingDiagnostic = (ExistingDiagnostic)object;
                    if (!Intrinsics.areEqual((Object)this.jsonFile, (Object)existingDiagnostic.jsonFile) || !Intrinsics.areEqual((Object)this.htmlFile, (Object)existingDiagnostic.htmlFile) || !Intrinsics.areEqual((Object)this.indexingTimes, (Object)existingDiagnostic.indexingTimes) || !Intrinsics.areEqual((Object)this.appInfo, (Object)existingDiagnostic.appInfo) || !Intrinsics.areEqual((Object)this.runtimeInfo, (Object)existingDiagnostic.runtimeInfo) || !Intrinsics.areEqual((Object)this.fileCount, (Object)existingDiagnostic.fileCount)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010.\u001a\u00020/J\b\u00100\u001a\u000201H\u0007J\u000e\u00102\u001a\u0002032\u0006\u00104\u001a\u000205J\b\u00106\u001a\u00020\u0014H\u0002J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u000203R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\t8BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\t8BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\u00020\t8BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\fR\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R/\u0010\u0016\u001a\u0015\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u00180\u0017\u00a2\u0006\u0002\b\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u0002\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u00148BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\u001e\u0010\u0002\u001a\u0004\b\u001f\u0010\u0015R$\u0010 \u001a\u00020\u00148\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b!\u0010\u0002\u001a\u0004\b\"\u0010\u0015\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020\u00148FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b&\u0010\u0002\u001a\u0004\b'\u0010\u0015R\u001a\u0010(\u001a\u00020\u00148FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b)\u0010\u0002\u001a\u0004\b*\u0010\u0015R\u001a\u0010+\u001a\u00020\u00148FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b,\u0010\u0002\u001a\u0004\b-\u0010\u0015\u00a8\u0006:"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "fileNamePrefix", "", "indexingDiagnosticsLimitOfFiles", "", "getIndexingDiagnosticsLimitOfFiles$annotations", "getIndexingDiagnosticsLimitOfFiles", "()I", "indexingDiagnosticsSizeLimitOfFilesInMBPerProject", "getIndexingDiagnosticsSizeLimitOfFilesInMBPerProject$annotations", "getIndexingDiagnosticsSizeLimitOfFilesInMBPerProject", "indexingDiagnosticsSizeLimitOfFilesInMiBPerProject", "getIndexingDiagnosticsSizeLimitOfFilesInMiBPerProject$annotations", "getIndexingDiagnosticsSizeLimitOfFilesInMiBPerProject", "isIntegrationTest", "", "()Z", "projectIndexingHistoryListenerEpName", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistoryListener;", "kotlin.jvm.PlatformType", "getProjectIndexingHistoryListenerEpName$annotations", "getProjectIndexingHistoryListenerEpName", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "shouldDumpDiagnosticsForInterruptedUpdaters", "getShouldDumpDiagnosticsForInterruptedUpdaters$annotations", "getShouldDumpDiagnosticsForInterruptedUpdaters", "shouldDumpInUnitTestMode", "getShouldDumpInUnitTestMode$annotations", "getShouldDumpInUnitTestMode", "setShouldDumpInUnitTestMode", "(Z)V", "shouldDumpPathsOfIndexedFiles", "getShouldDumpPathsOfIndexedFiles$annotations", "getShouldDumpPathsOfIndexedFiles", "shouldDumpProviderRootPaths", "getShouldDumpProviderRootPaths$annotations", "getShouldDumpProviderRootPaths", "shouldProvideVisibleAndAllThreadsTimeInfo", "getShouldProvideVisibleAndAllThreadsTimeInfo$annotations", "getShouldProvideVisibleAndAllThreadsTimeInfo", "clearDiagnostic", "", "getInstance", "Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper;", "getProjectDiagnosticDirectory", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "hasProvidedDiagnosticsLimitOfFilesValue", "readJsonIndexDiagnostic", "Lcom/intellij/util/indexing/diagnostic/dto/JsonIndexDiagnostic;", "file", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final IndexDiagnosticDumper getInstance() {
            boolean $i$f$service = false;
            Class<IndexDiagnosticDumper> serviceClass$iv = IndexDiagnosticDumper.class;
            IndexDiagnosticDumper indexDiagnosticDumper = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (indexDiagnosticDumper == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return indexDiagnosticDumper;
        }

        @JvmStatic
        public static /* synthetic */ void getProjectIndexingHistoryListenerEpName$annotations() {
        }

        @NotNull
        public final ExtensionPointName<ProjectIndexingHistoryListener> getProjectIndexingHistoryListenerEpName() {
            return projectIndexingHistoryListenerEpName;
        }

        @JvmStatic
        private static /* synthetic */ void getShouldDumpDiagnosticsForInterruptedUpdaters$annotations() {
        }

        private final boolean getShouldDumpDiagnosticsForInterruptedUpdaters() {
            return SystemProperties.getBooleanProperty("intellij.indexes.diagnostics.should.dump.for.interrupted.index.updaters", false);
        }

        @JvmStatic
        private static /* synthetic */ void getIndexingDiagnosticsLimitOfFiles$annotations() {
        }

        private final int getIndexingDiagnosticsLimitOfFiles() {
            return SystemProperties.getIntProperty("intellij.indexes.diagnostics.limit.of.files", 300);
        }

        private final boolean hasProvidedDiagnosticsLimitOfFilesValue() {
            String providedLimitOfFilesValue = System.getProperty("intellij.indexes.diagnostics.limit.of.files");
            if (providedLimitOfFilesValue == null) {
                return false;
            }
            try {
                String string2 = providedLimitOfFilesValue;
                Integer.parseInt(string2);
            }
            catch (NumberFormatException ignored) {
                return false;
            }
            return true;
        }

        @JvmStatic
        private static /* synthetic */ void getIndexingDiagnosticsSizeLimitOfFilesInMiBPerProject$annotations() {
        }

        private final int getIndexingDiagnosticsSizeLimitOfFilesInMiBPerProject() {
            String providedValue = System.getProperty("intellij.indexes.diagnostics.size.limit.of.files.MiB.per.project");
            if (providedValue != null) {
                try {
                    String string2 = providedValue;
                    return Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return Companion.hasProvidedDiagnosticsLimitOfFilesValue() ? 0 : 10;
        }

        @JvmStatic
        private static /* synthetic */ void getIndexingDiagnosticsSizeLimitOfFilesInMBPerProject$annotations() {
        }

        private final int getIndexingDiagnosticsSizeLimitOfFilesInMBPerProject() {
            return SystemProperties.getIntProperty("intellij.indexes.diagnostics.size.limit.of.files.MB.per.project", 10);
        }

        @JvmStatic
        public static /* synthetic */ void getShouldDumpPathsOfIndexedFiles$annotations() {
        }

        public final boolean getShouldDumpPathsOfIndexedFiles() {
            return SystemProperties.getBooleanProperty("intellij.indexes.diagnostics.should.dump.paths.of.indexed.files", false);
        }

        @JvmStatic
        public static /* synthetic */ void getShouldDumpProviderRootPaths$annotations() {
        }

        public final boolean getShouldDumpProviderRootPaths() {
            return SystemProperties.getBooleanProperty("intellij.indexes.diagnostics.should.dump.provider.root.paths", false);
        }

        @JvmStatic
        public static /* synthetic */ void getShouldProvideVisibleAndAllThreadsTimeInfo$annotations() {
        }

        public final boolean getShouldProvideVisibleAndAllThreadsTimeInfo() {
            return SystemProperties.getBooleanProperty("intellij.indexes.diagnostics.should.provide.visible.and.all.threads.time.info", false);
        }

        @JvmStatic
        public static /* synthetic */ void getShouldDumpInUnitTestMode$annotations() {
        }

        public final boolean getShouldDumpInUnitTestMode() {
            return shouldDumpInUnitTestMode;
        }

        public final void setShouldDumpInUnitTestMode(boolean bl) {
            shouldDumpInUnitTestMode = bl;
        }

        private final boolean isIntegrationTest() {
            return SystemProperties.getBooleanProperty("idea.is.integration.test", false);
        }

        @NotNull
        public final JsonIndexDiagnostic readJsonIndexDiagnostic(@NotNull Path file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Object object = IndexDiagnosticDumperUtils.INSTANCE.getJacksonMapper().readValue(file2.toFile(), JsonIndexDiagnostic.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"jacksonMapper.readValue(\u2026exDiagnostic::class.java)");
            return (JsonIndexDiagnostic)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void clearDiagnostic() {
            if (PathKt.exists(IndexDiagnosticDumperUtils.INSTANCE.getIndexingDiagnosticDir())) {
                Path $this$directoryStreamIfExists$iv = IndexDiagnosticDumperUtils.INSTANCE.getIndexingDiagnosticDir();
                boolean $i$f$directoryStreamIfExists = false;
                try {
                    Closeable closeable = Files.newDirectoryStream($this$directoryStreamIfExists$iv);
                    Throwable throwable = null;
                    try {
                        DirectoryStream dirStream = (DirectoryStream)closeable;
                        boolean bl = false;
                        Iterable $this$forEach$iv = dirStream;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Path it = (Path)element$iv;
                            boolean bl2 = false;
                            FileUtil.deleteWithRenaming(it);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (NoSuchFileException noSuchFileException) {
                }
            }
        }

        @NotNull
        public final Path getProjectDiagnosticDirectory(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Path directory = ProjectUtil.getProjectCachePath$default((Project)project2, (Path)IndexDiagnosticDumperUtils.INSTANCE.getIndexingDiagnosticDir(), (boolean)false, null, (int)6, null);
            PathKt.createDirectories(directory);
            return directory;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

