/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump.paths;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Base64;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexedHashesSupport;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.indexing.diagnostic.dump.paths.IndexedFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePaths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePaths;", "", "()V", "FAILED_TO_LOAD", "", "TOO_LARGE_FILE", "pusherName", "Lcom/intellij/openapi/roots/impl/FilePropertyPusher;", "getPusherName", "(Lcom/intellij/openapi/roots/impl/FilePropertyPusher;)Ljava/lang/String;", "createIndexedFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePath;", "fileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "dumpFilePropertyPusherValues", "", "file", "intellij.platform.lang.impl"})
public final class IndexedFilePaths {
    @NotNull
    public static final String TOO_LARGE_FILE = "<TOO LARGE>";
    @NotNull
    public static final String FAILED_TO_LOAD = "<FAILED TO LOAD: %s>";
    @NotNull
    public static final IndexedFilePaths INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IndexedFilePath createIndexedFilePath(@NotNull VirtualFile fileOrDir, @NotNull Project project2) {
        void contentHash;
        void $this$mapValuesTo$iv$iv;
        Object object;
        Object fileContent;
        String string2;
        String fileType;
        String string3;
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        int fileId = FileBasedIndex.getFileId((VirtualFile)fileOrDir);
        String string4 = fileOrDir.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"fileOrDir.url");
        String fileUrl = string4;
        if (fileOrDir.isDirectory()) {
            string3 = null;
        } else {
            FileType fileType2 = fileOrDir.getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType2, (String)"fileOrDir.fileType");
            string3 = fileType = fileType2.getName();
        }
        if (fileOrDir.isDirectory()) {
            string2 = null;
        } else {
            boolean $i$f$runReadAction = false;
            string2 = (String)ApplicationManager.getApplication().runReadAction(new Computable(fileOrDir, project2, fileType){
                final /* synthetic */ VirtualFile $fileOrDir$inlined;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ String $fileType$inlined;
                {
                    this.$fileOrDir$inlined = virtualFile2;
                    this.$project$inlined = project2;
                    this.$fileType$inlined = string2;
                }

                public final T compute() {
                    String string2;
                    boolean bl = false;
                    FileType fileType = SubstitutedFileType.substituteFileType(this.$fileOrDir$inlined, this.$fileOrDir$inlined.getFileType(), this.$project$inlined);
                    Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"SubstitutedFileType.subs\u2026eOrDir.fileType, project)");
                    String it = string2 = fileType.getName();
                    boolean bl2 = false;
                    return (T)(Intrinsics.areEqual((Object)it, (Object)this.$fileType$inlined) ^ true ? string2 : null);
                }
            });
        }
        String substitutedFileType = string2;
        try {
            FileContent fileContent2 = FileContentImpl.createByFile(fileOrDir);
            if (fileContent2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.FileContentImpl");
            }
            fileContent = (FileContentImpl)fileContent2;
            boolean $i$f$runReadAction = false;
            fileContent = (Pair)ApplicationManager.getApplication().runReadAction(new Computable((FileContentImpl)fileContent){
                final /* synthetic */ FileContentImpl $fileContent$inlined;
                {
                    this.$fileContent$inlined = fileContentImpl;
                }

                public final T compute() {
                    boolean bl = false;
                    byte[] contentHash = IndexedHashesSupport.getBinaryContentHash(this.$fileContent$inlined.getContent());
                    byte[] indexedHash = IndexedHashesSupport.calculateIndexedHash(this.$fileContent$inlined, contentHash);
                    return (T)TuplesKt.to((Object)Base64.encode(contentHash), (Object)Base64.encode(indexedHash));
                }
            });
        }
        catch (FileTooBigException e) {
            fileContent = TuplesKt.to((Object)TOO_LARGE_FILE, (Object)TOO_LARGE_FILE);
        }
        catch (Throwable e) {
            String string5 = FAILED_TO_LOAD;
            object = new Object[]{e.getMessage()};
            String string6 = String.format(string5, Arrays.copyOf(object, ((Object[])object).length));
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(this, *args)");
            String msg = string6;
            fileContent = TuplesKt.to((Object)msg, (Object)msg);
        }
        Object object2 = fileContent;
        String $i$f$runReadAction = (String)object2.component1();
        String indexedHash = (String)object2.component2();
        Long fileSize = fileOrDir.isDirectory() ? null : Long.valueOf(fileOrDir.getLength());
        PortableFilePath portableFilePath = PortableFilePaths.INSTANCE.getPortableFilePath(fileOrDir, project2);
        Map<String, Object> $this$mapValues$iv = this.dumpFilePropertyPusherValues(fileOrDir, project2);
        boolean $i$f$mapValues = false;
        object = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Object v = it.getValue();
            if (v == null || (v = v.toString()) == null) {
                v = "<null-value>";
            }
            Object v2 = v;
            map3.put(k, v2);
        }
        Map allPusherValues = destination$iv$iv;
        String string7 = indexedHash;
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"indexedHash");
        void v8 = contentHash;
        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"contentHash");
        return new IndexedFilePath(fileId, fileType, substitutedFileType, fileSize, fileUrl, portableFilePath, allPusherValues, string7, (String)v8);
    }

    private final Map<String, Object> dumpFilePropertyPusherValues(VirtualFile file2, Project project2) {
        HashMap map2 = new HashMap();
        FilePropertyPusher.EP_NAME.forEachExtensionSafe(new Consumer(file2, project2, map2){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Project $project;
            final /* synthetic */ HashMap $map;

            public final void accept(FilePropertyPusher<?> pusher) {
                if (this.$file.isDirectory() && pusher.acceptsDirectory(this.$file, this.$project) || !this.$file.isDirectory() && pusher.acceptsFile(this.$file, this.$project)) {
                    Map map2 = this.$map;
                    FilePropertyPusher<?> filePropertyPusher = pusher;
                    Intrinsics.checkNotNullExpressionValue(filePropertyPusher, (String)"pusher");
                    map2.put(IndexedFilePaths.access$getPusherName$p(IndexedFilePaths.INSTANCE, filePropertyPusher), pusher.getImmediateValue(this.$project, this.$file));
                }
            }
            {
                this.$file = virtualFile2;
                this.$project = project2;
                this.$map = hashMap;
            }
        });
        return map2;
    }

    private final String getPusherName(FilePropertyPusher<?> $this$pusherName) {
        String string2 = $this$pusherName.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaClass.name");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)string2, (CharSequence)"com."), (CharSequence)"intellij."), (CharSequence)"jetbrains."), (String)"util.", (String)"", (boolean)false, (int)4, null), (String)"impl.", (String)"", (boolean)false, (int)4, null);
    }

    private IndexedFilePaths() {
    }

    static {
        IndexedFilePaths indexedFilePaths;
        INSTANCE = indexedFilePaths = new IndexedFilePaths();
    }

    public static final /* synthetic */ String access$getPusherName$p(IndexedFilePaths $this, FilePropertyPusher $this$access_u24pusherName_u24p) {
        return $this.getPusherName($this$access_u24pusherName_u24p);
    }
}

