/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump.paths;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.providers.IdePortableFilePathProvider;
import com.intellij.util.indexing.diagnostic.dump.paths.providers.JdkPortableFilePathProvider;
import com.intellij.util.indexing.diagnostic.dump.paths.providers.LibraryRelativePortableFilePathProvider;
import com.intellij.util.indexing.diagnostic.dump.paths.providers.PortableFilePathProvider;
import com.intellij.util.indexing.diagnostic.dump.paths.providers.ProjectRelativePortableFilePathProvider;
import com.intellij.util.indexing.diagnostic.dump.paths.resolvers.AbsolutePortableFilePathResolver;
import com.intellij.util.indexing.diagnostic.dump.paths.resolvers.ArchiveRootPortableFilePathResolver;
import com.intellij.util.indexing.diagnostic.dump.paths.resolvers.IdeRootPortableFilePathResolver;
import com.intellij.util.indexing.diagnostic.dump.paths.resolvers.JdkRootPortableFilePathResolver;
import com.intellij.util.indexing.diagnostic.dump.paths.resolvers.LibraryRootPortableFilePathResolver;
import com.intellij.util.indexing.diagnostic.dump.paths.resolvers.PortableFilePathResolver;
import com.intellij.util.indexing.diagnostic.dump.paths.resolvers.ProjectRootPortableFilePathResolver;
import com.intellij.util.indexing.diagnostic.dump.paths.resolvers.RelativePortableFilePathResolver;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePaths;", "", "()V", "PROVIDERS", "", "Lcom/intellij/util/indexing/diagnostic/dump/paths/providers/PortableFilePathProvider;", "RESOLVERS", "Lcom/intellij/util/indexing/diagnostic/dump/paths/resolvers/PortableFilePathResolver;", "findFileByPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "portableFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath;", "project", "Lcom/intellij/openapi/project/Project;", "getPortableFilePath", "virtualFile", "isSupportedFileSystem", "", "intellij.platform.lang.impl"})
public final class PortableFilePaths {
    private static final List<PortableFilePathProvider> PROVIDERS;
    private static final List<PortableFilePathResolver> RESOLVERS;
    @NotNull
    public static final PortableFilePaths INSTANCE;

    @NotNull
    public final PortableFilePath getPortableFilePath(@NotNull VirtualFile virtualFile2, @NotNull Project project2) {
        PortableFilePath portableFilePath;
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        PortableFilePath.RelativePath relativePath = (PortableFilePath.RelativePath)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)PROVIDERS), (Function1)((Function1)new Function1<PortableFilePathProvider, PortableFilePath.RelativePath>(project2, virtualFile2){
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $virtualFile;

            @Nullable
            public final PortableFilePath.RelativePath invoke(@NotNull PortableFilePathProvider it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getRelativePortableFilePath(this.$project, this.$virtualFile);
            }
            {
                this.$project = project2;
                this.$virtualFile = virtualFile2;
                super(1);
            }
        })));
        if (relativePath != null) {
            portableFilePath = relativePath;
        } else {
            String string2 = virtualFile2.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"virtualFile.url");
            portableFilePath = new PortableFilePath.AbsolutePath(string2);
        }
        return portableFilePath;
    }

    @Nullable
    public final VirtualFile findFileByPath(@NotNull PortableFilePath portableFilePath, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)portableFilePath, (String)"portableFilePath");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        VirtualFile virtualFile2 = (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)RESOLVERS), (Function1)((Function1)new Function1<PortableFilePathResolver, VirtualFile>(project2, portableFilePath){
            final /* synthetic */ Project $project;
            final /* synthetic */ PortableFilePath $portableFilePath;

            @Nullable
            public final VirtualFile invoke(@NotNull PortableFilePathResolver it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.findFileByPath(this.$project, this.$portableFilePath);
            }
            {
                this.$project = project2;
                this.$portableFilePath = portableFilePath;
                super(1);
            }
        })));
        if (virtualFile2 == null) {
            virtualFile2 = AbsolutePortableFilePathResolver.INSTANCE.findFileByPath(project2, portableFilePath);
        }
        return virtualFile2;
    }

    public final boolean isSupportedFileSystem(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        return virtualFile2.isInLocalFileSystem() || virtualFile2.getFileSystem() instanceof ArchiveFileSystem;
    }

    private PortableFilePaths() {
    }

    static {
        PortableFilePaths portableFilePaths;
        INSTANCE = portableFilePaths = new PortableFilePaths();
        PROVIDERS = CollectionsKt.listOf((Object[])new PortableFilePathProvider[]{JdkPortableFilePathProvider.INSTANCE, LibraryRelativePortableFilePathProvider.INSTANCE, ProjectRelativePortableFilePathProvider.INSTANCE, IdePortableFilePathProvider.INSTANCE});
        RESOLVERS = CollectionsKt.listOf((Object[])new PortableFilePathResolver[]{JdkRootPortableFilePathResolver.INSTANCE, LibraryRootPortableFilePathResolver.INSTANCE, ArchiveRootPortableFilePathResolver.INSTANCE, IdeRootPortableFilePathResolver.INSTANCE, ProjectRootPortableFilePathResolver.INSTANCE, RelativePortableFilePathResolver.INSTANCE});
    }
}

