/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic.dump.paths.providers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.providers.PortableFilePathProvider;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/util/indexing/diagnostic/dump/paths/providers/LibraryRelativePortableFilePathProvider;", "Lcom/intellij/util/indexing/diagnostic/dump/paths/providers/PortableFilePathProvider;", "()V", "getRelativePortableFilePath", "Lcom/intellij/util/indexing/diagnostic/dump/paths/PortableFilePath$RelativePath;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.lang.impl"})
public final class LibraryRelativePortableFilePathProvider
implements PortableFilePathProvider {
    @NotNull
    public static final LibraryRelativePortableFilePathProvider INSTANCE;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public PortableFilePath.RelativePath getRelativePortableFilePath(@NotNull Project project2, @NotNull VirtualFile virtualFile2) {
        String string2;
        PortableFilePath.LibraryRoot.LibraryType libraryType;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        boolean $i$f$runReadAction = false;
        OrderEntry orderEntry = (OrderEntry)ApplicationManager.getApplication().runReadAction(new Computable(virtualFile2, project2){
            final /* synthetic */ VirtualFile $virtualFile$inlined;
            final /* synthetic */ Project $project$inlined;
            {
                this.$virtualFile$inlined = virtualFile2;
                this.$project$inlined = project2;
            }

            public final T compute() {
                boolean bl = false;
                return (T)LibraryUtil.findLibraryEntry(this.$virtualFile$inlined, this.$project$inlined);
            }
        });
        if (!(orderEntry instanceof LibraryOrderEntry)) {
            return null;
        }
        String libraryName = ((LibraryOrderEntry)orderEntry).getLibraryName();
        if (libraryName == null) {
            return null;
        }
        String string3 = ((LibraryOrderEntry)orderEntry).getLibraryLevel();
        if (string3 == null) return null;
        switch (string3) {
            case "application": {
                libraryType = PortableFilePath.LibraryRoot.LibraryType.APPLICATION;
                break;
            }
            case "project": {
                libraryType = PortableFilePath.LibraryRoot.LibraryType.PROJECT;
                break;
            }
            case "module": {
                libraryType = PortableFilePath.LibraryRoot.LibraryType.MODULE;
                break;
            }
            default: {
                return null;
            }
        }
        PortableFilePath.LibraryRoot.LibraryType libraryType2 = libraryType;
        if (libraryType2 == PortableFilePath.LibraryRoot.LibraryType.MODULE) {
            Module module = ((LibraryOrderEntry)orderEntry).getOwnerModule();
            Intrinsics.checkNotNullExpressionValue((Object)module, (String)"orderEntry.ownerModule");
            string2 = module.getName();
        } else {
            string2 = null;
        }
        String moduleName = string2;
        for (OrderRootType rootType : CollectionsKt.listOf((Object[])new OrderRootType[]{OrderRootType.CLASSES, OrderRootType.SOURCES})) {
            VirtualFile[] virtualFileArray;
            boolean inClassFiles = Intrinsics.areEqual((Object)rootType, (Object)OrderRootType.CLASSES);
            Intrinsics.checkNotNullExpressionValue((Object)((LibraryOrderEntry)orderEntry).getRootFiles(rootType), (String)"orderEntry.getRootFiles(rootType)");
            int n = virtualFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                void rootIndex;
                VirtualFile rootFile = virtualFileArray[n2];
                String relativePath = VfsUtilCore.getRelativePath(virtualFile2, rootFile);
                if (relativePath != null) {
                    return new PortableFilePath.RelativePath(new PortableFilePath.LibraryRoot(libraryType2, libraryName, moduleName, (int)rootIndex, inClassFiles), relativePath);
                }
                ++rootIndex;
            }
        }
        return null;
    }

    private LibraryRelativePortableFilePathProvider() {
    }

    static {
        LibraryRelativePortableFilePathProvider libraryRelativePortableFilePathProvider;
        INSTANCE = libraryRelativePortableFilePathProvider = new LibraryRelativePortableFilePathProvider();
    }
}

