/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.perFileVersion;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.util.indexing.CompositeDataIndexer;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.impl.perFileVersion.PersistentSubIndexerVersionEnumerator;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class PersistentSubIndexerRetriever<SubIndexerType, SubIndexerVersion>
implements Closeable {
    private static final String INDEXED_VERSIONS = "indexed_versions";
    private static final int UNINDEXED_STATE = -2;
    private static final int NULL_SUB_INDEXER = -3;
    @NotNull
    private final PersistentSubIndexerVersionEnumerator<SubIndexerVersion> myPersistentVersionEnumerator;
    @NotNull
    private final FileAttribute myFileAttribute;
    @NotNull
    private final CompositeDataIndexer<?, ?, SubIndexerType, SubIndexerVersion> myIndexer;
    private static final Map<Pair<String, Integer>, FileAttribute> ourAttributes = new HashMap<Pair<String, Integer>, FileAttribute>();

    public PersistentSubIndexerRetriever(@NotNull ID<?, ?> id2, int indexVersion, @NotNull CompositeDataIndexer<?, ?, SubIndexerType, SubIndexerVersion> indexer) throws IOException {
        if (id2 == null) {
            PersistentSubIndexerRetriever.$$$reportNull$$$0(0);
        }
        if (indexer == null) {
            PersistentSubIndexerRetriever.$$$reportNull$$$0(1);
        }
        this(IndexInfrastructure.getIndexRootDir(id2), id2.getName(), indexVersion, indexer);
    }

    @TestOnly
    PersistentSubIndexerRetriever(@NotNull Path root, @NotNull String indexName, int indexVersion, @NotNull CompositeDataIndexer<?, ?, SubIndexerType, SubIndexerVersion> indexer) throws IOException {
        if (root == null) {
            PersistentSubIndexerRetriever.$$$reportNull$$$0(2);
        }
        if (indexName == null) {
            PersistentSubIndexerRetriever.$$$reportNull$$$0(3);
        }
        if (indexer == null) {
            PersistentSubIndexerRetriever.$$$reportNull$$$0(4);
        }
        Path versionMapRoot = root.resolve(PersistentSubIndexerRetriever.versionMapRoot());
        this.myFileAttribute = PersistentSubIndexerRetriever.getFileAttribute(indexName, indexVersion);
        this.myIndexer = indexer;
        this.myPersistentVersionEnumerator = new PersistentSubIndexerVersionEnumerator(versionMapRoot.resolve(INDEXED_VERSIONS).toFile(), indexer.getSubIndexerVersionDescriptor());
    }

    public void clear() throws IOException {
        this.myPersistentVersionEnumerator.clear();
    }

    @Override
    public void close() throws IOException {
        this.myPersistentVersionEnumerator.close();
    }

    public void flush() throws IOException {
        this.myPersistentVersionEnumerator.flush();
    }

    private static Path versionMapRoot() {
        return Paths.get(".perFileVersion", INDEXED_VERSIONS);
    }

    public void setIndexedState(int fileId, @NotNull IndexedFile file2) throws IOException {
        if (file2 == null) {
            PersistentSubIndexerRetriever.$$$reportNull$$$0(5);
        }
        int indexerId = ProgressManager.getInstance().computeInNonCancelableSection(() -> this.getFileIndexerId(file2));
        this.setFileIndexerId(fileId, indexerId);
    }

    public void setUnindexedState(int fileId) throws IOException {
        this.setFileIndexerId(fileId, -2);
    }

    public void setFileIndexerId(int fileId, int indexerId) throws IOException {
        try (AttributeOutputStream stream = FSRecords.writeAttribute((int)fileId, (FileAttribute)this.myFileAttribute);){
            DataInputOutputUtil.writeINT(stream, indexerId);
        }
    }

    public FileIndexingState getSubIndexerState(int fileId, @NotNull IndexedFile file2) throws IOException {
        if (file2 == null) {
            PersistentSubIndexerRetriever.$$$reportNull$$$0(6);
        }
        try (AttributeInputStream stream = FSRecords.readAttributeWithLock((int)fileId, (FileAttribute)this.myFileAttribute);){
            if (stream != null) {
                int currentIndexedVersion = DataInputOutputUtil.readINT(stream);
                if (currentIndexedVersion == -2) {
                    FileIndexingState fileIndexingState = FileIndexingState.NOT_INDEXED;
                    return fileIndexingState;
                }
                int actualVersion = this.getFileIndexerId(file2);
                FileIndexingState fileIndexingState = actualVersion == currentIndexedVersion ? FileIndexingState.UP_TO_DATE : FileIndexingState.OUT_DATED;
                return fileIndexingState;
            }
            FileIndexingState fileIndexingState = FileIndexingState.NOT_INDEXED;
            return fileIndexingState;
        }
    }

    public int getFileIndexerId(@NotNull IndexedFile file2) throws IOException {
        SubIndexerVersion version;
        if (file2 == null) {
            PersistentSubIndexerRetriever.$$$reportNull$$$0(7);
        }
        if ((version = this.getVersion(file2)) == null) {
            return -3;
        }
        return this.myPersistentVersionEnumerator.enumerate(version);
    }

    @Nullable
    public SubIndexerVersion getVersion(@NotNull IndexedFile file2) {
        Object type;
        if (file2 == null) {
            PersistentSubIndexerRetriever.$$$reportNull$$$0(8);
        }
        if ((type = this.myIndexer.calculateSubIndexer(file2)) == null) {
            return null;
        }
        return (SubIndexerVersion)this.myIndexer.getSubIndexerVersion(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileAttribute getFileAttribute(String name2, int version) {
        Map<Pair<String, Integer>, FileAttribute> map2 = ourAttributes;
        synchronized (map2) {
            return ourAttributes.computeIfAbsent(new Pair<String, Integer>(name2, version), __ -> new FileAttribute(name2 + ".index.version", version, false));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/impl/perFileVersion/PersistentSubIndexerRetriever";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setIndexedState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getSubIndexerState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileIndexerId";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

