/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.storage.AbstractIntLog;
import com.intellij.util.indexing.impl.storage.IntLog;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.keyStorage.AppendableObjectStorage;
import com.intellij.util.io.keyStorage.AppendableStorageBackedByResizableMappedFile;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 ,2\u00020\u0001:\u0002,-B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0002J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u0003H\u0002J\u0006\u0010\u001a\u001a\u00020\u0003J\b\u0010\u001b\u001a\u00020\u0005H\u0007J\u0016\u0010\u001c\u001a\u0010\u0012\f\u0012\n \u001e*\u0004\u0018\u00010\u000f0\u000f0\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u0011H\u0002J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0011H\u0002J\b\u0010$\u001a\u00020%H\u0016J)\u0010&\u001a\u0002H'\"\u0004\b\u0000\u0010'2\u0006\u0010(\u001a\u00020\u00052\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H'0*H\u0002\u00a2\u0006\u0002\u0010+R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/util/indexing/impl/storage/IntLog;", "Lcom/intellij/util/indexing/impl/storage/AbstractIntLog;", "baseStorageFile", "Ljava/nio/file/Path;", "compact", "", "storageLockContext", "Lcom/intellij/util/io/StorageLockContext;", "(Ljava/nio/file/Path;ZLcom/intellij/util/io/StorageLockContext;)V", "modificationStamp", "", "getModificationStamp", "()J", "myKeyHashToVirtualFileMapping", "Lcom/intellij/util/io/keyStorage/AppendableObjectStorage;", "", "addData", "", "data", "", "inputId", "clear", "close", "doForce", "flush", "getCompactionMarker", "getDataFile", "isRequiresCompaction", "openLog", "Lcom/intellij/util/io/keyStorage/AppendableStorageBackedByResizableMappedFile;", "kotlin.jvm.PlatformType", "performCompaction", "processEntries", "processor", "Lcom/intellij/util/indexing/impl/storage/AbstractIntLog$IntLogEntryProcessor;", "setRequiresCompaction", "toString", "", "withLock", "T", "read", "operation", "Lkotlin/Function0;", "(ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "IntPairInArrayKeyDescriptor", "intellij.platform.lang.impl"})
public final class IntLog
implements AbstractIntLog {
    private volatile AppendableObjectStorage<int[]> myKeyHashToVirtualFileMapping;
    private final long modificationStamp;
    private final Path baseStorageFile;
    private final StorageLockContext storageLockContext;
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean processEntries(@NotNull AbstractIntLog.IntLogEntryProcessor processor) throws StorageException {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        try {
            void usefulRecords;
            void uselessRecords;
            long l = System.currentTimeMillis();
            this.doForce();
            BitSet uniqueInputs = new BitSet();
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = 0;
            Ref.IntRef intRef2 = new Ref.IntRef();
            intRef2.element = 0;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
            boolean isReadAction = application.isReadAccessAllowed();
            if (isReadAction) {
                ProgressManager.checkCanceled();
            }
            this.withLock(true, (Function0)new Function0<Boolean>(this, isReadAction, processor, uniqueInputs, (Ref.IntRef)uselessRecords, (Ref.IntRef)usefulRecords){
                final /* synthetic */ IntLog this$0;
                final /* synthetic */ boolean $isReadAction;
                final /* synthetic */ AbstractIntLog.IntLogEntryProcessor $processor;
                final /* synthetic */ BitSet $uniqueInputs;
                final /* synthetic */ Ref.IntRef $uselessRecords;
                final /* synthetic */ Ref.IntRef $usefulRecords;

                public final boolean invoke() {
                    return IntLog.access$getMyKeyHashToVirtualFileMapping$p(this.this$0).processAll(new AppendableObjectStorage.StorageObjectProcessor(this){
                        final /* synthetic */ processEntries.1 this$0;

                        public final boolean process(int $noName_0, int[] key) {
                            int inputId;
                            int data2;
                            if (this.this$0.$isReadAction) {
                                ProgressManager.checkCanceled();
                            }
                            if (!this.this$0.$processor.process(data2 = key[0], inputId = key[1])) {
                                return false;
                            }
                            boolean isPresent = this.this$0.$uniqueInputs.get(inputId);
                            if (isPresent) {
                                int n = this.this$0.$uselessRecords.element;
                                this.this$0.$uselessRecords.element = n + 1;
                            } else {
                                this.this$0.$uniqueInputs.set(inputId);
                                int n = this.this$0.$usefulRecords.element;
                                this.this$0.$usefulRecords.element = n + 1;
                            }
                            return true;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = intLog;
                    this.$isReadAction = bl;
                    this.$processor = intLogEntryProcessor;
                    this.$uniqueInputs = bitSet;
                    this.$uselessRecords = intRef;
                    this.$usefulRecords = intRef2;
                    super(0);
                }
            });
            if (uselessRecords.element >= usefulRecords.element) {
                this.setRequiresCompaction();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scanned IntLog of " + this.baseStorageFile + " for " + (System.currentTimeMillis() - l));
            }
            return true;
        }
        catch (IOException e) {
            throw (Throwable)new StorageException(e);
        }
    }

    @Override
    public void clear() {
        try {
            this.close();
        }
        catch (Exception e) {
            LOG.error(e);
        }
        IOUtil.deleteAllFilesStartingWith(this.baseStorageFile);
        this.myKeyHashToVirtualFileMapping = this.openLog();
    }

    private final AppendableStorageBackedByResizableMappedFile<int[]> openLog() {
        return new AppendableStorageBackedByResizableMappedFile<int[]>(this.getDataFile(), 4096, this.storageLockContext, 0x100000, true, IntPairInArrayKeyDescriptor.INSTANCE);
    }

    @Override
    public void addData(int data2, int inputId) throws StorageException {
        if (inputId == 0) {
            return;
        }
        try {
            this.withLock(false, (Function0)new Function0<Integer>(this, data2, inputId){
                final /* synthetic */ IntLog this$0;
                final /* synthetic */ int $data;
                final /* synthetic */ int $inputId;

                public final int invoke() {
                    return IntLog.access$getMyKeyHashToVirtualFileMapping$p(this.this$0).append(new int[]{this.$data, this.$inputId});
                }
                {
                    this.this$0 = intLog;
                    this.$data = n;
                    this.$inputId = n2;
                    super(0);
                }
            });
        }
        catch (IOException e) {
            throw (Throwable)new StorageException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.myKeyHashToVirtualFileMapping.isDirty()) {
            this.doForce();
        }
    }

    @Override
    public void close() throws IOException {
        this.withLock(false, (Function0)new Function0<Unit>(this){
            final /* synthetic */ IntLog this$0;

            public final void invoke() {
                IntLog.access$getMyKeyHashToVirtualFileMapping$p(this.this$0).close();
            }
            {
                this.this$0 = intLog;
                super(0);
            }
        });
    }

    private final void doForce() throws IOException {
        this.withLock(false, (Function0)new Function0<Unit>(this){
            final /* synthetic */ IntLog this$0;

            public final void invoke() {
                IntLog.access$getMyKeyHashToVirtualFileMapping$p(this.this$0).force();
            }
            {
                this.this$0 = intLog;
                super(0);
            }
        });
    }

    @Override
    public long getModificationStamp() {
        return this.modificationStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withLock(boolean read, Function0<? extends T> operation) {
        if (read) {
            this.myKeyHashToVirtualFileMapping.lockRead();
        } else {
            this.myKeyHashToVirtualFileMapping.lockWrite();
        }
        try {
            Object object = operation.invoke();
            return (T)object;
        }
        finally {
            if (read) {
                this.myKeyHashToVirtualFileMapping.unlockRead();
            } else {
                this.myKeyHashToVirtualFileMapping.unlockWrite();
            }
        }
    }

    private final void setRequiresCompaction() {
        Path marker = this.getCompactionMarker();
        if (Files.exists(marker, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(marker.getParent(), new FileAttribute[0]);
            Files.createFile(marker, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @VisibleForTesting
    public final boolean isRequiresCompaction() {
        return Files.exists(this.getCompactionMarker(), new LinkOption[0]);
    }

    private final Path getCompactionMarker() {
        Path dataFile = this.getDataFile();
        Path path2 = dataFile.resolveSibling(((Object)dataFile.getFileName()).toString() + ".require.compaction");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"dataFile.resolveSibling(\u2026 + \".require.compaction\")");
        return path2;
    }

    @NotNull
    public final Path getDataFile() {
        Path path2 = this.baseStorageFile.resolveSibling(((Object)this.baseStorageFile.getFileName()).toString() + ".project");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"baseStorageFile.resolveS\u2026.toString() + \".project\")");
        return path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performCompaction() throws IOException {
        try {
            Object object;
            Int2ObjectMap data2 = new Int2ObjectOpenHashMap();
            Int2IntOpenHashMap forwardData = new Int2IntOpenHashMap();
            Path oldDataFile = this.getDataFile();
            AppendableStorageBackedByResizableMappedFile oldMapping = new AppendableStorageBackedByResizableMappedFile(oldDataFile, 0, this.storageLockContext, 0x100000, true, IntPairInArrayKeyDescriptor.INSTANCE);
            oldMapping.lockRead();
            try {
                oldMapping.processAll(new AppendableObjectStorage.StorageObjectProcessor(forwardData, data2){
                    final /* synthetic */ Int2IntOpenHashMap $forwardData;
                    final /* synthetic */ Int2ObjectMap $data;

                    public final boolean process(int $noName_0, @NotNull int[] key) {
                        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                        int inputId = key[1];
                        int dataKey = key[0];
                        int absInputId = Math.abs(inputId);
                        if (dataKey == 0) {
                            IntSet associatedInputIds;
                            int currentKeyHash = this.$forwardData.get(inputId);
                            IntSet intSet = associatedInputIds = (IntSet)this.$data.get(currentKeyHash);
                            if (intSet != null) {
                                intSet.remove(absInputId);
                            }
                        } else if (inputId > 0) {
                            ((IntSet)this.$data.computeIfAbsent(dataKey, performCompaction.1.INSTANCE)).add(absInputId);
                            ((Map)this.$forwardData).put(absInputId, dataKey);
                        } else {
                            IntSet associatedInputIds;
                            IntSet intSet = associatedInputIds = (IntSet)this.$data.get(dataKey);
                            if (intSet != null) {
                                intSet.remove(absInputId);
                            }
                            this.$forwardData.remove(absInputId);
                        }
                        return true;
                    }
                    {
                        this.$forwardData = int2IntOpenHashMap;
                        this.$data = int2ObjectMap;
                    }
                });
                oldMapping.close();
            }
            finally {
                oldMapping.unlockRead();
            }
            String dataFileName = ((Object)oldDataFile.getFileName()).toString();
            String newDataFileName = "new." + dataFileName;
            Path newDataFile = oldDataFile.resolveSibling(newDataFileName);
            AppendableStorageBackedByResizableMappedFile<int[]> newMapping = new AppendableStorageBackedByResizableMappedFile<int[]>(newDataFile, 64 * data2.size(), this.storageLockContext, 0x100000, true, IntPairInArrayKeyDescriptor.INSTANCE);
            newMapping.lockWrite();
            try {
                object = data2.int2ObjectEntrySet().iterator();
                while (object.hasNext()) {
                    IntIterator inputIdIterator;
                    Int2ObjectMap.Entry entry;
                    Int2ObjectMap.Entry entry2 = entry = (Int2ObjectMap.Entry)object.next();
                    Intrinsics.checkNotNullExpressionValue((Object)entry2, (String)"entry");
                    int keyHash = entry2.getIntKey();
                    Intrinsics.checkNotNullExpressionValue((Object)((IntSet)entry.getValue()).iterator(), (String)"entry.value.iterator()");
                    while (inputIdIterator.hasNext()) {
                        int inputId = inputIdIterator.nextInt();
                        newMapping.append(new int[]{keyHash, inputId});
                    }
                }
                newMapping.close();
            }
            finally {
                newMapping.unlockWrite();
            }
            IOUtil.deleteAllFilesStartingWith(oldDataFile.toFile());
            Path path2 = newDataFile;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"newDataFile");
            Closeable closeable = Files.newDirectoryStream(path2.getParent());
            object = null;
            try {
                DirectoryStream paths2 = (DirectoryStream)closeable;
                boolean bl = false;
                Iterator iterator = paths2.iterator();
                while (iterator.hasNext()) {
                    Path path3;
                    Path path4 = path3 = (Path)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"path");
                    String name2 = ((Object)path4.getFileName()).toString();
                    if (!StringsKt.startsWith$default((String)name2, (String)newDataFileName, (boolean)false, (int)2, null)) continue;
                    File file2 = path3.toFile();
                    String string2 = name2;
                    int n = newDataFileName.length();
                    String string3 = string2.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                    FileUtil.rename(file2, dataFileName + string3);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
            }
            try {
                Files.delete(this.getCompactionMarker());
            }
            catch (IOException iOException) {}
        }
        catch (ProcessCanceledException e) {
            LOG.error(e);
            throw (Throwable)e;
        }
    }

    @NotNull
    public String toString() {
        return "super.toString()";
    }

    public IntLog(@NotNull Path baseStorageFile, boolean compact, @Nullable StorageLockContext storageLockContext) throws IOException {
        Intrinsics.checkNotNullParameter((Object)baseStorageFile, (String)"baseStorageFile");
        this.baseStorageFile = baseStorageFile;
        this.storageLockContext = storageLockContext;
        if (compact && this.isRequiresCompaction()) {
            this.performCompaction();
        }
        this.myKeyHashToVirtualFileMapping = this.openLog();
        this.modificationStamp = this.myKeyHashToVirtualFileMapping.getCurrentLength();
    }

    public /* synthetic */ IntLog(Path path2, boolean bl, StorageLockContext storageLockContext, int n, DefaultConstructorMarker defaultConstructorMarker) throws IOException {
        if ((n & 4) != 0) {
            storageLockContext = null;
        }
        this(path2, bl, storageLockContext);
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IntLog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ AppendableObjectStorage access$getMyKeyHashToVirtualFileMapping$p(IntLog $this) {
        return $this.myKeyHashToVirtualFileMapping;
    }

    public static final /* synthetic */ void access$setMyKeyHashToVirtualFileMapping$p(IntLog $this, AppendableObjectStorage appendableObjectStorage) {
        $this.myKeyHashToVirtualFileMapping = appendableObjectStorage;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/util/indexing/impl/storage/IntLog$IntPairInArrayKeyDescriptor;", "Lcom/intellij/util/io/DataExternalizer;", "", "()V", "read", "in", "Ljava/io/DataInput;", "save", "", "out", "Ljava/io/DataOutput;", "value", "intellij.platform.lang.impl"})
    private static final class IntPairInArrayKeyDescriptor
    implements DataExternalizer<int[]> {
        @NotNull
        public static final IntPairInArrayKeyDescriptor INSTANCE;

        @Override
        public void save(@NotNull DataOutput out, @NotNull int[] value) throws IOException {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            DataInputOutputUtil.writeINT(out, value[0]);
            DataInputOutputUtil.writeINT(out, value[1]);
        }

        @Override
        @NotNull
        public int[] read(@NotNull DataInput in) throws IOException {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            return new int[]{DataInputOutputUtil.readINT(in), DataInputOutputUtil.readINT(in)};
        }

        private IntPairInArrayKeyDescriptor() {
        }

        static {
            IntPairInArrayKeyDescriptor intPairInArrayKeyDescriptor;
            INSTANCE = intPairInArrayKeyDescriptor = new IntPairInArrayKeyDescriptor();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/indexing/impl/storage/IntLog$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.platform.lang.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

