/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.indexing.impl.storage.KeyHashLog;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.KeyDescriptor;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class VfsAwareMapIndexStorage<Key, Value>
extends MapIndexStorage<Key, Value>
implements VfsAwareIndexStorage<Key, Value> {
    private final boolean myBuildKeyHashToVirtualFileMapping;
    @Nullable
    private KeyHashLog<Key> myKeyHashToVirtualFileMapping;

    @TestOnly
    public VfsAwareMapIndexStorage(Path storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean readOnly) throws IOException {
        if (keyDescriptor == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(0);
        }
        if (valueExternalizer == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(1);
        }
        super(storageFile, keyDescriptor, valueExternalizer, cacheSize, false, true, readOnly, false, null);
        this.myBuildKeyHashToVirtualFileMapping = false;
    }

    public VfsAwareMapIndexStorage(Path storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean keyIsUniqueForIndexedFile, boolean buildKeyHashToVirtualFileMapping, boolean enableWal) throws IOException {
        if (keyDescriptor == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(2);
        }
        if (valueExternalizer == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(3);
        }
        super(storageFile, keyDescriptor, valueExternalizer, cacheSize, keyIsUniqueForIndexedFile, false, false, enableWal, null);
        this.myBuildKeyHashToVirtualFileMapping = buildKeyHashToVirtualFileMapping;
        this.initMapAndCache();
    }

    @Override
    protected void initMapAndCache() throws IOException {
        super.initMapAndCache();
        if (this.myBuildKeyHashToVirtualFileMapping && this.myBaseStorageFile != null) {
            FileSystem projectFileFS = this.myBaseStorageFile.getFileSystem();
            assert (!projectFileFS.isReadOnly()) : "File system " + projectFileFS + " is read only";
            this.myKeyHashToVirtualFileMapping = new KeyHashLog(this.myKeyDescriptor, this.myBaseStorageFile);
        } else {
            this.myKeyHashToVirtualFileMapping = null;
        }
    }

    @Override
    public void flush() throws IOException {
        this.l.lock();
        try {
            super.flush();
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.myKeyHashToVirtualFileMapping.force();
            }
        }
        finally {
            this.l.unlock();
        }
    }

    @Override
    public void close() throws StorageException {
        super.close();
        try {
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.myKeyHashToVirtualFileMapping.close();
            }
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            VfsAwareMapIndexStorage.unwrapCauseAndRethrow(e);
        }
    }

    @Override
    public void clear() throws StorageException {
        try {
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.myKeyHashToVirtualFileMapping.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processKeys(@NotNull Processor<? super Key> processor, GlobalSearchScope scope, @Nullable IdFilter idFilter) throws StorageException {
        if (processor == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(4);
        }
        ProgressIndicatorUtils.awaitWithCheckCanceled((Lock)this.l, (int)10, (TimeUnit)TimeUnit.MILLISECONDS);
        try {
            IntSet hashMaskSet;
            this.myCache.clear();
            Project project2 = scope.getProject();
            if (this.myKeyHashToVirtualFileMapping != null && project2 != null && idFilter != null && (hashMaskSet = this.myKeyHashToVirtualFileMapping.getSuitableKeyHashes(idFilter, project2)) != null) {
                boolean bl = this.doProcessKeys(key -> {
                    if (!hashMaskSet.contains(this.myKeyDescriptor.getHashCode(key))) {
                        return true;
                    }
                    return processor.process((Key)key);
                });
                return bl;
            }
            boolean bl = this.doProcessKeys(processor);
            return bl;
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            boolean bl = (Boolean)VfsAwareMapIndexStorage.unwrapCauseAndRethrow(e);
            return bl;
        }
        finally {
            this.l.unlock();
        }
    }

    @Override
    public void removeAllValues(@NotNull Key key, int inputId) throws StorageException {
        if (key == null) {
            VfsAwareMapIndexStorage.$$$reportNull$$$0(5);
        }
        if (this.myKeyHashToVirtualFileMapping != null) {
            this.myKeyHashToVirtualFileMapping.removeKeyHashToVirtualFileMapping(key, inputId);
        }
        super.removeAllValues(key, inputId);
    }

    @Override
    public void addValue(Key key, int inputId, Value value) throws StorageException {
        if (this.myKeyHashToVirtualFileMapping != null) {
            this.myKeyHashToVirtualFileMapping.addKeyHashToVirtualFileMapping(key, inputId);
        }
        super.addValue(key, inputId, value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/indexing/impl/storage/VfsAwareMapIndexStorage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processKeys";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeAllValues";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

