/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.memory;

import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.IndexStorageUtil;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.io.KeyDescriptor;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InMemoryIndexStorage<K, V>
implements VfsAwareIndexStorage<K, V> {
    private final Map<K, ValueContainerImpl<V>> myMap;

    public InMemoryIndexStorage(@NotNull KeyDescriptor<K> keyDescriptor) {
        if (keyDescriptor == null) {
            InMemoryIndexStorage.$$$reportNull$$$0(0);
        }
        this.myMap = IndexStorageUtil.createKeyDescriptorHashedMap(keyDescriptor);
    }

    public boolean processKeys(@NotNull Processor<? super K> processor, GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (processor == null) {
            InMemoryIndexStorage.$$$reportNull$$$0(1);
        }
        return this.myMap.keySet().stream().allMatch(processor::process);
    }

    public void addValue(K k, int inputId, V v) {
        this.myMap.computeIfAbsent(k, __ -> new ValueContainerImpl()).addValue(inputId, v);
    }

    public void removeAllValues(@NotNull K k, int inputId) {
        ValueContainerImpl<V> container;
        if (k == null) {
            InMemoryIndexStorage.$$$reportNull$$$0(2);
        }
        if ((container = this.myMap.get(k)) == null) {
            return;
        }
        container.removeAssociatedValue(inputId);
        if (container.size() == 0) {
            this.myMap.remove(k);
        }
    }

    public void clear() {
        this.myMap.clear();
    }

    @NotNull
    public ValueContainer<V> read(K k) throws StorageException {
        ValueContainer valueContainer = ObjectUtils.notNull(this.myMap.get(k), new ValueContainerImpl());
        if (valueContainer == null) {
            InMemoryIndexStorage.$$$reportNull$$$0(3);
        }
        return valueContainer;
    }

    public void clearCaches() {
    }

    public void close() {
    }

    public void flush() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/memory/InMemoryIndexStorage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/memory/InMemoryIndexStorage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeAllValues";
                break;
            }
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

