/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.roots.IndexableFilesIterationMethods;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.PartialAdditionalLibraryIndexableSetOrigin;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B*\u0012\r\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0003H\u0002J\b\u0010\u001d\u001a\u00020\u0003H\u0002R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/util/indexing/roots/AdditionalLibraryIndexableAddedFilesIterator;", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "presentableLibraryName", "", "Lorg/jetbrains/annotations/Nls;", "rootsToIndex", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "libraryNameForDebug", "(Ljava/lang/String;Ljava/util/Collection;Ljava/lang/String;)V", "getLibraryNameForDebug", "()Ljava/lang/String;", "getPresentableLibraryName", "getDebugName", "getIndexingProgressText", "getOrigin", "Lcom/intellij/util/indexing/roots/kind/IndexableSetOrigin;", "getRootUrls", "", "project", "Lcom/intellij/openapi/project/Project;", "getRootsScanningProgressText", "iterateFiles", "", "fileIterator", "Lcom/intellij/openapi/roots/ContentIterator;", "fileFilter", "Lcom/intellij/openapi/vfs/VirtualFileFilter;", "libDebugDescription", "rootsDebugDescription", "intellij.platform.lang.impl"})
public final class AdditionalLibraryIndexableAddedFilesIterator
implements IndexableFilesIterator {
    @Nullable
    private final String presentableLibraryName;
    private final Collection<VirtualFile> rootsToIndex;
    @NotNull
    private final String libraryNameForDebug;

    @NotNull
    public String getDebugName() {
        return this.libDebugDescription() + " " + this.rootsDebugDescription() + " roots";
    }

    private final String libDebugDescription() {
        String string2 = this.presentableLibraryName;
        if (string2 == null) {
            string2 = this.libraryNameForDebug;
        }
        return "Additional library change reindexing iterator for " + string2 + " library";
    }

    private final String rootsDebugDescription() {
        if (this.rootsToIndex.isEmpty()) {
            return "empty";
        }
        if (this.rootsToIndex.size() > 5) {
            return String.valueOf(this.rootsToIndex.size());
        }
        return CollectionsKt.joinToString$default((Iterable)this.rootsToIndex, null, null, null, (int)0, null, null, (int)63, null);
    }

    @NotNull
    public String getIndexingProgressText() {
        String string2;
        block3: {
            block2: {
                String string3;
                string2 = this.presentableLibraryName;
                if (string2 == null) break block2;
                String it = string3 = string2;
                boolean bl = false;
                string2 = IndexingBundle.message((String)"progress.text.additional.library.indexing.added.files", (Object[])new Object[]{it});
                if (string2 != null) break block3;
            }
            String string4 = IndexingBundle.message((String)"progress.text.additional.library.indexing.unknown.added.files", (Object[])new Object[0]);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"IndexingBundle.message(\"\u2026ing.unknown.added.files\")");
        }
        return string2;
    }

    @NotNull
    public String getRootsScanningProgressText() {
        String string2;
        block3: {
            block2: {
                String string3;
                string2 = this.presentableLibraryName;
                if (string2 == null) break block2;
                String it = string3 = string2;
                boolean bl = false;
                string2 = IndexingBundle.message((String)"progress.text.additional.library.scanning.added.files", (Object[])new Object[]{it});
                if (string2 != null) break block3;
            }
            String string4 = IndexingBundle.message((String)"progress.text.additional.library.scanning.unknown.added.files", (Object[])new Object[0]);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"IndexingBundle.message(\"\u2026ing.unknown.added.files\")");
        }
        return string2;
    }

    @NotNull
    public IndexableSetOrigin getOrigin() {
        return new PartialAdditionalLibraryIndexableSetOrigin(this.rootsToIndex);
    }

    public boolean iterateFiles(@NotNull Project project2, @NotNull ContentIterator fileIterator, @NotNull VirtualFileFilter fileFilter) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileIterator, (String)"fileIterator");
        Intrinsics.checkNotNullParameter((Object)fileFilter, (String)"fileFilter");
        return IndexableFilesIterationMethods.INSTANCE.iterateRoots(project2, (Iterable<? extends VirtualFile>)this.rootsToIndex, fileIterator, fileFilter, true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> getRootUrls(@NotNull Project project2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Iterable $this$map$iv = this.rootsToIndex;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getUrl();
            collection.add(string2);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Nullable
    public final String getPresentableLibraryName() {
        return this.presentableLibraryName;
    }

    @NotNull
    public final String getLibraryNameForDebug() {
        return this.libraryNameForDebug;
    }

    public AdditionalLibraryIndexableAddedFilesIterator(@Nullable String presentableLibraryName, @NotNull Collection<? extends VirtualFile> rootsToIndex, @NotNull String libraryNameForDebug) {
        Intrinsics.checkNotNullParameter(rootsToIndex, (String)"rootsToIndex");
        Intrinsics.checkNotNullParameter((Object)libraryNameForDebug, (String)"libraryNameForDebug");
        this.presentableLibraryName = presentableLibraryName;
        this.rootsToIndex = rootsToIndex;
        this.libraryNameForDebug = libraryNameForDebug;
    }
}

