/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.builders.IndexableIteratorBuilders;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.bridgeEntities.api.ContentRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.ModuleEntity;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

class ContentRootIndexableEntityProvider
implements IndexableEntityProvider.ModuleEntityDependent<ContentRootEntity>,
IndexableEntityProvider.Existing<ContentRootEntity> {
    ContentRootIndexableEntityProvider() {
    }

    @Override
    @NotNull
    public Class<ContentRootEntity> getEntityClass() {
        return ContentRootEntity.class;
    }

    @Override
    @NotNull
    public Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> getIteratorBuildersForExistingModule(@NotNull ModuleEntity entity, @NotNull EntityStorage entityStorage, @NotNull Project project2) {
        if (entity == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(0);
        }
        if (entityStorage == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(2);
        }
        Collection<IndexableEntityProvider.IndexableIteratorBuilder> collection = IndexableIteratorBuilders.INSTANCE.forModuleRoots(entity.getPersistentId(), ContentRootIndexableEntityProvider.collectRootUrls(entity.getContentRoots()));
        if (collection == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> getAddedEntityIteratorBuilders(@NotNull ContentRootEntity entity, @NotNull Project project2) {
        if (entity == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(5);
        }
        Collection<IndexableEntityProvider.IndexableIteratorBuilder> collection = IndexableIteratorBuilders.INSTANCE.forModuleRoots(entity.getModule().getPersistentId(), entity.getUrl());
        if (collection == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> getReplacedEntityIteratorBuilders(@NotNull ContentRootEntity oldEntity, @NotNull ContentRootEntity newEntity2) {
        if (oldEntity == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(7);
        }
        if (newEntity2 == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(8);
        }
        if (!newEntity2.getExcludedPatterns().equals(oldEntity.getExcludedPatterns())) {
            Collection<IndexableEntityProvider.IndexableIteratorBuilder> collection = IndexableIteratorBuilders.INSTANCE.forModuleRoots(newEntity2.getModule().getPersistentId(), newEntity2.getUrl());
            if (collection == null) {
                ContentRootIndexableEntityProvider.$$$reportNull$$$0(9);
            }
            return collection;
        }
        List newExcludedUrls = newEntity2.getExcludedUrls();
        List oldExcludedUrls = oldEntity.getExcludedUrls();
        if (!oldExcludedUrls.equals(newExcludedUrls)) {
            ArrayList<VirtualFileUrl> roots2 = new ArrayList<VirtualFileUrl>();
            for (VirtualFileUrl oldUrl : oldExcludedUrls) {
                boolean found2 = false;
                String oldPath = oldUrl.getUrl();
                for (VirtualFileUrl newUrl : newExcludedUrls) {
                    if (!VfsUtilCore.isEqualOrAncestor(newUrl.getUrl(), oldPath)) continue;
                    found2 = true;
                    break;
                }
                if (found2) continue;
                roots2.add(oldUrl);
            }
            Collection<IndexableEntityProvider.IndexableIteratorBuilder> collection = IndexableIteratorBuilders.INSTANCE.forModuleRoots(newEntity2.getModule().getPersistentId(), roots2);
            if (collection == null) {
                ContentRootIndexableEntityProvider.$$$reportNull$$$0(10);
            }
            return collection;
        }
        List list2 = Collections.emptyList();
        if (list2 == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> getReplacedModuleEntityIteratorBuilder(@NotNull ModuleEntity oldEntity, @NotNull ModuleEntity newEntity2, @NotNull Project project2) {
        if (oldEntity == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(12);
        }
        if (newEntity2 == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(13);
        }
        if (project2 == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(14);
        }
        List<VirtualFileUrl> newRoots = ContentRootIndexableEntityProvider.collectRootUrls(newEntity2.getContentRoots());
        List<VirtualFileUrl> oldRoots = ContentRootIndexableEntityProvider.collectRootUrls(oldEntity.getContentRoots());
        Collection<IndexableEntityProvider.IndexableIteratorBuilder> collection = IndexableIteratorBuilders.INSTANCE.forModuleRoots(newEntity2.getPersistentId(), newRoots, oldRoots);
        if (collection == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @NotNull
    private static List<VirtualFileUrl> collectRootUrls(List<ContentRootEntity> newContentRoots) {
        List<VirtualFileUrl> list2 = newContentRoots.stream().map(o -> o.getUrl()).filter(o -> o != null).collect(Collectors.toList());
        if (list2 == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @Override
    @NotNull
    public Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> getRemovedEntityIteratorBuilders(@NotNull ContentRootEntity entity, @NotNull Project project2) {
        VirtualFile root;
        if (entity == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(17);
        }
        if (project2 == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(18);
        }
        if (!(entity.getExcludedPatterns().isEmpty() && entity.getExcludedUrls().isEmpty() || (root = ((VirtualFilePointer)entity.getUrl()).getFile()) == null || !ProjectFileIndex.getInstance(project2).isInContent(root))) {
            Collection<IndexableEntityProvider.IndexableIteratorBuilder> collection = IndexableIteratorBuilders.INSTANCE.forModuleRoots(entity.getModule().getPersistentId(), entity.getUrl());
            if (collection == null) {
                ContentRootIndexableEntityProvider.$$$reportNull$$$0(19);
            }
            return collection;
        }
        List list2 = Collections.emptyList();
        if (list2 == null) {
            ContentRootIndexableEntityProvider.$$$reportNull$$$0(20);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityStorage";
                break;
            }
            case 2: 
            case 5: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/roots/ContentRootIndexableEntityProvider";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldEntity";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEntity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/roots/ContentRootIndexableEntityProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIteratorBuildersForExistingModule";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddedEntityIteratorBuilders";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacedEntityIteratorBuilders";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacedModuleEntityIteratorBuilder";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectRootUrls";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemovedEntityIteratorBuilders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIteratorBuildersForExistingModule";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAddedEntityIteratorBuilders";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReplacedEntityIteratorBuilders";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getReplacedModuleEntityIteratorBuilder";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRemovedEntityIteratorBuilders";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

