/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.roots.DefaultProjectIndexableFilesContributor;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.LibraryIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.ModuleIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.SdkIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.builders.IndexableIteratorBuilders;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryBridge;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.ProjectLibraryTableBridgeImpl;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.ModuleEntityUtils;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.ModuleEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\f\u001a\u00020\rJ$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0014\u001a\u00020\u0011J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013J \u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u001b"}, d2={"Lcom/intellij/util/indexing/roots/IndexableEntityProviderMethods;", "", "()V", "createIterators", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "module", "Lcom/intellij/openapi/module/Module;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "entity", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/ModuleEntity;", "entityStorage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "project", "Lcom/intellij/openapi/project/Project;", "storage", "createLibraryIterators", "name", "", "getLibIteratorsByName", "libraryTable", "Lcom/intellij/openapi/roots/libraries/LibraryTable;", "intellij.platform.lang.impl"})
public final class IndexableEntityProviderMethods {
    @NotNull
    public static final IndexableEntityProviderMethods INSTANCE;

    @NotNull
    public final Collection<IndexableFilesIterator> createIterators(@NotNull ModuleEntity entity, @NotNull List<? extends VirtualFile> roots2, @NotNull EntityStorage storage) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        if (roots2.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        ModuleBridge moduleBridge = ModuleEntityUtils.findModuleBridge(entity, storage);
        if (moduleBridge == null) {
            return CollectionsKt.emptyList();
        }
        ModuleBridge module = moduleBridge;
        return this.createIterators(module, roots2);
    }

    @NotNull
    public final Set<IndexableFilesIterator> createIterators(@NotNull Module module, @NotNull List<? extends VirtualFile> roots2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        return SetsKt.setOf((Object)new ModuleIndexableFilesIteratorImpl(module, roots2, true));
    }

    @NotNull
    public final Collection<IndexableFilesIterator> createIterators(@NotNull ModuleEntity entity, @NotNull EntityStorage entityStorage, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)entityStorage, (String)"entityStorage");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (DefaultProjectIndexableFilesContributor.Companion.indexProjectBasedOnIndexableEntityProviders()) {
            if (ModuleEntityUtils.isModuleUnloaded(entity, entityStorage)) {
                return CollectionsKt.emptyList();
            }
            List builders = new ArrayList();
            ExtensionPointName<IndexableEntityProvider<? extends WorkspaceEntity>> extensionPointName = IndexableEntityProvider.EP_NAME;
            Intrinsics.checkNotNullExpressionValue(extensionPointName, (String)"IndexableEntityProvider.EP_NAME");
            for (IndexableEntityProvider<? extends WorkspaceEntity> provider2 : extensionPointName.getExtensionList()) {
                if (!(provider2 instanceof IndexableEntityProvider.Existing)) continue;
                Collection<IndexableEntityProvider.IndexableIteratorBuilder> collection = ((IndexableEntityProvider.Existing)provider2).getIteratorBuildersForExistingModule(entity, entityStorage, project2);
                Intrinsics.checkNotNullExpressionValue(collection, (String)"provider.getIteratorBuil\u2026, entityStorage, project)");
                builders.addAll(collection);
            }
            return IndexableIteratorBuilders.INSTANCE.instantiateBuilders(builders, project2, entityStorage);
        }
        ModuleBridge module = ModuleEntityUtils.findModuleBridge(entity, entityStorage);
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        return ModuleIndexableFilesIteratorImpl.Companion.getModuleIterators(module);
    }

    @NotNull
    public final Collection<IndexableFilesIterator> createIterators(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        return CollectionsKt.listOf((Object)new SdkIndexableFilesIteratorImpl(sdk2));
    }

    private final List<IndexableFilesIterator> getLibIteratorsByName(LibraryTable libraryTable, String name2) {
        List<IndexableFilesIterator> list2;
        Library library2 = libraryTable.getLibraryByName(name2);
        if (library2 != null) {
            Library library3;
            Library $this$run = library3 = library2;
            boolean bl = false;
            Library library4 = $this$run;
            Intrinsics.checkNotNullExpressionValue((Object)library4, (String)"this");
            list2 = LibraryIndexableFilesIteratorImpl.Companion.createIteratorList(library4);
        } else {
            list2 = null;
        }
        return list2;
    }

    @NotNull
    public final List<IndexableFilesIterator> createLibraryIterators(@NotNull String name2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        boolean $i$f$runReadAction = false;
        return (List)ApplicationManager.getApplication().runReadAction(new Computable(name2, project2){
            final /* synthetic */ String $name$inlined;
            final /* synthetic */ Project $project$inlined;
            {
                this.$name$inlined = string2;
                this.$project$inlined = project2;
            }

            public final T compute() {
                List<IndexableFilesIterator> list2;
                block4: {
                    block7: {
                        Object v6;
                        EntityStorage storage;
                        block5: {
                            LibraryTablesRegistrar registrar;
                            block6: {
                                List list3;
                                boolean bl = false;
                                LibraryTablesRegistrar libraryTablesRegistrar = registrar = LibraryTablesRegistrar.getInstance();
                                Intrinsics.checkNotNullExpressionValue((Object)libraryTablesRegistrar, (String)"registrar");
                                LibraryTable libraryTable = libraryTablesRegistrar.getLibraryTable();
                                Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"registrar.libraryTable");
                                List list4 = IndexableEntityProviderMethods.access$getLibIteratorsByName(IndexableEntityProviderMethods.INSTANCE, libraryTable, this.$name$inlined);
                                if (list4 == null) break block6;
                                List it = list3 = list4;
                                boolean bl2 = false;
                                list2 = it;
                                break block4;
                            }
                            Iterator<LibraryTable> it = registrar.getCustomLibraryTables().iterator();
                            while (it.hasNext()) {
                                List bl2;
                                LibraryTable customLibraryTable;
                                LibraryTable libraryTable = customLibraryTable = it.next();
                                Intrinsics.checkNotNullExpressionValue((Object)libraryTable, (String)"customLibraryTable");
                                List list5 = IndexableEntityProviderMethods.access$getLibIteratorsByName(IndexableEntityProviderMethods.INSTANCE, libraryTable, this.$name$inlined);
                                if (list5 == null) continue;
                                List it2 = bl2 = list5;
                                boolean bl = false;
                                list2 = it2;
                                break block4;
                            }
                            storage = WorkspaceModel.Companion.getInstance(this.$project$inlined).getEntityStorage().getCurrent();
                            Sequence $this$firstOrNull$iv = storage.entities(LibraryEntity.class);
                            boolean $i$f$firstOrNull = false;
                            for (E element$iv : $this$firstOrNull$iv) {
                                LibraryEntity it3 = (LibraryEntity)element$iv;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it3.getName(), (Object)this.$name$inlined)) continue;
                                v6 = element$iv;
                                break block5;
                            }
                            v6 = null;
                        }
                        if ((list2 = (LibraryEntity)v6) == null) break block7;
                        Object object = list2;
                        List it = object;
                        boolean bl = false;
                        list2 = (LibraryBridge)ProjectLibraryTableBridgeImpl.Companion.getLibraryMap(storage).getDataByEntity((WorkspaceEntity)it);
                        if (list2 == null) break block7;
                        Object $this$run = object = list2;
                        boolean bl3 = false;
                        list2 = LibraryIndexableFilesIteratorImpl.Companion.createIteratorList((Library)$this$run);
                        if (list2 != null) break block4;
                    }
                    list2 = CollectionsKt.emptyList();
                }
                return (T)list2;
            }
        });
    }

    private IndexableEntityProviderMethods() {
    }

    static {
        IndexableEntityProviderMethods indexableEntityProviderMethods;
        INSTANCE = indexableEntityProviderMethods = new IndexableEntityProviderMethods();
    }

    public static final /* synthetic */ List access$getLibIteratorsByName(IndexableEntityProviderMethods $this, LibraryTable libraryTable, String name2) {
        return $this.getLibIteratorsByName(libraryTable, name2);
    }
}

