/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.roots.IndexableFilesIterationMethods;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.LibraryIndexableFilesIterator;
import com.intellij.util.indexing.roots.LibraryIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.kind.LibraryOrigin;
import com.intellij.util.indexing.roots.origin.LibraryOriginImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B?\b\u0002\u0012\r\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u0012\u000b\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0005\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\""}, d2={"Lcom/intellij/util/indexing/roots/LibraryIndexableFilesIteratorImpl;", "Lcom/intellij/util/indexing/roots/LibraryIndexableFilesIterator;", "libraryName", "", "Lcom/intellij/openapi/util/NlsSafe;", "presentableLibraryName", "Lorg/jetbrains/annotations/Nls;", "classRootUrls", "", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "sourceRootUrls", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getClassRootUrls", "()Ljava/util/List;", "getLibraryName", "()Ljava/lang/String;", "getPresentableLibraryName", "getSourceRootUrls", "getDebugName", "getIndexingProgressText", "getOrigin", "Lcom/intellij/util/indexing/roots/kind/LibraryOrigin;", "getRootUrls", "", "project", "Lcom/intellij/openapi/project/Project;", "getRootsScanningProgressText", "iterateFiles", "", "fileIterator", "Lcom/intellij/openapi/roots/ContentIterator;", "fileFilter", "Lcom/intellij/openapi/vfs/VirtualFileFilter;", "Companion", "intellij.platform.lang.impl"})
public final class LibraryIndexableFilesIteratorImpl
implements LibraryIndexableFilesIterator {
    @Nullable
    private final String libraryName;
    @NotNull
    private final String presentableLibraryName;
    @NotNull
    private final List<VirtualFilePointer> classRootUrls;
    @NotNull
    private final List<VirtualFilePointer> sourceRootUrls;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String getDebugName() {
        return "Library " + this.presentableLibraryName;
    }

    @NotNull
    public String getIndexingProgressText() {
        String string2 = IndexingBundle.message((String)"indexable.files.provider.indexing.library.name", (Object[])new Object[]{this.presentableLibraryName});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IndexingBundle.message(\"\u2026  presentableLibraryName)");
        return string2;
    }

    @NotNull
    public String getRootsScanningProgressText() {
        CharSequence charSequence = this.libraryName;
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string2 = IndexingBundle.message((String)"indexable.files.provider.scanning.library.name", (Object[])new Object[]{this.libraryName});
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IndexingBundle.message(\"\u2026brary.name\", libraryName)");
            return string2;
        }
        String string3 = IndexingBundle.message((String)"indexable.files.provider.scanning.additional.dependencies", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"IndexingBundle.message(\"\u2026additional.dependencies\")");
        return string3;
    }

    @NotNull
    public LibraryOrigin getOrigin() {
        return new LibraryOriginImpl(this.classRootUrls, this.sourceRootUrls);
    }

    public boolean iterateFiles(@NotNull Project project2, @NotNull ContentIterator fileIterator, @NotNull VirtualFileFilter fileFilter) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileIterator, (String)"fileIterator");
        Intrinsics.checkNotNullParameter((Object)fileFilter, (String)"fileFilter");
        boolean $i$f$runReadAction = false;
        Set roots2 = (Set)ApplicationManager.getApplication().runReadAction(new Computable(this){
            final /* synthetic */ LibraryIndexableFilesIteratorImpl this$0;
            {
                this.this$0 = libraryIndexableFilesIteratorImpl;
            }

            public final T compute() {
                boolean bl = false;
                return (T)SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)this.this$0.getClassRootUrls()), (Sequence)CollectionsKt.asSequence((Iterable)this.this$0.getSourceRootUrls())), (Function1)iterateFiles.roots.1.1.INSTANCE));
            }
        });
        return IndexableFilesIterationMethods.iterateRoots$default(IndexableFilesIterationMethods.INSTANCE, project2, roots2, fileIterator, fileFilter, false, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> getRootUrls(@NotNull Project project2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Iterable $this$map$iv = CollectionsKt.plus((Collection)this.classRootUrls, (Iterable)this.sourceRootUrls);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VirtualFilePointer virtualFilePointer = (VirtualFilePointer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getUrl();
            collection.add(string2);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Nullable
    public final String getLibraryName() {
        return this.libraryName;
    }

    @NotNull
    public final String getPresentableLibraryName() {
        return this.presentableLibraryName;
    }

    @NotNull
    public final List<VirtualFilePointer> getClassRootUrls() {
        return this.classRootUrls;
    }

    @NotNull
    public final List<VirtualFilePointer> getSourceRootUrls() {
        return this.sourceRootUrls;
    }

    private LibraryIndexableFilesIteratorImpl(String libraryName, String presentableLibraryName, List<? extends VirtualFilePointer> classRootUrls, List<? extends VirtualFilePointer> sourceRootUrls) {
        this.libraryName = libraryName;
        this.presentableLibraryName = presentableLibraryName;
        this.classRootUrls = classRootUrls;
        this.sourceRootUrls = sourceRootUrls;
    }

    public /* synthetic */ LibraryIndexableFilesIteratorImpl(String libraryName, String presentableLibraryName, List classRootUrls, List sourceRootUrls, DefaultConstructorMarker $constructor_marker) {
        this(libraryName, presentableLibraryName, classRootUrls, sourceRootUrls);
    }

    @JvmStatic
    @RequiresReadLock
    @Nullable
    public static final LibraryIndexableFilesIteratorImpl createIterator(@NotNull Library library2) {
        return Companion.createIterator(library2);
    }

    @JvmStatic
    @NotNull
    public static final List<IndexableFilesIterator> createIteratorList(@NotNull Library library2) {
        return Companion.createIteratorList(library2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/util/indexing/roots/LibraryIndexableFilesIteratorImpl$Companion;", "", "()V", "collectPointers", "", "Lcom/intellij/openapi/vfs/impl/LightFilePointer;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "rootType", "Lcom/intellij/openapi/roots/OrderRootType;", "createIterator", "Lcom/intellij/util/indexing/roots/LibraryIndexableFilesIteratorImpl;", "createIteratorList", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "intellij.platform.lang.impl"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        private final List<LightFilePointer> collectPointers(Library library2, OrderRootType rootType) {
            void $this$mapTo$iv$iv;
            VirtualFile[] virtualFileArray = library2.getRootProvider().getFiles(rootType);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"library.rootProvider.getFiles(rootType)");
            VirtualFile[] $this$map$iv = virtualFileArray;
            boolean $i$f$map = false;
            VirtualFile[] virtualFileArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                LightFilePointer lightFilePointer = new LightFilePointer((VirtualFile)it);
                collection.add(lightFilePointer);
            }
            return (List)destination$iv$iv;
        }

        @JvmStatic
        @RequiresReadLock
        @Nullable
        public final LibraryIndexableFilesIteratorImpl createIterator(@NotNull Library library2) {
            LibraryIndexableFilesIteratorImpl libraryIndexableFilesIteratorImpl;
            Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
            if (library2 instanceof LibraryEx && ((LibraryEx)library2).isDisposed()) {
                libraryIndexableFilesIteratorImpl = null;
            } else {
                String string2 = library2.getName();
                String string3 = library2.getPresentableName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"library.presentableName");
                OrderRootType orderRootType = OrderRootType.CLASSES;
                Intrinsics.checkNotNullExpressionValue((Object)orderRootType, (String)"OrderRootType.CLASSES");
                List<LightFilePointer> list2 = this.collectPointers(library2, orderRootType);
                OrderRootType orderRootType2 = OrderRootType.SOURCES;
                Intrinsics.checkNotNullExpressionValue((Object)orderRootType2, (String)"OrderRootType.SOURCES");
                libraryIndexableFilesIteratorImpl = new LibraryIndexableFilesIteratorImpl(string2, string3, list2, this.collectPointers(library2, orderRootType2), null);
            }
            return libraryIndexableFilesIteratorImpl;
        }

        @JvmStatic
        @NotNull
        public final List<IndexableFilesIterator> createIteratorList(@NotNull Library library2) {
            Object object;
            block3: {
                block2: {
                    LibraryIndexableFilesIteratorImpl libraryIndexableFilesIteratorImpl;
                    Intrinsics.checkNotNullParameter((Object)library2, (String)"library");
                    object = this.createIterator(library2);
                    if (object == null) break block2;
                    LibraryIndexableFilesIteratorImpl $this$run = libraryIndexableFilesIteratorImpl = object;
                    boolean bl = false;
                    object = CollectionsKt.listOf((Object)$this$run);
                    if (object != null) break block3;
                }
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

