/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.ModuleFileIndexImpl;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.roots.ModuleIndexableFilesIterator;
import com.intellij.util.indexing.roots.ModuleIndexableFilesPolicy;
import com.intellij.util.indexing.roots.kind.ModuleRootOrigin;
import com.intellij.util.indexing.roots.origin.ModuleRootOriginImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016J \u0010\u0014\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/util/indexing/roots/ModuleIndexableFilesIteratorImpl;", "Lcom/intellij/util/indexing/roots/ModuleIndexableFilesIterator;", "module", "Lcom/intellij/openapi/module/Module;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "printRootsInDebugName", "", "(Lcom/intellij/openapi/module/Module;Ljava/util/List;Z)V", "getDebugName", "", "getIndexingProgressText", "getOrigin", "Lcom/intellij/util/indexing/roots/kind/ModuleRootOrigin;", "getRootUrls", "", "project", "Lcom/intellij/openapi/project/Project;", "getRootsScanningProgressText", "iterateFiles", "fileIterator", "Lcom/intellij/openapi/roots/ContentIterator;", "fileFilter", "Lcom/intellij/openapi/vfs/VirtualFileFilter;", "Companion", "intellij.platform.lang.impl"})
public final class ModuleIndexableFilesIteratorImpl
implements ModuleIndexableFilesIterator {
    private final Module module;
    private final List<VirtualFile> roots;
    private final boolean printRootsInDebugName;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String getDebugName() {
        String string2;
        if (this.printRootsInDebugName) {
            String string3;
            if (this.roots.isEmpty()) {
                string3 = "empty";
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.roots;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string4 = it.getName();
                    collection.add(string4);
                }
                string3 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv)), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            }
            String rootsDebugStr = string3;
            string2 = "Module '" + this.module.getName() + "' (" + rootsDebugStr + ")";
        } else {
            string2 = "Module '" + this.module.getName() + "'";
        }
        return string2;
    }

    @NotNull
    public String getIndexingProgressText() {
        String string2;
        if (ModuleType.isInternal((Module)this.module)) {
            String string3 = IndexingBundle.message((String)"indexable.files.provider.indexing.internal.module.name", (Object[])new Object[0]);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"IndexingBundle.message(\"\u2026ng.internal.module.name\")");
        } else {
            String string4 = IndexingBundle.message((String)"indexable.files.provider.indexing.module.name", (Object[])new Object[]{this.module.getName()});
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"IndexingBundle.message(\"\u2026odule.name\", module.name)");
        }
        return string2;
    }

    @NotNull
    public String getRootsScanningProgressText() {
        if (ModuleType.isInternal((Module)this.module)) {
            String string2 = IndexingBundle.message((String)"indexable.files.provider.scanning.internal.module.name", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IndexingBundle.message(\"\u2026ng.internal.module.name\")");
            return string2;
        }
        String string3 = IndexingBundle.message((String)"indexable.files.provider.scanning.module.name", (Object[])new Object[]{this.module.getName()});
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"IndexingBundle.message(\"\u2026odule.name\", module.name)");
        return string3;
    }

    @NotNull
    public ModuleRootOrigin getOrigin() {
        return new ModuleRootOriginImpl(this.module, this.roots);
    }

    public boolean iterateFiles(@NotNull Project project2, @NotNull ContentIterator fileIterator, @NotNull VirtualFileFilter fileFilter) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileIterator, (String)"fileIterator");
        Intrinsics.checkNotNullParameter((Object)fileFilter, (String)"fileFilter");
        boolean $i$f$runReadAction = false;
        ModuleFileIndex index = (ModuleFileIndex)ApplicationManager.getApplication().runReadAction(new Computable(this){
            final /* synthetic */ ModuleIndexableFilesIteratorImpl this$0;
            {
                this.this$0 = moduleIndexableFilesIteratorImpl;
            }

            public final T compute() {
                ModuleFileIndex moduleFileIndex;
                boolean bl = false;
                if (ModuleIndexableFilesIteratorImpl.access$getModule$p(this.this$0).isDisposed()) {
                    moduleFileIndex = null;
                } else {
                    ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(ModuleIndexableFilesIteratorImpl.access$getModule$p(this.this$0));
                    Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                    moduleFileIndex = moduleRootManager.getFileIndex();
                }
                return (T)moduleFileIndex;
            }
        });
        if (index == null) {
            return false;
        }
        for (VirtualFile root : this.roots) {
            index.iterateContentUnderDirectory(root, fileIterator, fileFilter);
        }
        return true;
    }

    @NotNull
    public Set<String> getRootUrls(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Object[] objectArray = ProjectUtil.getRootManager((Module)this.module).getContentRootUrls();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"module.rootManager.contentRootUrls");
        return ArraysKt.toSet((Object[])objectArray);
    }

    public ModuleIndexableFilesIteratorImpl(@NotNull Module module, @NotNull List<? extends VirtualFile> roots2, boolean printRootsInDebugName) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(roots2, (String)"roots");
        this.module = module;
        this.roots = roots2;
        this.printRootsInDebugName = printRootsInDebugName;
        Collection collection = this.roots;
        boolean bl2 = bl = !collection.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    public static final /* synthetic */ Module access$getModule$p(ModuleIndexableFilesIteratorImpl $this) {
        return $this.module;
    }

    @JvmStatic
    @Deprecated(message="Should not be used in new code; only when rolled back to old behaviour, see DefaultProjectIndexableFilesContributor.indexProjectBasedOnIndexableEntityProviders(). Should be removed once new code proves stable")
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static final Collection<ModuleIndexableFilesIteratorImpl> getModuleIterators(@NotNull Module module) {
        return Companion.getModuleIterators(module);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/util/indexing/roots/ModuleIndexableFilesIteratorImpl$Companion;", "", "()V", "getModuleIterators", "", "Lcom/intellij/util/indexing/roots/ModuleIndexableFilesIteratorImpl;", "module", "Lcom/intellij/openapi/module/Module;", "intellij.platform.lang.impl"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Deprecated(message="Should not be used in new code; only when rolled back to old behaviour, see DefaultProjectIndexableFilesContributor.indexProjectBasedOnIndexableEntityProviders(). Should be removed once new code proves stable")
        @ApiStatus.ScheduledForRemoval
        @NotNull
        public final Collection<ModuleIndexableFilesIteratorImpl> getModuleIterators(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            ModuleFileIndex moduleFileIndex = moduleRootManager.getFileIndex();
            if (moduleFileIndex == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.roots.impl.ModuleFileIndexImpl");
            }
            ModuleFileIndexImpl fileIndex = (ModuleFileIndexImpl)moduleFileIndex;
            Set<VirtualFile> set2 = fileIndex.getModuleRootsToIterate();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"fileIndex.moduleRootsToIterate");
            List moduleRoots = CollectionsKt.toList((Iterable)set2);
            if (moduleRoots.isEmpty()) {
                return CollectionsKt.emptyList();
            }
            if (ModuleIndexableFilesPolicy.Companion.getInstance().shouldIndexSeparateRoots()) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = moduleRoots;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    VirtualFile virtualFile2 = (VirtualFile)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    ModuleIndexableFilesIteratorImpl moduleIndexableFilesIteratorImpl = new ModuleIndexableFilesIteratorImpl(module, CollectionsKt.listOf((Object)it), moduleRoots.size() > 1);
                    collection.add(moduleIndexableFilesIteratorImpl);
                }
                return (List)destination$iv$iv;
            }
            return CollectionsKt.listOf((Object)new ModuleIndexableFilesIteratorImpl(module, moduleRoots, false));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

