/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.roots.IndexableFilesIterationMethods;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.kind.IndexableSetOrigin;
import com.intellij.util.indexing.roots.origin.SdkOriginImpl;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\u0006H\u0016J\u0012\u0010\n\u001a\f0\u0006\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\f0\u0006\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\b\fH\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/util/indexing/roots/SdkIndexableFilesIteratorImpl;", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "(Lcom/intellij/openapi/projectRoots/Sdk;)V", "sdkPresentableName", "", "getSdkPresentableName", "()Ljava/lang/String;", "getDebugName", "getIndexingProgressText", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getOrigin", "Lcom/intellij/util/indexing/roots/kind/IndexableSetOrigin;", "getRootUrls", "", "project", "Lcom/intellij/openapi/project/Project;", "getRootsScanningProgressText", "iterateFiles", "", "fileIterator", "Lcom/intellij/openapi/roots/ContentIterator;", "fileFilter", "Lcom/intellij/openapi/vfs/VirtualFileFilter;", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class SdkIndexableFilesIteratorImpl
implements IndexableFilesIterator {
    private final Sdk sdk;

    @NotNull
    public String getDebugName() {
        return this.getSdkPresentableName() + " " + this.sdk.getName();
    }

    private final String getSdkPresentableName() {
        String string2;
        SdkTypeId sdkTypeId = this.sdk.getSdkType();
        if (!(sdkTypeId instanceof SdkType)) {
            sdkTypeId = null;
        }
        SdkType sdkType = (SdkType)sdkTypeId;
        String it = string2 = sdkType != null ? sdkType.getPresentableName() : null;
        boolean bl = false;
        CharSequence charSequence = it;
        String string3 = !(charSequence == null || charSequence.length() == 0) ? string2 : null;
        if (string3 == null) {
            String string4 = IndexingBundle.message((String)"indexable.files.provider.indexing.sdk.unnamed", (Object[])new Object[0]);
            string3 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"IndexingBundle.message(\"\u2026er.indexing.sdk.unnamed\")");
        }
        return string3;
    }

    @NotNull
    public String getIndexingProgressText() {
        String string2 = IndexingBundle.message((String)"indexable.files.provider.indexing.sdk", (Object[])new Object[]{this.getSdkPresentableName(), this.sdk.getName()});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IndexingBundle.message(\"\u2026resentableName, sdk.name)");
        return string2;
    }

    @NotNull
    public String getRootsScanningProgressText() {
        String string2 = IndexingBundle.message((String)"indexable.files.provider.scanning.sdk", (Object[])new Object[]{this.getSdkPresentableName(), this.sdk.getName()});
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"IndexingBundle.message(\"\u2026                sdk.name)");
        return string2;
    }

    @NotNull
    public IndexableSetOrigin getOrigin() {
        return (IndexableSetOrigin)new SdkOriginImpl(this.sdk);
    }

    public boolean iterateFiles(@NotNull Project project2, @NotNull ContentIterator fileIterator, @NotNull VirtualFileFilter fileFilter) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileIterator, (String)"fileIterator");
        Intrinsics.checkNotNullParameter((Object)fileFilter, (String)"fileFilter");
        boolean $i$f$runReadAction = false;
        List roots2 = (List)ApplicationManager.getApplication().runReadAction(new Computable(this){
            final /* synthetic */ SdkIndexableFilesIteratorImpl this$0;
            {
                this.this$0 = sdkIndexableFilesIteratorImpl;
            }

            public final T compute() {
                boolean bl = false;
                RootProvider rootProvider = SdkIndexableFilesIteratorImpl.access$getSdk$p(this.this$0).getRootProvider();
                Intrinsics.checkNotNullExpressionValue((Object)rootProvider, (String)"sdk.rootProvider");
                RootProvider rootProvider2 = rootProvider;
                Object[] objectArray = rootProvider2.getFiles(OrderRootType.SOURCES);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"rootProvider.getFiles(OrderRootType.SOURCES)");
                Collection collection = ArraysKt.toList((Object[])objectArray);
                Object[] objectArray2 = rootProvider2.getFiles(OrderRootType.CLASSES);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"rootProvider.getFiles(OrderRootType.CLASSES)");
                return (T)CollectionsKt.plus((Collection)collection, (Object[])objectArray2);
            }
        });
        return IndexableFilesIterationMethods.iterateRoots$default(IndexableFilesIterationMethods.INSTANCE, project2, roots2, fileIterator, fileFilter, false, 16, null);
    }

    @NotNull
    public Set<String> getRootUrls(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        RootProvider rootProvider = this.sdk.getRootProvider();
        Intrinsics.checkNotNullExpressionValue((Object)rootProvider, (String)"sdk.rootProvider");
        RootProvider rootProvider2 = rootProvider;
        Object[] objectArray = rootProvider2.getUrls(OrderRootType.SOURCES);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"rootProvider.getUrls(OrderRootType.SOURCES)");
        Object[] objectArray2 = rootProvider2.getUrls(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"rootProvider.getUrls(OrderRootType.CLASSES)");
        return ArraysKt.toSet((Object[])ArraysKt.plus((Object[])objectArray, (Object[])objectArray2));
    }

    public SdkIndexableFilesIteratorImpl(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        this.sdk = sdk2;
    }

    public static final /* synthetic */ Sdk access$getSdk$p(SdkIndexableFilesIteratorImpl $this) {
        return $this.sdk;
    }
}

