/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots.builders;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.LibraryIndexableFilesIterator;
import com.intellij.util.indexing.roots.LibraryIndexableFilesIteratorImpl;
import com.intellij.util.indexing.roots.builders.IndexableIteratorBuilderHandler;
import com.intellij.util.indexing.roots.builders.LibraryIdIteratorBuilder;
import com.intellij.util.indexing.roots.kind.LibraryOrigin;
import com.intellij.workspaceModel.ide.impl.legacyBridge.library.LibraryEntityUtils;
import com.intellij.workspaceModel.storage.EntityStorage;
import com.intellij.workspaceModel.storage.bridgeEntities.api.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.api.LibraryTableId;
import com.intellij.workspaceModel.storage.bridgeEntities.api.ModuleDependencyItem;
import com.intellij.workspaceModel.storage.bridgeEntities.api.ModuleEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J,\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/util/indexing/roots/builders/LibraryIndexableIteratorHandler;", "Lcom/intellij/util/indexing/roots/builders/IndexableIteratorBuilderHandler;", "()V", "accepts", "", "builder", "Lcom/intellij/util/indexing/roots/IndexableEntityProvider$IndexableIteratorBuilder;", "createLibraryIterator", "Lcom/intellij/util/indexing/roots/LibraryIndexableFilesIterator;", "libraryId", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/LibraryId;", "entityStorage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "project", "Lcom/intellij/openapi/project/Project;", "instantiate", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "builders", "", "DependencyChecker", "intellij.platform.lang.impl"})
public final class LibraryIndexableIteratorHandler
implements IndexableIteratorBuilderHandler {
    @Override
    public boolean accepts(@NotNull IndexableEntityProvider.IndexableIteratorBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        return builder2 instanceof LibraryIdIteratorBuilder;
    }

    @NotNull
    public List<IndexableFilesIterator> instantiate(@NotNull Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> builders, @NotNull Project project2, @NotNull EntityStorage entityStorage) {
        Intrinsics.checkNotNullParameter(builders, (String)"builders");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)entityStorage, (String)"entityStorage");
        Set idsToIndex = new LinkedHashSet();
        Iterable $this$forEach$iv = builders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LibraryIdIteratorBuilder builder2 = (LibraryIdIteratorBuilder)element$iv;
            boolean bl = false;
            if (!builder2.getDependencyChecked()) continue;
            idsToIndex.add(builder2.getLibraryId());
        }
        DependencyChecker dependencyChecker = new DependencyChecker(entityStorage, idsToIndex);
        Iterable $this$forEach$iv2 = builders;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            LibraryIdIteratorBuilder builder3 = (LibraryIdIteratorBuilder)element$iv;
            boolean bl = false;
            if (builder3.getDependencyChecked()) continue;
            dependencyChecker.checkDependency(builder3.getLibraryId());
        }
        List result2 = new ArrayList();
        Set ids = new LinkedHashSet();
        Iterable $this$forEach$iv3 = idsToIndex;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            LibraryIndexableFilesIterator libraryIndexableFilesIterator;
            LibraryId id2 = (LibraryId)element$iv;
            boolean bl = false;
            if (this.createLibraryIterator(id2, entityStorage, project2) == null) continue;
            LibraryIndexableFilesIterator it = libraryIndexableFilesIterator;
            boolean bl2 = false;
            LibraryOrigin libraryOrigin = it.getOrigin();
            Intrinsics.checkNotNullExpressionValue((Object)libraryOrigin, (String)"it.origin");
            if (!ids.add(libraryOrigin)) continue;
            result2.add(it);
        }
        return result2;
    }

    private final LibraryIndexableFilesIterator createLibraryIterator(LibraryId libraryId, EntityStorage entityStorage, Project project2) {
        LibraryIndexableFilesIteratorImpl libraryIndexableFilesIteratorImpl;
        Library library2 = LibraryEntityUtils.findLibraryBridge(libraryId, entityStorage, project2);
        if (library2 != null) {
            Library library3;
            Library it = library3 = library2;
            boolean bl = false;
            libraryIndexableFilesIteratorImpl = LibraryIndexableFilesIteratorImpl.Companion.createIterator(it);
        } else {
            libraryIndexableFilesIteratorImpl = null;
        }
        return libraryIndexableFilesIteratorImpl;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u0006R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/indexing/roots/builders/LibraryIndexableIteratorHandler$DependencyChecker;", "", "entityStorage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "idsToIndex", "", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/LibraryId;", "(Lcom/intellij/workspaceModel/storage/EntityStorage;Ljava/util/Set;)V", "dependencyIterator", "", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/ModuleDependencyItem;", "getEntityStorage", "()Lcom/intellij/workspaceModel/storage/EntityStorage;", "idsFromDependencies", "getIdsToIndex", "()Ljava/util/Set;", "moduleIterator", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/ModuleEntity;", "checkDependencies", "", "iterator", "libraryId", "checkDependency", "", "intellij.platform.lang.impl"})
    private static final class DependencyChecker {
        private final Set<LibraryId> idsFromDependencies;
        private Iterator<? extends ModuleEntity> moduleIterator;
        private Iterator<? extends ModuleDependencyItem> dependencyIterator;
        @NotNull
        private final EntityStorage entityStorage;
        @NotNull
        private final Set<LibraryId> idsToIndex;

        public final void checkDependency(@NotNull LibraryId libraryId) {
            Intrinsics.checkNotNullParameter((Object)libraryId, (String)"libraryId");
            if (libraryId.getTableId() instanceof LibraryTableId.ModuleLibraryTableId) {
                this.idsToIndex.add(libraryId);
                return;
            }
            if (this.idsFromDependencies.contains(libraryId)) {
                this.idsToIndex.add(libraryId);
                return;
            }
            Iterator iterator = this.moduleIterator;
            if (iterator == null) {
                iterator = this.entityStorage.entities(ModuleEntity.class).iterator();
            }
            Iterator localModuleIterator = iterator;
            Iterator<Object> localDependencyIterator = this.dependencyIterator;
            if (localDependencyIterator == null || !localDependencyIterator.hasNext()) {
                if (localModuleIterator.hasNext()) {
                    localDependencyIterator = ((ModuleEntity)localModuleIterator.next()).getDependencies().iterator();
                } else {
                    return;
                }
            }
            boolean foundInDependencies = this.checkDependencies(localDependencyIterator, libraryId);
            this.dependencyIterator = localDependencyIterator;
            if (foundInDependencies) {
                return;
            }
            while (localModuleIterator.hasNext()) {
                localDependencyIterator = ((ModuleEntity)localModuleIterator.next()).getDependencies().iterator();
                boolean foundInDependency = this.checkDependencies(localDependencyIterator, libraryId);
                this.dependencyIterator = localDependencyIterator;
                this.moduleIterator = localModuleIterator;
                if (!foundInDependency) continue;
                return;
            }
        }

        private final boolean checkDependencies(Iterator<? extends ModuleDependencyItem> iterator, LibraryId libraryId) {
            while (iterator.hasNext()) {
                ModuleDependencyItem next = iterator.next();
                if (!(next instanceof ModuleDependencyItem.Exportable.LibraryDependency)) continue;
                this.idsFromDependencies.add(((ModuleDependencyItem.Exportable.LibraryDependency)next).getLibrary());
                if (!Intrinsics.areEqual((Object)libraryId, (Object)((ModuleDependencyItem.Exportable.LibraryDependency)next).getLibrary())) continue;
                this.idsToIndex.add(libraryId);
                return true;
            }
            return false;
        }

        @NotNull
        public final EntityStorage getEntityStorage() {
            return this.entityStorage;
        }

        @NotNull
        public final Set<LibraryId> getIdsToIndex() {
            return this.idsToIndex;
        }

        public DependencyChecker(@NotNull EntityStorage entityStorage, @NotNull Set<LibraryId> idsToIndex) {
            Intrinsics.checkNotNullParameter((Object)entityStorage, (String)"entityStorage");
            Intrinsics.checkNotNullParameter(idsToIndex, (String)"idsToIndex");
            this.entityStorage = entityStorage;
            this.idsToIndex = idsToIndex;
            this.idsFromDependencies = new LinkedHashSet();
            this.idsFromDependencies.addAll((Collection<LibraryId>)this.idsToIndex);
        }
    }
}

