/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.roots.builders;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.util.indexing.roots.IndexableEntityProvider;
import com.intellij.util.indexing.roots.IndexableEntityProviderMethods;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.indexing.roots.builders.IndexableIteratorBuilderHandler;
import com.intellij.util.indexing.roots.builders.InheritedSdkIteratorBuilder;
import com.intellij.util.indexing.roots.builders.SdkIteratorBuilder;
import com.intellij.workspaceModel.ide.legacyBridge.ModifiableRootModelBridge;
import com.intellij.workspaceModel.storage.EntityStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J,\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/util/indexing/roots/builders/SdkIndexableIteratorHandler;", "Lcom/intellij/util/indexing/roots/builders/IndexableIteratorBuilderHandler;", "()V", "accepts", "", "builder", "Lcom/intellij/util/indexing/roots/IndexableEntityProvider$IndexableIteratorBuilder;", "instantiate", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "builders", "", "project", "Lcom/intellij/openapi/project/Project;", "entityStorage", "Lcom/intellij/workspaceModel/storage/EntityStorage;", "intellij.platform.lang.impl"})
public final class SdkIndexableIteratorHandler
implements IndexableIteratorBuilderHandler {
    @Override
    public boolean accepts(@NotNull IndexableEntityProvider.IndexableIteratorBuilder builder2) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        return builder2 instanceof SdkIteratorBuilder || builder2 instanceof InheritedSdkIteratorBuilder;
    }

    @NotNull
    public List<IndexableFilesIterator> instantiate(@NotNull Collection<? extends IndexableEntityProvider.IndexableIteratorBuilder> builders, @NotNull Project project2, @NotNull EntityStorage entityStorage) {
        Intrinsics.checkNotNullParameter(builders, (String)"builders");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)entityStorage, (String)"entityStorage");
        boolean hasProjectIterator = false;
        Set builderSet = CollectionsKt.toSet((Iterable)builders);
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = builderSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexableEntityProvider.IndexableIteratorBuilder builder2 = (IndexableEntityProvider.IndexableIteratorBuilder)element$iv;
            boolean bl = false;
            if (builder2 instanceof SdkIteratorBuilder) {
                if (ModifiableRootModelBridge.Companion.findSdk(((SdkIteratorBuilder)builder2).getSdkName(), ((SdkIteratorBuilder)builder2).getSdkType()) != null) {
                    Sdk sdk2;
                    Sdk $this$apply = sdk2;
                    boolean bl2 = false;
                    result2.addAll(IndexableEntityProviderMethods.INSTANCE.createIterators($this$apply));
                }
                continue;
            }
            if (hasProjectIterator) continue;
            ProjectRootManager projectRootManager = ProjectRootManager.getInstance(project2);
            Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
            Sdk sdk3 = projectRootManager.getProjectSdk();
            if (sdk3 != null) {
                String string2 = sdk3.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sdk.name");
                SdkTypeId sdkTypeId = sdk3.getSdkType();
                Intrinsics.checkNotNullExpressionValue((Object)sdkTypeId, (String)"sdk.sdkType");
                String string3 = sdkTypeId.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sdk.sdkType.name");
                if (!builderSet.contains(new SdkIteratorBuilder(string2, string3))) {
                    result2.addAll(IndexableEntityProviderMethods.INSTANCE.createIterators(sdk3));
                }
            }
            hasProjectIterator = true;
        }
        return result2;
    }
}

