/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.io.DirectBufferWrapper;
import com.intellij.util.io.IOStatistics;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.stats.FilePageCacheStatistics;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.system.CpuArch;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class FilePageCache {
    private static final Logger LOG = Logger.getInstance(FilePageCache.class);
    static final long MAX_PAGES_COUNT = 0xFFFFFFFFL;
    private static final long FILE_INDEX_MASK = -4294967296L;
    private static final int LOWER_LIMIT;
    private static final int UPPER_LIMIT;
    static final int BUFFER_SIZE;
    private final Int2ObjectMap<PagedFileStorage> myIndex2Storage = Int2ObjectMaps.synchronize(new Int2ObjectOpenHashMap());
    private final LinkedHashMap<Long, DirectBufferWrapper> mySegments;
    private final ReentrantLock mySegmentsAccessLock = new ReentrantLock();
    private final ReentrantLock mySegmentsAllocationLock = new ReentrantLock();
    private final LinkedHashMap<Long, DirectBufferWrapper> mySegmentsToRemove = new LinkedHashMap();
    private final long mySizeLimit = UPPER_LIMIT;
    private long mySize;
    private volatile int myUncachedFileAccess;
    private int myFastCacheHits;
    private int myHits;
    private int myMisses;
    private int myLoad;
    private volatile int myMaxRegisteredFiles;
    private long myMaxLoadedSize;
    private volatile int myMappingChangeCount;
    private long myCreatedCount;
    private long myCreatedMs;
    private long myDisposalMs;

    void assertUnderSegmentAllocationLock() {
        assert (this.mySegmentsAllocationLock.isHeldByCurrentThread());
    }

    public void incrementUncachedFileAccess() {
        ++this.myUncachedFileAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertNoBuffersLocked() {
        this.mySegmentsAllocationLock.lock();
        try {
            this.mySegmentsAccessLock.lock();
            try {
                for (DirectBufferWrapper value : this.mySegments.values()) {
                    if (value.isLocked()) {
                        throw new AssertionError();
                    }
                }
                for (DirectBufferWrapper value : this.mySegmentsToRemove.values()) {
                    if (value.isLocked()) {
                        throw new AssertionError();
                    }
                }
            }
            finally {
                this.mySegmentsAccessLock.unlock();
            }
        }
        finally {
            this.mySegmentsAllocationLock.unlock();
        }
    }

    public void incrementFastCacheHitsCount() {
        ++this.myFastCacheHits;
    }

    public long getMaxSize() {
        return this.mySizeLimit;
    }

    private static long maxDirectMemory() {
        try {
            Class<?> aClass = Class.forName("jdk.internal.misc.VM");
            Method maxDirectMemory = aClass.getMethod("maxDirectMemory", new Class[0]);
            return (Long)maxDirectMemory.invoke(null, new Object[0]);
        }
        catch (Throwable aClass) {
            try {
                Class<?> aClass2 = Class.forName("sun.misc.VM");
                Method maxDirectMemory = aClass2.getMethod("maxDirectMemory", new Class[0]);
                return (Long)maxDirectMemory.invoke(null, new Object[0]);
            }
            catch (Throwable aClass2) {
                try {
                    Class<?> aClass3 = Class.forName("java.nio.Bits");
                    Field maxMemory = aClass3.getDeclaredField("maxMemory");
                    maxMemory.setAccessible(true);
                    return (Long)maxMemory.get(null);
                }
                catch (Throwable aClass3) {
                    try {
                        Class<?> aClass4 = Class.forName("java.nio.Bits");
                        Field maxMemory = aClass4.getDeclaredField("MAX_MEMORY");
                        maxMemory.setAccessible(true);
                        return (Long)maxMemory.get(null);
                    }
                    catch (Throwable throwable) {
                        return Runtime.getRuntime().maxMemory();
                    }
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    FilePageCacheStatistics getStatistics() {
        this.mySegmentsAllocationLock.lock();
        this.mySegmentsAccessLock.lock();
        FilePageCacheStatistics filePageCacheStatistics = new FilePageCacheStatistics(PagedFileStorage.CHANNELS_CACHE.getStatistics(), this.myUncachedFileAccess, this.myMaxRegisteredFiles, this.myMaxLoadedSize, this.myHits, this.myFastCacheHits, this.myMisses, this.myLoad, this.myMappingChangeCount, this.mySizeLimit);
        this.mySegmentsAccessLock.unlock();
        FilePageCacheStatistics filePageCacheStatistics2 = filePageCacheStatistics;
        if (filePageCacheStatistics2 == null) {
            FilePageCache.$$$reportNull$$$0(0);
        }
        return filePageCacheStatistics2;
        {
            catch (Throwable throwable) {
                this.mySegmentsAccessLock.unlock();
                throw throwable;
            }
        }
        finally {
            this.mySegmentsAllocationLock.unlock();
        }
    }

    FilePageCache() {
        this.mySegments = new LinkedHashMap<Long, DirectBufferWrapper>(10, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Long, DirectBufferWrapper> eldest) {
                assert (FilePageCache.this.mySegmentsAccessLock.isHeldByCurrentThread());
                return FilePageCache.this.mySize > FilePageCache.this.mySizeLimit;
            }

            @Override
            public DirectBufferWrapper put(Long key, @NotNull DirectBufferWrapper wrapper2) {
                if (wrapper2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                FilePageCache.this.mySize += wrapper2.getLength();
                DirectBufferWrapper oldShouldBeNull = super.put(key, wrapper2);
                FilePageCache.this.myMaxLoadedSize = Math.max(FilePageCache.this.myMaxLoadedSize, FilePageCache.this.mySize);
                return oldShouldBeNull;
            }

            @Override
            @Nullable
            public DirectBufferWrapper remove(Object key) {
                assert (FilePageCache.this.mySegmentsAccessLock.isHeldByCurrentThread());
                DirectBufferWrapper wrapper2 = (DirectBufferWrapper)super.remove(key);
                if (wrapper2 != null) {
                    ++FilePageCache.this.myMappingChangeCount;
                    FilePageCache.this.mySegmentsToRemove.put((Long)key, wrapper2);
                    FilePageCache.this.mySize -= wrapper2.getLength();
                }
                return wrapper2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/util/io/FilePageCache$1", "put"));
            }
        };
    }

    int getMappingChangeCount() {
        return this.myMappingChangeCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long registerPagedFileStorage(@NotNull PagedFileStorage storage) {
        if (storage == null) {
            FilePageCache.$$$reportNull$$$0(1);
        }
        Int2ObjectMap<PagedFileStorage> int2ObjectMap = this.myIndex2Storage;
        synchronized (int2ObjectMap) {
            int registered = this.myIndex2Storage.size();
            int value = registered << 16;
            while (this.myIndex2Storage.get(value) != null) {
                value = ++registered << 16;
            }
            this.myIndex2Storage.put(value, storage);
            this.myMaxRegisteredFiles = Math.max(this.myMaxRegisteredFiles, this.myIndex2Storage.size());
            return (long)value << 32;
        }
    }

    @NotNull(value="Seems accessed storage has been closed")
    private @NotNull(value="Seems accessed storage has been closed") PagedFileStorage getRegisteredPagedFileStorageByIndex(long key) {
        int storageIndex = (int)((key & 0xFFFFFFFF00000000L) >> 32);
        PagedFileStorage pagedFileStorage = (PagedFileStorage)this.myIndex2Storage.get(storageIndex);
        if (pagedFileStorage == null) {
            FilePageCache.$$$reportNull$$$0(2);
        }
        return pagedFileStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DirectBufferWrapper get(Long key, boolean read) throws IOException {
        DirectBufferWrapper wrapper2;
        try {
            this.mySegmentsAccessLock.lock();
            wrapper2 = this.mySegments.get(key);
            if (wrapper2 != null) {
                ++this.myHits;
                DirectBufferWrapper directBufferWrapper = wrapper2;
                return directBufferWrapper;
            }
        }
        finally {
            this.mySegmentsAccessLock.unlock();
        }
        this.mySegmentsAllocationLock.lock();
        try {
            DirectBufferWrapper notYetRemoved = this.mySegmentsToRemove.remove(key);
            if (notYetRemoved != null) {
                DirectBufferWrapper previous;
                this.mySegmentsAccessLock.lock();
                try {
                    previous = this.mySegments.put(key, notYetRemoved);
                    assert (previous == null);
                }
                finally {
                    this.mySegmentsAccessLock.unlock();
                }
                this.disposeRemovedSegments(null);
                ++this.myHits;
                previous = notYetRemoved;
                return previous;
            }
            this.mySegmentsAccessLock.lock();
            try {
                wrapper2 = this.mySegments.get(key);
                if (wrapper2 != null) {
                    DirectBufferWrapper previous = wrapper2;
                    return previous;
                }
            }
            finally {
                this.mySegmentsAccessLock.unlock();
            }
            long started = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
            PagedFileStorage fileStorage = this.getRegisteredPagedFileStorageByIndex(key);
            this.disposeRemovedSegments(null);
            long disposed = IOStatistics.DEBUG ? System.currentTimeMillis() : 0L;
            wrapper2 = FilePageCache.createValue(key, read, fileStorage);
            if (IOStatistics.DEBUG) {
                long finished = System.currentTimeMillis();
                ++this.myCreatedCount;
                this.myCreatedMs += finished - disposed;
                this.myDisposalMs += disposed - started;
            }
            this.mySegmentsAccessLock.lock();
            try {
                if (this.mySize + (long)fileStorage.myPageSize < this.mySizeLimit) {
                    ++this.myLoad;
                } else {
                    ++this.myMisses;
                }
                this.mySegments.put(key, wrapper2);
            }
            finally {
                this.mySegmentsAccessLock.unlock();
            }
            this.ensureSize(this.mySizeLimit);
            DirectBufferWrapper directBufferWrapper = wrapper2;
            return directBufferWrapper;
        }
        finally {
            this.mySegmentsAllocationLock.unlock();
        }
    }

    private void disposeRemovedSegments(@Nullable PagedFileStorage verificationStorage) {
        this.assertUnderSegmentAllocationLock();
        if (this.mySegmentsToRemove.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<Long, DirectBufferWrapper>> iterator = this.mySegmentsToRemove.entrySet().iterator();
        while (iterator.hasNext()) {
            try {
                Map.Entry<Long, DirectBufferWrapper> entry = iterator.next();
                DirectBufferWrapper wrapper2 = entry.getValue();
                boolean released = wrapper2.tryRelease(wrapper2.getFile() == verificationStorage);
                if (!released) continue;
                iterator.remove();
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    private void ensureSize(long sizeLimit) {
        this.mySegmentsAllocationLock.isHeldByCurrentThread();
        try {
            this.mySegmentsAccessLock.lock();
            while (this.mySize > sizeLimit) {
                this.mySegments.doRemoveEldestEntry();
            }
        }
        finally {
            this.mySegmentsAccessLock.unlock();
        }
        this.disposeRemovedSegments(null);
    }

    @NotNull
    private static DirectBufferWrapper createValue(Long key, boolean read, PagedFileStorage owner) throws IOException {
        StorageLockContext context2 = owner.getStorageLockContext();
        if (read) {
            context2.checkReadAccess();
        } else {
            context2.checkWriteAccess();
        }
        long off = (key & 0xFFFFFFFFL) * (long)owner.myPageSize;
        return new DirectBufferWrapper(owner, off);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<Long, DirectBufferWrapper> getBuffersForOwner(@NotNull PagedFileStorage storage) {
        if (storage == null) {
            FilePageCache.$$$reportNull$$$0(3);
        }
        StorageLockContext storageLockContext = storage.getStorageLockContext();
        this.mySegmentsAccessLock.lock();
        storageLockContext.checkReadAccess();
        TreeMap<Long, DirectBufferWrapper> mineBuffers = new TreeMap<Long, DirectBufferWrapper>();
        for (Map.Entry<Long, DirectBufferWrapper> entry : this.mySegments.entrySet()) {
            if (entry.getValue().getFile() != storage) continue;
            mineBuffers.put(entry.getKey(), entry.getValue());
        }
        TreeMap<Long, DirectBufferWrapper> treeMap = mineBuffers;
        Object object = treeMap;
        if (object == null) {
            FilePageCache.$$$reportNull$$$0(4);
        }
        return object;
        finally {
            this.mySegmentsAccessLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unmapBuffersForOwner(PagedFileStorage fileStorage) {
        Map<Long, DirectBufferWrapper> buffers = this.getBuffersForOwner(fileStorage);
        if (!buffers.isEmpty()) {
            this.mySegmentsAccessLock.lock();
            try {
                for (Long key : buffers.keySet()) {
                    this.mySegments.remove(key);
                }
            }
            finally {
                this.mySegmentsAccessLock.unlock();
            }
        }
        this.mySegmentsAllocationLock.lock();
        try {
            this.disposeRemovedSegments(fileStorage);
        }
        finally {
            this.mySegmentsAllocationLock.unlock();
        }
    }

    void flushBuffers() {
        this.mySegmentsAccessLock.lock();
        try {
            while (!this.mySegments.isEmpty()) {
                this.mySegments.doRemoveEldestEntry();
            }
        }
        finally {
            this.mySegmentsAccessLock.unlock();
        }
        this.mySegmentsAllocationLock.lock();
        try {
            this.disposeRemovedSegments(null);
        }
        finally {
            this.mySegmentsAllocationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushBuffersForOwner(PagedFileStorage storage) throws IOException {
        storage.getStorageLockContext().checkReadAccess();
        Map<Long, DirectBufferWrapper> buffers = this.getBuffersForOwner(storage);
        if (!buffers.isEmpty()) {
            SmartList<IOException> exceptions = new SmartList<IOException>();
            this.mySegmentsAllocationLock.lock();
            try {
                try {
                    for (DirectBufferWrapper buffer : buffers.values()) {
                        if (!buffer.isDirty() || buffer.isReleased()) continue;
                        buffer.force();
                    }
                }
                catch (IOException e) {
                    exceptions.add(e);
                }
            }
            finally {
                this.mySegmentsAllocationLock.unlock();
            }
            if (!exceptions.isEmpty()) {
                throw new IOException(new CompoundRuntimeException(exceptions));
            }
        }
    }

    void removeStorage(long index) {
        this.myIndex2Storage.remove((int)(index >> 32));
    }

    static {
        int lower = 100;
        int upper = CpuArch.is32Bit() ? 200 : 500;
        BUFFER_SIZE = Math.max(1, SystemProperties.getIntProperty("idea.paged.storage.page.size", 10)) * 0x100000;
        long max = FilePageCache.maxDirectMemory() - 2L * (long)BUFFER_SIZE;
        LOWER_LIMIT = (int)Math.min(0x6400000L, max);
        UPPER_LIMIT = (int)Math.min((long)Math.max(LOWER_LIMIT, SystemProperties.getIntProperty("idea.max.paged.storage.cache", upper) * 0x100000), max);
        LOG.info("lower=" + LOWER_LIMIT / 0x100000 + "; upper=" + UPPER_LIMIT / 0x100000 + "; buffer=" + BUFFER_SIZE / 0x100000 + "; max=" + max / 0x100000L);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "Seems accessed storage has been closed";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 0;
                break;
            }
        }
        Object[] objectArray = new Object[n2];
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[0] = "com/intellij/util/io/FilePageCache";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[0] = "storage";
                break;
            }
            case 2: {
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[1] = "getStatistics";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[1] = "com/intellij/util/io/FilePageCache";
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[1] = "getBuffersForOwner";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerPagedFileStorage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBuffersForOwner";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

