/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.DirectBufferWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
class PagedFileStorageCache {
    private volatile CachedBuffer myLastBuffer;
    private volatile CachedBuffer myLastBuffer2;
    private volatile CachedBuffer myLastBuffer3;

    PagedFileStorageCache() {
    }

    void clear() {
        this.myLastBuffer = null;
        this.myLastBuffer2 = null;
        this.myLastBuffer3 = null;
    }

    @Nullable
    DirectBufferWrapper getPageFromCache(long page2) {
        DirectBufferWrapper buffer = PagedFileStorageCache.fromCache(this.myLastBuffer, page2);
        if (buffer != null) {
            return buffer;
        }
        buffer = PagedFileStorageCache.fromCache(this.myLastBuffer2, page2);
        if (buffer != null) {
            return buffer;
        }
        buffer = PagedFileStorageCache.fromCache(this.myLastBuffer3, page2);
        return buffer;
    }

    @Nullable
    private static DirectBufferWrapper fromCache(CachedBuffer lastBuffer, long page2) {
        if (lastBuffer != null && !lastBuffer.myWrapper.isReleased() && lastBuffer.myLastPage == page2) {
            return lastBuffer.myWrapper;
        }
        return null;
    }

    void updateCache(long page2, DirectBufferWrapper byteBufferWrapper) {
        if (this.myLastBuffer != null && this.myLastBuffer.myLastPage != page2) {
            this.myLastBuffer3 = this.myLastBuffer2;
            this.myLastBuffer2 = this.myLastBuffer;
        }
        this.myLastBuffer = new CachedBuffer(byteBufferWrapper, page2);
    }

    private static class CachedBuffer {
        private final DirectBufferWrapper myWrapper;
        private final long myLastPage;

        private CachedBuffer(DirectBufferWrapper wrapper2, long page2) {
            this.myWrapper = wrapper2;
            this.myLastPage = page2;
        }
    }
}

