/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.io.Decompressor;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.Set;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ZipUtil {
    private static final Logger LOG = Logger.getInstance(ZipUtil.class);

    private ZipUtil() {
    }

    public static boolean addFileToZip(@NotNull ZipOutputStream zos, @NotNull File file2, @NotNull String relativeName, @Nullable Set<? super String> writtenItemRelativePaths, @Nullable FileFilter fileFilter) throws IOException {
        if (zos == null) {
            ZipUtil.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(1);
        }
        if (relativeName == null) {
            ZipUtil.$$$reportNull$$$0(2);
        }
        return ZipUtil.addFileToZip(zos, file2, relativeName, writtenItemRelativePaths, fileFilter, FileContentProcessor.STANDARD, file2.isDirectory());
    }

    public static boolean addFileToZip(@NotNull ZipOutputStream zos, @NotNull File file2, @NotNull String relativeName, @Nullable Set<? super String> writtenItemRelativePaths, @Nullable FileFilter fileFilter, @NotNull FileContentProcessor contentProcessor, boolean isDir) throws IOException {
        if (zos == null) {
            ZipUtil.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(4);
        }
        if (relativeName == null) {
            ZipUtil.$$$reportNull$$$0(5);
        }
        if (contentProcessor == null) {
            ZipUtil.$$$reportNull$$$0(6);
        }
        while (!relativeName.isEmpty() && relativeName.charAt(0) == '/') {
            relativeName = relativeName.substring(1);
        }
        if (isDir && !Strings.endsWithChar(relativeName, '/')) {
            relativeName = relativeName + "/";
        }
        if (fileFilter != null && !FileUtilRt.isFilePathAcceptable(file2, fileFilter) || writtenItemRelativePaths != null && !writtenItemRelativePaths.add(relativeName)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Add " + file2 + " as " + relativeName);
        }
        long size = isDir ? 0L : file2.length();
        ZipEntry e = new ZipEntry(relativeName);
        e.setTime(file2.lastModified());
        if (size == 0L) {
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
        }
        zos.putNextEntry(e);
        if (!isDir) {
            try (InputStream is = contentProcessor.getContent(file2);){
                FileUtilRt.copy(is, zos);
            }
        }
        zos.closeEntry();
        return true;
    }

    public static boolean addFileOrDirRecursively(@NotNull ZipOutputStream jarOutputStream, @Nullable File jarFile, @NotNull File file2, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        if (jarOutputStream == null) {
            ZipUtil.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(8);
        }
        if (relativePath == null) {
            ZipUtil.$$$reportNull$$$0(9);
        }
        if (file2.isDirectory()) {
            return ZipUtil.addDirToZipRecursively(jarOutputStream, jarFile, file2, relativePath, fileFilter, writtenItemRelativePaths);
        }
        return ZipUtil.addFileToZip(jarOutputStream, file2, relativePath, writtenItemRelativePaths, fileFilter);
    }

    public static boolean addDirToZipRecursively(@NotNull ZipOutputStream outputStream, @Nullable File jarFile, @NotNull File dir, @NotNull String relativePath, @Nullable FileFilter fileFilter, @Nullable Set<String> writtenItemRelativePaths) throws IOException {
        File[] children2;
        if (outputStream == null) {
            ZipUtil.$$$reportNull$$$0(10);
        }
        if (dir == null) {
            ZipUtil.$$$reportNull$$$0(11);
        }
        if (relativePath == null) {
            ZipUtil.$$$reportNull$$$0(12);
        }
        if (jarFile != null && FileUtil.isAncestor(dir.getPath(), jarFile.getPath(), false)) {
            return false;
        }
        if (!relativePath.isEmpty()) {
            ZipUtil.addFileToZip(outputStream, dir, relativePath, writtenItemRelativePaths, fileFilter, FileContentProcessor.STANDARD, true);
        }
        if ((children2 = dir.listFiles()) != null) {
            for (File child : children2) {
                String childRelativePath = (relativePath.isEmpty() ? "" : relativePath + "/") + child.getName();
                ZipUtil.addFileOrDirRecursively(outputStream, jarFile, child, childRelativePath, fileFilter, writtenItemRelativePaths);
            }
        }
        return true;
    }

    @Deprecated
    public static void extract(@NotNull File file2, @NotNull File outputDir, @Nullable FilenameFilter filter2) throws IOException {
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(13);
        }
        if (outputDir == null) {
            ZipUtil.$$$reportNull$$$0(14);
        }
        new Decompressor.Zip(file2).filter(FileFilterAdapter.wrap(outputDir.toPath(), filter2)).extract(outputDir.toPath());
    }

    public static void extract(@NotNull Path file2, @NotNull Path outputDir, @Nullable FilenameFilter filter2) throws IOException {
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(15);
        }
        if (outputDir == null) {
            ZipUtil.$$$reportNull$$$0(16);
        }
        new Decompressor.Zip(file2).filter(FileFilterAdapter.wrap(outputDir, filter2)).extract(outputDir);
    }

    public static void extract(@NotNull Path file2, @NotNull Path outputDir, @Nullable FilenameFilter filter2, boolean overwrite) throws IOException {
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(17);
        }
        if (outputDir == null) {
            ZipUtil.$$$reportNull$$$0(18);
        }
        new Decompressor.Zip(file2).filter(FileFilterAdapter.wrap(outputDir, filter2)).overwrite(overwrite).extract(outputDir);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static void extract(@NotNull File file2, @NotNull File outputDir, @Nullable FilenameFilter filter2, boolean overwrite) throws IOException {
        if (file2 == null) {
            ZipUtil.$$$reportNull$$$0(19);
        }
        if (outputDir == null) {
            ZipUtil.$$$reportNull$$$0(20);
        }
        new Decompressor.Zip(file2).filter(FileFilterAdapter.wrap(outputDir.toPath(), filter2)).overwrite(overwrite).extract(outputDir);
    }

    public static boolean isZipContainsFolder(File zip2) throws IOException {
        try (ZipFile zipFile = new ZipFile(zip2);){
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry zipEntry = en.nextElement();
                if (zipEntry.getName().indexOf(47) < 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static void compressFile(@NotNull File srcFile, @NotNull File zipFile) throws IOException {
        if (srcFile == null) {
            ZipUtil.$$$reportNull$$$0(21);
        }
        if (zipFile == null) {
            ZipUtil.$$$reportNull$$$0(22);
        }
        try (FileInputStream is = new FileInputStream(srcFile);
             ZipOutputStream os = new ZipOutputStream(new FileOutputStream(zipFile));){
            os.putNextEntry(new ZipEntry(srcFile.getName()));
            FileUtilRt.copy(is, os);
            os.closeEntry();
        }
    }

    public static void compressFile(@NotNull Path srcFile, @NotNull Path zipFile) throws IOException {
        if (srcFile == null) {
            ZipUtil.$$$reportNull$$$0(23);
        }
        if (zipFile == null) {
            ZipUtil.$$$reportNull$$$0(24);
        }
        try (ZipOutputStream os = new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]));){
            os.putNextEntry(new ZipEntry(srcFile.getFileName().toString()));
            Files.copy(srcFile, os);
            os.closeEntry();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zos";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentProcessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarOutputStream";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcFile";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zipFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/ZipUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileToZip";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileOrDirRecursively";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "addDirToZipRecursively";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "extract";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "compressFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class FileFilterAdapter
    implements Predicate<String> {
        private final File myOutputDir;
        private final FilenameFilter myFilter;

        private static FileFilterAdapter wrap(@NotNull Path outputDir, @Nullable FilenameFilter filter2) {
            if (outputDir == null) {
                FileFilterAdapter.$$$reportNull$$$0(0);
            }
            return filter2 == null ? null : new FileFilterAdapter(outputDir, filter2);
        }

        private FileFilterAdapter(@NotNull Path outputDir, FilenameFilter filter2) {
            if (outputDir == null) {
                FileFilterAdapter.$$$reportNull$$$0(1);
            }
            this.myOutputDir = outputDir.toFile();
            this.myFilter = filter2;
        }

        @Override
        public boolean test(String entryName) {
            File outputFile = new File(this.myOutputDir, entryName);
            return this.myFilter.accept(outputFile.getParentFile(), outputFile.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "outputDir";
            objectArray2[1] = "com/intellij/util/io/ZipUtil$FileFilterAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "wrap";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface FileContentProcessor {
        public static final FileContentProcessor STANDARD = new FileContentProcessor(){

            @Override
            public InputStream getContent(@NotNull File file2) throws IOException {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return new FileInputStream(file2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/io/ZipUtil$FileContentProcessor$1", "getContent"));
            }
        };

        public InputStream getContent(@NotNull File var1) throws IOException;
    }
}

