/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.DirectoryContentSpec;
import com.intellij.util.io.impl.DirectoryContentSpecImpl;
import com.intellij.util.io.impl.DirectorySpec;
import com.intellij.util.io.impl.ZipSpec;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0001J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0004J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0014J\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R \u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0002\u0018\u0019\u00a8\u0006\u001a"}, d2={"Lcom/intellij/util/io/impl/DirectorySpecBase;", "Lcom/intellij/util/io/impl/DirectoryContentSpecImpl;", "originalFile", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "children", "Ljava/util/LinkedHashMap;", "", "getChildren", "()Ljava/util/LinkedHashMap;", "getOriginalFile", "()Ljava/nio/file/Path;", "addChild", "", "name", "spec", "generateInDirectory", "target", "Ljava/io/File;", "generateInTempDir", "", "mergeWith", "other", "Lcom/intellij/util/io/DirectoryContentSpec;", "Lcom/intellij/util/io/impl/DirectorySpec;", "Lcom/intellij/util/io/impl/ZipSpec;", "intellij.platform.testFramework"})
public abstract class DirectorySpecBase
extends DirectoryContentSpecImpl {
    @NotNull
    private final LinkedHashMap<String, DirectoryContentSpecImpl> children;
    @Nullable
    private final Path originalFile;

    @NotNull
    protected final LinkedHashMap<String, DirectoryContentSpecImpl> getChildren() {
        return this.children;
    }

    public final void addChild(@NotNull String name2, @NotNull DirectoryContentSpecImpl spec) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Map map2 = this.children;
        if (map2.containsKey(name2)) {
            DirectoryContentSpecImpl existing = this.children.get(name2);
            if (spec instanceof DirectorySpecBase && existing instanceof DirectorySpecBase) {
                Map map3 = ((DirectorySpecBase)existing).children;
                Map map4 = ((DirectorySpecBase)spec).children;
                map3.putAll(map4);
                return;
            }
            throw (Throwable)new IllegalArgumentException("'" + name2 + "' already exists");
        }
        ((Map)this.children).put(name2, spec);
    }

    /*
     * WARNING - void declaration
     */
    protected final void generateInDirectory(@NotNull File target2) {
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Object object = this.children;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void name2;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            object = (String)entry2.getKey();
            entry2 = entry;
            DirectoryContentSpecImpl child = (DirectoryContentSpecImpl)entry2.getValue();
            child.generate(new File(target2, (String)name2));
        }
    }

    @Override
    @NotNull
    public Path generateInTempDir() {
        File file2 = FileUtil.createTempDirectory("directory-by-spec", null, true);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"FileUtil.createTempDirec\u2026ory-by-spec\", null, true)");
        File target2 = file2;
        this.generate(target2);
        Path path2 = target2.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"target.toPath()");
        return path2;
    }

    @NotNull
    public final Map<String, DirectoryContentSpecImpl> getChildren() {
        Map<String, DirectoryContentSpecImpl> map2 = Collections.unmodifiableMap((Map)this.children);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"Collections.unmodifiableMap(children)");
        return map2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DirectoryContentSpecImpl mergeWith(@NotNull DirectoryContentSpec other) {
        DirectorySpecBase directorySpecBase;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean bl = Intrinsics.areEqual(other.getClass(), this.getClass());
        if (!bl) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        DirectorySpecBase cfr_ignored_0 = (DirectorySpecBase)other;
        Object object = other;
        if (object instanceof DirectorySpec) {
            directorySpecBase = new DirectorySpec(null, 1, null);
        } else if (object instanceof ZipSpec) {
            directorySpecBase = new ZipSpec();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        DirectorySpecBase result2 = directorySpecBase;
        result2.children.putAll((Map<String, DirectoryContentSpecImpl>)this.children);
        Object object2 = ((DirectorySpecBase)other).children;
        Iterator iterator = object2.entrySet().iterator();
        while (iterator.hasNext()) {
            void name2;
            Object object3 = object = iterator.next();
            object2 = (String)object3.getKey();
            object3 = object;
            DirectoryContentSpecImpl child = (DirectoryContentSpecImpl)object3.getValue();
            DirectoryContentSpecImpl oldChild = this.children.get(name2);
            Map map2 = result2.children;
            DirectoryContentSpecImpl directoryContentSpecImpl = oldChild;
            if (directoryContentSpecImpl == null || (directoryContentSpecImpl = directoryContentSpecImpl.mergeWith(child)) == null) {
                directoryContentSpecImpl = child;
            }
            map2.put(name2, directoryContentSpecImpl);
        }
        return result2;
    }

    @Override
    @Nullable
    public Path getOriginalFile() {
        return this.originalFile;
    }

    private DirectorySpecBase(Path originalFile) {
        super(null);
        this.originalFile = originalFile;
        this.children = new LinkedHashMap();
    }

    public /* synthetic */ DirectorySpecBase(Path originalFile, DefaultConstructorMarker $constructor_marker) {
        this(originalFile);
    }
}

