/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.CompositeMessageBus;
import com.intellij.util.messages.impl.CompositeMessageBus$WhenMappings;
import com.intellij.util.messages.impl.CompositeMessageBusKt;
import com.intellij.util.messages.impl.DescriptorBasedMessageBusConnection;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusEx;
import com.intellij.util.messages.impl.MessageBusImpl;
import com.intellij.util.messages.impl.MessagePublisher;
import com.intellij.util.messages.impl.ToDirectChildrenMessagePublisher;
import com.intellij.util.messages.impl.ToParentMessagePublisher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0001J\b\u0010\u0014\u001a\u00020\u0012H\u0017J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u001b\u0010\u0016\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016\u00a2\u0006\u0002\u0010\u001aJ!\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00182\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ/\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H!0 \"\u0004\b\u0000\u0010!2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H!0\u001d2\u0006\u0010\"\u001a\u00020#H\u0010\u00a2\u0006\u0002\b$J\u001a\u0010%\u001a\u00020\u00122\u0010\u0010&\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030(0'H\u0016J\b\u0010)\u001a\u00020\u0012H\u0014J*\u0010*\u001a\u00020\u00122\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001d2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00190\t2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020-H\u0016J\u001b\u0010/\u001a\u00020-2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016\u00a2\u0006\u0002\u00100J\u0014\u00101\u001a\u00020\u00122\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0016J\u000e\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u0001J\b\u00104\u001a\u00020\u0012H\u0016J\"\u00105\u001a\u00020\u00122\u0018\u00106\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\t07H\u0016J\u001c\u0010,\u001a\u00020\u0012\"\u0004\b\u0000\u0010!2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H!0\u001dH\u0002J\u001e\u00108\u001a\u00020\u00122\u0006\u00109\u001a\u00020:2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00100\fH\u0016R:\u0010\b\u001a.\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00010\u0001 \n*\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00010\u00010\f\u00a2\u0006\u0002\b\u000b0\t\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\t0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/intellij/util/messages/impl/CompositeMessageBus;", "Lcom/intellij/util/messages/impl/MessageBusImpl;", "Lcom/intellij/util/messages/impl/MessageBusEx;", "owner", "Lcom/intellij/util/messages/MessageBusOwner;", "parentBus", "(Lcom/intellij/util/messages/MessageBusOwner;Lcom/intellij/util/messages/impl/CompositeMessageBus;)V", "(Lcom/intellij/util/messages/MessageBusOwner;)V", "childBuses", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "topicClassToListenerDescriptor", "", "", "Lcom/intellij/util/messages/ListenerDescriptor;", "addChild", "", "bus", "clearAllSubscriberCache", "clearPublisherCache", "clearSubscriberCache", "topicAndHandlerPairs", "", "", "([Ljava/lang/Object;)V", "computeSubscribers", "topic", "Lcom/intellij/util/messages/Topic;", "(Lcom/intellij/util/messages/Topic;)[Ljava/lang/Object;", "createPublisher", "Lcom/intellij/util/messages/impl/MessagePublisher;", "L", "direction", "Lcom/intellij/util/messages/Topic$BroadcastDirection;", "createPublisher$intellij_platform_core", "disconnectPluginConnections", "predicate", "Ljava/util/function/Predicate;", "Ljava/lang/Class;", "disposeChildren", "doComputeSubscribers", "result", "subscribeLazyListeners", "", "hasChildren", "notifyConnectionTerminated", "([Ljava/lang/Object;)Z", "notifyOnSubscriptionToTopicToChildren", "onChildBusDisposed", "childBus", "removeEmptyConnectionsRecursively", "setLazyListeners", "map", "Ljava/util/concurrent/ConcurrentMap;", "unsubscribeLazyListeners", "module", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "listenerDescriptors", "intellij.platform.core"})
@VisibleForTesting
@ApiStatus.Internal
public class CompositeMessageBus
extends MessageBusImpl
implements MessageBusEx {
    private final List<MessageBusImpl> childBuses;
    private volatile Map<String, List<ListenerDescriptor>> topicClassToListenerDescriptor;

    @Override
    public void setLazyListeners(@NotNull ConcurrentMap<String, List<ListenerDescriptor>> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Map<String, List<ListenerDescriptor>> topicClassToListenerDescriptor = this.topicClassToListenerDescriptor;
        if (topicClassToListenerDescriptor == CompositeMessageBusKt.access$getEMPTY_MAP$p()) {
            this.topicClassToListenerDescriptor = map2;
        } else {
            topicClassToListenerDescriptor.putAll((Map<String, List<ListenerDescriptor>>)map2);
            if (this.rootBus != this) {
                this.rootBus.subscriberCache.clear();
            }
            this.subscriberCache.clear();
        }
    }

    @Override
    public boolean hasChildren() {
        return !this.childBuses.isEmpty();
    }

    public final void addChild(@NotNull MessageBusImpl bus) {
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        CompositeMessageBusKt.access$childrenListChanged(this);
        this.childBuses.add(bus);
    }

    public final void onChildBusDisposed(@NotNull MessageBusImpl childBus) {
        Intrinsics.checkNotNullParameter((Object)childBus, (String)"childBus");
        boolean removed = this.childBuses.remove(childBus);
        CompositeMessageBusKt.access$childrenListChanged(this);
        MessageBusImpl.LOG.assertTrue(removed);
    }

    @Override
    @NotNull
    public <L> MessagePublisher<L> createPublisher$intellij_platform_core(@NotNull Topic<L> topic, @NotNull Topic.BroadcastDirection direction) {
        MessagePublisher messagePublisher;
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        switch (CompositeMessageBus$WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                messagePublisher = new ToParentMessagePublisher<L>(topic, this);
                break;
            }
            case 2: {
                boolean bl;
                boolean bl2 = bl = this.parentBus == null;
                if (!bl) {
                    boolean bl3 = false;
                    String string2 = "Broadcast direction TO_DIRECT_CHILDREN is allowed only for app level message bus. " + "Please publish to app level message bus or change topic " + topic.getListenerClass() + " broadcast direction to NONE or TO_PARENT";
                    throw new IllegalArgumentException(string2.toString());
                }
                messagePublisher = new ToDirectChildrenMessagePublisher<L>(topic, this, this.childBuses);
                break;
            }
            default: {
                messagePublisher = new MessagePublisher(topic, this);
            }
        }
        return messagePublisher;
    }

    @Override
    @NotNull
    public Object[] computeSubscribers(@NotNull Topic<?> topic) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        if (this.owner.isDisposed()) {
            objectArray = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_OBJECT_ARRAY, (String)"ArrayUtilRt.EMPTY_OBJECT_ARRAY");
        } else {
            objectArray = super.computeSubscribers(topic);
        }
        return objectArray;
    }

    @Override
    public void doComputeSubscribers(@NotNull Topic<?> topic, @NotNull List<Object> result2, boolean subscribeLazyListeners2) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        if (subscribeLazyListeners2) {
            this.subscribeLazyListeners(topic);
        }
        super.doComputeSubscribers(topic, result2, subscribeLazyListeners2);
        if (topic.getBroadcastDirection() == Topic.BroadcastDirection.TO_CHILDREN) {
            Iterator<MessageBusImpl> iterator = this.childBuses.iterator();
            while (iterator.hasNext()) {
                MessageBusImpl childBus;
                MessageBusImpl messageBusImpl = childBus = iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)messageBusImpl, (String)"childBus");
                if (messageBusImpl.isDisposed()) continue;
                childBus.doComputeSubscribers(topic, result2, !childBus.owner.isParentLazyListenersIgnored());
            }
        }
    }

    private final <L> void subscribeLazyListeners(Topic<L> topic) {
        if (topic.getListenerClass() == Runnable.class || this.topicClassToListenerDescriptor == CompositeMessageBusKt.access$getEMPTY_MAP$p()) {
            return;
        }
        Class<L> clazz = topic.getListenerClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"topic.listenerClass");
        List<ListenerDescriptor> list2 = this.topicClassToListenerDescriptor.remove(clazz.getName());
        if (list2 == null) {
            return;
        }
        List<ListenerDescriptor> listenerDescriptors = list2;
        LinkedHashMap listenerMap = new LinkedHashMap();
        for (ListenerDescriptor listenerDescriptor : listenerDescriptors) {
            try {
                List list3 = (List)listenerMap.computeIfAbsent(listenerDescriptor.pluginDescriptor, subscribeLazyListeners.1.INSTANCE);
                Object object = this.owner.createListener(listenerDescriptor);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"owner.createListener(listenerDescriptor)");
                list3.add(object);
            }
            catch (ExtensionNotApplicableException extensionNotApplicableException) {
            }
            catch (ProcessCanceledException e) {
                throw (Throwable)e;
            }
            catch (Throwable e) {
                MessageBusImpl.LOG.error("Cannot create listener", e);
            }
        }
        listenerMap.forEach(new BiConsumer(this, topic){
            final /* synthetic */ CompositeMessageBus this$0;
            final /* synthetic */ Topic $topic;

            public final void accept(@NotNull PluginDescriptor key, @NotNull List<Object> listeners2) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Intrinsics.checkNotNullParameter(listeners2, (String)"listeners");
                this.this$0.subscribers.add(new DescriptorBasedMessageBusConnection(key, this.$topic, listeners2));
            }
            {
                this.this$0 = compositeMessageBus;
                this.$topic = topic;
            }
        });
    }

    @Override
    public void notifyOnSubscriptionToTopicToChildren(@NotNull Topic<?> topic) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        for (MessageBusImpl childBus : this.childBuses) {
            childBus.subscriberCache.remove(topic);
            childBus.notifyOnSubscriptionToTopicToChildren(topic);
        }
    }

    @Override
    public boolean notifyConnectionTerminated(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter((Object)topicAndHandlerPairs, (String)"topicAndHandlerPairs");
        boolean isChildClearingNeeded = super.notifyConnectionTerminated(topicAndHandlerPairs);
        if (!isChildClearingNeeded) {
            return false;
        }
        Iterable $this$forEach$iv = this.childBuses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessageBusImpl it = (MessageBusImpl)element$iv;
            boolean bl = false;
            it.clearSubscriberCache(topicAndHandlerPairs);
        }
        this.rootBus.getQueue$intellij_platform_core().queue.removeIf(new Predicate(topicAndHandlerPairs){
            final /* synthetic */ Object[] $topicAndHandlerPairs;

            public final boolean test(Message it) {
                Message message2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)message2, (String)"it");
                return CompositeMessageBusKt.access$nullizeHandlersFromMessage(message2, this.$topicAndHandlerPairs);
            }
            {
                this.$topicAndHandlerPairs = objectArray;
            }
        });
        return false;
    }

    @Override
    public void clearSubscriberCache(@NotNull Object[] topicAndHandlerPairs) {
        Intrinsics.checkNotNullParameter((Object)topicAndHandlerPairs, (String)"topicAndHandlerPairs");
        super.clearSubscriberCache(topicAndHandlerPairs);
        Iterable $this$forEach$iv = this.childBuses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessageBusImpl it = (MessageBusImpl)element$iv;
            boolean bl = false;
            it.clearSubscriberCache(topicAndHandlerPairs);
        }
    }

    @Override
    public void removeEmptyConnectionsRecursively() {
        super.removeEmptyConnectionsRecursively();
        Iterable $this$forEach$iv = this.childBuses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessageBusImpl p1 = (MessageBusImpl)element$iv;
            boolean bl = false;
            p1.removeEmptyConnectionsRecursively();
        }
    }

    @Override
    public void clearPublisherCache() {
        this.publisherCache.clear();
        Iterable $this$forEach$iv = this.childBuses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessageBusImpl childBus = (MessageBusImpl)element$iv;
            boolean bl = false;
            if (childBus instanceof CompositeMessageBus) {
                ((CompositeMessageBus)childBus).clearPublisherCache();
                continue;
            }
            childBus.publisherCache.clear();
        }
    }

    @Override
    public void unsubscribeLazyListeners(@NotNull IdeaPluginDescriptor module, @NotNull List<ListenerDescriptor> listenerDescriptors) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(listenerDescriptors, (String)"listenerDescriptors");
        this.topicClassToListenerDescriptor.values().removeIf(new Predicate(module){
            final /* synthetic */ IdeaPluginDescriptor $module;

            public final boolean test(@NotNull List<ListenerDescriptor> descriptors) {
                Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
                if (descriptors.removeIf(new Predicate(this){
                    final /* synthetic */ unsubscribeLazyListeners.1 this$0;

                    public final boolean test(@NotNull ListenerDescriptor it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return it.pluginDescriptor == this.this$0.$module;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                })) {
                    return descriptors.isEmpty();
                }
                return false;
            }
            {
                this.$module = ideaPluginDescriptor;
            }
        });
        if (listenerDescriptors.isEmpty() || this.subscribers.isEmpty()) {
            return;
        }
        HashMap topicToDescriptors = new HashMap();
        for (ListenerDescriptor descriptor : listenerDescriptors) {
            Set set2 = (Set)topicToDescriptors.computeIfAbsent(descriptor.topicClassName, unsubscribeLazyListeners.2.INSTANCE);
            String string2 = descriptor.listenerClassName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"descriptor.listenerClassName");
            set2.add(string2);
        }
        boolean isChanged = false;
        List newSubscribers = null;
        Iterator iterator = this.subscribers.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"subscribers.iterator()");
        Iterator connectionIterator = iterator;
        while (connectionIterator.hasNext()) {
            List newHandlers;
            Set listenerClassNames;
            DescriptorBasedMessageBusConnection connection;
            Object e = connectionIterator.next();
            if (!(e instanceof DescriptorBasedMessageBusConnection)) {
                e = null;
            }
            if ((DescriptorBasedMessageBusConnection)e == null) {
                continue;
            }
            if (module != connection.module) continue;
            Class<?> clazz = connection.topic.getListenerClass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"connection.topic.listenerClass");
            if ((Set)topicToDescriptors.get(clazz.getName()) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)listenerClassNames, (String)"topicToDescriptors.get(c\u2026erClass.name) ?: continue");
            if (CompositeMessageBusKt.access$computeNewHandlers(connection.handlers, listenerClassNames) == null) {
                continue;
            }
            isChanged = true;
            connectionIterator.remove();
            if (newHandlers.isEmpty()) continue;
            if (newSubscribers == null) {
                newSubscribers = new ArrayList();
            }
            newSubscribers.add(new DescriptorBasedMessageBusConnection(module, connection.topic, newHandlers));
        }
        List list2 = newSubscribers;
        if (list2 != null) {
            List list3 = list2;
            ConcurrentLinkedQueue concurrentLinkedQueue = this.subscribers;
            Collection p1 = list3;
            boolean bl = false;
            concurrentLinkedQueue.addAll(p1);
        }
        if (isChanged) {
            if (this.rootBus != this) {
                this.rootBus.subscriberCache.clear();
            }
            this.subscriberCache.clear();
        }
    }

    @Override
    public void disconnectPluginConnections(@NotNull Predicate<Class<?>> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        super.disconnectPluginConnections(predicate);
        Iterable $this$forEach$iv = this.childBuses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessageBusImpl it = (MessageBusImpl)element$iv;
            boolean bl = false;
            it.disconnectPluginConnections(predicate);
        }
    }

    @Override
    @TestOnly
    public void clearAllSubscriberCache() {
        MessageBusImpl.LOG.assertTrue(this.rootBus != this);
        this.rootBus.subscriberCache.clear();
        this.subscriberCache.clear();
        Iterable $this$forEach$iv = this.childBuses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MessageBusImpl it = (MessageBusImpl)element$iv;
            boolean bl = false;
            it.subscriberCache.clear();
        }
    }

    @Override
    protected void disposeChildren() {
        Iterable $this$forEach$iv = this.childBuses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Disposable p1 = (Disposable)element$iv;
            boolean bl = false;
            Disposer.dispose(p1);
        }
    }

    public CompositeMessageBus(@NotNull MessageBusOwner owner, @NotNull CompositeMessageBus parentBus) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)parentBus, (String)"parentBus");
        super(owner, parentBus);
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"ContainerUtil.createLock\u2026iteList<MessageBusImpl>()");
        this.childBuses = list2;
        this.topicClassToListenerDescriptor = CompositeMessageBusKt.access$getEMPTY_MAP$p();
    }

    public CompositeMessageBus(@NotNull MessageBusOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(owner);
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"ContainerUtil.createLock\u2026iteList<MessageBusImpl>()");
        this.childBuses = list2;
        this.topicClassToListenerDescriptor = CompositeMessageBusKt.access$getEMPTY_MAP$p();
    }
}

