/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MouseInputListener;
import org.jetbrains.annotations.NotNull;

public class MouseEventAdapter<T>
extends MouseAdapter
implements MouseInputListener {
    private final T myAdapter;

    public MouseEventAdapter(T adapter) {
        this.myAdapter = adapter;
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        if (event == null || event.isConsumed()) {
            return;
        }
        MouseListener listener2 = this.getMouseListener(this.myAdapter);
        if (listener2 != null) {
            listener2.mouseEntered(this.convert(event));
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (event == null || event.isConsumed()) {
            return;
        }
        MouseListener listener2 = this.getMouseListener(this.myAdapter);
        if (listener2 != null) {
            listener2.mousePressed(this.convert(event));
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (event == null || event.isConsumed()) {
            return;
        }
        MouseListener listener2 = this.getMouseListener(this.myAdapter);
        if (listener2 != null) {
            listener2.mouseClicked(this.convert(event));
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (event == null || event.isConsumed()) {
            return;
        }
        MouseListener listener2 = this.getMouseListener(this.myAdapter);
        if (listener2 != null) {
            listener2.mouseReleased(this.convert(event));
        }
    }

    @Override
    public void mouseExited(MouseEvent event) {
        if (event == null || event.isConsumed()) {
            return;
        }
        MouseListener listener2 = this.getMouseListener(this.myAdapter);
        if (listener2 != null) {
            listener2.mouseExited(this.convert(event));
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (event == null || event.isConsumed()) {
            return;
        }
        MouseMotionListener listener2 = this.getMouseMotionListener(this.myAdapter);
        if (listener2 != null) {
            listener2.mouseMoved(this.convert(event));
        }
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (event == null || event.isConsumed()) {
            return;
        }
        MouseMotionListener listener2 = this.getMouseMotionListener(this.myAdapter);
        if (listener2 != null) {
            listener2.mouseDragged(this.convert(event));
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        if (event == null || event.isConsumed()) {
            return;
        }
        MouseWheelListener listener2 = this.getMouseWheelListener(this.myAdapter);
        if (listener2 != null) {
            listener2.mouseWheelMoved(this.convert(event));
        }
    }

    protected MouseListener getMouseListener(T adapter) {
        return adapter instanceof MouseListener ? (MouseListener)adapter : null;
    }

    protected MouseMotionListener getMouseMotionListener(T adapter) {
        return adapter instanceof MouseMotionListener ? (MouseMotionListener)adapter : null;
    }

    protected MouseWheelListener getMouseWheelListener(T adapter) {
        return adapter instanceof MouseWheelListener ? (MouseWheelListener)adapter : null;
    }

    @NotNull
    protected MouseEvent convert(@NotNull MouseEvent event) {
        if (event == null) {
            MouseEventAdapter.$$$reportNull$$$0(0);
        }
        MouseEvent mouseEvent = event;
        if (mouseEvent == null) {
            MouseEventAdapter.$$$reportNull$$$0(1);
        }
        return mouseEvent;
    }

    @NotNull
    protected MouseWheelEvent convert(@NotNull MouseWheelEvent event) {
        if (event == null) {
            MouseEventAdapter.$$$reportNull$$$0(2);
        }
        MouseWheelEvent mouseWheelEvent = event;
        if (mouseWheelEvent == null) {
            MouseEventAdapter.$$$reportNull$$$0(3);
        }
        return mouseWheelEvent;
    }

    @NotNull
    public static MouseEvent convert(@NotNull MouseEvent event, Component source) {
        if (event == null) {
            MouseEventAdapter.$$$reportNull$$$0(4);
        }
        Point point = event.getLocationOnScreen();
        SwingUtilities.convertPointFromScreen(point, source);
        return MouseEventAdapter.convert(event, source, point.x, point.y);
    }

    @NotNull
    public static MouseEvent convert(@NotNull MouseEvent event, Component source, int x, int y) {
        if (event == null) {
            MouseEventAdapter.$$$reportNull$$$0(5);
        }
        return MouseEventAdapter.convert(event, source, event.getID(), event.getWhen(), event.getModifiers() | event.getModifiersEx(), x, y);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static MouseEvent convert(@NotNull MouseEvent event, Component source, int id2, long when, int modifiers, int x, int n) {
        void y;
        if (event == null) {
            MouseEventAdapter.$$$reportNull$$$0(6);
        }
        if (event instanceof MouseWheelEvent) {
            return MouseEventAdapter.convert((MouseWheelEvent)event, source, id2, when, modifiers, x, (int)y);
        }
        if (event instanceof MenuDragMouseEvent) {
            return MouseEventAdapter.convert((MenuDragMouseEvent)event, source, id2, when, modifiers, x, (int)y);
        }
        return new MouseEvent(source, id2, when, modifiers, x, (int)y, event.getClickCount(), event.isPopupTrigger(), event.getButton());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static MouseWheelEvent convert(@NotNull MouseWheelEvent event, Component source, int id2, long when, int modifiers, int x, int n) {
        void y;
        if (event == null) {
            MouseEventAdapter.$$$reportNull$$$0(7);
        }
        return new MouseWheelEvent(source, id2, when, modifiers, x, (int)y, event.getXOnScreen(), event.getYOnScreen(), event.getClickCount(), event.isPopupTrigger(), event.getScrollType(), event.getScrollAmount(), event.getWheelRotation(), event.getPreciseWheelRotation());
    }

    @NotNull
    public static MenuDragMouseEvent convert(MenuDragMouseEvent event, Component source, int id2, long when, int modifiers, int x, int y) {
        return new MenuDragMouseEvent(source, id2, when, modifiers, x, y, event.getClickCount(), event.isPopupTrigger(), event.getPath(), event.getMenuSelectionManager());
    }

    private static boolean dispatch(Component component2, @NotNull MouseEvent event) {
        if (event == null) {
            MouseEventAdapter.$$$reportNull$$$0(8);
        }
        component2.dispatchEvent(event);
        return event.isConsumed();
    }

    public static void redispatch(@NotNull MouseEvent event, Component source) {
        if (event == null) {
            MouseEventAdapter.$$$reportNull$$$0(9);
        }
        if (source != null && MouseEventAdapter.dispatch(source, MouseEventAdapter.convert(event, source))) {
            event.consume();
        }
    }

    public static void redispatch(@NotNull MouseEvent event, Component source, int x, int y) {
        if (event == null) {
            MouseEventAdapter.$$$reportNull$$$0(10);
        }
        if (source != null && MouseEventAdapter.dispatch(source, MouseEventAdapter.convert(event, source, x, y))) {
            event.consume();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/MouseEventAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/MouseEventAdapter";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dispatch";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "redispatch";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

