/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.accessibility;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AccessibleContextUtil {
    static final String PUNCTUATION_CHARACTER = ".";
    static final String PUNCTUATION_SEPARATOR = "  ";

    public static void setName(@NotNull Component component2, @Nls String name2) {
        if (component2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(0);
        }
        AccessibleContextUtil.setAccessibleName(component2, name2);
    }

    public static void setName(@NotNull Component component2, @NotNull Component source) {
        if (component2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(1);
        }
        if (source == null) {
            AccessibleContextUtil.$$$reportNull$$$0(2);
        }
        AccessibleContextUtil.setName(component2, AccessibleContextUtil.getAccessibleName(source));
    }

    public static void setCombinedName(@NotNull Component component2, @NotNull Component j1, @NotNull @NlsSafe String separator, @NotNull Component j2) {
        if (component2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(3);
        }
        if (j1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(4);
        }
        if (separator == null) {
            AccessibleContextUtil.$$$reportNull$$$0(5);
        }
        if (j2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(6);
        }
        AccessibleContextUtil.setAccessibleName(component2, AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleName(j1), separator, AccessibleContextUtil.getAccessibleName(j2)));
    }

    public static void setCombinedName(@NotNull Component component2, @NotNull Component j1, @NotNull @NlsSafe String separator1, @NotNull Component j2, @NotNull @NlsSafe String separator2, @NotNull Component j3) {
        if (component2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(7);
        }
        if (j1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(8);
        }
        if (separator1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(9);
        }
        if (j2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(10);
        }
        if (separator2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(11);
        }
        if (j3 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(12);
        }
        AccessibleContextUtil.setAccessibleName(component2, AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleName(j1), separator1, AccessibleContextUtil.getAccessibleName(j2), separator2, AccessibleContextUtil.getAccessibleName(j3)));
    }

    @Nls
    @Nullable
    public static String getCombinedName(@NotNull Component j1, @NotNull @NlsSafe String separator, @NotNull Component j2) {
        if (j1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(13);
        }
        if (separator == null) {
            AccessibleContextUtil.$$$reportNull$$$0(14);
        }
        if (j2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(15);
        }
        return AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleName(j1), separator, AccessibleContextUtil.getAccessibleName(j2));
    }

    @Nls
    @Nullable
    public static String getCombinedName(@NotNull Component j1, @NotNull @NlsSafe String separator1, @NotNull Component j2, @NotNull @NlsSafe String separator2, @NotNull Component j3) {
        if (j1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(16);
        }
        if (separator1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(17);
        }
        if (j2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(18);
        }
        if (separator2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(19);
        }
        if (j3 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(20);
        }
        return AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleName(j1), separator1, AccessibleContextUtil.getAccessibleName(j2), separator2, AccessibleContextUtil.getAccessibleName(j3));
    }

    @Nls
    @Nullable
    public static String getCombinedName(@NotNull @NlsSafe String separator, Component ... components) {
        if (separator == null) {
            AccessibleContextUtil.$$$reportNull$$$0(21);
        }
        String result2 = "";
        for (Component c : components) {
            result2 = AccessibleContextUtil.combineAccessibleStrings(result2, separator, AccessibleContextUtil.getAccessibleName(c));
        }
        return result2;
    }

    public static void setDescription(@NotNull Component component2, @NotNull Component source) {
        if (component2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(22);
        }
        if (source == null) {
            AccessibleContextUtil.$$$reportNull$$$0(23);
        }
        AccessibleContextUtil.setAccessibleDescription(component2, AccessibleContextUtil.getAccessibleDescription(source));
    }

    public static void setDescription(@NotNull Component component2, @Nls String description) {
        if (component2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(24);
        }
        AccessibleContextUtil.setAccessibleDescription(component2, description);
    }

    public static void setCombinedDescription(@NotNull Component component2, @NotNull Component j1, @NotNull @NlsSafe String separator, @NotNull Component j2) {
        if (component2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(25);
        }
        if (j1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(26);
        }
        if (separator == null) {
            AccessibleContextUtil.$$$reportNull$$$0(27);
        }
        if (j2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(28);
        }
        AccessibleContextUtil.setAccessibleDescription(component2, AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleDescription(j1), separator, AccessibleContextUtil.getAccessibleDescription(j2)));
    }

    public static void setCombinedDescription(@NotNull Component component2, @NotNull Component j1, @NotNull @NlsSafe String separator1, @NotNull Component j2, @NotNull @NlsSafe String separator2, @NotNull Component j3) {
        if (component2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(29);
        }
        if (j1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(30);
        }
        if (separator1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(31);
        }
        if (j2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(32);
        }
        if (separator2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(33);
        }
        if (j3 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(34);
        }
        AccessibleContextUtil.setAccessibleDescription(component2, AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleDescription(j1), separator1, AccessibleContextUtil.getAccessibleDescription(j2), separator2, AccessibleContextUtil.getAccessibleDescription(j3)));
    }

    public static String getCombinedDescription(@NotNull Component j1, @NotNull @NlsSafe String separator, @NotNull Component j2) {
        if (j1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(35);
        }
        if (separator == null) {
            AccessibleContextUtil.$$$reportNull$$$0(36);
        }
        if (j2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(37);
        }
        return AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleDescription(j1), separator, AccessibleContextUtil.getAccessibleDescription(j2));
    }

    public static String getCombinedDescription(@NotNull Component j1, @NotNull @NlsSafe String separator1, @NotNull Component j2, @NotNull @NlsSafe String separator2, @NotNull Component j3) {
        if (j1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(38);
        }
        if (separator1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(39);
        }
        if (j2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(40);
        }
        if (separator2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(41);
        }
        if (j3 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(42);
        }
        return AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.getAccessibleDescription(j1), separator1, AccessibleContextUtil.getAccessibleDescription(j2), separator2, AccessibleContextUtil.getAccessibleDescription(j3));
    }

    @Nullable
    @Nls
    public static String getUniqueDescription(@NotNull AccessibleContext context2, @Nullable @Nls String description) {
        String name2;
        if (context2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(43);
        }
        if (StringUtil.equals(description, name2 = context2.getAccessibleName())) {
            return null;
        }
        return description;
    }

    public static void setParent(@NotNull Component component2, @Nullable Component newParent) {
        if (component2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(44);
        }
        if (newParent instanceof Accessible) {
            component2.getAccessibleContext().setAccessibleParent((Accessible)((Object)newParent));
            return;
        }
        component2.getAccessibleContext().setAccessibleParent(null);
    }

    @Nullable
    @Nls
    public static String combineAccessibleStrings(@Nullable @Nls String s1, @Nullable @Nls String s2) {
        return AccessibleContextUtil.combineAccessibleStrings(s1, " ", s2);
    }

    @Nullable
    @Nls
    public static String combineAccessibleStrings(@Nullable @Nls String s1, @NotNull @NlsSafe String separator, @Nullable @Nls String s2) {
        if (separator == null) {
            AccessibleContextUtil.$$$reportNull$$$0(45);
        }
        if (StringUtil.isEmpty(s1)) {
            return s2;
        }
        if (StringUtil.isEmpty(s2)) {
            return s1;
        }
        return s1 + separator + s2;
    }

    @Nullable
    @Nls
    public static String combineAccessibleStrings(@Nullable @Nls String s1, @NotNull @Nls String separator1, @Nullable @Nls String s2, @NotNull @Nls String separator2, @Nullable @Nls String s3) {
        if (separator1 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(46);
        }
        if (separator2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(47);
        }
        return AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.combineAccessibleStrings(s1, separator1, s2), separator2, s3);
    }

    @NotNull
    public static String replaceLineSeparatorsWithPunctuation(@Nullable String text2) {
        if (StringUtil.isEmpty(text2)) {
            return "";
        }
        String[] lines2 = StringUtil.splitByLines(text2);
        StringBuilder result2 = new StringBuilder();
        boolean first2 = true;
        for (String line : lines2) {
            if (StringUtil.isEmpty(line = line.trim())) continue;
            if (first2) {
                first2 = false;
            } else {
                result2.append(PUNCTUATION_SEPARATOR);
            }
            result2.append(line);
            if (line.endsWith(PUNCTUATION_CHARACTER)) continue;
            result2.append(PUNCTUATION_CHARACTER);
        }
        String string2 = result2.toString();
        if (string2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(48);
        }
        return string2;
    }

    @Nls
    @Nullable
    private static String getAccessibleName(@NotNull Component component2) {
        if (component2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(49);
        }
        if (component2 instanceof Accessible) {
            return component2.getAccessibleContext().getAccessibleName();
        }
        return null;
    }

    private static void setAccessibleName(@NotNull Component component2, @Nls String name2) {
        if (component2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(50);
        }
        if (component2 instanceof Accessible) {
            component2.getAccessibleContext().setAccessibleName(name2);
        }
    }

    @Nullable
    @Nls
    private static String getAccessibleDescription(@NotNull Component component2) {
        if (component2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(51);
        }
        if (component2 instanceof Accessible) {
            return component2.getAccessibleContext().getAccessibleDescription();
        }
        return null;
    }

    private static void setAccessibleDescription(@NotNull Component component2, @Nullable @Nls String description) {
        if (component2 == null) {
            AccessibleContextUtil.$$$reportNull$$$0(52);
        }
        if (component2 instanceof Accessible) {
            component2.getAccessibleContext().setAccessibleDescription(description);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 48: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: 
            case 8: 
            case 13: 
            case 16: 
            case 26: 
            case 30: 
            case 35: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "j1";
                break;
            }
            case 5: 
            case 14: 
            case 21: 
            case 27: 
            case 36: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 6: 
            case 10: 
            case 15: 
            case 18: 
            case 28: 
            case 32: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "j2";
                break;
            }
            case 9: 
            case 17: 
            case 31: 
            case 39: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator1";
                break;
            }
            case 11: 
            case 19: 
            case 33: 
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator2";
                break;
            }
            case 12: 
            case 20: 
            case 34: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "j3";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/accessibility/AccessibleContextUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/accessibility/AccessibleContextUtil";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceLineSeparatorsWithPunctuation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setCombinedName";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCombinedName";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setCombinedDescription";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getCombinedDescription";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueDescription";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "combineAccessibleStrings";
                break;
            }
            case 48: {
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getAccessibleName";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "setAccessibleName";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getAccessibleDescription";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "setAccessibleDescription";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 48: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

