/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagingErrorDialog;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackagesNotificationPanel {
    private final JEditorPane myHtmlViewer;
    private final Map<String, Runnable> myLinkHandlers;
    @NlsContexts.DialogTitle
    private String myErrorTitle;
    private PackageManagementService.ErrorDescription myErrorDescription;

    public PackagesNotificationPanel() {
        this(PackagesNotificationPanel::showError);
    }

    public PackagesNotificationPanel(final @NotNull BiConsumer<? super String, ? super PackageManagementService.ErrorDescription> showErrorFunction) {
        if (showErrorFunction == null) {
            PackagesNotificationPanel.$$$reportNull$$$0(0);
        }
        this.myLinkHandlers = new HashMap<String, Runnable>();
        this.myHtmlViewer = SwingHelper.createHtmlViewer((boolean)true, null, null, null);
        this.myHtmlViewer.setVisible(false);
        this.myHtmlViewer.setOpaque(true);
        this.myHtmlViewer.addHyperlinkListener(new HyperlinkAdapter(){

            @Override
            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                Runnable handler;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((handler = PackagesNotificationPanel.this.myLinkHandlers.get(e.getDescription())) != null) {
                    handler.run();
                } else if (PackagesNotificationPanel.this.myErrorTitle != null && PackagesNotificationPanel.this.myErrorDescription != null) {
                    showErrorFunction.accept(PackagesNotificationPanel.this.myErrorTitle, PackagesNotificationPanel.this.myErrorDescription);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/packaging/PackagesNotificationPanel$1", "hyperlinkActivated"));
            }
        });
    }

    public static void showError(@NotNull @NlsContexts.DialogTitle String title, @NotNull PackageManagementService.ErrorDescription description) {
        if (title == null) {
            PackagesNotificationPanel.$$$reportNull$$$0(1);
        }
        if (description == null) {
            PackagesNotificationPanel.$$$reportNull$$$0(2);
        }
        PackagingErrorDialog dialog = new PackagingErrorDialog(title, description);
        dialog.show();
    }

    public void showResult(String packageName, @Nullable PackageManagementService.ErrorDescription errorDescription) {
        if (errorDescription == null) {
            String message2 = IdeBundle.message((String)"package.installed.successfully", (Object[])new Object[0]);
            if (packageName != null) {
                message2 = IdeBundle.message((String)"package.0.installed.successfully", (Object[])new Object[]{packageName});
            }
            this.showSuccess(message2);
        } else {
            String title = IdeBundle.message((String)"failed.to.install.packages.dialog.title", (Object[])new Object[0]);
            if (packageName != null) {
                title = IdeBundle.message((String)"failed.to.install.package.dialog.title", (Object[])new Object[]{packageName});
            }
            String text2 = IdeBundle.message((String)"install.package.failure", (Object[])new Object[]{packageName});
            this.showError(text2, title, errorDescription);
        }
    }

    public void addLinkHandler(String key, Runnable handler) {
        this.myLinkHandlers.put(key, handler);
    }

    public void removeAllLinkHandlers() {
        this.myLinkHandlers.clear();
    }

    public JComponent getComponent() {
        return this.myHtmlViewer;
    }

    public void showSuccess(@NlsContexts.NotificationContent String text2) {
        this.showContent(text2, MessageType.INFO.getPopupBackground());
    }

    private void showContent(@NotNull @NlsContexts.NotificationContent String text2, @NotNull Color background) {
        if (text2 == null) {
            PackagesNotificationPanel.$$$reportNull$$$0(3);
        }
        if (background == null) {
            PackagesNotificationPanel.$$$reportNull$$$0(4);
        }
        String htmlText = text2.startsWith("<html>") ? text2 : UIUtil.toHtml(text2);
        this.myHtmlViewer.setText(htmlText);
        this.myHtmlViewer.setBackground(background);
        this.setVisibleEditorPane(true);
        this.myErrorTitle = null;
        this.myErrorDescription = null;
    }

    public void showError(@NlsContexts.NotificationContent String text2, @Nullable @NlsContexts.DialogTitle String detailsTitle, PackageManagementService.ErrorDescription errorDescription) {
        this.showContent(text2, MessageType.ERROR.getPopupBackground());
        this.myErrorTitle = detailsTitle;
        this.myErrorDescription = errorDescription;
    }

    public void showWarning(@NlsContexts.NotificationContent String text2) {
        this.showContent(text2, MessageType.WARNING.getPopupBackground());
    }

    public void hide() {
        this.setVisibleEditorPane(false);
    }

    private void setVisibleEditorPane(boolean visible) {
        boolean oldVisible = this.myHtmlViewer.isVisible();
        this.myHtmlViewer.setVisible(visible);
        if (oldVisible != visible) {
            this.myHtmlViewer.revalidate();
            this.myHtmlViewer.repaint();
        }
    }

    public boolean hasLinkHandler(String key) {
        return this.myLinkHandlers.containsKey(key);
    }

    public void removeLinkHandler(String key) {
        this.myLinkHandlers.remove(key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showErrorFunction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
        }
        objectArray2[1] = "com/intellij/webcore/packaging/PackagesNotificationPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showError";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showContent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

