/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.project.ProjectKt;
import com.intellij.workspaceModel.ide.JpsImportedEntitySource;
import com.intellij.workspaceModel.ide.JpsProjectConfigLocation;
import com.intellij.workspaceModel.ide.VirtualFileUrlManagerUtil;
import com.intellij.workspaceModel.storage.impl.url.VirtualFileUrlImplKt;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u00a8\u0006\u0007"}, d2={"getJpsProjectConfigLocation", "Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation;", "project", "Lcom/intellij/openapi/project/Project;", "toExternalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "Lcom/intellij/workspaceModel/ide/JpsImportedEntitySource;", "intellij.platform.projectModel.impl"})
public final class JpsEntitySourcesKt {
    @NotNull
    public static final ProjectModelExternalSource toExternalSource(@NotNull JpsImportedEntitySource $this$toExternalSource) {
        Intrinsics.checkNotNullParameter((Object)$this$toExternalSource, (String)"$this$toExternalSource");
        ProjectModelExternalSource projectModelExternalSource = ExternalProjectSystemRegistry.getInstance().getSourceById($this$toExternalSource.getExternalSystemId());
        Intrinsics.checkNotNullExpressionValue((Object)projectModelExternalSource, (String)"ExternalProjectSystemReg\u2026rceById(externalSystemId)");
        return projectModelExternalSource;
    }

    @Nullable
    public static final JpsProjectConfigLocation getJpsProjectConfigLocation(@NotNull Project project2) {
        JpsProjectConfigLocation jpsProjectConfigLocation;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (ProjectKt.isDirectoryBased(project2)) {
            JpsProjectConfigLocation.DirectoryBased directoryBased;
            String string2 = project2.getBasePath();
            if (string2 != null) {
                String string3;
                String it = string3 = string2;
                boolean bl = false;
                VirtualFileUrlManager virtualFileUrlManager = VirtualFileUrlManagerUtil.getInstance(VirtualFileUrlManager.Companion, project2);
                Path path2 = ProjectKt.getStateStore(project2).getDirectoryStorePath();
                Intrinsics.checkNotNull((Object)path2);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"project.stateStore.directoryStorePath!!");
                VirtualFileUrl ideaFolder = VirtualFileUrlImplKt.toVirtualFileUrl((Path)path2, (VirtualFileUrlManager)virtualFileUrlManager);
                String string4 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it");
                directoryBased = new JpsProjectConfigLocation.DirectoryBased(virtualFileUrlManager.fromPath(string4), ideaFolder);
            } else {
                directoryBased = null;
            }
            jpsProjectConfigLocation = directoryBased;
        } else {
            JpsProjectConfigLocation.FileBased fileBased;
            String string5 = project2.getProjectFilePath();
            if (string5 != null) {
                String string6;
                String it = string6 = string5;
                boolean bl = false;
                VirtualFileUrlManager virtualFileUrlManager = VirtualFileUrlManagerUtil.getInstance(VirtualFileUrlManager.Companion, project2);
                String string7 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"it");
                VirtualFileUrl iprFile = virtualFileUrlManager.fromPath(string7);
                VirtualFileUrl virtualFileUrl = virtualFileUrlManager.getParentVirtualUrl(iprFile);
                Intrinsics.checkNotNull((Object)virtualFileUrl);
                fileBased = new JpsProjectConfigLocation.FileBased(iprFile, virtualFileUrl);
            } else {
                fileBased = null;
            }
            jpsProjectConfigLocation = fileBased;
        }
        return jpsProjectConfigLocation;
    }
}

